/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/message/MessageMixin","sap/ui/core/format/NumberFormat","sap/ui/model/ValidateException","sap/ui/Device","sap/ui/core/library","sap/m/library","./NumericInput","./StepInputRenderer","sap/ui/events/KeyCodes","sap/base/Log"],function(C,I,M,N,V,D,c,l,a,S,K,L){"use strict";var T=c.TextAlign;var b=c.ValueState;var d=l.StepInputValidationMode;var f=l.StepInputStepModeType;var g=C.extend("sap.m.StepInput",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/StepInput.designtime",properties:{min:{type:"float",group:"Data"},max:{type:"float",group:"Data"},step:{type:"float",group:"Data",defaultValue:1},stepMode:{type:"sap.m.StepInputStepModeType",group:"Data",defaultValue:f.AdditionAndSubtraction},largerStep:{type:"float",group:"Data",defaultValue:2},value:{type:"float",group:"Data",defaultValue:0},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension"},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:b.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},displayValuePrecision:{type:"int",group:"Data",defaultValue:0},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.End},validationMode:{type:"sap.m.StepInputValidationMode",group:"Misc",defaultValue:d.FocusOut}},aggregations:{_input:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"string"}}}},dnd:{draggable:false,droppable:true}},constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(this.getEditable()){this._getOrCreateDecrementButton();this._getOrCreateIncrementButton();}if(typeof i!=="string"){s=i;}if(s&&s.value===undefined){this.setValue(this._getDefaultValue(undefined,s.max,s.min));}}});var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");g.STEP_INPUT_INCREASE_BTN_TOOLTIP=o.getText("STEP_INPUT_INCREASE_BTN");g.STEP_INPUT_DECREASE_BTN_TOOLTIP=o.getText("STEP_INPUT_DECREASE_BTN");g.INITIAL_WAIT_TIMEOUT=500;g.ACCELLERATION=0.8;g.MIN_WAIT_TIMEOUT=50;g.INITIAL_SPEED=120;g._TOLERANCE=10;var F=["enabled","editable","name","placeholder","required","valueStateText","description","fieldWidth","textAlign"];M.call(g.prototype);g.prototype.init=function(){this._iRealPrecision=0;this._attachChange();this._bPaste=false;this._bNeedsVerification=false;this._bValueStatePreset=true;this._onmousewheel=this._onmousewheel.bind(this);window.addEventListener("contextmenu",function(e){if(this._btndown===false&&e.target.className.indexOf("sapMInputBaseIconContainer")!==-1){e.preventDefault();}}.bind(this));};g.prototype.onBeforeRendering=function(){var m=this._getMin(),e=this._getMax(),v=this._sOriginalValue||this.getValue(),E=this.getEditable();this._iRealPrecision=this._getRealValuePrecision();this._getInput().setValue(this._getFormattedValue(v));this._getInput().setValueState(this.getValueState());this._getInput().setTooltip(this.getTooltip());this._getOrCreateDecrementButton().setVisible(E);this._getOrCreateIncrementButton().setVisible(E);this._disableButtons(v,e,m);this.$().off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);if(this._bNeedsVerification&&!this._bValueStatePreset){this._verifyValue();this._bNeedsVerification=false;}};g.prototype.onAfterRendering=function(){this.$().on(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);};g.prototype.exit=function(){this.$().off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);this._sOriginalValue=null;};g.prototype.setProperty=function(p,v,s){C.prototype.setProperty.call(this,p,v,s);if(F.indexOf(p)>-1){this._getInput().setProperty(p,this.getProperty(p),s);}return this;};g.prototype.setValidationMode=function(v){if(this.getValidationMode()!==v){switch(v){case d.FocusOut:this._detachLiveChange();break;case d.LiveChange:this._attachLiveChange();break;}this.setProperty("validationMode",v);}return this;};g.prototype.setMin=function(m){if(m!==undefined&&!this._validateOptionalNumberProperty("min",m)){return this;}return this.setProperty("min",m);};g.prototype.setMax=function(m){if(m!==undefined&&!this._validateOptionalNumberProperty("max",m)){return this;}return this.setProperty("max",m);};g.prototype._validateOptionalNumberProperty=function(n,v){if(this._isNumericLike(v)){return true;}L.error("The value of property '"+n+"' must be a number");return false;};g.prototype.setDisplayValuePrecision=function(n){var v,i;if(h(n)){v=parseInt(n);}else{v=0;L.warning(this+": ValuePrecision ("+n+") is not correct. It should be a number between 0 and 20! Setting the default ValuePrecision:0.");}var i=this.setProperty("displayValuePrecision",v);this._getNumberFormatter(true);return i;};g.prototype._getIncrementButton=function(){var e=this._getInput().getAggregation("_endIcon")||[];var i=null;if(e.length){i=e[e.length-1];}return i;};g.prototype._getDecrementButton=function(){var e=this._getInput().getAggregation("_beginIcon");return e?e[0]:null;};g.prototype._createIncrementButton=function(){var i=this._getInput().addEndIcon({src:I.getIconURI("add"),id:this.getId()+"-incrementBtn",noTabStop:true,decorative:false,press:this._handleButtonPress.bind(this,1),tooltip:g.STEP_INPUT_INCREASE_BTN_TOOLTIP});i.getEnabled=function(){return!this._shouldDisableIncrementButton(this._parseNumber(this._getInput().getValue()),this._getMax());}.bind(this);i.$().attr("tabindex","-1");this._attachEvents(i,true);i.addEventDelegate({onAfterRendering:function(){i.$().attr("tabindex","-1");}});return i;};g.prototype._createDecrementButton=function(){var i=this._getInput().addBeginIcon({src:I.getIconURI("less"),id:this.getId()+"-decrementBtn",noTabStop:true,decorative:false,press:this._handleButtonPress.bind(this,-1),tooltip:g.STEP_INPUT_DECREASE_BTN_TOOLTIP});i.getEnabled=function(){return!this._shouldDisableDecrementButton(this._parseNumber(this._getInput().getValue()),this._getMin());}.bind(this);i.$().attr("tabindex","-1");this._attachEvents(i,false);i.addEventDelegate({onAfterRendering:function(){i.$().attr("tabindex","-1");}});return i;};g.prototype._getInput=function(){if(!this.getAggregation("_input")){var n=new a({id:this.getId()+"-input",textAlign:this.getTextAlign(),editable:this.getEditable(),enabled:this.getEnabled(),description:this.getDescription(),fieldWidth:this.getFieldWidth(),liveChange:this._inputLiveChangeHandler});this.setAggregation("_input",n);}return this.getAggregation("_input");};g.prototype._changeValue=function(e){if((this._fTempValue!=this._fOldValue)||e){this.setValue(this._fTempValue);this.fireChange({value:this._fTempValue});}else{this._applyValue(this._fTempValue);this._disableButtons(this._parseNumber(this._getInput().getValue()),this._getMax(),this._getMin());}return this;};g.prototype._handleButtonPress=function(m){if(!this._bSpinStarted){this._bDelayedEventFire=false;this._changeValueWithStep(m);this._btndown=false;this._changeValue();}else{this._bSpinStarted=false;}this._bNeedsVerification=true;return this;};g.prototype._changeValueWithStep=function(m){var n,e;if(isNaN(this._fTempValue)||this._fTempValue===undefined){this._fTempValue=this.getValue();}e=this._checkInputValue();this._fTempValue+=e;n=m!==0?this._calculateNewValue(m):this._fTempValue;if(m!==0||e!==0||this._bDelayedEventFire){this._fTempValue=n;}if(this._bDelayedEventFire){this._applyValue(n);this._disableButtons(this._parseNumber(this._getFormattedValue(n)),this._getMax(),this._getMin());this._bNeedsVerification=true;}return this;};g.prototype._disableButtons=function(v,m,i){if(!this._isNumericLike(v)){return;}var e=this._getIncrementButton(),j=this._getDecrementButton(),s=this._shouldDisableDecrementButton(v,i),k=this._shouldDisableIncrementButton(v,m);j&&j.toggleStyleClass("sapMStepInputIconDisabled",s);e&&e.toggleStyleClass("sapMStepInputIconDisabled",k);return this;};g.prototype._shouldDisableDecrementButton=function(v,m){var e=this._isNumericLike(m),E=this.getEnabled(),r=e&&m>=v;return E?r:true;};g.prototype._shouldDisableIncrementButton=function(v,m){var e=this._isNumericLike(m),E=this.getEnabled(),r=e&&m<=v;return E?r:true;};g.prototype._verifyValue=function(){var m=this._getMin(),e=this._getMax(),v=this._parseNumber(this._getInput().getValue()),i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core"),B=this.getBinding("value"),j=B&&B.getType&&B.getType(),s=j&&j.oConstraints&&j.oConstraints.maximum,k=j&&j.oConstraints&&j.oConstraints.minimum,n,p=[],H=false,E;if(!this._isNumericLike(v)){return;}E=this;do{H=E.hasListeners("validationError");E=E.getEventingParent();}while(E&&!H);if(this._isMoreThanMax(v)){if(H&&s){return;}n=i.getText("EnterNumberMax",[e]);p.push("maximum");}else if(this._isLessThanMin(v)){if(H&&k){return;}n=i.getText("EnterNumberMin",[m]);p.push("minimum");}else if(this._areFoldChangeRequirementsFulfilled()&&(v%this.getStep()!==0)){n=i.getText("Float.Invalid");}if(n){this.setProperty("valueState",b.Error,true);this._getInput().setValueState(b.Error);this._getInput().setValueStateText(n);if(H){this.fireValidationError({element:this,exception:new V(n,p),id:this.getId(),message:n,property:"value"});}}else{this.setProperty("valueState",b.None,true);this._getInput().setValueState(b.None);}};g.prototype.setValueState=function(v){this._bValueStatePreset=true;this.setProperty("valueState",v);this._getInput().setValueState(v);return this;};g.prototype.setValue=function(v){var r;if(isNaN(v)||v===null){v=this._getDefaultValue(undefined,this._getMax(),this._getMin());}else{v=Number(v);}if(!this._validateOptionalNumberProperty("value",v)){return this;}this._sOriginalValue=v;this._applyValue(v);this._disableButtons(this._parseNumber(this._getInput().getValue()),this._getMax(),this._getMin());if(v!==this._fOldValue){this._fOldValue=v;r=this.setProperty("value",v);}else{r=this;}this._iRealPrecision=this._getRealValuePrecision();this._fTempValue=v;this._bValueStatePreset=false;return r;};g.prototype._getNumberFormatter=function(r){if(!this._formatter||r){this._formatter=N.getFloatInstance({decimals:this.getDisplayValuePrecision()});}return this._formatter;};g.prototype._getFormattedValue=function(v){var p=this.getDisplayValuePrecision(),i,s;if(v==undefined){v=this.getValue();}if(D.system.desktop){return this._getNumberFormatter().format(v);}if(p<=0){return parseFloat(v).toFixed(0);}s=v.toString().split(".");if(s.length===2){i=s[1].length;if(i>p){return parseFloat(v).toFixed(p);}return s[0]+"."+this._padZeroesRight(s[1],p);}else{return v.toString()+"."+this._padZeroesRight("0",p);}};g.prototype._padZeroesRight=function(v,p){var r="",e=v.length;for(var i=e;i<p;i++){r=r+"0";}r=v+r;return r;};g.prototype._checkInputValue=function(){var i=this._getInput().getValue(),e=0;if(i===""){i=this._getDefaultValue(i,this._getMax(),this._getMin()).toString();}if(this.getDisplayValuePrecision()===0){i=Math.round(this._parseNumber(i.toLowerCase().split('e')[0])).toString();}if(this._getFormattedValue(this._fTempValue)!==i){e=this._parseNumber(i)-this._fTempValue;}return e;};g.prototype.onsappageup=function(e){e.preventDefault();if(this.getEditable()){this._bDelayedEventFire=true;this._changeValueWithStep(this.getLargerStep());}};g.prototype.onsappagedown=function(e){e.preventDefault();if(this.getEditable()){this._bDelayedEventFire=true;this._changeValueWithStep(-this.getLargerStep());}};g.prototype.onsappageupmodifiers=function(e){if(this.getEditable()&&this._isNumericLike(this._getMax())&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){this._bDelayedEventFire=true;this._fTempValue=this._parseNumber(this._getInput().getValue());this._changeValueWithStep(this._getMax()-this._fTempValue);}};g.prototype.onsappagedownmodifiers=function(e){if(this.getEditable()&&this._isNumericLike(this._getMin())&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){this._bDelayedEventFire=true;this._fTempValue=this._parseNumber(this._getInput().getValue());this._changeValueWithStep(-(this._fTempValue-this._getMin()));}};g.prototype.onsapup=function(e){e.preventDefault();if(this.getEditable()){this._bDelayedEventFire=true;this._changeValueWithStep(1);e.setMarked();}};g.prototype.onsapdown=function(e){e.preventDefault();if(this.getEditable()){this._bDelayedEventFire=true;this._changeValueWithStep(-1);e.setMarked();}};g.prototype._onmousewheel=function(e){var i=this.getDomRef().contains(document.activeElement);if(i&&this.getEditable()&&this.getEnabled()){e.preventDefault();var O=e.originalEvent,j=O.detail?(-O.detail>0):(O.wheelDelta>0);this._bDelayedEventFire=true;this._changeValueWithStep((j?1:-1));}};g.prototype.onkeydown=function(e){var s,m,i;if(!this.getEditable()){return;}if(e.which===K.ENTER&&this._fTempValue!==this.getValue()){e.preventDefault();this._changeValue();return;}this._bPaste=(e.ctrlKey||e.metaKey)&&(e.which===K.V);if(e.which===K.ARROW_UP&&!e.altKey&&e.shiftKey&&(e.ctrlKey||e.metaKey)){m=this._getMax();this._fTempValue=this._parseNumber(this._getInput().getValue());s=(m!==undefined)?m-this._fTempValue:0;}else if(e.which===K.ARROW_DOWN&&!e.altKey&&e.shiftKey&&(e.ctrlKey||e.metaKey)){i=this._getMin();this._fTempValue=this._parseNumber(this._getInput().getValue());s=(i!==undefined)?-(this._fTempValue-i):0;}else if(e.which===K.ARROW_UP&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){s=this.getLargerStep();}else if(e.which===K.ARROW_DOWN&&!(e.ctrlKey||e.metaKey||e.altKey)&&e.shiftKey){s=-this.getLargerStep();}else if(e.which===K.ARROW_UP&&(e.ctrlKey||e.metaKey)){s=1;}else if(e.which===K.ARROW_DOWN&&(e.ctrlKey||e.metaKey)){s=-1;}else if(e.which===K.ARROW_UP&&e.altKey){s=1;}else if(e.which===K.ARROW_DOWN&&e.altKey){s=-1;}if(s!==undefined){e.preventDefault();if(s!==0){this._bDelayedEventFire=true;this._changeValueWithStep(s);}}};g.prototype.onsapescape=function(e){if(this._fOldValue!==this._fTempValue){this._applyValue(this._fOldValue);this._bNeedsVerification=true;}};g.prototype._attachLiveChange=function(){this._getInput().attachLiveChange(this._liveChange,this);};g.prototype._detachLiveChange=function(){this._getInput().detachLiveChange(this._liveChange,this);};g.prototype._attachChange=function(){this._getInput().attachChange(this._change,this);};g.prototype._liveChange=function(){this._disableButtons(this._parseNumber(this._getInput().getValue()),this._getMax(),this._getMin());this._verifyValue();};g.prototype._change=function(e){var O;var n=this._getInput().getValue();var i=this._isLessThanMin(n)||this._isMoreThanMax(n);if(!this._isButtonFocused()){if(!this._btndown||i){O=this._parseNumber(this._getFormattedValue());if(this._fOldValue===undefined){this._fOldValue=O;}this._bDelayedEventFire=false;this._changeValueWithStep(0);this._changeValue();this._bNeedsVerification=true;}else{this._fTempValue=this._parseNumber(this._getInput().getValue());}}};g.prototype._isMoreThanMax=function(v){return this._isNumericLike(this._getMax())&&this._getMax()<v;};g.prototype._isLessThanMin=function(v){return this._isNumericLike(this._getMin())&&this._getMin()>v;};g.prototype._applyValue=function(n){this._getInput().setValue(this._getFormattedValue(n));};g.prototype._calculateNewValue=function(s,i){if(i===undefined){i=s<0?false:true;}var e=this.getStep(),m=this._getMax(),j=this._getMin(),k=parseFloat(this._getDefaultValue(this._getInput().getValue(),m,j)),n=i?1:-1,p=Math.abs(e)*Math.abs(s),r=k+n*p,v;if(this._areFoldChangeRequirementsFulfilled()){r=v=this._calculateClosestFoldValue(k,p,n);}else{v=this._sumValues(this._fTempValue,p,n,this._iRealPrecision);}if(this._isNumericLike(m)&&r>=m){v=m;}if(this._isNumericLike(j)&&r<=j){v=j;}return v;};g.prototype._getRealValuePrecision=function(){var s=this.getValue().toString().split("."),e=this.getStep().toString().split("."),i,j;i=(!s[1])?0:s[1].length;j=(!e[1])?0:e[1].length;return(i>j)?i:j;};g.prototype._getOrCreateDecrementButton=function(){return this._getDecrementButton()||this._createDecrementButton();};g.prototype._getOrCreateIncrementButton=function(){return this._getIncrementButton()||this._createIncrementButton();};g.prototype._inputLiveChangeHandler=function(e){var v=this.getParent()._restrictCharsWhenDecimal(e);this.setProperty("value",v?v:e.getParameter("newValue"),true);};g.prototype._restrictCharsWhenDecimal=function(e){var s=D.system.desktop?this._getNumberFormatter().oFormatOptions.decimalSeparator:".";var i=e.getParameter("value").indexOf(s),j=this.getDisplayValuePrecision(),E=e.getParameter("value"),v;if(i>0&&j>=0){var k=E.split(s)[1],m=k?k.length:0,n=E.split(s)[0],p=j>0?E.substring(E.indexOf(s)+1,E.length):'';if(!this._bPaste){if(m>j){v=n+(j>0?s+p.substr(0,j):'');this._showWrongValueVisualEffect();}}else{if(E.indexOf(s)){v=E.split(s)[0]+(j>0?s+k.substring(0,j):'');}this._bPaste=false;}}else{v=E;}if(this._getInput()._getInputValue()!==v){this._getInput().updateDomValue(v);}return v;};g.prototype._showWrongValueVisualEffect=function(){var O=this.getValueState(),i=this._getInput();if(O===b.Error){return;}i.setValueState(b.Error);setTimeout(i["setValueState"].bind(i,O),1000);};g.prototype._getDefaultValue=function(v,m,e){if(v!==""&&v!==undefined){return this._parseNumber(this._getInput().getValue());}if(this._isNumericLike(e)&&e>0){return e;}else if(this._isNumericLike(m)&&m<0){return m;}else{return 0;}};g.prototype._isNumericLike=function(v){return!isNaN(v)&&v!==null&&v!=="";};g.prototype._isInteger=function(v){return v===parseInt(v);};g.prototype._isButtonFocused=function(){return document.activeElement===this._getIncrementButton().getDomRef()||document.activeElement===this._getDecrementButton().getDomRef();};g.prototype._sumValues=function(v,e,s,p){var P=Math.pow(10,p),i=parseInt((v*P).toFixed(1)),j=parseInt((e*P).toFixed(1));return(i+(s*j))/P;};g.prototype._areFoldChangeRequirementsFulfilled=function(){return this.getStepMode()===f.Multiple&&this.getDisplayValuePrecision()===0&&this._isInteger(this.getStep())&&this._isInteger(this.getLargerStep());};g.prototype._calculateClosestFoldValue=function(v,s,i){var r=Math.floor(v),e=s;do{r+=i;e--;}while(r%s!==0&&e);if(r%s!==0){L.error("Wrong next/previous value "+r+" for "+v+", step: "+s+" and sign: "+i,this);}return r;};function h(v){return(typeof(v)==='number')&&!isNaN(v)&&v>=0&&v<=20;}g.prototype._calcWaitTimeout=function(){this._speed*=g.ACCELLERATION;this._waitTimeout=((this._waitTimeout-this._speed)<g.MIN_WAIT_TIMEOUT?g.MIN_WAIT_TIMEOUT:(this._waitTimeout-this._speed));return this._waitTimeout;};g.prototype._spinValues=function(i){this._spinTimeoutId=setTimeout(function(){if(this._btndown){this._bSpinStarted=true;this._bDelayedEventFire=true;this._changeValueWithStep(i?1:-1);this._disableButtons(this._parseNumber(this._getInput().getValue()),this._getMax(),this._getMin());if((this._getIncrementButton().getEnabled()&&i)||(this._getDecrementButton().getEnabled()&&!i)){this._spinValues(i);}}}.bind(this),this._calcWaitTimeout());};g.prototype._attachEvents=function(B,i){var e={onmousedown:function(E){if(E.button===0&&!this._btndown){this._btndown=true;this._waitTimeout=g.INITIAL_WAIT_TIMEOUT;this._speed=g.INITIAL_SPEED;this._spinValues(i);}}.bind(this),onmouseup:function(E){if(E.button===0){this._bDelayedEventFire=undefined;this._btndown=false;this._stopSpin();}}.bind(this),onmouseout:function(E){if(this._btndown){this._bDelayedEventFire=undefined;this._stopSpin();}}.bind(this),oncontextmenu:function(E){E.stopImmediatePropagation(true);if(E.originalEvent&&E.originalEvent.cancelable){E.preventDefault();}E.stopPropagation();},ontouchend:function(E){if(D.system.phone||D.system.tablet){this._bDelayedEventFire=undefined;this._btndown=false;this._stopSpin();}if(E.originalEvent&&E.originalEvent.cancelable){E.preventDefault();}if(i){this._getIncrementButton().invalidate();}else{this._getDecrementButton().invalidate();}}.bind(this)};B.addDelegate(e,true);};g.prototype._stopSpin=function(){this._resetSpinValues();if(this._bSpinStarted){this._changeValue();}};g.prototype._getMin=function(){var B=this.getBinding("value"),e=B&&B.getType&&B.getType(),s=e&&e.oConstraints&&e.oConstraints.minimum;return s?parseFloat(s):this.getMin();};g.prototype._getMax=function(){var B=this.getBinding("value"),e=B&&B.getType&&B.getType(),s=e&&e.oConstraints&&e.oConstraints.maximum;return s?parseFloat(s):this.getMax();};g.prototype.getIdForLabel=function(){return this._getInput().getIdForLabel();};g.prototype.onfocusout=function(e){if(!this._btndown){this._changeValueWithStep(0);if(this._bDelayedEventFire&&(this._fTempValue)!==this._fOldValue){this._bDelayedEventFire=undefined;this._changeValue();}}};g.prototype.getFocusDomRef=function(){return this.getAggregation("_input").getFocusDomRef();};g.prototype._resetSpinValues=function(){clearTimeout(this._spinTimeoutId);this._waitTimeout=500;this._speed=120;};g.prototype.getAccessibilityInfo=function(){return{type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_STEPINPUT"),description:this.getValue()||"",focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};g.prototype._parseNumber=function(v){if(D.system.desktop){return this._getNumberFormatter().parse(v);}return Number(v);};return g;});
