/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TimePickerInternals","./TimePickerClock","./ToggleButton","./SegmentedButton","./SegmentedButtonItem","./TimePickerClocksRenderer","./ToggleButtonRenderer","sap/ui/core/Renderer","sap/ui/events/KeyCodes",'sap/ui/Device','sap/ui/core/library',"sap/ui/thirdparty/jquery"],function(T,a,b,S,c,d,e,R,K,D,f,q){"use strict";var g=1000;var h=f.TextDirection;var i=T.extend("sap.m.TimePickerClocks",{metadata:{aggregations:{_buttons:{type:"sap.m.internal.ToggleSpinButton",multiple:true,visibility:"hidden"},_clocks:{type:"sap.m.TimePickerClock",multiple:true,visibility:"hidden"}}}});var j=R.extend(e);j.apiVersion=2;j.render=function(r,B){var s=B.getId(),t=B.getType(),E=B.getEnabled(),w=B.getWidth(),l=B._getTooltip(),m=B._getText(),n=B.getTextDirection(),I=D.browser.internet_explorer||D.browser.edge,o=(n===h.Inherit)&&!I;r.openStart("div",B);r.class("sapMBtnBase");r.class("sapMBtn");var A=this.generateAccProps(B);A["pressed"]=null;A["valuemin"]=B.getMin();A["valuemax"]=B.getMax();A["valuenow"]=parseInt(B.getText());A["label"]=B.getLabel();A["valuetext"]=parseInt(B.getText()).toString()+" "+B.getLabel();A["role"]="spinbutton";r.accessibilityState(B,A);if(!E){r.attr("disabled","disabled");r.class("sapMBtnDisabled");}if(w!=""||w.toLowerCase()==="auto"){r.style("width",w);r.style("min-width","2.25rem");}r.attr("tabindex","0");r.openEnd();r.openStart("span",s+"-inner");r.class("sapMBtnInner");if(B._isHoverable()){r.class("sapMBtnHoverable");}if(E){r.class("sapMFocusable");if(I){r.class("sapMIE");}}if(m){r.class("sapMBtnText");}if(B.getPressed()){r.class("sapMToggleBtnPressed");}if(t!==""){r.class("sapMBtn"+t);}r.openEnd();if(m){r.openStart("span",s+"-content");r.class("sapMBtnContent");if(n!==h.Inherit){r.attr("dir",n.toLowerCase());}r.openEnd();if(o){r.openStart("bdi",s+"-BDI-content");r.openEnd();}r.text(m);if(o){r.close("bdi");}r.close("span");}if(I&&E){r.openStart("span");r.class("sapMBtnFocusDiv");r.openEnd();r.close("span");}r.close("span");if(l){r.openStart("span",s+"-tooltip");r.class("sapUiInvisibleText");r.openEnd();r.text(l);r.close("span");}r.close("div");};var k=b.extend("sap.m.internal.ToggleSpinButton",{metadata:{library:"sap.m",properties:{label:{type:"string",defaultValue:""},min:{type:"int",defaultValue:0},max:{type:"int",defaultValue:0}}},renderer:j});i.prototype.init=function(){T.prototype.init.apply(this,arguments);this._activeClock=0;};i.prototype.onAfterRendering=function(){if(!this._clickAttached){this._attachClickEvent();}this._clockConstraints=this._getClocksConstraints();};i.prototype.onkeyup=function(E){var l=E.which||E.keyCode;if(l===K.CONTROL){E.preventDefault();if(this._clockIndexes.H===this._getActiveClockIndex()&&this.getSupport2400()&&this._ctrlKeyDown===1){this._getActiveClock()._toggle2400(true)._markToggleAsSelected(false);}this._ctrlKeyDown=0;}else if(l===K.SPACE){this._spaceKeyDown=false;}};i.prototype.onkeydown=function(E){var l=E.which||E.keyCode,C=E.key,m=this.getAggregation("_clocks"),o=this._getActiveClock(),A=this._getActiveClockIndex(),s=this.getSupport2400(),n=["0","1","2","3","4","5","6","7","8","9",":"],p,H,v,B="",r,I,t,M=0,V=-1,u=E.srcControl&&E.srcControl.getMetadata().getName().indexOf("ToggleSpinButton")===-1?false:true;if(this._clockIndexes.H===A&&s&&l===K.CONTROL&&!this._ctrlKeyDown){E.preventDefault();this._ctrlKeyDown=1;o._toggle2400(true)._markToggleAsSelected(true);}else if(l===K.ENTER){if(!u){return;}if(typeof this._parentAcceptCallback==="function"){this._parentAcceptCallback();}}else if((l===K.ARROW_UP||l===K.ARROW_DOWN)&&!E.altKey&&!E.metaKey){o&&o.getEnabled()&&o.modifyValue(l===K.ARROW_UP);E.preventDefault();}else if((l===K.PAGE_UP||l===K.PAGE_DOWN)&&!E.altKey&&!E.metaKey){E.preventDefault();if(!E.shiftKey&&!E.ctrlKey){o=this._getHoursClock();}else if(E.shiftKey&&!E.ctrlKey){o=this._getMinutesClock();}else{o=this._getSecondsClock();}o&&o.getEnabled()&&o.modifyValue(l===K.PAGE_UP);o&&this._switchClock(this._getClockIndex(o));}else if(l===K.P||l===K.A){E.preventDefault();p=this._getFormatButton();p&&p.setSelectedKey(l===K.P?"pm":"am");}else if(l===K.SPACE&&!this._spaceKeyDown){if(!u){return;}E.preventDefault();this._spaceKeyDown=true;v=o.getSelectedValue();H=o._get24HoursVisible()?24:0;if(this._clockIndexes.H===A&&s&&v!==H&&(v===24||v===0)){o.setSelectedValue(H);}this._kbdBuffer="";this._resetCooldown(true);setTimeout(function(){this._switchNextClock(true);}.bind(this),0);}else if(n.indexOf(C)!==-1){this._exactMatch=null;this._resetCooldown(true);if(C===":"){this._kbdBuffer="";this._resetCooldown(true);this._switchNextClock(true);}else if(this._clockConstraints[A]){B=this._kbdBuffer+C;r=parseInt(B);if(this._clockConstraints[A].step===1){if(r>this._clockConstraints[A].max){m[A].setSelectedValue(parseInt(this._kbdBuffer));this._switchNextClock();this._kbdBuffer=C;A=this._getActiveClockIndex();m[A].setSelectedValue(parseInt(C));this._resetCooldown(true);}else{this._kbdBuffer=B;m[A].setSelectedValue(parseInt(this._kbdBuffer));if(this._kbdBuffer.length===2||parseInt(this._kbdBuffer+"0")>this._clockConstraints[A].max){this._resetCooldown(this._kbdBuffer.length===2?false:true);this._kbdBuffer="";this._switchNextClock();}}}else{for(I=this._clockConstraints[A].min;I<=this._clockConstraints[A].max;I++){if(I%this._clockConstraints[A].step===0){t=I.toString();if(B===t.substr(0,B.length)||r===I){M++;V=M===1?I:-1;if(r===I){this._exactMatch=I;}}}}if(M===1){m[A].setSelectedValue(V);this._exactMatch=null;this._kbdBuffer="";this._resetCooldown(true);this._switchNextClock();}else if(B.length===2){this._exactMatch=null;this._kbdBuffer="";this._resetCooldown(true);}else{this._kbdBuffer=B;}}}}};i.prototype.setValue=function(v){var H=this._getHoursClock(),F=this._getValueFormatPattern(),I=F.indexOf("HH"),l=F.indexOf("H"),m=H&&H.getSelectedValue()===24,n=T._isHoursValue24(v,I,l),o;if(m&&this._isFormatSupport24()&&!n){v=T._replaceZeroHoursWith24(v,I,l);}v=this.validateProperty("value",v);this.setProperty("value",v,true);if(v){o=this._parseValue(n?T._replace24HoursWithZero(v,I,l):v);}if(o){this._setTimeValues(o,n);}return this;};i.prototype.getTimeValues=function(){var H=this._getHoursClock(),m=this._getMinutesClock(),s=this._getSecondsClock(),F=this._getFormatButton(),l=null,A=null,o=new Date();if(H){l=parseInt(H.getSelectedValue());}if(F){A=F.getSelectedKey();}if(A==="am"&&l===12){l=0;}else if(A==="pm"&&l!==12){l+=12;}if(l!==null){o.setHours(l.toString());}if(m){o.setMinutes(m.getSelectedValue());}if(s){o.setSeconds(s.getSelectedValue());}return o;};i.prototype.showFirstClock=function(){this._switchClock(0);return this;};i.prototype._attachClickEvent=function(){var E=this.getDomRef();E.addEventListener("click",q.proxy(this._focusActiveButton,this),false);this._clickAttached=true;};i.prototype._focusActiveButton=function(){var B=this.getAggregation("_buttons"),A=this._getActiveClockIndex();B&&B[A]&&B[A].focus();};i.prototype._setAcceptCallback=function(C){this._parentAcceptCallback=C;};i.prototype._resetCooldown=function(s){if(g===0){return;}if(this._typeCooldownId){clearTimeout(this._typeCooldownId);}if(s){this._startCooldown();}};i.prototype._startCooldown=function(){if(g===0){return;}this._typeCooldownId=setTimeout(function(){this._kbdBuffer="";this._typeCooldownId=null;if(this._exactMatch){this._getActiveClock().setSelectedValue(this._exactMatch);this._exactMatch=null;}}.bind(this),g);};i.prototype._switchNextClock=function(w){var A=this._getActiveClockIndex(),C=this.getAggregation("_clocks"),l=C.length,o=this._getActiveClock(),s=A;if(!C){return;}if(this._clockIndexes.H===A&&this.getSupport2400()){o._save2400State();if(o.getSelectedValue()===24){return;}}do{A++;if(A>=l){A=w?0:l-1;}}while(!o.getEnabled()&&A!==s&&(w||A<l-1));this._ctrlKeyDown=0;if(A!==s&&C[A].getEnabled()){this._switchClock(A);}};i.prototype._getClocksConstraints=function(){var C=this.getAggregation("_clocks"),s=this.getSupport2400(),l=[],m,M,n,r,I;if(C){for(I=0;I<C.length;I++){m=C[I].getItemMin();M=C[I]._getMaxValue();n=C[I].getValueStep();r=C[I].getLastItemReplacement();if(r!==-1&&r<m){m=r;if(M!==24||!s){M--;}}else if(M===24&&s){m=0;}l[I]={min:m,max:M,step:n,prependZero:C[I].getPrependZero()};}}return l;};i.prototype._getActiveClockIndex=function(){return this._activeClock||0;};i.prototype._getActiveClock=function(){var A=this._getActiveClockIndex(),C=this.getAggregation("_clocks");return C&&C[A]?C[A]:null;};i.prototype._setTimeValues=function(o,H){var l=this._getHoursClock(),m=this._getMinutesClock(),s=this._getSecondsClock(),M=this._getMinutesButton(),n=this._getSecondsButton(),F=this._getFormatButton(),v=this.getValueFormat(),p,A=null;o=o||new Date();if(Object.prototype.toString.call(o)!=="[object Date]"||isNaN(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(!H){var V=this._formatValue(o,true);this.setProperty("value",V,true);p=o.getHours();}else{p=24;}if((v.indexOf("a")!==-1||v==="")&&F){A=p>=12?"pm":"am";p=(p>12)?p-12:p;p=(p===0?12:p);F&&F.setSelectedKey(A);}l&&l.setSelectedValue(p);m&&m.setSelectedValue(o.getMinutes());s&&s.setSelectedValue(o.getSeconds());l&&this.getSupport2400()&&l._save2400State();if(H){m&&m.setSelectedValue(0).setEnabled(false);s&&s.setSelectedValue(0).setEnabled(false);M&&M.setEnabled(false);n&&n.setEnabled(false);}else{m&&m.setEnabled(true);s&&s.setEnabled(true);M&&M.setEnabled(true);n&&n.setEnabled(true);}};i.prototype._getHoursClock=function(){var C=this.getAggregation("_clocks");return C&&this._clockIndexes&&C[this._clockIndexes.H]?C[this._clockIndexes.H]:null;};i.prototype._getMinutesClock=function(){var C=this.getAggregation("_clocks");return C&&this._clockIndexes&&C[this._clockIndexes.M]?C[this._clockIndexes.M]:null;};i.prototype._getSecondsClock=function(){var C=this.getAggregation("_clocks");return C&&this._clockIndexes&&C[this._clockIndexes.S]?C[this._clockIndexes.S]:null;};i.prototype._getHoursButton=function(){var B=this.getAggregation("_buttons");return B&&this._clockIndexes&&B[this._clockIndexes.H]?B[this._clockIndexes.H]:null;};i.prototype._getMinutesButton=function(){var B=this.getAggregation("_buttons");return B&&this._clockIndexes&&B[this._clockIndexes.M]?B[this._clockIndexes.M]:null;};i.prototype._getSecondsButton=function(){var B=this.getAggregation("_buttons");return B&&this._clockIndexes&&B[this._clockIndexes.S]?B[this._clockIndexes.S]:null;};i.prototype._destroyControls=function(){this.destroyAggregation("_buttons");this.destroyAggregation("_clocks");this.destroyAggregation("_buttonAmPm");};i.prototype._createControls=function(){var F=this._getDisplayFormatPattern(),I=this.getId(),l=this._isFormatSupport24(),s=this.getSupport2400(),m=0,n=0,o=0,p="",L=-1,r,t,H,B,C,u=0,v,w,x,P=false,V,y;this._clockIndexes={};if(F===undefined){return;}r=F.indexOf("HH");t=F.indexOf("H");if(r!==-1){v=true;P=true;L=(s)?24:0;w=0;x=23;}else if(t!==-1){v=true;L=(s)?24:0;w=0;x=23;}else if(F.indexOf("hh")!==-1){v=true;P=true;w=1;x=12;}else if(F.indexOf("h")!==-1){v=true;w=1;x=12;}if(v){this.addAggregation("_clocks",new a(I+"-clockH",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_HOURS"),selectedValue:m,itemMin:1,itemMax:12,valueStep:1,displayStep:1,innerItems:l,lastItemReplacement:L,prependZero:P,support2400:s}));if(s){x++;}this.addAggregation("_buttons",new k(I+"-btnH",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_HOURS"),min:w,max:x}));this._clockIndexes.H=u++;}if(F.indexOf("m")!==-1){if(F.indexOf("mm")!==-1){L=0;P=true;}else{L=0;P=false;}this.addAggregation("_clocks",new a(I+"-clockM",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_MINUTES"),selectedValue:n,itemMin:1,itemMax:60,valueStep:this.getMinutesStep(),lastItemReplacement:L,prependZero:P}));this.addAggregation("_buttons",new k(I+"-btnM",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_MINUTES"),min:0,max:59}));this._clockIndexes.M=u++;}if(F.indexOf("s")!==-1){if(F.indexOf("ss")!==-1){L=0;P=true;}else{L=0;P=false;}this.addAggregation("_clocks",new a(I+"-clockS",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_SECONDS"),selectedValue:o,itemMin:1,itemMax:60,valueStep:this.getSecondsStep(),lastItemReplacement:L,prependZero:P}));this.addAggregation("_buttons",new k(I+"-btnS",{label:this._oResourceBundle.getText("TIMEPICKER_LBL_SECONDS"),min:0,max:59}));this._clockIndexes.S=u++;}if(F.indexOf("a")!==-1){this.setAggregation("_buttonAmPm",new S(I+"-format",{items:[new c({text:this._sAM,key:"am"}),new c({text:this._sPM,key:"pm"})],selectedKey:p,tooltip:this._oResourceBundle.getText("TIMEPICKER_AMPM_BUTTON_TOOLTIP")}));}if(!this.getAggregation("_nowButton")){this.setAggregation("_nowButton",this._getCurrentTimeButton());}B=this.getAggregation("_buttons");C=this.getAggregation("_clocks");this._clockCount=C.length;this._switchClock(0);for(u=0;u<this._clockCount;u++){this._attachEvents(C[u],B[u]);}V=this.getValue();if(V){H=T._isHoursValue24(V,r,t);y=this._parseValue(H?T._replace24HoursWithZero(V,r,t):V);if(y){this._setTimeValues(y,H);}}};i.prototype._attachEvents=function(C,B){C.attachChange(function(E){var s=E.getParameter("value"),I=E.getParameter("finalChange"),v=E.getParameter("stringValue"),l=this.getAggregation("_buttons"),m=E.getParameter("id").slice(-1);l[this._clockIndexes[m]]&&l[this._clockIndexes[m]].setText(v).focus();if(!I){if(m==="H"){this._handleHoursChange(E);}return;}if(!this.getSupport2400()||s!==24){setTimeout(function(){this._switchNextClock();}.bind(this),0);}}.bind(this));B.attachPress(function(E){var s=E.getParameter("id").slice(-1),l=this.getAggregation("_clocks");if(l[this._clockIndexes[s]].getEnabled()){this._switchClock(this._clockIndexes[s]);}}.bind(this));B.onfocusin=function(E){var s=E.target.id.slice(-1),l=this.getAggregation("_clocks");if(l[this._clockIndexes[s]].getEnabled()){this._switchClock(this._clockIndexes[s]);}}.bind(this);};i.prototype._switchClock=function(C){var l=this.getAggregation("_clocks"),B=this.getAggregation("_buttons"),A=this._getActiveClock();if(C!==this._activeClock){A._save2400State();}if(this._activeClock!==undefined){B[this._activeClock].setPressed(false);l[this._activeClock].removeStyleClass("sapMTPCActive");}l[C].addStyleClass("sapMTPCActive");B[C].setPressed(true);B[C].focus();this._activeClock=C;};i.prototype._getClockIndex=function(C){var s=C.getId().slice(-1);return this._clockIndexes[s];};i.prototype._handleHoursChange=function(E){var v=parseInt(E.getParameter("value")),m=this._getMinutesClock(),s=this._getSecondsClock(),M=this._getMinutesButton(),o=this._getSecondsButton();if(!this.getSupport2400()){return;}this._ctrlKeyDown=this._ctrlKeyDown?2:0;if(v===24){if(m&&m.getEnabled()){this._sMinutes=m.getSelectedValue();this._setControlValueAndEnabled(m,M,0,false);}if(s&&s.getEnabled()){this._sSeconds=s.getSelectedValue();this._setControlValueAndEnabled(s,o,0,false);}}else{if(m&&!m.getEnabled()){this._setControlValueAndEnabled(m,M,this._sMinutes,true);}if(s&&!s.getEnabled()){this._setControlValueAndEnabled(s,o,parseInt(this._sSeconds),true);}}this._getHoursButton().focus();};i.prototype._setControlValueAndEnabled=function(C,B,v,E){C.setSelectedValue(parseInt(v));C.setEnabled(E);B.setEnabled(E);};i.prototype._formatNumberToString=function(n,p,m,r){var N;if(p&&n<10){N=n.toString().padStart(2,"0");}else if(n===m&&r!==""){N=r;}else{N=n.toString();}return N;};return i;});
