/*
* ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/core/Control","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/MessageBox","sap/ui/Device","sap/m/Dialog","sap/m/ResponsivePopover","sap/m/p13n/Container","sap/m/p13n/AbstractContainerItem","sap/m/library"],function(C,B,a,T,M,D,b,R,c,A,l){"use strict";var P=l.P13nPopupMode;var d=C.extend("sap.m.p13n.Popup",{metadata:{properties:{title:{type:"string"},mode:{type:"sap.m.P13nPopupMode",defaultValue:P.Dialog},warningText:{type:"string"},reset:{type:"function"}},aggregations:{panels:{type:"sap.m.p13n.IContent",multiple:true},additionalButtons:{type:"sap.m.Button",multiple:true}},events:{close:{reason:{type:"string"}}}},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}});d.prototype.init=function(){C.prototype.init.apply(this,arguments);this._aPanels=[];};d.prototype.isOpen=function(){return!!this._bIsOpen;};d.prototype.setMode=function(m){this.setProperty("mode",m);if(this._oPopup){this._oPopup.removeAllContent();this._oPopup.destroy();var p=this._createContainer();this.addDependent(p);this._oPopup=p;}return this;};d.prototype.open=function(s,S){if(!s){throw new Error("Please provide a source control!");}if(!this._oPopup){var p=this._createContainer(S);this.addDependent(p);this._oPopup=p;}if(this.getMode()==="Dialog"){this._oPopup.open();}else{this._oPopup.openBy(s);}this._bIsOpen=true;};d.prototype.addPanel=function(p){this._getContainer().addView(new A({key:p.getId(),text:p.getTitle(),content:p}));this._aPanels.push(p);return this;};d.prototype.removePanel=function(p){this._aPanels.splice(this._aPanels.indexOf(p),1);this._getContainer().removeView(this._getContainer().getView(p.getId()));return this;};d.prototype.getPanels=function(){return this._aPanels;};d.prototype._createContainer=function(m){m=m?m:{};return this["_create"+this.getMode()].call(this,m);};d.prototype._createResponsivePopover=function(m){var p=new R(this.getId()+"-responsivePopover",{title:this.getTitle(),horizontalScrolling:m.hasOwnProperty("horizontalScrolling")?m.horizontalScrolling:false,verticalScrolling:false,contentWidth:m.contentWidth?m.contentWidth:"30rem",resizable:m.hasOwnProperty("resizable")?m.resizable:true,contentHeight:m.contentHeight?m.contentHeight:"35rem",placement:m.placement?m.placement:"Bottom",content:this._getContainer()});p.setCustomHeader(this._createTitle());return p;};d.prototype._createDialog=function(m){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=new b(this.getId()+"-dialog",{title:this.getTitle(),horizontalScrolling:m.hasOwnProperty("horizontalScrolling")?m.horizontalScrolling:false,verticalScrolling:false,contentWidth:m.contentWidth?m.contentWidth:"40rem",contentHeight:m.contentHeight?m.contentHeight:"55rem",draggable:true,resizable:true,stretch:D.system.phone,content:this._getContainer(),buttons:[new B(this.getId()+"-confirmBtn",{text:m.confirm&&m.confirm.text?m.confirm.text:r.getText("p13n.POPUP_OK"),type:"Emphasized",press:function(){this._onClose(o,"Ok");}.bind(this)}),new B(this.getId()+"-cancelBtn",{text:r.getText("p13n.POPUP_CANCEL"),press:function(){this._onClose(o,"Cancel");}.bind(this)})]});o.setCustomHeader(this._createTitle());this.getAdditionalButtons().forEach(function(e){o.addButton(e);});return o;};d.prototype._createTitle=function(){var r=this.getReset();var t=this.getTitle();var w=this.getWarningText();var o;if(r){o=new a({contentLeft:[new T({text:t})]});o.addContentRight(new B(this.getId()+"-resetBtn",{text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.POPUP_RESET"),press:function(e){var f=e.getSource().getParent().getParent();var g=f.getParent();var s=w;M.warning(s,{actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK,onClose:function(h){if(h===M.Action.OK){f.getButtons()[0].focus();r(g);}}});}}));}return o;};d.prototype._getContainer=function(s){if(!this._oContainer){this._oContainer=new c();}if(this._oContainer.getViews().length>1){this._oContainer.switchView(this._oContainer.getViews()[1].getKey());}return this._oContainer;};d.prototype._onClose=function(o,r){o.close();this._bIsOpen=false;this.fireClose({reason:r});};d.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();}this._aPanels=null;};return d;});
