/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/Text","sap/m/Column","sap/m/Table","sap/m/library","sap/m/ToolbarSpacer","sap/m/Button","sap/m/OverflowToolbar","sap/ui/model/Filter"],function(B,L,C,H,V,I,T,a,b,l,c,d,O,F){"use strict";var e=l.ListKeyboardMode;var f=l.FlexJustifyContent;var g=l.ListType;var S=B.extend("sap.m.p13n.SelectionPanel",{metadata:{library:"sap.m",properties:{showHeader:{type:"boolean",defaultValue:false},enableCount:{type:"boolean",defaultValue:false},fieldColumn:{type:"string",defaultValue:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.DEFAULT_DESCRIPTION")},activeColumn:{type:"string",defaultValue:""},itemFactory:{type:"function"}}},renderer:{apiVersion:2}});S.prototype.applySettings=function(){B.prototype.applySettings.apply(this,arguments);this._setTemplate(this._getListTemplate());this.addStyleClass("sapMSelectionPanel");this._aInitializedFields=[];this._bShowFactory=false;this.addStyleClass("SelectionPanelHover");this._displayColumns();this.setEnableReorder(true);};S.prototype.setItemFactory=function(i){this.setProperty("itemFactory",i);this._oListControl.setGrowing(!!i);return this;};S.prototype._getListTemplate=function(){return new C({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:g.Active,cells:[new V({items:[new L({wrapping:true,required:"{"+this.P13N_MODEL+">required}",tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"})]}),new H({justifyContent:f.Center,items:[new I({src:"sap-icon://circle-task-2",size:"0.5rem",color:sap.ui.core.IconColor.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(h){if(h){return true;}else{return false;}}}})]})]});};S.prototype.setShowHeader=function(s){if(s){var h=this._getResourceText("p13n.SHOW_SELECTED");var i=this._getResourceText("p13n.SHOW_ALL");this._oListControl.setHeaderToolbar(new O({content:[this._getSearchField(),new c(),new d({press:function(E){this._bShowSelected=E.getSource().getText()==h;this._filterList(this._bShowSelected,this._sSearch);E.getSource().setText(this._bShowSelected?i:h);}.bind(this),text:h})]}));}this.setProperty("showHeader",s);return this;};S.prototype.getSelectedFields=function(){var s=[];this._loopItems(this._oListControl,function(i,k){if(i.getSelected()){s.push(k);}});return s;};S.prototype._filterList=function(s,h){var o=[],i=[];if(s){i=new F(this.PRESENCE_ATTRIBUTE,"EQ",true);}if(h){o=new F("label","Contains",h);}this._oListControl.getBinding("items").filter(new F([].concat(i,o),true));};S.prototype._onSearchFieldLiveChange=function(E){this._sSearch=E.getSource().getValue();this._filterList(this._bShowSelected,this._sSearch);};S.prototype._handleActivated=function(h){this._removeMoveButtons();if(this._oHoveredItem&&this._oHoveredItem.getBindingContextPath()){var v=!!this._getP13nModel().getProperty(this._oHoveredItem.getBindingContextPath()).active;var o=this._oHoveredItem.getCells()[1].getItems()[0];o.setVisible(v);}var i=h.getCells()[1].getItems()[0];i.setVisible(false);this._oHoveredItem=h;this._updateEnableOfMoveButtons(h,false);this._addMoveButtons(h);};S.prototype._removeMoveButtons=function(){var m=this._getMoveButtonContainer();if(m){m.removeItem(this._getMoveTopButton());m.removeItem(this._getMoveUpButton());m.removeItem(this._getMoveDownButton());m.removeItem(this._getMoveBottomButton());}};S.prototype._getMoveButtonContainer=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.getParent()&&this._oMoveBottomButton.getParent().isA("sap.m.FlexBox")){return this._oMoveBottomButton.getParent();}};S.prototype.showFactory=function(s){this._bShowFactory=s;this._displayColumns();if(s){this.removeStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(e.Edit);this._addFactoryControl();}else{this.addStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(e.Navigation);this._removeFactoryControl();}};S.prototype._loopItems=function(o,i){o.getItems().forEach(function(h){var p=h.getBindingContextPath();var k=this._getP13nModel().getProperty(p).name;i.call(this,h,k);}.bind(this));};S.prototype.setP13nData=function(){this._oListControl.removeSelections();B.prototype.setP13nData.apply(this,arguments);this._updateCount();};S.prototype._updateCount=function(){this._getP13nModel().setProperty("/selectedItems",this._oListControl.getSelectedContexts(true).length);};S.prototype._selectTableItem=function(t,s){B.prototype._selectTableItem.apply(this,arguments);this._updateCount();};S.prototype._removeFactoryControl=function(){this._oListControl.getItems().forEach(function(i){var o=i.getCells()[0];if(o.getItems().length>1){o.removeItem(o.getItems()[1]);}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields;};S.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};S.prototype._getShowFactory=function(){return this._bShowFactory;};S.prototype._displayColumns=function(){var h=[this.getFieldColumn()];if(!this._bShowFactory){h.push(new a({width:"30%",hAlign:"Center",vAlign:"Middle",header:new T({text:this.getActiveColumn()})}));}this._setPanelColumns(h);};S.prototype._setPanelColumns=function(h){this._sText=h[0];var E=this.getEnableCount();if(E){var o=new a({header:new T({text:{parts:[{path:this.P13N_MODEL+'>/selectedItems'},{path:this.P13N_MODEL+'>/items'}],formatter:function(s,A){return this._sText+" "+this._getResourceText('p13n.HEADER_COUNT',[s,A instanceof Array?A.length:0]);}.bind(this)}})});h[0]=o;}B.prototype._setPanelColumns.apply(this,arguments);};S.prototype._addFactoryControl=function(o){this._oListControl.getItems().forEach(function(i){var h=i.getBindingContext(this.P13N_MODEL);var j=this.getItemFactory().call(this,h);var k=i.getCells()[0];k.addItem(j);}.bind(this));this.addStyleClass("sapUiMDCAFLabelMarkingList");};S.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerSelectionPanelTable",Object.assign({growing:false,growingThreshold:25,growingScrollToLoad:true,updateStarted:function(){this._removeMoveButtons();this._removeFactoryControl();}.bind(this),updateFinished:function(){if(this._getShowFactory()){this._addFactoryControl();}}.bind(this)},this._getListControlConfig()));};S.prototype.filterContent=function(h){if(this._oListControl.getBinding("items")){this._oListControl.getBinding("items").filter(h,true);}};S.prototype._addMoveButtons=function(i){var t=i;if(!t){return;}var h=this._getP13nModel().getProperty(t.getBindingContextPath())[this.PRESENCE_ATTRIBUTE];if(h){t.getCells()[1].addItem(this._getMoveTopButton());t.getCells()[1].addItem(this._getMoveUpButton());t.getCells()[1].addItem(this._getMoveDownButton());t.getCells()[1].addItem(this._getMoveBottomButton());}};S.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._aInitializedFields=null;this._oHoveredItem=null;this._bShowFactory=null;this._sSearch=null;this._bShowSelected=null;};return S;});
