/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/library","sap/ui/core/Element","sap/ui/core/util/File","sap/ui/Device","sap/ui/core/Item","sap/m/upload/UploadSetItem","sap/m/upload/UploaderHttpRequestMethod"],function(L,M,E,F,D,H,U,a){"use strict";var b=E.extend("sap.m.upload.Uploader",{metadata:{library:"sap.m",publicMethods:["uploadItem","terminateItem","downloadItem"],properties:{uploadUrl:{type:"string",defaultValue:null},downloadUrl:{type:"string",defaultValue:null},httpRequestMethod:{type:"sap.m.upload.UploaderHttpRequestMethod",defaultValue:a.Post},useMultipart:{type:"boolean",defaultValue:false}},events:{uploadStarted:{parameters:{item:{type:"sap.m.upload.UploadSetItem"}}},uploadProgressed:{parameters:{item:{type:"sap.m.upload.UploadSetItem"},loaded:{type:"int"},total:{type:"int"}}},uploadCompleted:{parameters:{item:{type:"sap.m.upload.UploadSetItem"},responseXHR:{type:"object"}}},uploadAborted:{parameters:{item:{type:"sap.m.upload.UploadSetItem"}}}}}});b.prototype.init=function(){this._mRequestHandlers={};};b.uploadFile=function(f,u,h){var x=new window.XMLHttpRequest();var s=this.getHttpRequestMethod();return new Promise(function(r,c){x.open(s,u,true);if((D.browser.edge||D.browser.internet_explorer)&&f.type&&x.readyState===1){x.setRequestHeader("Content-Type",f.type);}if(h){h.forEach(function(o){x.setRequestHeader(o.getKey(),o.getText());});}x.onreadystatechange=function(){if(this.readyState===window.XMLHttpRequest.DONE){if(this.status===200){r(this);}else{c(this);}}};x.send(f);});};b.prototype.uploadItem=function(i,h){var x=new window.XMLHttpRequest(),f=i.getFileObject(),t=this,r={xhr:x,item:i},s=this.getHttpRequestMethod(),u=i.getUploadUrl()||this.getUploadUrl();x.open(s,u,true);if((D.browser.edge||D.browser.internet_explorer)&&f.type&&x.readyState===1){x.setRequestHeader("Content-Type",f.type);}if(h){h.forEach(function(c){x.setRequestHeader(c.getKey(),c.getText());});}if(this.getUseMultipart()){var o=new window.FormData();var n=f?f.name:null;if(f instanceof window.Blob&&n){o.append(n,f,f.name);}else{o.append(n,f);}o.append("_charset_","UTF-8");f=o;}x.upload.addEventListener("progress",function(e){t.fireUploadProgressed({item:i,loaded:e.loaded,total:e.total,aborted:false});});x.onreadystatechange=function(){var c=t._mRequestHandlers[i.getId()],R={};if(this.readyState===window.XMLHttpRequest.DONE&&!c.aborted){R={"response":this.response,"responseXML":this.responseXML,"readyState":this.readyState,"status":this.status,"headers":this.getAllResponseHeaders()};t.fireUploadCompleted({item:i,responseXHR:R});}};this._mRequestHandlers[i.getId()]=r;x.send(f);this.fireUploadStarted({item:i});};b.prototype.terminateItem=function(i){var h=this._mRequestHandlers[i.getId()],t=this;h.xhr.onabort=function(){h.aborted=false;t.fireUploadAborted({item:i});};h.aborted=true;h.xhr.abort();};b.prototype.downloadItem=function(i,h,A){var u=this.getDownloadUrl()||i.getUrl();if(D.browser.name==="sf"){A=false;}if(!i.getUrl()){L.warning("Items to download do not have a URL.");return false;}else if(A){var B=null,x=new window.XMLHttpRequest();x.open("GET",u);h.forEach(function(o){x.setRequestHeader(o.getKey(),o.getText());});x.responseType="blob";x.onload=function(){var f=i.getFileName(),s=U._splitFileName(f,false);B=x.response;F.save(B,s.name,s.extension,i.getMediaType(),"utf-8");};x.send();return true;}else{M.URLHelper.redirect(u,true);return true;}};return b;});
