/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','./ComboBox','./library','sap/ui/core/History','sap/ui/core/SeparatorItem','./DropdownBoxRenderer','sap/ui/Device','./TextField','sap/ui/core/ListItem','sap/ui/dom/containsOrEquals','sap/ui/events/jquery/EventExtension','sap/ui/events/KeyCodes','sap/ui/dom/jquery/cursorPos','sap/ui/dom/jquery/selectText'],function(q,L,C,a,H,S,D,b,T,c,d,E,K){"use strict";var e=C.extend("sap.ui.commons.DropdownBox",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{searchHelpEnabled:{type:"boolean",group:"Behavior",defaultValue:false},searchHelpText:{type:"string",group:"Appearance",defaultValue:null},searchHelpAdditionalText:{type:"string",group:"Appearance",defaultValue:null},searchHelpIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},events:{searchHelp:{parameters:{value:{type:"string"}}}}}});e.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oValueBeforePaste=null;this._oValueBeforeOpen=null;this.__aItems=null;this._iCursorPosBeforeBackspace=null;this._searchHelpItem=null;this._iItemsForHistory=10;this._oHistory=new H(this.getId());};e.prototype.exit=function(){var I=this.getId()+"-h-";if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}C.prototype.exit.apply(this,arguments);function r(f){var o=sap.ui.getCore().byId(f);if(o){o.destroy();}}for(var i=0;i<this.getMaxHistoryItems();i++){r(I+i);}if(this.__oSeparator){this.__oSeparator.destroy();this.__oSeparator=null;}this._oHistory=null;this.__aItems=null;this._sWantedValue=undefined;};e.prototype.onAfterRendering=function(o){C.prototype.onAfterRendering.apply(this,arguments);if(!this._sHandleItemsChanged){this.checkValueInItems();}};e.prototype.getItems=function(){if(this.oPopup&&this.oPopup.isOpen()){return this.__aItems;}else{return C.prototype.getItems.apply(this,arguments);}};e.prototype.insertItem=function(i,I){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.splice(I,0,i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().insertItem(i,I);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return this;}else{return C.prototype.insertItem.apply(this,arguments);}};e.prototype.addItem=function(i){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.push(i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().addItem(i);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return this;}else{return C.prototype.addItem.apply(this,arguments);}};e.prototype.removeItem=function(v){if(this.oPopup&&this.oPopup.isOpen()){var I=null;var o=v;if(typeof(v)=="string"){v=sap.ui.getCore().byId(v);}if(typeof(v)=="object"){for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=this.__aItems.length){L.warning("Element.removeAggregation called with invalid index: Items, "+v);}else{I=this.__aItems[v];this.__aItems.splice(v,1);}}if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().removeItem(o);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var f=r.cursorPos();this._doTypeAhead(r.val().substr(0,f),"");}return I;}else{return C.prototype.removeItem.apply(this,arguments);}};e.prototype.removeAllItems=function(){if(this.oPopup&&this.oPopup.isOpen()){var i=this.__aItems;if(!i){return[];}C.prototype.removeAllItems.apply(this,arguments);this.__aItems=[];return i;}else{return C.prototype.removeAllItems.apply(this,arguments);}};e.prototype.indexOfItem=function(I){if(this.oPopup&&this.oPopup.isOpen()){if(this.__aItems){if(this.__aItems.length==undefined){return-2;}for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){return i;}}}return-1;}else{return C.prototype.indexOfItem.apply(this,arguments);}};e.prototype.destroyItems=function(){if(this.oPopup&&this.oPopup.isOpen()){if(!this.__aItems){return this;}this._getListBox().removeAllItems();for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]){this.__aItems[i].destroy();}}this.__aItems=[];return this;}else{return C.prototype.destroyItems.apply(this,arguments);}};e.prototype.updateItems=function(){C.prototype.updateItems.apply(this,arguments);if(this.oPopup&&this.oPopup.isOpen()){var r=q(this.getInputDomRef());var i=r.cursorPos();this._doTypeAhead(r.val().substr(0,i),"");}};e.prototype._handleItemsChanged=function(o,f){if(f){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}if(this._bNoItemCheck){return;}if(this.__aItems&&(!this.oPopup||!this.oPopup.isOpen())){throw new Error("DropdownBox "+this.getId()+" : this.__aItems is not empty!");}if(this.getListBox()&&this.oPopup&&this.oPopup.isOpen()){if(this.__aItems.length>this._iItemsForHistory||this._searchHelpItem){var I;var i=0;switch(o.getParameter("event")){case"destroyItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}this.__aItems=[];if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}break;case"removeAllItems":this.__aItems=[];break;case"removeItem":I=o.getParameter("item");for(i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){this.__aItems.splice(i,1);break;}}if(this.__aItems.length<=this._iItemsForHistory){this._getListBox().setItems(this.__aItems,false,true);}break;case"insertItem":this.__aItems.splice(o.getParameter("index"),0,o.getParameter("item"));break;case"addItem":this.__aItems.push(o.getParameter("item"));break;case"setItems":this.__aItems=o.getParameter("items");break;case"updateItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}this.__aItems=this._getListBox().getItems();break;default:break;}}else{this.__aItems=this._getListBox().getItems();}var r=q(this.getInputDomRef());var g=r.cursorPos();this._doTypeAhead(r.val().substr(0,g),"");}C.prototype._handleItemsChanged.apply(this,arguments);this.checkValueInItems();};e.prototype.onclick=function(o){if(!this.mobile&&this.getEnabled&&this.getEnabled()&&this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){this._close();this._doSelect();}else if(!this._F4ForClose){this._open();}this.focus();}this._F4ForClose=false;};e.prototype.onmousedown=function(o){if(!this.getEnabled()||!this.getEditable()){return;}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true;}else{this._F4ForOpen=true;}C.prototype.onmousedown.apply(this,arguments);};e.prototype.onsapshow=function(o){if(this.mobile){return;}if(!this.getEnabled()||!this.getEditable()){o.preventDefault();o.stopImmediatePropagation();return;}if(o.which===K.F4&&this._searchHelpItem){this._close();this.fireSearchHelp({value:q(this.getInputDomRef()).val()});o.preventDefault();o.stopImmediatePropagation();return;}if(this.oPopup&&this.oPopup.isOpen()){this._close();}else{this._open();var l=this._getListBox();l.scrollToIndex(l.getSelectedIndex());this._doSelect();}o.preventDefault();o.stopImmediatePropagation();};e.prototype.onkeydown=function(o){if(o.target.id==this.getId()+"-select"){return;}if(b.browser.webkit&&(o.which==K.DELETE||o.which==K.BACKSPACE)){this.onkeypress(o);}if(o.which!==K.BACKSPACE){return;}};e.prototype.onpaste=function(o){if(o.target.id==this.getId()+"-select"){return;}if(this._oValueBeforePaste===null){this._oValueBeforePaste=q(this.getInputDomRef()).val();}};e.prototype.oncut=e.prototype.onpaste;e.prototype.oninput=function(o){if(this.mobile){return;}var r=q(this.getInputDomRef());var v=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var V=this._doTypeAhead(v,"");if(!V&&this._oValueBeforePaste){this._doTypeAhead("",this._oValueBeforePaste);}this._oValueBeforePaste=null;this._fireLiveChange(o);};e.prototype.onkeyup=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=o.which;T.prototype.onkeyup.apply(this,arguments);if(this._oValueBeforePaste===null||k===K.TAB){return;}if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var r=q(this.getInputDomRef()),v=false;if(k===K.BACKSPACE&&this._iCursorPosBeforeBackspace!==null){var i=r.cursorPos();if(this._iCursorPosBeforeBackspace!==i){i++;}this._iCursorPosBeforeBackspace=null;v=this._doTypeAhead(r.val().substr(0,i-1),"");}else if(!(v=this._doTypeAhead("",r.val()))){r.val(this._oValueBeforePaste);}if(v){this._getListBox().rerender();}this._oValueBeforePaste=null;};e.prototype.onsaphome=function(o){if(o.target.id==this.getId()+"-select"){return;}if((!this.oPopup||!this.oPopup.isOpen())&&this.getEditable()&&this.getEnabled()){T.prototype.onsaphome.apply(this,arguments);var r=q(this.getInputDomRef());r.cursorPos(0);this._updateSelection();o.preventDefault();}else{C.prototype.onsaphome.apply(this,arguments);}};e.prototype.onsapdelete=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.oPopup||!this.oPopup.isOpen()){return;}var l=this._getListBox(),i=l.getSelectedItem(),m=i.getId().match(/\-h\-([0-4])/),I=l.getSelectedIndex();if(m&&m.length===2){this._oHistory.remove(i.getText());l.removeItem(I);var f=this._oHistory.get().length;if(f===0){l.removeItem(0);}l.rerender();var n=I+(this._searchHelpItem?2:0);if(n==f){n++;}l.setSelectedIndex(n);this.setValue(l.getSelectedItem().getText());}};e.prototype.onkeypress=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=o.which,i=o.keyCode;if((C._isHotKey(o)||(b.browser.firefox&&i===K.HOME)||i===K.F4&&o.which===0)&&!(o.ctrlKey&&o.which==120)){return;}else if(i==K.ESCAPE){var v=this.getProperty("value");var I=this.getInputDomRef();if(I&&I.value!==v){q(I).val(v);}return;}var n=String.fromCharCode(k),r=q(this.getInputDomRef()),f=r.cursorPos(),V=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}if(k===K.BACKSPACE){this._doTypeAhead(V.substr(0,f-1),"");}else{this._doTypeAhead(V.substr(0,f),n);}if(V!=r.val()){this._fireLiveChange(o);}this._bFocusByOpen=undefined;o.preventDefault();};e.prototype.onsapright=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(1);}else{this._updateSelection(-1);}o.preventDefault();};e.prototype.onsapleft=function(o){if(o.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(-1);}else{this._updateSelection(1);}o.preventDefault();};e.prototype.onfocusin=function(o){if(!this.oPopup||!this.oPopup.isOpen()||this._bFocusByOpen){var r=q(this.getInputDomRef()),l=r.val().length;if(l>0&&!this.mobile){this._callDoSelectAfterFocusIn(0,l);}this._bFocusByOpen=undefined;}C.prototype.onfocusin.apply(this,arguments);};e.prototype._callDoSelectAfterFocusIn=function(s,i){this._doSelect(s,i);};e.prototype.onselect=function(o){var t=new Date().getTime();if(this._bIgnoreSelect){this._bIgnoreSelect=false;this.iOldTimestamp=t;return;}if(this.iOldTimestamp&&t-this.iOldTimestamp<50){return;}this.iOldTimestamp=undefined;if(!this.getEnabled()||!this.getEditable()){return;}var r=q(this.getInputDomRef()),n=r.cursorPos(),v=r.val();if(v.length>0&&n>0){this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}}o.preventDefault();};e.prototype._determinePosinset=function(i,n){var p=n+1;if(this.oPopup&&this.oPopup.isOpen()){this.dontSetPoisinset=undefined;var I=i[n];var h=i[0].getId().search(this.getId()+"-h-")!=-1;if(I.getId().search(this.getId()+"-h-")==-1){if(h){p=p-1;}if(this._searchHelpItem){p=p-2;}}}return p;};e.prototype._doSelect=function(s,i){this._bIgnoreSelect=true;var o=this.getInputDomRef();if(o){var r=q(o);r.selectText(s?s:0,i?i:r.val().length);}return this;};e.prototype._updateSelection=function(m){var r=q(this.getInputDomRef()),n=r.cursorPos()+(m||0),v=r.val();this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}else{this._getListBox().rerender();}};e.prototype._doTypeAhead=function(v,n,N,I){if(this.__doTypeAhead===true){return;}this.__doTypeAhead=true;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sWantedValue=undefined;var l=this._getListBox(),m=this.getMaxPopupItems(),f=this.__aItems||l.getItems(),V=f.length,h=this.getMaxHistoryItems()>0&&f.length>this._iItemsForHistory,F=!N&&h,o=v+n,s=new RegExp("[.*+?|()\\[\\]{}\\\\]","g"),r=o.toLowerCase().replace(s,"\\$&"),g=RegExp("^"+r+".*$"),M=n&&n.length||0,R=q(this.getInputDomRef());this.__aItems=f;if(V<=0){this.__doTypeAhead=false;return false;}var j,k=this._getFilteredItems(f,g),p=k.length>0;if(!p){F=false;}if(F){j=k;}else{j=f.slice(0);}var t=[];if(h){t=this._addHistoryItems(j,F&&g);l.setItems(j,false,true);V=j.length;}l.setVisibleItems(m<V?m:-1);var u,w=t.length;var i=0;if(I>=0){u=f[I];}if(!F&&w>0&&p){t=this._getFilteredItems(t,g);u=t[0];}if(F){u=k[0];}else if(!u){if(k.length>0){u=k[0];}else{var O=R.val();var x=0;for(i=0;i<j.length;i++){var y=j[i];if(y.getEnabled()){if(!x){x=i;}if(y.getText()==O){u=y;break;}}}if(!u){u=j[x];}}}var z=this._searchHelpItem;if(z){j.splice(w++,0,z[0],z[1]);l.setItems(j,false,true);}i=l.indexOfItem(u);var A=u.getText();var P=i+1;var B=j.length;if(t.length>0){B=B-1;}if(z){B=B-2;}if(P>t.length){if(t.length>0){P=P-1;}if(z){P=P-2;}}this._updatePosInSet(R,P,(u.getAdditionalText?u.getAdditionalText():""));R.attr("aria-setsize",B);R.val(A);this._sTypedChars=o;this._doSelect(v.length+M,A.length);l.setSelectedIndex(i);if(z&&i==2){l.scrollToIndex(0);}else{l.scrollToIndex(i);}this._iClosedUpDownIdx=i;if(!p){R=this.$();R.addClass("sapUiTfErr");setTimeout(function(){R.removeClass("sapUiTfErr");},300);R.cursorPos(v.length);this._doSelect(v.length,A.length);}this.__doTypeAhead=false;return p;};e.prototype._prepareOpen=function(l,p){this._oValueBeforeOpen=q(this.getInputDomRef()).val();this._bOpening=true;if(!this.noTypeAheadByOpen){var i;if(this._iClosedUpDownIdx>=0){i=this._iClosedUpDownIdx;}else if(this.getSelectedItemId()){i=this.indexOfItem(sap.ui.getCore().byId(this.getSelectedItemId()));}this._doTypeAhead("",q(this.getInputDomRef()).val(),true,i);this._doSelect();}return this;};e.prototype._handleOpened=function(){C.prototype._handleOpened.apply(this,arguments);q(this.getInputDomRef()).trigger("focus");};e.prototype._cleanupClose=function(l){if(this.__aItems){var s=l.getSelectedItem();l.setItems(this.__aItems,false,true);this._iClosedUpDownIdx=l.indexOfItem(s);l.setSelectedIndex(this._iClosedUpDownIdx);this.__aItems=undefined;}this._oValueBeforeOpen=null;this._bOpening=undefined;return this;};e.prototype._getFilteredItems=function(I,r){var t=I.slice(0),o;for(var i=t.length-1;i>=0;i--){o=t[i];if(!r.test(o.getText().toLowerCase())||!o.getEnabled()){t.splice(i,1);}}return t;};e.prototype._addHistoryItems=function(I,r){var s=this.getId()+"-h-",o,h=this._oHistory.get(),l=h.length,n=[];for(var i=0,j=0;j<this.getMaxHistoryItems()&&i<l;i++){if(!r||r.test(h[i])){o=(o=sap.ui.getCore().byId(s+j))&&o.setText(h[i])||new c(s+j,{text:h[i]});n.push(o);j++;}}if(n.length>0){var f=s+"separator",g=this._getSeparator(f);n.push(g);}I.unshift.apply(I,n);return n;};e.prototype._getSeparator=function(s){if(!this.__oSeparator&&s){this.__oSeparator=sap.ui.getCore().byId(s)||new S(s);}return this.__oSeparator||null;};e.prototype.fireChange=function(A){this.fireEvent("change",A);if(A.newValue&&(this.getMaxHistoryItems()>0)){this._oHistory.add(A.newValue);}this._sWantedValue=undefined;return this;};e.prototype.setValue=function(v,n){v=(v===undefined||v===null||v==="")?"":v;var I=this.getItems(),t,V=false,f;for(var i=0,l=I.length;i<l&&!V;i++){var o=I[i];var g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===v&&g;}if(V){C.prototype.setValue.call(this,v,n);this._sWantedValue=undefined;}else if(v===""&&I.length>0){C.prototype.setValue.call(this,f,n);}else{this._sWantedValue=v;}return this;};e.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.apply(this,arguments);if(!this._bOpening&&(!this.oPopup||!this.oPopup.isOpen())){this._cleanupClose(this._getListBox());}return this;};e.prototype._focusAfterListBoxClick=function(){if(!b.browser.webkit){this.focus();}else{var l=this._getListBox();l.addDelegate({onclick:function(){l.removeDelegate(this);this.focus();}.bind(this)});}};e.prototype.onsapfocusleave=function(o){var l=this._getListBox();if(o.relatedControlId&&d(l.getFocusDomRef(),sap.ui.getCore().byId(o.relatedControlId).getFocusDomRef())){this._focusAfterListBoxClick();}else{if(this.oPopup&&this.oPopup.isOpen()){this._close();}T.prototype.onsapfocusleave.apply(this,arguments);}};e.prototype.getTooltip_AsString=function(){var t=C.prototype.getTooltip_AsString.apply(this,arguments);if(!this._searchHelpItem){return t;}else{var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=r.getText("DDBX_SHI_ARIA");s=s==="DDBX_SHI_ARIA"?"Open search help via {0}":s;var A=this._searchHelpItem[0]&&this._searchHelpItem[0].getAdditionalText()||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;s=s.replace("{0}",A);return(t?t+" - ":"")+s;}};e.prototype._handleSelect=function(o){if(this._searchHelpItem&&o.getParameter("selectedItem")===this._searchHelpItem[0]){var f=new q.Event("sapshow");f.which=K.F4;this.onsapshow(f);}else{var i=o.getParameter("selectedItem");if(!i){i=sap.ui.getCore().byId(o.getParameter("selectedId"));}if(i.getId().search(this.getId()+"-h-")!=-1){var l=this._getListBox(),I=l.getItems();var g=this._oHistory.get().length;if(g>this.getMaxHistoryItems()){g=Math.max(this.getMaxHistoryItems(),0);}for(var h=g;h<I.length;h++){if(I[h].getText()==i.getText()&&I[h].getEnabled()){o.mParameters.selectedIndex=h;if(!o.getParameter("selectedIndices")){o.mParameters.selectedIndices=new Array(1);o.mParameters.aSelectedIndices=new Array(1);}o.mParameters.selectedIndices[0]=h;o.mParameters.aSelectedIndices[0]=h;o.mParameters.selectedItem=I[h];break;}}}this._sWantedValue=undefined;return C.prototype._handleSelect.apply(this,arguments);}};e.prototype.setSearchHelpEnabled=function(f,t,A,i){this.setProperty("searchHelpEnabled",f);if(t){this.setProperty("searchHelpText",t);}else{t=this.getSearchHelpText();}if(A){this.setProperty("searchHelpAdditionalText",A);}else{A=this.getSearchHelpAdditionalText();}if(i){this.setProperty("searchHelpIcon",i);}else{i=this.getSearchHelpIcon();}if(f){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){t=t||r.getText("DDBX_SHI");t=t==="DDBX_SHI"?"Search Help":t;A=A||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;}i=i||sap.ui.require.toUrl("sap/ui/commons/images/dropdown/ico12_f4.gif");if(!this._searchHelpItem){this._searchHelpItem=[new c(this.getId()+"_shi",{text:t,additionalText:A,enabled:true,icon:i}),new S()];}else{this._searchHelpItem[0].setText(t).setAdditionalText(A).setIcon(i);}}else{if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}}return this;};e.prototype.setSearchHelpText=function(s){this.setProperty("searchHelpText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),s,this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());return this;};e.prototype.setSearchHelpAdditionalText=function(s){this.setProperty("searchHelpAdditionalText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),s,this.getSearchHelpIcon());return this;};e.prototype.setSearchHelpIcon=function(s){this.setProperty("searchHelpIcon",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),s);return this;};e.prototype.checkValueInItems=function(){var v=this.getValue();var I=C.prototype.getItems.apply(this);var w=this._sWantedSelectedKey;var W=this._sWantedSelectedItemId;if(I&&I.length>0){var V=false;var f;var i=0,l=0;var o;var g=false;var t="";if(this._sWantedValue){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===this._sWantedValue&&g;}if(V){v=this._sWantedValue;this._sWantedValue=undefined;w=undefined;W=undefined;C.prototype.setValue.call(this,v);}}if(!V){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];g=o.getEnabled();t=o.getText();if(g&&!f){f=t;}V=t===v&&g;}}if(!V){v=f;C.prototype.setValue.call(this,v);}}else{v="";C.prototype.setValue.call(this,v);}this._sWantedSelectedKey=w;this._sWantedSelectedItemId=W;return v;};e.prototype.setMaxHistoryItems=function(m){var o=this.getMaxHistoryItems();var I=this.getId()+"-h-";var f;this.setProperty('maxHistoryItems',m,true);if(m<o){var l=this._getListBox();for(var i=Math.max(m,0);i<o;i++){f=sap.ui.getCore().byId(I+i);if(f){l.removeItem(f);f.destroy();}}if(m<=0&&this.__oSeparator){l.removeItem(this.__oSeparator);}}return this;};e.prototype.clearHistory=function(){this._oHistory.clear();var I=this.getId()+"-h-";var l=this._getListBox();var o;for(var i=0;i<this.getMaxHistoryItems();i++){o=sap.ui.getCore().byId(I+i);if(o){l.removeItem(o);o.destroy();}}if(this.__oSeparator){l.removeItem(this.__oSeparator);}};e.prototype.ondrop=function(o){o.preventDefault();};e.prototype._isSetEmptySelectedKeyAllowed=function(){return false;};return e;});
