/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./TextField','./TextView','./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/theming/Parameters','./InPlaceEditRenderer','sap/ui/core/library','sap/ui/Device','./Button','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes'],function(T,a,l,C,V,P,I,c,D,B,b,K){"use strict";var d=l.TextViewDesign;var e=c.ValueState;var f=C.extend("sap.ui.commons.InPlaceEdit",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:e.None},undoEnabled:{type:"boolean",group:"Misc",defaultValue:true},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:d.Standard}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});f.prototype.init=function(){this._bEditMode=false;};f.prototype.exit=function(){this._bEditMode=undefined;this._oDisplayControl=undefined;this._oEditControl=undefined;this._sOldText=undefined;this._sOldTextAvailable=undefined;this._bUseEditButton=undefined;this._iHeight=undefined;if(this._oTextView){this._oTextView.destroy();delete this._oTextView;}if(this._oTextField){this._oTextField.destroy();delete this._oTextField;}if(this._oUndoButton){this._oUndoButton.destroy();delete this._oUndoButton;}if(this._oEditButton){this._oEditButton.destroy();delete this._oEditButton;}var x=this.getContent();if(x){x.detachEvent("_change",w,this);if(x instanceof T){x.detachEvent("change",t,this);x.detachEvent("liveChange",v,this);}}};f.prototype.onBeforeRendering=function(){var x=this;u(x);j(x);var y=this.getTooltip();if(y instanceof sap.ui.core.TooltipBase){if(this._bEditMode){y._currentControl=this._oEditControl;}else{y._currentControl=this._oDisplayControl;}}};f.prototype.onAfterRendering=function(){if(!this._bEditMode&&this.getEditable()&&this._oTextView&&this._oTextView.getDomRef()){this._oTextView.$().attr("tabindex","0");}var $=this.$();var x;var O;if(this._bEditMode){this._oEditControl.$().css("width","100%");if(this._iHeight>0){O=$.height();var y=this._iHeight-O;var M=$.outerHeight(true)-$.outerHeight(false);y=y+M;var z=Math.floor(y/2);var A=y-z;$.css("margin-top",z+"px").css("margin-bottom",A+"px");}}else if(this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){this._oDisplayControl.$().css("width","auto").css("max-width","100%");}else{var E=this._oDisplayControl.$();E.css("width","100%");if(!this._iHeight&&this._iHeight!=0&&this.getDesign()!=d.Standard){x=E.outerHeight(true);O=$.innerHeight();if(O<x){var F=$.outerHeight()-$.innerHeight();this._iHeight=x+F;}else{this._iHeight=0;}}if(this._iHeight>0){$.css("height",this._iHeight+"px");}}if(this._sOldTextAvailable&&this._oUndoButton&&this._oUndoButton.getDomRef()){this._oUndoButton.$().attr("tabindex","-1");}if(this._oEditButton&&this._oEditButton.getDomRef()){this._oEditButton.$().attr("tabindex","-1");}if(this._delayedCallId){clearTimeout(this._delayedCallId);this._delayedCallId=null;}if(this.getValueState()==e.Success){this._delayedCallId=setTimeout(function(){this.removeValidVisualization();}.bind(this),3000);}};f.prototype.removeValidVisualization=function(){var x=this.$();if(x){x.removeClass("sapUiIpeSucc");}};f.prototype.clearOldText=function(){if(!this.getUndoEnabled()){return;}if(this._bEditMode){this._sOldText=this._oEditControl.getValue();this._sOldTextAvailable=true;}else{this._sOldText=undefined;this._sOldTextAvailable=false;}this.rerender();};f.prototype.getRequired=function(){if(this.getContent()&&this.getContent().getRequired){return this.getContent().getRequired();}else{return false;}};f.prototype.getEditable=function(){var x=this.getContent();if(!x||(x.getEditable&&!x.getEditable())||(x.getEnabled&&!x.getEnabled())){return false;}else{return true;}};f.prototype.onsapescape=function(E){if(this.getUndoEnabled()){if(!D.browser.firefox){var x=this;n(x);}else{this._bEsc=true;}if(this.$().hasClass("sapUiIpeUndo")){E.stopPropagation();}this._oEditControl._bEsc=undefined;this._oEditControl._sValue=undefined;}};f.prototype.onkeypress=function(E){if(this._bEsc){var x=this;this._bEsc=undefined;n(x);}};f.prototype.onkeydown=function(E){if(E.keyCode==K.F2&&!this._bEditMode){var x=this;s(x);this.$().addClass("sapUiIpeFocus");}};f.prototype.onfocusin=function(E){if(!this._bEditMode){if(!this._bUseEditButton&&E.target.id!=this.getId()+"--X"){var x=this;s(x);}this.$().addClass("sapUiIpeFocus");}else if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null;}};f.prototype.ontap=function(E){if(D.os.name=="iOS"){this.onfocusin(E);}};f.prototype.onfocusout=function(E){if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null;}this._focusDelay=setTimeout(function(){this._handleFocusOut(E);}.bind(this),200);};f.prototype._handleFocusOut=function(E){var F=document.activeElement;if(!b(this.getDomRef(),F)){if(!this._bEditMode){this.$().removeClass("sapUiIpeFocus");}var x=this;h(x);}this._focusDelay=undefined;};f.prototype.setContent=function(x){var O=this.getContent();if(O){O.detachEvent("_change",w,this);if(O instanceof T){O.detachEvent("change",t,this);O.detachEvent("liveChange",v,this);O._propagateEsc=undefined;}}this._sOldText=undefined;this._sOldTextAvailable=false;this._oDisplayControl=undefined;this._oEditControl=undefined;this.setAggregation("content",x);if(x){x.attachEvent("_change",w,this);if(x instanceof T){x.attachEvent("change",t,this);x.attachEvent("liveChange",v,this);x._propagateEsc=true;}}var y=this;u(y);return this;};f.prototype.setValueState=function(x){var y=this.getContent();if(y&&y.setValueState){y.setValueState(x);}else if(this._oEditControl&&this._oEditControl.setValueState){this._oEditControl.setValueState(x);w.call(this);}else{this.setProperty("valueState",x);}return this;};f.prototype.getValueState=function(){var x=this.getContent();if(x&&x.getValueState){return x.getValueState();}else if(this._oEditControl&&this._oEditControl.getValueState){return this._oEditControl.getValueState();}else{return this.getProperty("valueState");}};f.prototype.setTooltip=function(x){var y=this.getContent();if(y){y.setTooltip(x);}else{this._refreshTooltipBaseDelegate(x);this.setAggregation("tooltip",x);}return this;};f.prototype.getTooltip=function(){var x=this.getContent();if(x){return x.getTooltip();}else{return this.getAggregation("tooltip");}};f.prototype.setDesign=function(x){this.setProperty("design",x);this._iHeight=undefined;return this;};f.prototype.clone=function(){var x=this.getContent();if(x){x.detachEvent("_change",w,this);if(x instanceof T){x.detachEvent("change",t,this);x.detachEvent("liveChange",v,this);}}var y=C.prototype.clone.apply(this,arguments);if(x){x.attachEvent("_change",w,this);if(x instanceof T){x.attachEvent("change",t,this);x.attachEvent("liveChange",v,this);}}return y;};f.prototype.getFocusDomRef=function(){if(!this.getDomRef()){return undefined;}if(this._bEditMode){return this._oEditControl.getFocusDomRef();}else{return this._oDisplayControl.getFocusDomRef();}};f.prototype.getIdForLabel=function(){if(this._oDisplayControl&&this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){return this._oDisplayControl.getId();}else if(this._oEditControl){return this._oEditControl.getId();}else{return this.getId();}};f.prototype.onThemeChanged=function(E){var x=this;k(x);p(x);this._iHeight=undefined;if(this.getDomRef()&&!this._bEditMode){this.rerender();}};f.prototype.getAccessibilityInfo=function(){var x=this.getContent();return x&&x.getAccessibilityInfo?x.getAccessibilityInfo():null;};var g={onAfterRendering:function(){this.onAfterRendering();}};function u(x){var y=x.getContent();if(!y){return;}var z=y.getTooltip();switch(y.getMetadata().getName()){case"sap.ui.commons.TextField":case"sap.ui.commons.ComboBox":case"sap.ui.commons.DropdownBox":if(!x._oTextView){x._oTextView=new a(x.getId()+"--TV",{wrapping:false});x._oTextView.setParent(x);x._oTextView.removeDelegate(g);x._oTextView.addDelegate(g,x);x._oTextView.getTooltip=function(){return this.getParent().getTooltip();};}x._oTextView.setText(y.getValue());x._oTextView.setEnabled(y.getEnabled());x._oTextView.setTextDirection(y.getTextDirection());x._oTextView.setVisible(y.getVisible());x._oTextView.setWidth("100%");x._oTextView.setTextAlign(y.getTextAlign());x._oTextView.setDesign(x.getDesign());x._oTextView.setHelpId(y.getHelpId());x._oTextView.setAccessibleRole(y.getAccessibleRole());if(x._oTextView._oTooltip&&x._oTextView._oTooltip!=z){x._oTextView.removeDelegate(x._oTextView._oTooltip);x._oTextView._oTooltip=undefined;}if(z instanceof sap.ui.core.TooltipBase){if(!x._oTextView._oTooltip||x._oTextView._oTooltip!=z){x._oTextView.addDelegate(z);x._oTextView._oTooltip=z;}}x._oDisplayControl=x._oTextView;x._oEditControl=y;x._bUseEditButton=false;break;case"sap.ui.commons.Link":x._oDisplayControl=y;x._oDisplayControl.removeDelegate(g);x._oDisplayControl.addDelegate(g,x);if(x._oTextField){x._oTextField.setValue(y.getText());x._oTextField.setWidth("100%");x._oEditControl=x._oTextField;if(x._oTextField._oTooltip&&x._oTextField._oTooltip!=z){x._oTextField.removeDelegate(x._oTextField._oTooltip);x._oTextField._oTooltip=undefined;}if(z instanceof sap.ui.core.TooltipBase){if(!x._oTextField._oTooltip||x._oTextField._oTooltip!=z){x._oTextField.addDelegate(z);x._oTextField._oTooltip=z;}}}o(x);x._bUseEditButton=true;break;default:throw new Error("Control not supported for InPlaceEdit");}}function s(x){if(!x._bEditMode&&x.getEditable()){if(!x._oEditControl&&x.getContent().getMetadata().getName()=="sap.ui.commons.Link"){var y=x.getValueState();x._oTextField=new T(x.getId()+"--input",{valueState:y});x._oTextField.setParent(x);x._oTextField.attachEvent('change',r,x);x._oTextField.attachEvent('liveChange',v,x);x._oTextField._propagateEsc=true;x._oTextField.getTooltip=function(){return this.getParent().getTooltip();};}if(!x._sOldTextAvailable&&x.getUndoEnabled()){x._sOldText=i(x);x._sOldTextAvailable=true;}x._bEditMode=true;x.rerender();x._oEditControl.focus();}}function h(x){if(x._bEditMode&&x.getEditable()){x._bEditMode=false;if(x._sOldText==i(x)){x._sOldText=undefined;x._sOldTextAvailable=false;}x.rerender();}}function i(x){var y=x.getContent();if(!y){return undefined;}if(y.getValue){return y.getValue();}else if(y.getText){return y.getText();}}function j(x){if(!x._oUndoButton&&x.getUndoEnabled()){x._oUndoButton=new B(x.getId()+"--X",{lite:true}).setParent(x);k(x);x._oUndoButton.attachEvent('press',m,x);}if(x._oUndoButton){x._oUndoButton.setEnabled(x.getEditable());}}function k(x){if(x._oUndoButton){var y=P._getThemeImage('_sap_ui_commons_InPlaceEdit_UndoImageURL');var z=P._getThemeImage('_sap_ui_commons_InPlaceEdit_UndoImageDownURL');if(!y){y="sap-icon://decline";}x._oUndoButton.setIcon(y);x._oUndoButton.setIconHovered(z);}}function m(E){var x=this;n(x);if(this._bEditMode){this._oEditControl.focus();this.$().removeClass("sapUiIpeUndo");}}function n(x){if(x.getUndoEnabled()&&x._sOldTextAvailable){var y=x.getContent();if(!y){return;}if(y.setValue){y.setValue(x._sOldText);}else if(y.setText){y.setText(x._sOldText);}if(x._bEditMode){x._oEditControl.setValue(x._sOldText);x._oEditControl.fireChange({newValue:x._sOldText});}else if(y.fireChange){y.fireChange({newValue:x._sOldText});}else{x.fireChange({newValue:x._sOldText});}if(!x._bEditMode){x._sOldText=undefined;x._sOldTextAvailable=false;}}}function o(x){if(!x._oEditButton){x._oEditButton=new B(x.getId()+"--Edit",{lite:true}).setParent(x);x._oEditButton.addStyleClass("sapUiIpeEBtn");p(x);x._oEditButton.attachEvent('press',q,x);}}function p(x){if(x._oEditButton){var y=P._getThemeImage('_sap_ui_commons_InPlaceEdit_EditImageURL');var z=P._getThemeImage('_sap_ui_commons_InPlaceEdit_EditImageDownURL');if(!y){y="sap-icon://edit";}x._oEditButton.setIcon(y);x._oEditButton.setIconHovered(z);}}function q(E){var x=this;s(x);this.$().addClass("sapUiIpeFocus");}function r(E){var x=this.getContent();if(x.setText){var N=E.getParameter("newValue");x.setText(N);t.apply(this,arguments);}}function t(E){if(this._sOldText!=E.getParameter("newValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo");}else{this.$().removeClass("sapUiIpeUndo");}this.fireChange(E.getParameters());}function v(E){if(this._sOldText!=E.getParameter("liveValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo");}else{this.$().removeClass("sapUiIpeUndo");}this.fireLiveChange({liveValue:E.getParameter("liveValue")});}function w(){if(!this._bEditMode){this.invalidate();}else{switch(this.getValueState()){case(e.Error):if(!this.$().hasClass('sapUiIpeErr')){this.$().addClass('sapUiIpeErr');this.$().removeClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeSucc');}break;case(e.Success):if(!this.$().hasClass('sapUiIpeSucc')){this.$().addClass('sapUiIpeSucc');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeWarn');}break;case(e.Warning):if(!this.$().hasClass('sapUiIpeWarn')){this.$().addClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeSucc');}break;default:this.$().removeClass('sapUiIpeWarn');this.$().removeClass('sapUiIpeErr');this.$().removeClass('sapUiIpeSucc');break;}}}return f;});
