/*
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Manifest','./ComponentMetadata','./Element','sap/base/util/extend','sap/base/util/deepExtend','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectRegistry','sap/ui/core/ResizeHandler','sap/ui/thirdparty/URI','sap/ui/performance/trace/Interaction','sap/base/assert','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/UriParameters','sap/base/util/isPlainObject','sap/base/util/LoaderExtensions','sap/ui/VersionInfo','sap/ui/core/mvc/ViewType'],function(M,C,E,a,d,b,c,f,R,U,I,g,L,O,h,j,l,V,n){"use strict";var S={lazy:"lazy",eager:"eager",waitFor:"waitFor"};function o(e){['sap-client','sap-server'].forEach(function(N){if(!e.hasSearch(N)){var v=sap.ui.getCore().getConfiguration().getSAPParam(N);if(v){e.addSearch(N,v);}}});}function p(m,e,i,k){if(i){for(var N in m){if(!e[N]&&i[N]&&i[N].uri){e[N]=k;}}}}function q(m,e,k,i){var v=e.getEntry(k);if(v!==undefined&&!j(v)){return v;}var P,F;if(i&&(P=m.getParent())instanceof C){F=P.getManifestEntry(k,i);}if(F||v){v=d({},F,v);}return v;}function r(e,i){var k=Object.create(Object.getPrototypeOf(e));k._oMetadata=e;k._oManifest=i;for(var m in e){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof e[m]==="function"){k[m]=e[m].bind(e);}}k.getManifest=function(){return i&&i.getJson();};k.getManifestObject=function(){return i;};k.getManifestEntry=function(K,v){return q(e,i,K,v);};k.getMetadataVersion=function(){return 2;};return k;}function s(e,i,T){g(typeof e==="function","fn must be a function");var k=c._sOwnerId;try{c._sOwnerId=i;return e.call(T);}finally{c._sOwnerId=k;}}var t=c.extend("sap.ui.core.Component",{constructor:function(i,m){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){m=i;i=undefined;}if(m&&typeof m._metadataProxy==="object"){this._oMetadataProxy=m._metadataProxy;this._oManifest=m._metadataProxy._oManifest;delete m._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(m&&typeof m._cacheTokens==="object"){this._mCacheTokens=m._cacheTokens;delete m._cacheTokens;}if(m&&Array.isArray(m._activeTerminologies)){this._aActiveTerminologies=m._activeTerminologies;delete m._activeTerminologies;}if(m&&typeof m._manifestModels==="object"){this._mManifestModels=m._manifestModels;delete m._manifestModels;}else{this._mManifestModels={};}this._mServices={};this._oKeepAliveConfig=this.getManifestEntry("/sap.ui5/keepAlive");if(this._oKeepAliveConfig){this._oKeepAliveConfig.supported=!!this._oKeepAliveConfig.supported;}this._bIsActive=true;this._aDestroyables=[];c.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);f.apply(t,{onDeregister:function(e){E.registry.forEach(function(i){if(i._sapui_candidateForDestroy&&i._sOwnerId===e&&!i.getParent()){L.debug("destroying dangling template "+i+" when destroying the owner component");i.destroy();}});}});function u(v){var e,i;if(!sap.ui.getCore().getConfiguration().getDisableCustomizing()){if(typeof v==="string"){i=v;}else if(v&&typeof v.isA==="function"&&!v.isA("sap.ui.core.Component")){i=t.getOwnerIdFor(v);}else{e=v;}if(i){e=t.get(i);}if(e){if(e.getExtensionComponent){e=e.getExtensionComponent();if(!e){throw new Error("getExtensionComponent() must return an instance.");}}}}return e;}t.getCustomizing=function(v,m){var T=m.type,P="/sap.ui5/extends/extensions/"+T+"/"+m.name;if(T==="sap.ui.viewExtensions"){P+="/"+m.extensionName;}var e=u(v);return e?e._getManifestEntry(P,true):undefined;};t.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};t.prototype.getManifestEntry=function(k){return this._getManifestEntry(k);};t.prototype._getManifestEntry=function(k,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(k,m);}else{return q(this.getMetadata(),this._oManifest,k,m);}};t.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};t.prototype._isVariant=function(){if(this._oManifest){var e=this.getManifestEntry("/sap.ui5/componentName");return e&&e!==this.getManifestEntry("/sap.app/id");}else{return false;}};t.activateCustomizing=function(e){};t.deactivateCustomizing=function(e){};t.getOwnerIdFor=function(e){g(e instanceof c,"oObject must be given and must be a ManagedObject");var i=(e instanceof c)&&e._sOwnerId;return i||undefined;};t.getOwnerComponentFor=function(e){return t.get(t.getOwnerIdFor(e));};t.prototype.runAsOwner=function(e){if(!this.isActive()){throw new Error("Execute 'runAsOwner' on an inactive owner component is not supported. Component: '"+this.getMetadata().getName()+"' with id '"+this.getId()+"'.");}return s(e,this.getId());};t.prototype.getInterface=function(){return this;};t.prototype._initCompositeSupport=function(m){this.oComponentData=m&&m.componentData;if(this._oManifest){this._oManifest.init(this);}else{this.getMetadata().init();}if(this._isVariant()){var e=this._oManifest.getEntry("/sap.app/id");if(e){z(e,this._oManifest.resolveUri("./","manifest"));}}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=function(i){var k=i.originalEvent;this.onWindowError(k.message,k.filename,k.lineno);}.bind(this);window.addEventListener("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=function(i){var v=this.onWindowBeforeUnload.apply(this,arguments);if(typeof(v)==='string'){i.returnValue=v;i.preventDefault();return v;}}.bind(this);window.addEventListener("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=this.onWindowUnload.bind(this);window.addEventListener("unload",this._fnWindowUnloadHandler);}};t.prototype._getDestroyables=function(){if(!this._aDestroyables){L.error("Mandatory super constructor not called for Component: '"+this.getManifestObject().getComponentName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"};});this._aDestroyables=[];}return this._aDestroyables;};t.prototype.destroy=function(){for(var e in this._mServices){if(this._mServices[e].instance){this._mServices[e].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){window.removeEventListener("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){window.removeEventListener("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){window.removeEventListener("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}function k(F){if(F&&!F._bIsBeingDestroyed){F.destroy();}}var v=this._getDestroyables();for(var i=0;i<v.length;i++){v[i]=v[i].then(k);}c.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(this._oManifest){this._oManifest.exit(this);delete this._oManifest;}else{this.getMetadata().exit();}return Promise.all(v);};t.prototype.getComponentData=function(){return this.oComponentData;};t.prototype.getEventBus=function(){if(!this._oEventBus){var e=sap.ui.require("sap/ui/core/EventBus");if(!e){var i=this.getMetadata().getName();L.warning("Synchronous loading of EventBus, due to #getEventBus() call on Component '"+i+"'.","SyncXHR",null,function(){return{type:"SyncXHR",name:i};});e=sap.ui.requireSync("sap/ui/core/EventBus");}this._oEventBus=new e();if(!this.isActive()){this._oEventBus.suspend();}}return this._oEventBus;};t.prototype.isActive=function(){return this._bIsActive;};t.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var e=this._getManifestEntry("/sap.app/dataSources",true)||{};var i=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(i,e,this._mCacheTokens);};t.prototype._initComponentModels=function(m,e,i){var k=this.getManifestObject().getComponentName();var v=t._findManifestModelClasses({models:m,dataSources:e,componentName:k});t._loadManifestModelClasses(v,k);var F=t._createManifestModelConfigurations({models:v,dataSources:e,component:this,mergeParent:true,cacheTokens:i,activeTerminologies:this.getActiveTerminologies()}),G={},H;if(!F){return;}for(H in F){if(!this._mManifestModels[H]){G[H]=F[H];}}var J=t._createManifestModels(G,k);for(H in J){this._mManifestModels[H]=J[H];}for(H in this._mManifestModels){var K=this._mManifestModels[H];this.setModel(K,H||undefined);}};t.prototype.getService=function(e){if(!this._mServices[e]){this._mServices[e]={};this._mServices[e].promise=new Promise(function(i,k){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(m){var v=this._getManifestEntry("/sap.ui5/services/"+e,true);var F=v&&v.factoryName;if(!F){k(new Error("Service "+e+" not declared!"));return;}var G=m.get(F);if(G){G.createInstance({scopeObject:this,scopeType:"component",settings:v.settings||{}}).then(function(K){if(!this.bIsDestroyed){this._mServices[e].instance=K;this._mServices[e].interface=K.getInterface();i(this._mServices[e].interface);}else{k(new Error("Service "+e+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(k);}else{var H="The ServiceFactory "+F+" for Service "+e+" not found in ServiceFactoryRegistry!";var J=this._getManifestEntry("/sap.ui5/services/"+e+"/optional",true);if(!J){L.error(H);}k(new Error(H));}}.bind(this),k);}.bind(this));}return this._mServices[e].promise;};function w(e,i){var k=e._getManifestEntry("/sap.ui5/services",true);var m=i?[]:null;if(!k){return m;}var v=Object.keys(k);if(!i&&v.some(function(F){return k[F].startup===S.waitFor;})){throw new Error("The specified component \""+e.getMetadata().getName()+"\" cannot be loaded in sync mode since it has some services declared with \"startup\" set to \"waitFor\"");}return v.reduce(function(P,F){if(k[F].lazy===false||k[F].startup===S.waitFor||k[F].startup===S.eager){var G=e.getService(F);if(k[F].startup===S.waitFor){P.push(G);}}return P;},m);}t.prototype.createComponent=function(v){g((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.usage==='string'&&v.usage),"vUsage either must be a non-empty string or an object with a non-empty usage id");var m={async:true};if(v){var e;if(typeof v==="object"){e=v.usage;["id","async","settings","componentData"].forEach(function(N){if(v[N]!==undefined){m[N]=v[N];}});}else if(typeof v==="string"){e=v;}m=this._enhanceWithUsageConfig(e,m);}var i=t._createComponent(m,this);if(i instanceof Promise){this.registerForDestroy(i);}return i;};t.prototype._enhanceWithUsageConfig=function(e,m){var i=this.getManifestEntry("/sap.ui5/componentUsages/"+e);if(!i){throw new Error("Component usage \""+e+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}if(i.activeTerminologies){throw new Error("Terminologies vector can't be used in component usages");}return d(i,m);};t.prototype.getActiveTerminologies=function(){return this._aActiveTerminologies?this._aActiveTerminologies.slice():undefined;};t._createComponent=function(m,e){function i(){if(m.async===true){return t.create(m);}else{return sap.ui.component(m);}}if(e){if(!e.isActive()){throw new Error("Creation of component '"+m.name+"' is not possible due to inactive owner component '"+e.getId()+"'");}return e.runAsOwner(i);}else{return i();}};t._applyCacheToken=function(e,i,m){var k=sap.ui.getCore().getConfiguration();var v=m?"Model":"DataSource";var F=m?"[\"sap.ui5\"][\"models\"]":"[\"sap.app\"][\"dataSources\"]";var G=m&&m["sap-language"]||e.search(true)["sap-language"];var H=m&&m["sap-client"]||e.search(true)["sap-client"];if(!G){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+i.cacheToken+"\" for "+v+" \""+i.dataSource+"\" ("+e.toString()+"). "+"Missing \"sap-language\" URI parameter",F+"[\""+i.dataSource+"\"]",i.componentName);return;}if(!H){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+i.cacheToken+"\" for "+v+" \""+i.dataSource+"\" ("+e.toString()+"). "+"Missing \"sap-client\" URI parameter",F+"[\""+i.dataSource+"\"]",i.componentName);return;}if(H!==k.getSAPParam("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+i.cacheToken+"\" for "+v+" \""+i.dataSource+"\" ("+e.toString()+"). "+"URI parameter \"sap-client="+H+"\" must be identical with configuration \"sap-client="+k.getSAPParam("sap-client")+"\"",F+"[\""+i.dataSource+"\"]",i.componentName);return;}if(e.hasQuery("sap-context-token")&&!e.hasQuery("sap-context-token",i.cacheToken)||m&&m["sap-context-token"]&&m["sap-context-token"]!==i.cacheToken){L.warning("Component Manifest: Overriding existing \"sap-context-token="+(e.query(true)["sap-context-token"]||m["sap-context-token"])+"\" with provided value \""+i.cacheToken+"\" for "+v+" \""+i.dataSource+"\" ("+e.toString()+").",F+"[\""+i.dataSource+"\"]",i.componentName);}if(m){if(e.hasQuery("sap-context-token")){L.warning("Component Manifest: Move existing \"sap-context-token="+e.query(true)["sap-context-token"]+"\" to metadataUrlParams for "+v+" \""+i.dataSource+"\" ("+e.toString()+").",F+"[\""+i.dataSource+"\"]",i.componentName);}e.removeQuery("sap-context-token");m["sap-context-token"]=i.cacheToken;}else{e.setQuery("sap-context-token",i.cacheToken);}};t._findManifestModelClasses=function(m){if(!m.models){return null;}var e={models:m.models,dataSources:m.dataSources||{},origin:{dataSources:{},models:{}}};var i=m.componentName;var k={};for(var v in e.models){var F=e.models[v];if(typeof F==='string'){F={dataSource:F};}if(F.dataSource){var G=e.dataSources&&e.dataSources[F.dataSource];if(typeof G==='object'){if(G.type===undefined){G.type='OData';}var H;if(!F.type){switch(G.type){case'OData':H=G.settings&&G.settings.odataVersion;if(H==="4.0"){F.type='sap.ui.model.odata.v4.ODataModel';}else if(!H||H==="2.0"){F.type='sap.ui.model.odata.v2.ODataModel';}else{L.error('Component Manifest: Provided OData version "'+H+'" in '+'dataSource "'+F.dataSource+'" for model "'+v+'" is unknown. '+'Falling back to default model type "sap.ui.model.odata.v2.ODataModel".','["sap.app"]["dataSources"]["'+F.dataSource+'"]',i);F.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':F.type='sap.ui.model.json.JSONModel';break;case'XML':F.type='sap.ui.model.xml.XMLModel';break;default:}}}}if(!F.type){L.error("Component Manifest: Missing \"type\" for model \""+v+"\"","[\"sap.ui5\"][\"models\"][\""+v+"\"]",i);continue;}k[v]=F;}return k;};t._createManifestModelConfigurations=function(m){var e=m.component;var v=m.manifest||e.getManifestObject();var F=m.mergeParent;var G=m.cacheTokens||{};var H=e?e.getMetadata().getComponentName():v.getComponentName();var J=sap.ui.getCore().getConfiguration();var K=m.activeTerminologies;if(!m.models){return null;}var N={models:m.models,dataSources:m.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&F){var P=e.getMetadata();while(P instanceof C){var Q=P.getManifestObject();var T=P.getManifestEntry("/sap.app/dataSources");p(N.dataSources,N.origin.dataSources,T,Q);var W=P.getManifestEntry("/sap.ui5/models");p(N.models,N.origin.models,W,Q);P=P.getParent();}}var X={};for(var Y in N.models){var Z=N.models[Y];var $=sap.ui.require(Z.type.replace(/\./g,"/"));if(!$){$=O.get(Z.type);}if(!$){L.error("Component Manifest: Class \""+Z.type+"\" for model \""+Y+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+Y+"\"]",H);continue;}var a1=$.getMetadata();var b1=a1.isA("sap.ui.model.odata.ODataModel");var c1=a1.isA("sap.ui.model.odata.v2.ODataModel");var d1=a1.isA("sap.ui.model.odata.v4.ODataModel");var e1=a1.isA("sap.ui.model.resource.ResourceModel");var f1=false;var g1=null;if(typeof Z==='string'){Z={dataSource:Z};}if(Z.dataSource){var h1=N.dataSources&&N.dataSources[Z.dataSource];if(typeof h1==='object'){if(h1.type===undefined){h1.type='OData';}if(d1&&h1.settings&&h1.settings.odataVersion){Z.settings=Z.settings||{};Z.settings.odataVersion=h1.settings.odataVersion;}if(!Z.uri){Z.uri=h1.uri;f1=true;}if(h1.type==='OData'&&h1.settings&&typeof h1.settings.maxAge==="number"){Z.settings=Z.settings||{};Z.settings.headers=Z.settings.headers||{};Z.settings.headers["Cache-Control"]="max-age="+h1.settings.maxAge;}if(h1.type==='OData'&&h1.settings&&h1.settings.annotations){var i1=h1.settings.annotations;for(var i=0;i<i1.length;i++){var j1=i1[i];var k1=N.dataSources[j1];if(!k1){L.error("Component Manifest: ODataAnnotation \""+j1+"\" for dataSource \""+Z.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+j1+"\"]",H);continue;}if(k1.type!=='ODataAnnotation'){L.error("Component Manifest: dataSource \""+j1+"\" was expected to have type \"ODataAnnotation\" but was \""+k1.type+"\"","[\"sap.app\"][\"dataSources\"][\""+j1+"\"]",H);continue;}if(!k1.uri){L.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+j1+"\"","[\"sap.app\"][\"dataSources\"][\""+j1+"\"]",H);continue;}var l1=new U(k1.uri);if(c1||d1){["sap-language","sap-client"].forEach(function(A1){if(!l1.hasQuery(A1)&&J.getSAPParam(A1)){l1.setQuery(A1,J.getSAPParam(A1));}});var m1=G.dataSources&&G.dataSources[k1.uri];if(m1){t._applyCacheToken(l1,{cacheToken:m1,componentName:H,dataSource:j1});}}var n1=N.origin.dataSources[i1[i]]||v;var o1=n1._resolveUri(l1).toString();Z.settings=Z.settings||{};Z.settings.annotationURI=Z.settings.annotationURI||[];Z.settings.annotationURI.push(o1);}}}else{L.error("Component Manifest: dataSource \""+Z.dataSource+"\" for model \""+Y+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+Z.dataSource+"\"]",H);continue;}}if(b1&&(!Z.settings||Z.settings.json===undefined)){Z.settings=Z.settings||{};Z.settings.json=true;}if(e1){if(Z.uri&&Z.settings&&Z.settings.bundleUrl){L.warning("Defining both model uri and bundleUrl is not supported. Only model uri will be resolved.");}if(!Z.uri&&Z.settings&&Z.settings.terminologies){if(Z.bundleUrl||Z.settings.bundleUrl){Z.uri=Z.bundleUrl||Z.settings.bundleUrl;delete Z.settings.bundleUrl;}}}if(Z.uri){var p1=new U(Z.uri);var q1=(f1?N.origin.dataSources[Z.dataSource]:N.origin.models[Y])||v;p1=q1._resolveUri(p1);if(Z.dataSource){o(p1);if(c1||d1){var r1=N.dataSources&&N.dataSources[Z.dataSource];var s1=G.dataSources&&G.dataSources[r1.uri];g1=Z.settings&&Z.settings.metadataUrlParams;var t1=(!g1||typeof g1['sap-language']==='undefined')&&!p1.hasQuery('sap-language')&&J.getSAPParam('sap-language');if(t1||s1){Z.settings=Z.settings||{};g1=Z.settings.metadataUrlParams=Z.settings.metadataUrlParams||{};if(t1){g1['sap-language']=J.getSAPParam('sap-language');}}if(s1){t._applyCacheToken(p1,{cacheToken:s1,componentName:H,dataSource:Y},g1);}}}Z.uri=p1.toString();}if(Z.uriSettingName===undefined){if(b1||c1||d1){Z.uriSettingName='serviceUrl';}else if(e1){Z.uriSettingName='bundleUrl';}else{}}var u1;var v1;if(e){v1=e.getComponentData();}else{v1=m.componentData;}u1=v1&&v1.startupParameters&&v1.startupParameters["sap-system"];if(!u1){u1=J.getSAPParam("sap-system");}var w1=false;var x1;if(u1&&(b1||c1)){w1=true;x1=sap.ui.require("sap/ui/model/odata/ODataUtils");}if(Z.uri){if(w1){Z.preOriginBaseUri=Z.uri.split("?")[0];Z.uri=x1.setOrigin(Z.uri,{alias:u1});Z.postOriginBaseUri=Z.uri.split("?")[0];}if(Z.uriSettingName!==undefined){Z.settings=Z.settings||{};if(!Z.settings[Z.uriSettingName]){Z.settings[Z.uriSettingName]=Z.uri;}}else if(Z.settings){Z.settings=[Z.uri,Z.settings];}else{Z.settings=[Z.uri];}}else if(w1&&Z.uriSettingName!==undefined&&Z.settings&&Z.settings[Z.uriSettingName]){Z.preOriginBaseUri=Z.settings[Z.uriSettingName].split("?")[0];Z.settings[Z.uriSettingName]=x1.setOrigin(Z.settings[Z.uriSettingName],{alias:u1});Z.postOriginUri=Z.settings[Z.uriSettingName].split("?")[0];}if(w1&&Z.settings&&Z.settings.annotationURI){var y1=[].concat(Z.settings.annotationURI);var z1=[];for(var k=0;k<y1.length;k++){z1.push(x1.setAnnotationOrigin(y1[k],{alias:u1,preOriginBaseUri:Z.preOriginBaseUri,postOriginBaseUri:Z.postOriginBaseUri}));}Z.settings.annotationURI=z1;}if(e1&&Z.settings){if(K){Z.settings.activeTerminologies=K;}v._processResourceConfiguration(Z.settings,undefined,true);}if(Z.settings&&!Array.isArray(Z.settings)){Z.settings=[Z.settings];}X[Y]=Z;}if(v.getEntry("/sap.ui5/commands")||(e&&e._getManifestEntry("/sap.ui5/commands",true))){X["$cmd"]={type:'sap.ui.model.json.JSONModel'};}return X;};t._loadManifestModelClasses=function(m,e){for(var i in m){var k=m[i];try{sap.ui.requireSync(k.type.replace(/\./g,"/"));}catch(v){L.error("Component Manifest: Class \""+k.type+"\" for model \""+i+"\" could not be loaded. "+v,"[\"sap.ui5\"][\"models\"][\""+i+"\"]",e);continue;}}};t._createManifestModels=function(m,e){var i={};for(var k in m){var v=m[k];var F=O.get(v.type);var G=[null].concat(v.settings||[]);var H=F.bind.apply(F,G);var J=new H();i[k]=J;}return i;};function x(m){var e={afterManifest:{},afterPreload:{}};var i=b({},m.getEntry("/sap.app/dataSources"));var k=b({},m.getEntry("/sap.ui5/models"));var v=m.getComponentName();var F=t._findManifestModelClasses({models:k,dataSources:i,componentName:v});var P=h.fromQuery(window.location.search).get("sap-ui-xx-preload-component-models-"+m.getComponentName());var G=P&&P.split(",");for(var H in F){var J=F[H];if(!J.preload&&G&&G.indexOf(H)>-1){J.preload=true;L.warning("FOR TESTING ONLY!!! Activating preload for model \""+H+"\" ("+J.type+")",v,"sap.ui.core.Component");}if(J.type==="sap.ui.model.resource.ResourceModel"&&(!J.settings||J.settings.async!==true)){e.afterPreload[H]=J;}else if(J.preload){if(sap.ui.loader._.getModuleState(J.type.replace(/\./g,"/")+".js")){e.afterManifest[H]=J;}else{L.warning("Can not preload model \""+H+"\" as required class has not been loaded: \""+J.type+"\"",v,"sap.ui.core.Component");}}}return e;}function y(e){return sap.ui.require.toUrl(e.replace(/\./g,"/")+"/manifest.json");}function z(m,v){l.registerResourcePath(m.replace(/\./g,"/"),v);}function A(e){var m=[];var k=[];function v(i){if(!i._oManifest){var N=i.getComponentName();var F=y(N);var G=l.loadResource({url:F,dataType:"json",async:true}).catch(function(H){L.error("Failed to load component manifest from \""+F+"\" (component "+N+")! Reason: "+H);return{};});m.push(G);k.push(i);}var P=i.getParent();if(P&&(P instanceof C)&&!P.isBaseClass()){v(P);}}v(e);return Promise.all(m).then(function(F){for(var i=0;i<F.length;i++){if(F[i]){k[i]._applyManifest(F[i]);}}});}t._fnLoadComponentCallback=null;var _=[];Object.defineProperty(t,"_fnOnInstanceCreated",{get:function(){return _[0];},set:function(e){if(typeof e==="function"){_.push(e);}else{_=[];}}});t._fnPreprocessManifest=null;t.create=function(m){if(m==null||typeof m!=="object"){throw new TypeError("Component.create() must be called with a configuration object.");}var P=b({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return B(P);};sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}var e=function(i){return{type:"sap.ui.component",name:i};};if(typeof v==='string'){L.warning("Do not use deprecated function 'sap.ui.component' ("+v+") + for Component instance lookup. "+"Use 'Component.get' instead","sap.ui.component",null,e.bind(null,v));return t.get(v);}if(v.async){L.info("Do not use deprecated factory function 'sap.ui.component' ("+v["name"]+"). "+"Use 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}else{L.warning("Do not use synchronous component creation ("+v["name"]+")! "+"Use the new asynchronous factory 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}return B(v,true);};function B(v,e){var i=t.get(c._sOwnerId);var k=v.activeTerminologies||(i&&i.getActiveTerminologies())||sap.ui.getCore().getConfiguration().getActiveTerminologies();if(!v.asyncHints||!v.asyncHints.cacheTokens){var m=i&&i._mCacheTokens;if(typeof m==="object"){v.asyncHints=v.asyncHints||{};v.asyncHints.cacheTokens=m;}}function F(N,v){return _.map(function(P){return P(N,v);});}function G(N,v){if(v.async){var P=N.rootControlLoaded?N.rootControlLoaded():Promise.resolve();var Q=F(N,v);Q.push(P);return Promise.all(Q);}else{F(N,v);}return N;}function H(N){if(e&&N.getMetadata().isA("sap.ui.core.IAsyncContentCreation")){throw new Error("Do not use deprecated factory function 'sap.ui.component' in combination with IAsyncContentCreation ("+v["name"]+"). "+"Use 'Component.create' instead");}var P=v.name,Q=v.id,T=v.componentData,W=P+'.Component',X=v.settings;var Y=new N(a({},X,{id:Q,componentData:T,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens,_activeTerminologies:k}));g(Y instanceof t,"The specified component \""+W+"\" must be an instance of sap.ui.core.Component!");L.info("Component instance Id = "+Y.getId());var Z=Y.getMetadata().handleValidation()!==undefined||v.handleValidation;if(Z){if(Y.getMetadata().handleValidation()!==undefined){Z=Y.getMetadata().handleValidation();}else{Z=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(Y,Z);}var $=w(Y,v.async);if(v.async){return G(Y,v).then(function(){return Promise.all($);}).then(function(){return Y;});}else{return G(Y,v);}}var J=D(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor,activeTerminologies:k});if(v.async){var K=c._sOwnerId;return J.then(function(N){var P=function(Q){var T=Q.getParent();var W=Promise.resolve();if(T instanceof C){W=W.then(function(){return P(T);});}return W.then(function(){return Q.getManifestObject().loadDependenciesAndIncludes(true);});};return P(N.getMetadata()).then(function(){return s(function(){return H(N);},K);});});}else{return H(J);}}t.load=function(m){var P=b({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return D(P,{preloadOnly:P.asyncHints&&P.asyncHints.preloadOnly});};t.get=function(i){return t.registry.get(i);};sap.ui.component.load=function(e,F){L.warning("Do not use deprecated function 'sap.ui.component.load'! Use 'Component.load' instead");return D(e,{failOnError:F,preloadOnly:e.asyncHints&&e.asyncHints.preloadOnly});};function D(i,m){var k=m.activeTerminologies,N=i.name,F=i.url,G=sap.ui.getCore().getConfiguration(),H=/^(sync|async)$/.test(G.getComponentPreload()),J=i.manifest,K,P,Q,T,W,X;function Y(e,m){var v=JSON.parse(JSON.stringify(e));if(i.async){return Z(v).then(function($){return new M($,m);});}else{return new M(v,m);}}function Z(e){if(typeof t._fnPreprocessManifest==="function"&&e!=null){try{var v=d({},i);return t._fnPreprocessManifest(e,v);}catch($){L.error("Failed to execute flexibility hook for manifest preprocessing.",$);return Promise.reject($);}}else{return Promise.resolve(e);}}g(!F||typeof F==='string',"sUrl must be a string or undefined");if(N&&typeof F==='string'){z(N,F);}I.setStepComponent(N);if(J===undefined){K=i.manifestFirst===undefined?G.getManifestFirst():!!i.manifestFirst;P=i.manifestUrl;}else{if(i.async===undefined){i.async=true;}K=!!J;P=J&&typeof J==='string'?J:undefined;Q=J&&typeof J==='object'?Y(J,{url:i&&i.altManifestUrl,activeTerminologies:k}):undefined;}if(!Q&&P){Q=M.load({activeTerminologies:k,manifestUrl:P,componentName:N,processJson:Z,async:i.async,failOnError:true});}if(Q&&!i.async){N=Q.getComponentName();if(N&&typeof F==='string'){z(N,F);}}if(!(Q&&i.async)){if(!N){throw new Error("The name of the component is undefined.");}g(typeof N==='string',"sName must be a string");}if(K&&!Q){Q=M.load({activeTerminologies:k,manifestUrl:y(N),componentName:N,async:i.async,processJson:Z,failOnError:false});}function a1(){return(N+".Component").replace(/\./g,"/");}function b1(e){var v=N+'.Component';if(!e){var $="The specified component controller '"+v+"' could not be found!";if(m.failOnError){throw new Error($);}else{L.warning($);}}if(Q){var n1=r(e.getMetadata(),Q);var o1=function(){var p1=Array.prototype.slice.call(arguments);var q1;if(p1.length===0||typeof p1[0]==="object"){q1=p1[0]=p1[0]||{};}else if(typeof p1[0]==="string"){q1=p1[1]=p1[1]||{};}q1._metadataProxy=n1;if(T){q1._manifestModels=T;}var r1=Object.create(e.prototype);e.apply(r1,p1);return r1;};o1.getMetadata=function(){return n1;};o1.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return o1;}else{return e;}}function c1(v,e){g((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.name==='string'&&v.name),"reference either must be a non-empty string or an object with a non-empty 'name' and an optional 'url' property");if(typeof v==='object'){if(v.url){z(v.name,v.url);}return(v.lazy&&e!==true)?undefined:v.name;}return v;}function d1(v,$){var n1=v+'.Component',o1=sap.ui.getCore().getConfiguration().getDepCache(),p1,q1,r1,s1=function(p1,$){return function(e){var t1="Component-preload for this component does not exist.";L.warning("Couldn't preload component from "+p1+": "+((e&&e.message)||e),!$?t1:t1+" If the component is part of a library or another component, the configuration 'sap.app/embeddedBy' is not maintained. "+" The 'sap.app/embeddedBy' property must be relative path inside the deployment unit (library or component).","sap.ui.core.Component#preload");};};if(H&&v!=null&&!sap.ui.loader._.getModuleState(n1.replace(/\./g,"/")+".js")){if($){q1=V._getTransitiveDependencyForComponent(v);if(q1&&!q1.hasOwnPreload){r1=[q1.library];Array.prototype.push.apply(r1,q1.dependencies);return sap.ui.getCore().loadLibraries(r1,{preloadOnly:true}).catch(s1(q1.library,true));}else{p1=n1.replace(/\./g,"/")+(o1?'-h2-preload.js':'-preload.js');return sap.ui.loader._.loadJSResourceAsync(p1).catch(s1(p1,true));}}try{p1=n1+'-preload';sap.ui.requireSync(p1.replace(/\./g,"/"));}catch(e){s1(p1,false)(e);}}else if($){return Promise.resolve();}}function e1(e,Q,v){var $=[];var n1=v?function(x1){$.push(x1);}:function(){};var o1=Q.getEntry("/sap.ui5/dependencies/libs");if(o1){var p1=[];for(var q1 in o1){if(!o1[q1].lazy){p1.push(q1);}}if(p1.length>0){L.info("Component \""+e+"\" is loading libraries: \""+p1.join(", ")+"\"");n1(sap.ui.getCore().loadLibraries(p1,{async:v}));}}var r1=Q.getEntry("/sap.ui5/extends/component");if(r1){n1(d1(r1,v));}var s1=[];var t1=Q.getEntry("/sap.ui5/dependencies/components");if(t1){for(var u1 in t1){if(!t1[u1].lazy){s1.push(u1);}}}var v1=Q.getEntry("/sap.ui5/componentUsages");if(v1){for(var w1 in v1){if(v1[w1].lazy===false&&s1.indexOf(v1[w1].name)===-1){s1.push(v1[w1].name);}}}if(s1.length>0){s1.forEach(function(e){n1(d1(e,v));});}return v?Promise.all($):undefined;}if(i.async){var f1=i.asyncHints||{},g1=[],h1=function(e){e=e.then(function(v){return{result:v,rejected:false};},function(v){return{result:v,rejected:true};});return e;},i1=function(e){if(e){g1.push(h1(e));}},j1=function($){return $;},k1,l1;k1=[];if(Array.isArray(f1.preloadBundles)){f1.preloadBundles.forEach(function(v){k1.push(sap.ui.loader._.loadJSResourceAsync(c1(v,true),true));});}if(Array.isArray(f1.libs)){l1=f1.libs.map(c1).filter(j1);k1.push(sap.ui.getCore().loadLibraries(l1,{preloadOnly:true}));}k1=Promise.all(k1);if(l1&&!m.preloadOnly){k1=k1.then(function(){return sap.ui.getCore().loadLibraries(l1);});}i1(k1);if(f1.components){Object.keys(f1.components).forEach(function(e){i1(d1(c1(f1.components[e]),true));});}if(!Q){i1(d1(N,true));}else{var m1=[];Q=Q.then(function(Q){var e=Q.getComponentName();if(typeof F==='string'){z(e,F);}Q.defineResourceRoots();Q._preprocess({resolveUI5Urls:true,i18nProperties:m1});return Q;});if(m.createModels){i1(Q.then(function(Q){var e=Q.getComponentName();W=x(Q);if(Object.keys(W.afterManifest).length>0){t._loadManifestModelClasses(W.afterManifest,e);var v=b({},Q.getEntry("/sap.app/dataSources"));var $=t._createManifestModelConfigurations({models:W.afterManifest,dataSources:v,manifest:Q,componentData:i.componentData,cacheTokens:f1.cacheTokens,activeTerminologies:k});T=t._createManifestModels($,e);}return Q;}));}i1(Q.then(function(Q){var e=Promise.resolve();var v=Q.getEntry("/sap.app/embeddedBy");var $=Q.getComponentName();if(!v){e=d1($,true);}else if(!sap.ui.loader._.getModuleState(a1()+".js")){L.warning("Component '"+$+"' is defined to be embedded in a library or another component"+"The relatively given preload for the embedding resource was not loaded before hand. "+"Please make sure to load the embedding resource containing this Component before instantiating.",undefined,"sap.ui.core.Component#embeddedBy");}return e.then(function(){return Q._processI18n(true,m1);}).then(function(){if(!m.createModels){return null;}var n1=Object.keys(W.afterPreload);if(n1.length===0){return null;}return new Promise(function(o1,p1){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(q1){o1(q1);},p1);}).then(function(o1){var p1=b({},Q.getEntry("/sap.app/dataSources"));var q1=t._createManifestModelConfigurations({models:W.afterPreload,dataSources:p1,manifest:Q,componentData:i.componentData,cacheTokens:f1.cacheTokens,activeTerminologies:k});function r1(s1){var t1=q1[s1];if(Array.isArray(t1.settings)&&t1.settings.length>0){var u1=t1.settings[0];u1.activeTerminologies=m.activeTerminologies;return o1.loadResourceBundle(u1,true).then(function(v1){u1.bundle=v1;delete u1.terminologies;delete u1.activeTerminologies;delete u1.enhanceWith;},function(v1){L.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.","[\"sap.ui5\"][\"models\"][\""+s1+"\"]",Q.getComponentName());L.error(v1);delete q1[s1];});}else{return Promise.resolve();}}return Promise.all(n1.map(r1)).then(function(){if(Object.keys(q1).length>0){var s1=t._createManifestModels(q1,Q.getComponentName());if(!T){T={};}for(var t1 in s1){T[t1]=s1[t1];}}});});});}));X=function(e){if(typeof t._fnLoadComponentCallback==="function"){var v=d({},i);try{return t._fnLoadComponentCallback(v,e);}catch($){L.error("Callback for loading the component \""+e.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",$,"sap.ui.core.Component");}}};}return Promise.all(g1).then(function(v){var e=[],$=false,n1;$=v.some(function(o1){if(o1&&o1.rejected){n1=o1.result;return true;}e.push(o1.result);});if($){return Promise.reject(n1);}return e;}).then(function(v){if(Q&&X){return Q.then(X).then(function(){return v;});}return v;}).then(function(v){L.debug("Component.load: all promises fulfilled, then "+v);if(Q){return Q.then(function(e){if(!e._bLoadManifestRequestFailed){Q=e;N=Q.getComponentName();return e1(N,Q,true);}else{Q=undefined;return Q;}});}else{return v;}}).then(function(){if(m.preloadOnly){return true;}return new Promise(function(e,v){sap.ui.require([a1()],function($){e($);},v);}).then(function(e){var v=e.getMetadata();var N=v.getComponentName();var $=y(N);var n1;if(Q&&typeof J!=="object"&&(typeof P==="undefined"||P===$)){v._applyManifest(JSON.parse(JSON.stringify(Q.getRawJson())));}n1=A(v);return n1.then(function(){var o1=Promise.resolve();if(!Q&&m.activeTerminologies){Q=new M(v.getManifestObject().getRawJson(),{process:false,activeTerminologies:k});o1=Q._processI18n(true);}return o1.then(b1.bind(undefined,e));});});}).then(function(e){if(!Q){return e;}var v=[];var $;var n1=Q.getEntry("/sap.ui5/rootView");if(typeof n1==="string"){$="XML";}else if(n1&&typeof n1==="object"&&n1.type){$=n1.type;}if($&&n[$]){var o1="sap/ui/core/mvc/"+n[$]+"View";v.push(o1);}var p1=Q.getEntry("/sap.ui5/routing");if(p1){if(p1.routes){var q1=Q.getEntry("/sap.ui5/routing/config/routerClass")||"sap.ui.core.routing.Router";var r1=q1.replace(/\./g,"/");v.push(r1);}else if(p1.targets){var s1=Q.getEntry("/sap.ui5/routing/config/targetsClass")||"sap.ui.core.routing.Targets";var t1=s1.replace(/\./g,"/");v.push(t1);v.push("sap/ui/core/routing/Views");}}var u1=b({},Q.getEntry("/sap.ui5/models"));var v1=b({},Q.getEntry("/sap.app/dataSources"));var w1=t._findManifestModelClasses({models:u1,dataSources:v1,componentName:Q.getComponentName()});for(var x1 in w1){if(!w1.hasOwnProperty(x1)){continue;}var y1=w1[x1];if(!y1.type){continue;}var z1=y1.type.replace(/\./g,"/");if(v.indexOf(z1)===-1){v.push(z1);}}if(v.length>0){return Promise.all(v.map(function(z1){return new Promise(function(A1,B1){var C1=false;function D1(E1){if(C1){return;}L.warning("Can not preload module \""+z1+"\". "+"This will most probably cause an error once the module is used later on.",Q.getComponentName(),"sap.ui.core.Component");L.warning(E1);C1=true;A1();}sap.ui.require([z1],A1,D1);});})).then(function(){return e;});}else{return e;}}).then(function(e){var v=m.waitFor;if(v){var $=Array.isArray(v)?v:[v];return Promise.all($).then(function(){return e;});}return e;}).catch(function(e){if(T){for(var N in T){var v=T[N];if(v&&typeof v.destroy==="function"){v.destroy();}}}throw e;});}if(Q){Q.defineResourceRoots();Q._preprocess({resolveUI5Urls:true});e1(N,Q);}d1(N);return b1(sap.ui.requireSync(a1()));}if(Math.sqrt(2)<1){sap.ui.require(["sap/ui/core/Core"],function(){});}t.prototype.getCommand=function(e){var i,k=this._getManifestEntry("/sap.ui5/commands",true);if(k&&e){i=k[e];}return e?i:k;};t.prototype.deactivate=function(){var e=t.getOwnerComponentFor(this);if(e&&e.isActive()){throw new Error("Component.deactivate must not be called on nested components.");}if(!this.isKeepAliveSupported()){L.warning("Deactivation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return;}if(!this.isActive()){L.warning("Deactivation of component failed. Component '"+this.getId()+"' is already inactive.");return;}this.onOwnerDeactivation();this._bIsActive=false;E.registry.filter(function(i){var k=t.getOwnerIdFor(i);if(k===this.getId()){R.suspend(i.getDomRef());return i.onOwnerDeactivation();}},this);t.registry.filter(function(i){var k=t.getOwnerIdFor(i);if(k===this.getId()){i.deactivate();}},this);if(this._oEventBus){this._oEventBus.suspend();}if(this.getRouter()){this.getRouter().stop();}if(typeof this.onDeactivate==="function"){this.onDeactivate();}};t.prototype.activate=function(){if(!this.isKeepAliveSupported()){L.warning("Activation of component failed. Component '"+this.getId()+"' does not support 'keepAlive'.");return;}if(this.isActive()){L.warning("Activation of component failed. Component '"+this.getId()+"' is already active.");return;}this.onOwnerActivation();this._bIsActive=true;E.registry.forEach(function(e){var i=t.getOwnerIdFor(e);if(i===this.getId()){R.resume(e.getDomRef());return e.onOwnerActivation();}},this);t.registry.forEach(function(e){var i=t.getOwnerIdFor(e);if(i===this.getId()){e.activate();}},this);if(this._oEventBus){this._oEventBus.resume();}if(this.getRouter()){this.getRouter().initialize();}if(typeof this.onActivate==="function"){this.onActivate();}};t.prototype.isKeepAliveSupported=function(){var i=this._oKeepAliveConfig&&this._oKeepAliveConfig.supported;if(i){i=t.registry.filter(function(e){var k=t.getOwnerIdFor(e);if(k===this.getId()){return true;}},this).every(function(e){return e.isKeepAliveSupported();},this);}return!!i;};t.prototype.registerForDestroy=function(e){var i=this._getDestroyables();e=e.then(function(k){i.splice(i.indexOf(e),1);return k;});i.push(e);};return t;});
