/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/base/assert','../Device','./Control','./_IconRegistry','./InvisibleText','./library',"./IconRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/Log"],function(a,D,C,_,I,l,b,K,q,L){"use strict";var c=l.IconColor;var d=l.CSSColor;var i=function(v){if(v!=null&&v!==""&&!d.isValid(v)&&!(v in c)){L.error("\""+v+"\" is not of type sap.ui.core.CSSColor nor of type sap.ui.core.IconColor.");return false;}else{return true;}};var e=C.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}},renderer:b});e.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(E){if(this.hasListeners("press")){E.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),$;if(A||s){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===1)){$=this.$();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};e.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(E){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors(D.system.desktop?"hover":undefined);}};e.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};e.prototype.onmouseout=function(){this._restoreColors();};e.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(E){if(this.hasListeners("press")){E.setMarked();}this.firePress({});};e.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){E.preventDefault();var $=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};e.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};e.prototype._restoreColors=function(m){var s,B;if(m==="hover"){s=this.getHoverColor();B=this.getHoverBackgroundColor();}s=s||this.getColor();B=B||this.getBackgroundColor();this._addColorClass(s||"","color");this._addColorClass(B||"","background-color");};e.prototype._addColorClass=function(s,f){var $=this.$(),t=this;var g="";if(f==="color"){g="sapUiIconColor";}else if(f==="background-color"){g="sapUiIconBGColor";}else{return;}q.each(c,function(p,P){t.removeStyleClass(g+P);});if(s in c){$.css(f,"");this.addStyleClass(g+s);}else{$.css(f,s);}};e.prototype.setSrc=function(s){a(s==null||_.isIconURI(s),this+": Property 'src' (value: '"+s+"') should be a valid Icon URI (sap-icon://...)");return this.setProperty("src",s);};e.prototype.setColor=function(s){if(i(s)){this.setProperty("color",s,true);this._addColorClass(s,"color");}return this;};e.prototype.setActiveColor=function(s){if(i(s)){this.setProperty("activeColor",s,true);}return this;};e.prototype.setHoverColor=function(s){if(i(s)){this.setProperty("hoverColor",s,true);}return this;};e.prototype.setBackgroundColor=function(s){if(i(s)){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");}return this;};e.prototype.setActiveBackgroundColor=function(s){if(i(s)){this.setProperty("activeBackgroundColor",s,true);}return this;};e.prototype.setHoverBackgroundColor=function(s){if(i(s)){this.setProperty("hoverBackgroundColor",s,true);}return this;};e.prototype.attachEvent=function(E){C.prototype.attachEvent.apply(this,arguments);if(E=="press"&&this.hasListeners("press")){this.invalidate();}return this;};e.prototype.detachEvent=function(E){C.prototype.detachEvent.apply(this,arguments);if(E=="press"&&!this.hasListeners("press")){this.invalidate();}return this;};e.prototype._getOutputTitle=function(o){var t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&o&&o.text)){return t||o.text;}};e.prototype._getIconLabel=function(o){var A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),s=A||t||(u&&o&&(o.text||o.name));if(s){return s;}};e.prototype._createInvisibleText=function(t){var o=this.getAggregation("_invisibleText");if(!o){o=new I(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",o,true);}else{o.setText(t);}return o;};e.prototype._getAccessibilityAttributes=function(o){var f=this.getAriaLabelledBy(),A={},s=this._getIconLabel(o),g;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else if(this.hasListeners("press")){A.role="button";}else{A.role="img";}if(f.length>0){if(s){g=this._createInvisibleText(s);f.push(g.getId());}A.labelledby=f.join(" ");}else if(s){A.label=s;}return A;};e.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var o=_.getIconInfo(this.getSrc(),undefined,"sync");return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(o?o.text||o.name:""),focusable:h};};return e;});
