/*
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/thirdparty/URI','sap/base/util/Version','sap/base/Log','sap/ui/dom/includeStylesheet','sap/base/i18n/ResourceBundle','sap/base/util/uid','sap/base/util/merge','sap/base/util/isPlainObject','sap/base/util/LoaderExtensions',"sap/base/util/isEmptyObject"],function(B,U,V,L,a,R,u,b,c,d,f){"use strict";function g(v){var o=V(v);return o.getSuffix()?V(o.getMajor()+"."+o.getMinor()+"."+o.getPatch()):o;}function h(o,p){if(o&&p&&typeof p==="string"&&p[0]==="/"){var P=p.substring(1).split("/"),s;for(var i=0,l=P.length;i<l;i++){s=P[i];o=o.hasOwnProperty(s)?o[s]:undefined;if(o===null||typeof o!=="object"){if(i+1<l&&o!==undefined){o=undefined;}break;}}return o;}return o&&o[p];}function k(o){if(o&&typeof o==='object'&&!Object.isFrozen(o)){Object.freeze(o);for(var K in o){if(o.hasOwnProperty(K)){k(o[K]);}}}}var M=B.extend("sap.ui.core.Manifest",{constructor:function(m,o){B.apply(this,arguments);this._uid=u();this._iInstanceCount=0;this._oRawManifest=m;this._bProcess=!(o&&o.process===false);this._bAsync=!(o&&o.async===false);this._activeTerminologies=o&&o.activeTerminologies;this._bLoadManifestRequestFailed=o&&o._bLoadManifestRequestFailed;this._sComponentName=o&&o.componentName;var C=this.getComponentName(),s=o&&o.baseUrl||C&&sap.ui.require.toUrl(C.replace(/\./g,"/"))+"/";if(s){this._oBaseUri=new U(s).absoluteTo(new U(document.baseURI).search(""));}if(o&&typeof o.url==="string"){this._oManifestBaseUri=new U(o.url).absoluteTo(new U(document.baseURI).search("")).search("");}else{this._oManifestBaseUri=this._oBaseUri;}k(this._oRawManifest);this._oManifest=b({},this._oRawManifest);if(this._bProcess){this._processI18n();}},_processI18n:function(A,I){if(!I){I=[];this._preprocess({i18nProperties:I});}if(I.length>0){var r=function(o){var e=function(m,s){return o.getText(s);};for(var i=0,l=I.length;i<l;i++){var p=I[i];p.object[p.key]=p.object[p.key].replace(M._rManifestTemplate,e);}};if(A){return this._loadI18n(A).then(r);}else{r(this._loadI18n(A));}}else{return A?Promise.resolve():undefined;}},_loadI18n:function(A){var m=this._oRawManifest,i,s="manifest",I=(m["sap.app"]&&m["sap.app"]["i18n"])||"i18n/i18n.properties";if(typeof I==="string"){i=new U(I);return R.create({url:this.resolveUri(i,s),async:A});}else if(typeof I==="object"){I=JSON.parse(JSON.stringify(I));s=I.bundleUrlRelativeTo||s;this._processResourceConfiguration(I,s);var p=Object.assign({activeTerminologies:this._activeTerminologies,async:A},I);return R.create(p);}},getJson:function(){return this._oManifest;},getRawJson:function(){return this._oRawManifest;},getEntry:function(p){if(!p||p.indexOf(".")<=0){L.warning("Manifest entries with keys without namespace prefix can not be read via getEntry. Key: "+p+", Component: "+this.getComponentName());return null;}var m=this.getJson();var e=h(m,p);if(p&&p[0]!=="/"&&!c(e)){L.warning("Manifest entry with key '"+p+"' must be an object. Component: "+this.getComponentName());return null;}return e;},checkUI5Version:function(){var m=this.getEntry("/sap.ui5/dependencies/minUI5Version");if(m&&L.isLoggable(L.Level.WARNING)&&sap.ui.getCore().getConfiguration().getDebug()){sap.ui.getVersionInfo({async:true}).then(function(v){var o=g(m);var e=g(v&&v.version);if(o.compareTo(e)>0){L.warning("Component \""+this.getComponentName()+"\" requires at least version \""+o.toString()+"\" but running on \""+e.toString()+"\"!");}}.bind(this),function(e){L.warning("The validation of the version for Component \""+this.getComponentName()+"\" failed! Reasion: "+e);}.bind(this));}},_loadIncludes:function(A){var r=this.getEntry("/sap.ui5/resources"),p;if(!r){return;}var C=this.getComponentName();var J=r["js"];if(J){var e=function(t){return function(){return new Promise(function(v,w){sap.ui.require([t],v,w);});};};p=Promise.resolve();for(var i=0;i<J.length;i++){var o=J[i];var F=o.uri;if(F){var m=F.match(/\.js$/i);if(m){var s=C.replace(/\./g,'/')+(F.slice(0,1)==='/'?'':'/')+F.slice(0,m.index);L.info("Component \""+C+"\" is loading JS: \""+s+"\"");if(A){p=p.then(e(s));}else{sap.ui.requireSync(s);}}}}}var l=r["css"];if(l){for(var j=0;j<l.length;j++){var n=l[j];if(n.uri){var q=this.resolveUri(n.uri);L.info("Component \""+C+"\" is loading CSS: \""+q+"\"");a(q,{id:n.id,"data-sap-ui-manifest-uid":this._uid});}}}return p;},removeIncludes:function(){var r=this.getEntry("/sap.ui5/resources");if(!r){return;}var C=this.getComponentName();var e=r["css"];if(e){var l=document.querySelectorAll("link[data-sap-ui-manifest-uid='"+this._uid+"']");for(var i=0;i<l.length;i++){var o=l[i];L.info("Component \""+C+"\" is removing CSS: \""+o.href+"\"");o.parentNode.removeChild(o);}}},_loadDependencies:function(A){var p=[];var D=this.getEntry("/sap.ui5/dependencies"),C=this.getComponentName();if(D){var l=D["libs"];if(l){for(var s in l){if(!l[s].lazy){L.info("Component \""+C+"\" is loading library: \""+s+"\"");p.push(sap.ui.getCore().loadLibrary(s,{async:A}));}}}var m=D["components"];var e=[];if(m){for(var n in m){if(!m[n].lazy){e.push(n);}}}if(A){var i=new Promise(function(r,j){sap.ui.require(["sap/ui/core/Component"],function(o){r(o);},j);}).then(function(j){return Promise.all(e.map(function(C){return j.load({name:C,manifest:false});}));});p.push(i);}else{e.forEach(function(n){var j=n.replace(/\./g,"/")+"/Component";var o=sap.ui.loader._.getModuleState(j+".js");if(o===-1){sap.ui.requireSync(j);}else if(o===0){L.info("Component \""+C+"\" is loading component: \""+n+".Component\"");sap.ui.requireSync("sap/ui/core/Component");sap.ui.component.load({name:n});}});}}return Promise.all(p);},defineResourceRoots:function(){var r=this.getEntry("/sap.ui5/resourceRoots");if(r){for(var s in r){var e=r[s];var o=new U(e);if(o.is("absolute")||(o.path()&&o.path()[0]==="/")){L.error("Resource root for \""+s+"\" is absolute and therefore won't be registered! \""+e+"\"",this.getComponentName());continue;}e=this._resolveUri(o).toString();var p={};p[s.replace(/\./g,"/")]=e;sap.ui.loader.config({paths:p});}}},getComponentName:function(){var r=this.getRawJson();return this._sComponentName||h(r,"/sap.ui5/componentName")||h(r,"/sap.app/id");},resolveUri:function(s,r){var o=this._resolveUri(new U(s),r);return o&&o.toString();},_resolveUri:function(o,r){return M._resolveUriRelativeTo(o,r==="manifest"?this._oManifestBaseUri:this._oBaseUri);},_preprocess:function(e){M.processObject(this._oManifest,function(o,K,v){if(e.resolveUI5Urls&&v.startsWith("ui5:")){o[K]=d.resolveUI5Url(v);}else if(e.i18nProperties&&v.match(M._rManifestTemplate)){e.i18nProperties.push({object:o,key:K});}});},init:function(i){if(this._iInstanceCount===0){this.loadDependenciesAndIncludes();}this._iInstanceCount++;},loadDependenciesAndIncludes:function(A){if(this._pDependenciesAndIncludes){return this._pDependenciesAndIncludes;}this.checkUI5Version();this.defineResourceRoots();this._preprocess({resolveUI5Urls:true});this._pDependenciesAndIncludes=Promise.all([this._loadDependencies(A),this._loadIncludes(A)]);return this._pDependenciesAndIncludes;},exit:function(i){var I=Math.max(this._iInstanceCount-1,0);if(I===0){this.removeIncludes();delete this._pDependenciesAndIncludes;}this._iInstanceCount=I;}});M._rManifestTemplate=/\{\{([^\}\}]+)\}\}/g;M._resolveUriRelativeTo=function(o,e){if(o.is("absolute")||(o.path()&&o.path()[0]==="/")){return o;}var p=new U(document.baseURI).search("");e=e.absoluteTo(p);return o.absoluteTo(e).relativeTo(p);};M.prototype._processResourceConfiguration=function(s,e,A){var t=this;Object.keys(s).forEach(function(K){if(K==="bundleUrl"&&!A){var j=s[K];s[K]=t.resolveUri(j,s["bundleUrlRelativeTo"]||e);}if(K==="terminologies"){var T=s[K];for(var l in s[K]){t._processResourceConfiguration(T[l],e);}}if(K==="enhanceWith"){var E=s[K];for(var i=0;i<E.length;i++){t._processResourceConfiguration(E[i],e);}}});};M.load=function(o){var m=o&&o.manifestUrl,C=o&&o.componentName,A=o&&o.async,F=o&&o.failOnError,p=o&&o.processJson;var e=new U(m);["sap-language","sap-client"].forEach(function(n){if(!e.hasQuery(n)){var v=sap.ui.getCore().getConfiguration().getSAPParam(n);if(v){e.addQuery(n,v);}}});m=e.toString();L.info("Loading manifest via URL: "+m);if(!A){L.warning("Synchronous loading of manifest, due to Manifest.load() call for '"+m+"'. Use parameter 'async' true to avoid this.","SyncXHR",null,function(){return{type:"SyncXHR",name:"Manifest"};});}var i=d.loadResource({url:m,dataType:"json",async:typeof A!=="undefined"?A:false,headers:{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},failOnError:typeof F!=="undefined"?F:true});var s={componentName:C,url:m,process:false};if(o.activeTerminologies){s["activeTerminologies"]=o.activeTerminologies;}if(A){return i.then(function(i){if(p&&i){return p(i);}else{return i;}}).then(function(i){if(!i){s._bLoadManifestRequestFailed=true;}return new M(i,s);});}return new M(i,s);};M.processObject=function(o,C){for(var K in o){if(!o.hasOwnProperty(K)){continue;}var v=o[K];switch(typeof v){case"object":if(v){M.processObject(v,C);}break;case"string":C(o,K,v);break;default:}}};return M;});
