/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/BindingParser","sap/ui/core/CommandExecution","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/base/util/resolveReference","sap/base/Log"],function(B,C,a,b,J,M,c,O,r,L){"use strict";var E={resolveEventHandler:function(n,o,l){var h,s,f;n=n.trim();if(sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){h=function(){};}else{if(n.startsWith("cmd:")){var d=n.substr(4);h=function(e){var j=C.find(e.getSource(),d);if(j){j.trigger();}else{L.error("Handler '"+n+"' could not be resolved. No CommandExecution defined for command: "+d);}};h._sapui_commandName=d;}else{s=n.indexOf("(");f=n;if(s>0){f=n.substring(0,s).trim();}else if(s===0){throw new Error("Event handler name starts with a bracket, must start with a function name "+"(or with a dot followed by controller-local function name): "+n);}h=r(f,Object.assign({".":o},l),{preferDotContext:f.indexOf(".")===-1,bindContext:false});}if(h&&s>0){var i=n.lastIndexOf(")");if(i>s){if(n.substring(s).indexOf("{=")>-1){L.warning("It looks like an event handler parameter contains a binding expression ({=...}). This is not allowed and will cause an error later on "+"because the entire event handler is already considered an expression: "+n);}h=(function(f,o){return function(j){var p,S,k=n;if(n.indexOf("$parameters")>-1){p=new J(j.mParameters);}if(n.indexOf("$source")>-1){S=new M(j.getSource());}var m={"$controller":o,$event:j};if(f.indexOf(".")>0){var G=f.split(".")[0];m[G]=window[G];}else if(f.indexOf(".")===-1){if(o&&o[f]){k="$controller."+k;}else if(window[f]){m[f]=window[f];}}Object.assign(m,l);var q=B.parseExpression(k.replace(/^\./,"$controller."),0,{oContext:o},m);if(q.result){try{g(q.result,j.getSource(),o,p,S);}catch(e){e.message="Error when evaluating event handler '"+n+"': "+e.message;throw e;}}if(p){p.destroy();}if(S){S.destroy();}};})(f,o);}else{L.error("Syntax error in event handler '"+n+"': arguments must be enclosed in a pair of brackets");}}}if(typeof h==="function"){h._sapui_handlerName=n;return[h,o];}L.warning("Event handler name '"+n+"' could not be resolved to an event handler function");},parse:function e(v){v=v.trim();var t=new c();var R=[];var s="";var p=0;t.init(v,0);for(;;){var S=t.next();if(S==='"'||S==="'"){var d=t.getIndex();t.string();s+=v.slice(d,t.getIndex());S=t.getCh();}if(!S){break;}switch(S){case"(":p++;break;case")":p--;break;default:break;}if(S===";"&&p===0){R.push(s.trim());s="";}else{s+=S;}}if(s){R.push(s.trim());}return R;}};function g(o,e,d,p,s){var t,P;o.mode=a.OneWay;if(!o.parts){o.parts=[];o.parts[0]={path:o.path,targetType:o.targetType,type:o.type,suspended:o.suspended,formatOptions:o.formatOptions,constraints:o.constraints,model:o.model,mode:o.mode};delete o.path;delete o.targetType;delete o.mode;delete o.model;}for(var i=0;i<o.parts.length;i++){P=o.parts[i];if(typeof P=="string"){P={path:P};o.parts[i]=P;}if(!P.path&&P.parts){throw new Error("Bindings in event handler parameters cannot use parts. Just use one single path.");}var S=P.path.indexOf(">");if(S>0){P.model=P.path.substr(0,S);P.path=P.path.substr(S+1);}}var T,f,h,j=[];o.parts.forEach(function(P){var m;if(P.model==="$parameters"){m=p;f=p.createBindingContext("/");}else if(P.model==="$source"){m=s;f=s.createBindingContext("/");}else{m=e.getModel(P.model);f=e.getBindingContext(P.model);}t=P.type;if(typeof t=="string"){T=O.get(t);if(typeof T!=="function"){throw new Error("Cannot find type \""+t+"\" used for binding \""+P.path+"\"!");}t=new T(P.formatOptions,P.constraints);}h=m.bindProperty(P.path,f,o.parameters);h.setType(t,P.targetType||"any");h.setFormatter(P.formatter);h.setBindingMode(a.OneTime);j.push(h);});if(j.length>1||(o.formatter&&o.formatter.textFragments)){t=o.type;if(typeof t=="string"){T=O.get(t);t=new T(o.formatOptions,o.constraints);}h=new b(j,o.useRawValues,o.useInternalValues);h.setType(t,P.targetType||"any");h.setBindingMode(a.OneTime);}else{h=j[0];}h.setFormatter(o.formatter);h.initialize();return h.getExternalValue();}return E;});
