/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/library','./HashChanger',"sap/base/Log","sap/base/util/ObjectPath"],function(l,H,L,O){"use strict";var a=l.routing.HistoryDirection;var D="Direction_Unchanged";var b=function(h){var t=this;this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;function c(C){if(b._bUsePushState&&!b.getInstance()){var s=window.history.state===null?{}:window.history.state;if(typeof s==="object"){s.sap=s.sap?s.sap:{};if(s.sap.history&&Array.isArray(s.sap.history)&&s.sap.history[s.sap.history.length-1]===C){b._aStateHistory=s.sap.history;}else{b._aStateHistory.push(C);s.sap.history=b._aStateHistory;window.history.replaceState(s,window.document.title);}}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}}t._reset();}if(!h){L.error("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter");}this._setHashChanger(h);if(h._initialized){c(h.getHash());}else{h.attachEventOnce("hashChanged",function(e){c(e.getParameter("newHash"));});}};b._aStateHistory=[];b._bUsePushState=window.self===window.top;b.prototype.getHistoryStateOffset=function(){if(!b._bUsePushState){return undefined;}var s=O.get("history.state.sap.history");if(!Array.isArray(s)){return undefined;}return s.length-b._aStateHistory.length;};b.prototype.destroy=function(){this._unRegisterHashChanger();};b.prototype.getDirection=function(n){if(n!==undefined&&this._bIsInitial){return undefined;}if(n===undefined){return this._sCurrentDirection;}return this._getDirection(n);};b.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1];};b.prototype._setHashChanger=function(h){if(this._oHashChanger){this._unRegisterHashChanger();}this._oHashChanger=h;this._mEventListeners={};h.getRelevantEventsInfo().forEach(function(e){var E=e.name,p=e.paramMapping||{},f=this._onHashChange.bind(this,p);this._mEventListeners[E]=f;this._oHashChanger.attachEvent(E,f,this);}.bind(this));this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this);};b.prototype._unRegisterHashChanger=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(E){this._oHashChanger.detachEvent(E,this._mEventListeners[E],this);}.bind(this));delete this._mEventListeners;}this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null;};b.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash();};b.prototype._getDirection=function(n,h,c){if(c&&this._oNextHash&&this._oNextHash.sHash===n){return a.NewEntry;}if(h){return a.NewEntry;}if(this._bUnknown){return a.Unknown;}if(this.aHistory[this.iHistoryPosition+1]===n&&this.aHistory[this.iHistoryPosition-1]===n){return a.Unknown;}if(this.aHistory[this.iHistoryPosition-1]===n){return a.Backwards;}if(this.aHistory[this.iHistoryPosition+1]===n){return a.Forwards;}return a.Unknown;};b.prototype._getDirectionWithState=function(h){var s=window.history.state===null?{}:window.history.state,B,d;if(typeof s==="object"){if(s.sap===undefined){b._aStateHistory.push(h);s.sap={};s.sap.history=b._aStateHistory;window.history.replaceState(s,document.title);d=a.NewEntry;}else{B=s.sap.history.every(function(u,c){return u===b._aStateHistory[c];});if(B&&s.sap.history.length===b._aStateHistory.length){d=D;}else{d=B?a.Backwards:a.Forwards;b._aStateHistory=s.sap.history;}}}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}return d;};b.prototype._onHashChange=function(p,e){var n=p.newHash||"newHash",o=p.oldHash||"oldHash",f=p.fullHash||"fullHash";this._hashChange(e.getParameter(n),e.getParameter(o),e.getParameter(f));};b.prototype._hashChange=function(n,o,f){var c=window.history.length,d;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===n){if(this._oNextHash.sDirection){d=this._oNextHash.sDirection;}else{this.aHistory[this.iHistoryPosition]=n;if(f!==undefined&&b._bUsePushState&&this===b.getInstance()){b._aStateHistory[b._aStateHistory.length-1]=f;window.history.replaceState({sap:{history:b._aStateHistory}},window.document.title);}this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown;}return;}}this._bIsInitial=false;if(d){this._adaptToDirection(d,{oldHash:o,newHash:n,fullHash:f});}else{if(!d&&f!==undefined&&b._bUsePushState&&this===b.getInstance()){d=this._getDirectionWithState(f);}if(d===D){return;}if(!d){d=this._getDirection(n,this._iHistoryLength<window.history.length,true);}this._bUnknown=false;switch(d){case a.Unknown:this._reset();break;case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition++;break;case a.Forwards:this.iHistoryPosition++;break;case a.Backwards:this.iHistoryPosition--;break;default:break;}}this._sCurrentDirection=d;this._iHistoryLength=c;if(this._oNextHash){this._oNextHash=null;}};b.prototype._adaptToDirection=function(d,h){var f=h.fullHash,n=h.newHash,I,s;if(b._bUsePushState&&this===b.getInstance()&&f!==undefined){switch(d){case a.NewEntry:case a.Forwards:b._aStateHistory.push(f);break;case a.Backwards:I=b._aStateHistory.lastIndexOf(f);if(I!==-1){b._aStateHistory.splice(I+1);}else{b._aStateHistory=[f];L.debug("Can't find "+f+" in "+JSON.stringify(b._aStateHistory));}break;case a.Unknown:b._aStateHistory[b._aStateHistory.length-1]=f;break;default:break;}s={};s.sap={};s.sap.history=b._aStateHistory;window.history.replaceState(s,document.title);}switch(d){case a.NewEntry:this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition+=1;break;case a.Forwards:I=this.aHistory.indexOf(n,this.iHistoryPosition+1);if(I!==-1){this.iHistoryPosition=I;}else{this.aHistory.splice(this.iHistoryPosition+1,this.aHistory.length-this.iHistoryPosition-1,n);this.iHistoryPosition++;}break;case a.Backwards:I=this.aHistory.lastIndexOf(n,this.iHistoryPosition-1);if(I!==-1){this.iHistoryPosition=I;}else{this.aHistory=[n];this.iHistoryPosition=0;}break;case a.Unknown:this.aHistory[this.iHistoryPosition]=n;break;default:break;}};b.prototype._hashSet=function(e){var h=e.getParameter("hash");if(h===undefined){h=e.getParameter("sHash");}this._hashChangedByApp(h,false);};b.prototype._hashReplaced=function(e){var h=e.getParameter("hash"),d=e.getParameter("direction");if(h===undefined){h=e.getParameter("sHash");}if(h===this._oHashChanger.getHash()&&d){this._sCurrentDirection=d;}this._hashChangedByApp(h,true,d);};b.prototype._hashChangedByApp=function(n,w,d){this._oNextHash={sHash:n,bWasReplaced:w,sDirection:d};};var i;b.getInstance=function(){return i;};i=new b(H.getInstance());return b;},true);
