/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/SelectionManager","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Util","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/dt/SelectionMode","sap/base/util/includes","sap/ui/dt/DesignTimeStatus","sap/base/util/restricted/_curry","sap/base/util/restricted/_difference","sap/base/util/isEmptyObject"],function(M,E,A,O,S,a,b,c,d,e,f,U,T,g,L,i,m,h,j,D,_,k,l){"use strict";var n=M.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"int"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(){this._sStatus=D.SYNCED;this._mPendingOverlays={};this._oTaskManager=new T({complete:function(p){if(p.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==D.SYNCED){this._sStatus=D.SYNCED;setTimeout(function(){if(this._sStatus===D.SYNCED){this.fireSynced();}}.bind(this),0);}}}.bind(this),add:function(p){if(p.getSource().count()===1){this._sStatus=D.SYNCING;this.fireSyncing();}}.bind(this)});this._oTaskRunner=new g({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new S();this._aOverlaysCreatedInLastBatch=[];M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(p){this._createOverlaysForRootElement(p.getParameter("element"));},this);this.getPlugins().forEach(function(p){p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("addPlugin",function(p){var P=p.getParameter("plugin");P.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("enabledChanged",function(p){var v=p.getParameter("value");var $=d.getOverlayContainer();$[v?"show":"hide"]();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){this._oTaskManager.add({type:"applyStyles",callbackFn:R.applyStyles.bind(R,true),overlayId:R.getId()});}}.bind(this));},this);}});n.prototype._onProcessingStatusChange=function(p){if(p.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:p.getSource().getMetadata().getName()});}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:p.getSource().getMetadata().getName()});}};n.prototype._onApplyStylesRequired=function(p){var P=p.getParameters();var q=p.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:q.applyStyles.bind(q,P.bForceScrollbarSync),overlayId:q.getId()},"overlayId");};n.prototype._removeOverlayFromSyncingBatch=function(p){var I=this._aOverlaysCreatedInLastBatch.indexOf(p);if(I!==-1){this._aOverlaysCreatedInLastBatch.splice(I,1);}};n.prototype._registerElementOverlays=function(){var p=this._aOverlaysCreatedInLastBatch.slice();if(!p.length){return;}var t=this._oTaskManager.add({type:"registerElementOverlays"});var P=this.getPlugins();p.forEach(function(q){O.register(q);q.attachBeforeDestroy(function(r){O.deregister(r.getSource());});});p.forEach(function(q){P.forEach(function(r){try{r.callElementOverlayRegistrationMethods(q);}catch(v){var s=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf("registerElementOverlay() method of the plugin {0} has failed for overlay with id='{1}' (element id='{2}')",r.getMetadata().getName(),q.getId(),q.getElement().getId()));L.error(U.errorToString(s));}});},this);p.forEach(function(q){try{this.fireElementOverlayCreated({elementOverlay:q});}catch(v){var r=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('One of the listeners of elementOverlayCreated event failed while precessing the overlay with id="{0}" for element with id="{1}"',q.getId(),q.getElement().getId()));L.error(U.errorToString(r));}},this);this._aOverlaysCreatedInLastBatch=[];this._oTaskManager.complete(t);};n.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(p){p.destroy();});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending;};n.prototype.getSelection=function(){return this.getSelectionManager().get();};n.prototype.getSelectionManager=function(){return this._oSelectionManager;};n.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};n.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(p){return p.isBusy();});};n.prototype.waitForBusyPlugins=function(){var B=this.getBusyPlugins();return Promise.all(B.map(function(p){return p.waitForBusyAction();}));};n.prototype.addPlugin=function(p){this.addAggregation("plugins",p);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};n.prototype.insertPlugin=function(p,I){this.insertAggregation("plugins",p,I);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};n.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}}.bind(this));this.removeAggregation("plugins",p);return this;};n.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}.bind(this));this.removeAllAggregation("plugins");return this;};n.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};n.prototype.getDesignTimeMetadataFor=function(p){var C;if(typeof p==="string"){C=p;L.error("sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance");}else{C=p.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};n.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};n.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:"createOverlay",element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(p){d.getOverlayContainer().append(p.render());this._oTaskManager.add({type:"applyStyles",callbackFn:p.applyStyles.bind(p),overlayId:p.getId()},"overlayId");this._oTaskManager.complete(t);return p;}.bind(this),function(v){var p=U.propagateError(v,"DesignTime#_createOverlaysForRootElement",U.printf("Root element with id = '{0}' initialization is failed",r.getId()));L.error(U.errorToString(p));this._oTaskManager.cancel(t);this.fireSyncFailed({error:p});}.bind(this));};n.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};n.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};n.prototype.getElementOverlays=function(){var p=[];this._iterateRootElements(function(r){p=p.concat(this._getAllElementOverlaysIn(r));},this);return p;};n.prototype.createOverlay=function(v){var p=Object.assign({},i(v)?v:{element:v});var t=this._oTaskManager.add({type:"createOverlay"});if(!p.element||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return this._rejectCreateOverlay(p.element);}var s=p.element.getId();var q=O.getOverlay(s);if(q){this._oTaskManager.complete(t);return Promise.resolve(q);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}if(typeof p.root==="undefined"){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(q){return this._createChildren(q,p).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[s];},this);if(this.bIsDestroyed){q.detachEvent("destroyed",this._onElementOverlayDestroyed,this);q.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(q.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}this._aOverlaysCreatedInLastBatch.push(q);this._oTaskManager.complete(t);return q;}.bind(this));}.bind(this)).catch(function(r){var u=U.propagateError(r,"DesignTime#createOverlay",U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this._oTaskManager.cancel(t);return Promise.reject(u);}.bind(this));return this._mPendingOverlays[s];};n.prototype._rejectCreateOverlay=function(p){var r;if(!p){r="Cannot create overlay — no element is specified.";}else if(p.bIsDestroyed){r="Cannot create overlay — the element is already destroyed.";}else if(p instanceof M&&!c.isElementInTemplate(p)){r="Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='"+p.getId()+"'. Please report to CA-UI5-FL-RTA component.";}else{r=U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(p));}return Promise.reject(U.createError("DesignTime#createOverlay",r));};n.prototype._createAggregationOverlay=function(s,p,q,I){return new A({aggregationName:s,element:p,visible:!I,designTimeMetadata:new b({data:q}),init:function(r){var t=r.getSource();t.attachEvent("destroyed",this._onAggregationOverlayDestroyed,this);t.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this);}.bind(this),beforeDestroy:function(r){var t=r.getSource();O.deregister(t);t.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this);}.bind(this)});};n.prototype._createElementOverlay=function(p){var q=p.element;function r(P){return new E(P);}return new Promise(function(R,s){r({element:q,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(q)instanceof a?this.getDesignTimeMetadataFor(q):_(function(t,P,q,u){u=m({},u,t);this._mMetadataOriginal=u;if(P){u=f.propagateMetadataToElementOverlay(u,P,q);}return u;})(this.getDesignTimeMetadataFor(q),p.parentMetadata,q)),init:function(t){var u=t.getSource();R(t.getSource());u.attachEvent("destroyed",this._onElementOverlayDestroyed,this);u.attachEvent("elementDestroyed",this._onElementDestroyed,this);u.attachEvent("selectionChange",this._onElementOverlaySelectionChange,this);u.attachEvent("elementModified",this._onElementModified,this);u.attachEvent("editableChange",this._onEditableChanged,this);u.attachEvent("applyStylesRequired",this._onApplyStylesRequired,this);}.bind(this),initFailed:function(t,u){var v=u.getSource();var w=U.propagateError(u.getParameter("error"),"DesignTime#_createElementOverlay",U.printf("Can't create overlay properly (id='{0}') for '{1}'",v.getId(),t));v.detachEvent("destroyed",this._onElementOverlayDestroyed,this);v.detachEvent("elementDestroyed",this._onElementDestroyed,this);v.detachEvent("applyStylesRequired",this._onApplyStylesRequired,this);v.destroy();s(w);}.bind(this,q.getId())});}.bind(this));};function o(p,q){var r=p.getElement();return q.reduce(function(t,s){var u=c.getAggregationBindingTemplate(r,s);if(u){t[s]=u;}return t;},{});}n.prototype._createChildren=function(p,P){var q=p.getAggregationNames();var r=P.parentMetadata;var s=o(p,q);var t=Object.keys(s);var u=P.isTemplate!==undefined;var H=!l(s);var I=H&&!u;var v=I?true:P.isTemplate;var w=I?false:P.isTemplate;if(H&&v&&!I){q=k(q,t);}return this._createChildrenOverlays(p,r,t,v,s).then(this._createChildrenOverlays.bind(this,p,r,q,w));};n.prototype._createChildrenOverlays=function(p,P,q,I,r){var s=!l(r);if(s&&!I){return Promise.resolve();}return Promise.all(q.map(function(t){var u=p.getElement();var v=u.getMetadata().getName();var w=f.propagateMetadataToAggregationOverlay(p.getDesignTimeMetadata().getAggregation(t),u,P);var x=this._createAggregationOverlay(t,u,w,s);O.register(x);var C;if(s){C=[r[t]];}else{C=c[x.isAssociation()?"getAssociationInstances":"getAggregation"](u,t);}return Promise.all(C.map(function(y,u){return this.createOverlay({element:u,root:false,parentMetadata:w,isTemplate:I}).catch(function(z){var B=this._enrichChildCreationError(z,u,y,t);L[B.severity](B.message);return B.errorObject;}.bind(this));}.bind(this,v))).then(function(y){y.map(function(z){if(z instanceof E&&!z.bIsDestroyed&&!z.getParent()){x.addChild(z,true);}},this);return x;}.bind(this));},this)).then(function(t){t.forEach(function(u){if(p.bIsDestroyed){u.destroy();}else if(s){p.addAggregationBindingTemplateOverlay(u);}else{p.addChild(u,true);}});});};n.prototype._enrichChildCreationError=function(p,q,P,s){var r="error";var t=U.errorToString(p);if(p.message.includes("Cannot create overlay without a valid element")){r="warning";p=U.createError("DesignTime#_createChildren",U.printf(["Child element in aggregation '{0}' of {1} must be a descendant of sap.ui.core.Element or ","sap.ui.core.Component, but {2} was give. Consider ignoring the aggregation '{0}' ","in the .designtime configuration of the control."].join(""),s,P,U.getObjectType(q)));t=p.toString();}else if(p.message.startsWith("Element is in a bound aggregation")){r="error";t=p.toString();}return{errorObject:p,severity:r,message:t};};n.prototype._destroyOverlaysForElement=function(p){var q=O.getOverlay(p);if(q){q.destroy();}};n.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};n.prototype._onElementOverlayDestroyed=function(p){if(this._bDestroyPending){return;}var q=p.getSource();this._oTaskManager.cancelBy({type:"applyStyles",overlayId:q.getId()},"overlayId");var s=q.getAssociation("element");if(s in this._mPendingOverlays){this._removeOverlayFromSyncingBatch(q);delete this._mPendingOverlays[s];return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(q.isSelected()){this.getSelectionManager().remove(q);}this.fireElementOverlayDestroyed({elementOverlay:q});};n.prototype._onElementDestroyed=function(p){var s=p.getParameter("targetId");this.removeRootElement(s);};n.prototype._onAggregationOverlayDestroyed=function(p){this._oTaskManager.cancelBy({type:"applyStyles",overlayId:p.getSource().getId()},"overlayId");if(!O.hasOverlays()){d.removeOverlayContainer();}};n.prototype._onElementOverlaySelectionChange=function(p){var q=p.getSource();var s=p.getParameter("selected");if(s){if(this.getSelectionManager().getSelectionMode()===h.Multi){this.getSelectionManager().add(q);}else{this.getSelectionManager().set(q);}if(!j(this.getSelectionManager().get(),q)){q.setSelected(false);}}else{this.getSelectionManager().remove(q);}};n.prototype._onElementModified=function(p){var P=m({},p.getParameters());var q=p.getSource();P.type=!P.type?p.getId():P.type;switch(P.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(P.value,P.target,P.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(P.target);}}.bind(this),0);break;case"propertyChanged":P.id=p.getSource().getId();delete P.type;delete P.target;if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",P,function(){if(!q.bIsDestroyed){this.fireElementPropertyChanged(arguments[1]);}},this);}else{this.fireElementPropertyChanged(P);}break;default:break;}};n.prototype._onEditableChanged=function(p){var P=m({},p.getParameters());var q=p.getSource();P.id=q.getId();if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",P,function(){if(!q.bIsDestroyed){this.fireElementOverlayEditableChanged(arguments[1]);}},this);}else{this.fireElementOverlayEditableChanged(P);}};n.prototype._onAddAggregation=function(p,P,s){if(c.isElementValid(p)){var q=O.getOverlay(P);var r=q&&q.getAggregationOverlay(s);if(!r){var t;var u=function(v){var w=v.getParameter("elementOverlay");if(w.getElement().getId()===P.getId()){var r=w.getAggregationOverlay(s);this.detachSynced(t,this);this.detachElementOverlayCreated(u,this);this._addAggregation(p,r);}};t=function(){var q=O.getOverlay(P);var r=q&&q.getAggregationOverlay(s);this.detachSynced(t,this);this.detachElementOverlayCreated(u,this);this._addAggregation(p,r);};this.attachElementOverlayCreated(u,this);this.attachSynced(t,this);}else{this._addAggregation(p,r);}}};n.prototype._addAggregation=function(p,P){var q=O.getOverlay(p);if(!q&&P&&P.getElement()){var t=this._oTaskManager.add({type:"createChildOverlay",element:p});this.createOverlay({element:p,root:false,parentMetadata:P.getDesignTimeMetadata().getData()}).then(function(q){var I=P.insertChild(null,q);if(I===true){this._oTaskManager.add({type:"applyStyles",callbackFn:q.applyStyles.bind(q),overlayId:q.getId()},"overlayId");var r=P.indexOfAggregation("children",q);this.attachEventOnce("synced",q,function(){if(!q.bIsDestroyed){this.fireElementOverlayAdded({id:q.getId(),targetIndex:r,targetId:P.getId(),targetAggregation:P.getAggregationName()});}},this);}this._oTaskManager.complete(t);}.bind(this)).catch(function(s,r,v){this._oTaskManager.cancel(t);var u=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new element overlay (elementId='{0}') into aggregation overlay (id='{1}')",s,r));if(!p.bIsDestroyed&&!P.bIsDestroyed){L.error(U.errorToString(u));}}.bind(this,p.getId(),P.getId()));}else{if(q&&!this._isElementInRootElements(q)&&q.isRoot()){q.setIsRoot(false);}if(P){P.insertChild(null,q);}else{L.error("No parentAggregationOverlay exists during addAggregation");return;}q.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(q._mMetadataOriginal,P.getDesignTimeMetadata().getData(),p));this.fireElementOverlayMoved({id:q.getId(),targetIndex:P.indexOfAggregation("children",q),targetId:P.getId(),targetAggregation:P.getAggregationName()});}};n.prototype._checkIfOverlayShouldBeDestroyed=function(p){var q=O.getOverlay(p);if(!p.bIsDestroyed&&q&&(!this._isElementInRootElements(p)||p.sParentAggregationName==="dependents")){q.destroy();}};n.prototype._isElementInRootElements=function(p){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(p,r)){F=true;return false;}return undefined;});return F;};n.prototype._iterateRootElements=function(s,p){var r=this.getRootElements();r.forEach(function(R){var q=c.getElementInstance(R);s.call(p||this,q);},this);};n.prototype._getAllElementOverlaysIn=function(p){var q=[];var r=O.getOverlay(p);if(r){e.iterateOverlayElementTree(r,function(C){if(C.getDesignTimeMetadata()){q.push(C);}});}return q;};n.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty("enabled",v);this.fireEnabledChanged({value:v});}};n.prototype.getStatus=function(){return this._sStatus;};return n;});
