/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(M,i){"use strict";var T=M.extend("sap.ui.dt.TaskManager",{metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},constructor:function(){M.apply(this,arguments);this._mQueuedTasks={};this._mPendingTasks={};},_iNextId:0,_iTaskCounter:0});function v(t){if(!i(t)||!t.type||typeof t.type!=="string"){throw new Error("Invalid task specified");}}function g(t){var a;if(typeof t==="string"){a=function(m){return m[t];};}else if(typeof t==="function"){a=t;}else{throw new Error("Validator needs to be a function or a string");}return a;}function f(t,n,o){if(t(o)===n){this._iTaskCounter--;return false;}return true;}T.prototype._removeTasksByIdentifier=function(t,a,l){if(a){var b=g(a);var n=b(t);if(this[l][t.type]&&n){this[l][t.type]=this[l][t.type].filter(f.bind(this,b,n));}}};T.prototype._removeTaskById=function(t,l){Object.keys(this[l]).forEach(function(s){this[l][s]=this[l][s].filter(function(m){if(m.id===t){this._iTaskCounter--;return false;}return true;}.bind(this));},this);};T.prototype._addTask=function(t){var a=this._iNextId++;this._mQueuedTasks[t.type]=this._mQueuedTasks[t.type]||[];this._mQueuedTasks[t.type].push(Object.assign({},t,{id:a}));this._iTaskCounter++;if(!this.getSuppressEvents()){this.fireAdd({taskId:a});}return a;};T.prototype.add=function(t,d){v(t);this._removeTasksByIdentifier(t,d,"_mQueuedTasks");return this._addTask(t);};T.prototype.complete=function(t){this._removeTaskById(t,"_mQueuedTasks");this._removeTaskById(t,"_mPendingTasks");if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]});}};T.prototype.completeBy=function(t){v(t);var c=[];var _=function(a){return(a||[]).filter(function(l){var C=Object.keys(t).every(function(k){return l[k]&&l[k]===t[k];});if(C){this._iTaskCounter--;c.push(l.id);return false;}return true;}.bind(this));}.bind(this);this._mQueuedTasks[t.type]=_(this._mQueuedTasks[t.type]);this._mPendingTasks[t.type]=_(this._mPendingTasks[t.type]);if(!this.getSuppressEvents()){this.fireComplete({taskId:c});}};T.prototype.cancel=function(t){this.complete(t);};T.prototype.cancelBy=function(t,s){this._removeTasksByIdentifier(t,s,"_mQueuedTasks");this._removeTasksByIdentifier(t,s,"_mPendingTasks");};T.prototype.isEmpty=function(){return this._iTaskCounter===0;};T.prototype.count=function(t){return this.getList(t).length;};T.prototype._markAsPending=function(t,a){this._mPendingTasks[t]=(this._mPendingTasks[t]||[]).concat(a);this._mQueuedTasks[t]=[];};T.prototype._getTypedList=function(t,m){var a=[];if(this._mQueuedTasks[t]){a=this._mQueuedTasks[t].slice(0);}if(m){this._markAsPending(t,a);}else if(this._mPendingTasks[t]){a=a.concat(this._mQueuedTasks[t].slice(0));}return a;};T.prototype._getAllTasks=function(m){var a=[];a=Object.keys(this._mQueuedTasks).reduce(function(r,_){r=r.concat(this._mQueuedTasks[_]);if(m){this._markAsPending(_,this._mQueuedTasks[_]);}return r;}.bind(this),[]);if(!m){a=a.concat(Object.keys(this._mPendingTasks).reduce(function(r,_){return r.concat(this._mPendingTasks[_]);}.bind(this),[]));}return a;};T.prototype.getList=function(t){if(t){return this._getTypedList(t,false);}return this._getAllTasks(false);};T.prototype.getQueuedTasks=function(t){if(t){return this._getTypedList(t,true);}return this._getAllTasks(true);};T.prototype.destroy=function(){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id);},this);M.prototype.destroy.apply(this,arguments);};return T;});
