/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_omit","sap/base/util/restricted/_isEqual","sap/base/util/each","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/changeHandler/Base","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/ui/model/json/JSONModel"],function(_,a,e,i,b,m,O,L,J,B,R,U,S,V,c,d,C,f,g,h,j,k){"use strict";var l={};function n(E,P){return q(function(z,A){var M=A.model;var D=A.vmReference;var F=false;var T=z.key;var G=z.key;return Promise.resolve().then(function(){if(O.get([D,"currentVariant"],M.oData)&&M.oData[D].currentVariant!==M.oData[D].originalCurrentVariant){G=M.oData[D].originalCurrentVariant;F=true;return M.updateCurrentVariant({variantManagementReference:D,newVariantReference:T,appComponent:M.oAppComponent,internallyCalled:true});}}).then(function(){if(O.get([D,"modified"],M.oData)===true){var H=V.getControlChangesForVariant({reference:M.sFlexReference,vmReference:D,vReference:G,changeInstance:true});return o({changes:H,vmReference:D,vReference:G,revert:!F,model:M}).then(function(){M.oData[D].originalCurrentVariant=T;M.oData[D].modified=false;M.checkUpdate(true);});}}).then(function(){if(!F){M._callVariantSwitchListeners(D,M.oData[D].currentVariant);}});}.bind(null,E.getParameters(),P),P.model,P.vmReference);}function o(P){var z=P.model._getDirtyChangesFromVariantChanges(P.changes);z=z.reverse();return Promise.resolve().then(function(){if(P.revert){return R.revertMultipleChanges(z,{appComponent:P.model.oAppComponent,modifier:J,flexController:P.model.oFlexController});}}).then(function(){z.forEach(function(A){V.removeChangeFromVariant({reference:P.model.sFlexReference,change:A,vmReference:P.vmReference,vReference:P.vReference});P.model.oFlexController.deleteChange(A,P.model.oAppComponent);});});}function p(M,z,A){if(A||M.oData[z]){M.oData[z].variantBusy=A;}M.checkUpdate();}function q(z,M,A){M._oVariantSwitchPromise=M._oVariantSwitchPromise.catch(function(){}).then(p.bind(null,M,A,true)).then(z).then(p.bind(null,M,A,false)).catch(function(E){p(M,A,false);throw E;});M.oFlexController.setVariantSwitchPromise(M._oVariantSwitchPromise);return M._oVariantSwitchPromise;}function s(z,A){l[z]=A;}function r(P,z){return S.switchVariant(P).then(function(){this.oData[P.vmReference].originalCurrentVariant=P.newVReference;this.oData[P.vmReference].currentVariant=P.newVReference;if(this.oData[P.vmReference].updateVariantInURL){U.updateVariantInURL({vmReference:P.vmReference,newVReference:P.newVReference,model:this});}this._callVariantSwitchListeners(P.vmReference,P.newVReference,undefined,z);this.checkUpdate();}.bind(this));}function u(z){j.getInstance().then(function(A){if(!A.isVariantPersonalizationEnabled()){z.remove=false;z.rename=false;z.change=false;}});}function t(z,A,D){var E=D?g.getCurrentLayer():f.USER;if((z.layer===E)&&(z.key!==A)){return true;}return false;}function w(z){return new Promise(function(A){if(z.getDomRef()){A();}else{z.addEventDelegate({onAfterRendering:function(){A();}});}});}var v=k.extend("sap.ui.fl.variants.VariantModel",{constructor:function(D,P){this.pSequentialImportCompleted=Promise.resolve();k.apply(this,[D]);this.sharing={PRIVATE:"private",PUBLIC:"public"};this.oFlexController=P.flexController;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=this.oChangePersistence.getComponentName();this.oAppComponent=P.appComponent;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};if(b(D)){try{D=V.fillVariantModel({reference:this.sFlexReference});}catch(E){L.error("Variants Map was not found: "+E.message);}}if(D&&typeof D==="object"){Object.keys(D).forEach(function(K){D[K].variants.forEach(function(z){if(!D[K].currentVariant&&(z.key===D[K].defaultVariant)){D[K].currentVariant=z.key;}z.originalTitle=z.title;z.originalFavorite=z.favorite;z.originalExecuteOnSelect=z.executeOnSelect;z.originalVisible=z.visible;z.originalContexts=z.contexts;});D[K].originalCurrentVariant=D[K].currentVariant;D[K].originalDefaultVariant=D[K].defaultVariant;});this.setData(D);}}});v.prototype.initialize=function(){return Promise.resolve().then(function(){var z=h.getUshellContainer();if(z){var A=[h.getUShellService("UserInfo"),h.getUShellService("URLParsing"),h.getUShellService("CrossApplicationNavigation"),h.getUShellService("ShellNavigation")];return Promise.all(A).then(function(D){s("UserInfo",D[0]);s("URLParsing",D[1]);s("CrossApplicationNavigation",D[2]);s("ShellNavigation",D[3]);}).catch(function(E){throw new Error("Error getting service from Unified Shell: "+E);});}return undefined;}).then(function(){U.initialize({model:this});}.bind(this));};v.prototype.updateCurrentVariant=function(P){var z={vmReference:P.variantManagementReference,currentVReference:this.oData[P.variantManagementReference].originalCurrentVariant,newVReference:P.newVariantReference,flexController:this.oFlexController,appComponent:P.appComponent||this.oAppComponent,modifier:J,reference:this.sFlexReference};if(P.internallyCalled){return r.call(this,z,P.scenario);}return q(r.bind(this,z,P.scenario),this,P.variantManagementReference);};v.prototype.getCurrentVariantReference=function(z){return this.oData[z].currentVariant;};v.prototype.getVariantManagementReference=function(z){var A="";var I=-1;Object.keys(this.oData).some(function(K){return this.oData[K].variants.some(function(D,E){if(D.key===z){A=K;I=E;return true;}});}.bind(this));return{variantManagementReference:A,variantIndex:I};};v.prototype.getVariant=function(z,A){return V.getVariant({reference:this.sFlexReference,vmReference:A||this.getVariantManagementReference(z).variantManagementReference,vReference:z});};v.prototype.getVariantProperty=function(z,P){return this.getVariant(z).content.content[P];};function x(z,A){var D=V.getVariantChangesForVariant({vmReference:z,reference:this.sFlexReference});var E=this.oData[z].currentVariant;var F=this.oData[z].defaultVariant;if(A.getExecuteOnSelectionForStandardDefault()&&E===F&&E===z&&!D.setExecuteOnSelect){var G=V.getVariant({reference:this.sFlexReference,vmReference:z,vReference:z});G.content.content.executeOnSelect=true;this.oData[z].variants[0].originalExecuteOnSelect=true;this.oData[z].variants[0].executeOnSelect=true;return true;}return false;}v.prototype.attachVariantApplied=function(P){var z=sap.ui.getCore().byId(P.vmControlId);var A=this.getVariantManagementReferenceForControl(z);return this.waitForVMControlInit(A).then(function(A,P){if(!this._oVariantAppliedListeners[A]){this._oVariantAppliedListeners[A]={};}var I=x.call(this,A,z);if(P.callAfterInitialVariant||I){var D={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:A,flexController:this.oFlexController};V.waitForInitialVariantChanges(D).then(function(){var E=V.getCurrentVariantReference({vmReference:A,reference:this.sFlexReference});this._callVariantSwitchListeners(A,E,P.callback);}.bind(this));}return w(P.control).then(function(){if(c.getRelevantVariantManagementControlId(P.control,this.getVariantManagementControlIds())===P.vmControlId){this.oData[A].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[A][P.control.getId()]=P.callback;}else{L.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the responsible VariantManagement control");}}.bind(this));}.bind(this,A,P));};v.prototype._callVariantSwitchListeners=function(z,N,A,D){if(this._oVariantAppliedListeners[z]){var E;this.oData[z].variants.some(function(F){if(F.key===N){E=m({},F);return true;}});if(D){E.createScenario=D;}if(A){A(E);}else{e(this._oVariantAppliedListeners[z],function(F,A){A(E);});}}};v.prototype.detachVariantApplied=function(z,A){var D=this.getVariantManagementReferenceForControl(sap.ui.getCore().byId(z));if(this._oVariantAppliedListeners[D]){delete this._oVariantAppliedListeners[D][A];}};v.prototype.addChange=function(z){var A=z.getVariantReference();var D=this.getVariantManagementReference(A).variantManagementReference;if(z.getState()===C.states.NEW){this.oData[D].modified=true;}this.checkUpdate(true);return V.addChangeToVariant({reference:this.sFlexReference,change:z,vmReference:D,vReference:A});};v.prototype.removeChange=function(z){var A=z.getVariantReference();var D=this.getVariantManagementReference(A).variantManagementReference;var E=V.removeChangeFromVariant({reference:this.sFlexReference,change:z,vmReference:D,vReference:A});this.checkDirtyStateForControlModels([D]);return E;};v.prototype._getVariantTitleCount=function(N,z){var D=this.getData();return D[z].variants.reduce(function(A,E){if(N.toLowerCase()===E.title.toLowerCase()&&E.visible){A++;}return A;},0);};v.prototype._duplicateVariant=function(P){var N=P.newVariantReference;var z=P.sourceVariantReference;var A=P.variantManagementReference;var D=this.getVariant(z);var E=V.getControlChangesForVariant({vmReference:A,vReference:z,changeInstance:true,reference:this.sFlexReference}).map(function(K){return K.getDefinition();});var F={content:{},controlChanges:E,variantChanges:{}};var G=g.compareAgainstCurrentLayer(D.content.layer,P.layer);Object.keys(D.content).forEach(function(K){if(K==="fileName"){F.content[K]=N;}else if(K==="variantReference"){if(G===1){var M=this.getVariant(D.content.variantReference);if(M.content.layer===P.layer){F.content[K]=M.content.variantReference;}else{F.content[K]=D.content.variantReference;}}else if(G===0){F.content[K]=D.content.variantReference;}else if(G===-1){F.content[K]=z;}}else if(K==="content"){F.content[K]=JSON.parse(JSON.stringify(D.content[K]));F.content.content.title=P.title;}else{F.content[K]=D.content[K];}}.bind(this));F.content.layer=P.layer;F.content.contexts=P.contexts;E=F.controlChanges.slice();var H={};var I;F.controlChanges=E.reduce(function(K,M){if(g.compareAgainstCurrentLayer(M.layer,P.layer)>=0){H=m({},M);H.layer=P.layer;H.variantReference=F.content.fileName;if(!H.support){H.support={};}H.support.sourceChangeFileName=M.fileName;H.packageName="$TMP";I=C.createInitialFileContent(H);K.push(new C(I));}return K;},[]);return F;};v.prototype.copyVariant=function(P){var D=this._duplicateVariant(P);D.generator=P.generator;var z={key:D.content.fileName,layer:P.layer,title:D.content.content.title,originalTitle:D.content.content.title,originalExecuteOnSelect:D.content.content.executeOnSelect,executeOnSelect:false,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true,originalVisible:true,sharing:P.layer===f.USER?this.sharing.PRIVATE:this.sharing.PUBLIC,contexts:D.content.contexts,originalContexts:D.originalContexts};var A=c.createVariant({model:this,variantSpecificData:D});var E=[];[A].concat(A.getControlChanges()).forEach(function(F){E.push(this.oChangePersistence.addDirtyChange(F));}.bind(this));var I=V.addVariantToVariantManagement({variantData:m({},A.getDefinitionWithChanges(),{content:{content:{visible:z.visible,favorite:z.favorite}}}),reference:this.sFlexReference,vmReference:P.variantManagementReference});this.oData[P.variantManagementReference].variants.splice(I,0,z);return this.updateCurrentVariant({variantManagementReference:P.variantManagementReference,newVariantReference:A.getId(),appComponent:P.appComponent,internallyCalled:true,scenario:"saveAs"}).then(function(){return E;});};v.prototype.removeVariant=function(P){var z=this.oChangePersistence.getDirtyChanges().filter(function(A){return(A.getVariantReference&&A.getVariantReference()===P.variant.getId())||A.getId()===P.variant.getId();});return this.updateCurrentVariant({variantManagementReference:P.variantManagementReference,newVariantReference:P.sourceVariantReference,appComponent:P.component}).then(function(){var I=V.removeVariantFromVariantManagement({reference:this.sFlexReference,variant:P.variant,vmReference:P.variantManagementReference});this.oData[P.variantManagementReference].variants.splice(I,1);this.checkUpdate();z.forEach(function(A){this.oChangePersistence.deleteChange(A);}.bind(this));}.bind(this));};v.prototype.collectModelChanges=function(z,A){var D=this.getData()[z];var M=D.variants;var E=[];var P={};M.forEach(function(F){if(F.originalTitle!==F.title){P={variantReference:F.key,changeType:"setTitle",title:F.title,originalTitle:F.originalTitle,layer:A};E.push(P);}if(F.originalFavorite!==F.favorite){P={variantReference:F.key,changeType:"setFavorite",favorite:F.favorite,originalFavorite:F.originalFavorite,layer:A};E.push(P);}if(F.originalExecuteOnSelect!==F.executeOnSelect){P={variantReference:F.key,changeType:"setExecuteOnSelect",executeOnSelect:F.executeOnSelect,originalExecuteOnSelect:F.originalExecuteOnSelect,layer:A};E.push(P);}if(!F.visible&&F.originalVisible){P={variantReference:F.key,changeType:"setVisible",visible:false,layer:A};E.push(P);}if(!a(F.originalContexts,F.contexts)){P={variantReference:F.key,changeType:"setContexts",layer:A,contexts:F.contexts,originalContexts:F.originalContexts};E.push(P);}});if(D.originalDefaultVariant!==D.defaultVariant){P={variantManagementReference:z,changeType:"setDefault",defaultVariant:D.defaultVariant,originalDefaultVariant:D.originalDefaultVariant,layer:A};E.push(P);}return E;};v.prototype.manageVariants=function(z,A,D,E,F){return new Promise(function(G){z.attachEventOnce("manage",{resolve:G,variantManagementReference:A,layer:D},this.fnManageClickRta,this);z.openManagementDialog(true,E,F);}.bind(this));};v.prototype.addVariantChange=function(z,P){var A=this.setVariantProperties(z,P);var N={};var D={vmReference:z,add:true,reference:this.sFlexReference};N.changeType=P.changeType;N.layer=P.layer;N.generator=P.generator;if(P.changeType==="setDefault"){N.fileType="ctrl_variant_management_change";N.selector=J.getSelector(z,P.appComponent);}else{if(P.changeType==="setTitle"){d.setTextInChange(N,"title",P.title,"XFLD");}N.fileType="ctrl_variant_change";N.selector=J.getSelector(P.variantReference,P.appComponent);}var E=this.oFlexController.createBaseChange(N,P.appComponent);E.setContent(A);D.changeContent=E.getDefinition();V.updateChangesForVariantManagementInMap(D);this.oChangePersistence.addDirtyChange(E);return E;};v.prototype.deleteVariantChange=function(z,P,A){var D={vmReference:z,add:false,reference:this.sFlexReference,changeContent:undefined};this.setVariantProperties(z,P,true);D.changeContent=A.getDefinition();V.updateChangesForVariantManagementInMap(D);this.oChangePersistence.deleteChange(A);};v.prototype.setVariantProperties=function(z,P,A){var D=-1;var E;var F=this.getData();if(P.variantReference){D=this.getVariantManagementReference(P.variantReference).variantIndex;E=F[z].variants[D];}var G={};switch(P.changeType){case"setTitle":G.title=P.title;E.title=P.title;E.originalTitle=E.title;break;case"setFavorite":G.favorite=P.favorite;E.favorite=P.favorite;E.originalFavorite=E.favorite;break;case"setExecuteOnSelect":G.executeOnSelect=P.executeOnSelect;if(E){E.executeOnSelect=P.executeOnSelect;E.originalExecuteOnSelect=E.executeOnSelect;}break;case"setVisible":G.visible=P.visible;G.createdByReset=false;E.visible=P.visible;E.originalVisible=E.visible;break;case"setContexts":G.contexts=P.contexts;E.contexts=P.contexts;E.originalContexts=P.contexts;break;case"setDefault":G.defaultVariant=P.defaultVariant;F[z].defaultVariant=P.defaultVariant;F[z].originalDefaultVariant=F[z].defaultVariant;var H=U.getStoredHashParams({model:this});if(H){if(F[z].defaultVariant!==F[z].currentVariant&&H.indexOf(F[z].currentVariant)===-1){U.update({parameters:H.concat(F[z].currentVariant),updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}else if(F[z].defaultVariant===F[z].currentVariant&&H.indexOf(F[z].currentVariant)>-1){H.splice(H.indexOf(F[z].currentVariant),1);U.update({parameters:H,updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}}if(A&&F[z].currentVariant!==P.defaultVariant){this.updateCurrentVariant({variantManagementReference:z,newVariantReference:P.defaultVariant,appComponent:P.appComponent});}break;default:break;}var I=V.getContent(this.sFlexReference);if(D>-1){var K=V.setVariantData({variantData:G,vmReference:z,previousIndex:D,reference:this.sFlexReference});F[z].variants.splice(D,1);F[z].variants.splice(K,0,E);}else if(I[z]){I[z].defaultVariant=P.defaultVariant;}this.setData(F);this.checkUpdate(true);return G;};v.prototype._ensureStandardVariantExists=function(z){var D=this.getData();var A=D[z]||{};var E=_(A,["initPromise"]);if(!D[z]||b(E)){D[z]=m(A,{currentVariant:z,originalCurrentVariant:z,defaultVariant:z,originalDefaultVariant:z,variants:[{key:z,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,executeOnSelect:false,originalExecuteOnSelect:false,visible:true,originalVisible:true,contexts:{},originalContexts:{},author:c.DEFAULT_AUTHOR}]});this.setData(D);var F={};F[z]={defaultVariant:z,variantManagementChanges:{},variants:[{content:{fileName:z,fileType:"ctrl_variant",variantManagementReference:z,variantReference:"",support:{user:c.DEFAULT_AUTHOR},content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),favorite:true,visible:true,executeOnSelect:false},contexts:{}},controlChanges:[],variantChanges:{}}]};try{V.addFakeStandardVariant(this.sFlexReference,this.oAppComponent.getId(),F);}catch(G){L.error("Variants Map was not found: "+G.message);}}};v.prototype.setModelPropertiesForControl=function(z,D,A){this.oData[z].modified=false;this.oData[z].showFavorites=true;var E=this._bDesignTimeMode;if(E!==D){this._bDesignTimeMode=D;if(D){U.clearAllVariantURLParameters({model:this});}else if(E){U.update({parameters:U.getStoredHashParams({model:this}),updateURL:true,updateHashEntry:false,model:this});}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}A.detachManage(this.fnManageClick,this);if(D&&this.oData[z]._isEditable){this.oData[z].variantsEditable=false;this.oData[z].variants.forEach(function(F){F.rename=true;F.change=true;F.sharing=this.sharing.PUBLIC;F.remove=t(F,z,D);}.bind(this));}else if(this.oData[z]._isEditable){A.attachManage({variantManagementReference:z},this.fnManageClick,this);this.oData[z].variantsEditable=true;this.oData[z].variants.forEach(function(F){F.remove=t(F,z,D);switch(F.layer){case f.USER:F.rename=true;F.change=true;F.sharing=this.sharing.PRIVATE;u(F);break;case f.PUBLIC:var G=this._oUserInfoService&&this._oUserInfoService.getUser();var H=!G||G.getId().toUpperCase()===F.author.toUpperCase()||j.getInstanceOrUndef().isKeyUser();F.remove=H;F.rename=H;F.change=H;F.sharing=this.sharing.PUBLIC;break;default:F.rename=false;F.change=false;F.sharing=this.sharing.PUBLIC;}}.bind(this));}else{this.oData[z].variantsEditable=false;this.oData[z].variants.forEach(function(F){F.remove=false;F.rename=false;F.change=false;});}};v.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(E,D){var z=this.collectModelChanges(D.variantManagementReference,D.layer);D.resolve(z);};this.fnManageClick=function(E,D){if(!this.oFlexController||!V.getContent(this.sFlexReference)){return;}var z=this.collectModelChanges(D.variantManagementReference,f.USER);var A=[];z.forEach(function(F){F.appComponent=this.oAppComponent;A.push(this.addVariantChange(D.variantManagementReference,F));}.bind(this));this.oChangePersistence.saveDirtyChanges(this.oAppComponent,false,A);};};function y(F,z,A,D){if(!this._bDesignTimeMode){return F.saveSequenceOfDirtyChanges(z,D).then(function(E){if(E){var G=E.response[0];this.oData[A].variants.forEach(function(H){if(H.key===G.fileName){H.author=G.support.user;}});}}.bind(this));}return Promise.resolve();}v.prototype._handleSaveEvent=function(E){if(!this._bDesignTimeMode){var z=E.getSource();var P=E.getParameters();return this._handleSave(z,P);}return Promise.resolve();};v.prototype._handleSave=function(z,P){var A=h.getAppComponentForControl(z);var D=this.getLocalId(z.getId(),A);var N;return q(function(E,A,P){var F=P.def;var G=P.execute;var H=this.getCurrentVariantReference(E);var I=V.getControlChangesForVariant({reference:this.sFlexReference,vmReference:E,vReference:H,changeInstance:true});if(P.overwrite){return this.oFlexController.saveSequenceOfDirtyChanges(this._getDirtyChangesFromVariantChanges(I),A);}var K=P.layer||(P.public?f.PUBLIC:f.USER);var M=P.newVariantReference||h.createDefaultFileName();var Q={variantManagementReference:E,appComponent:A,layer:K,title:P.name,contexts:P.contexts,sourceVariantReference:H,newVariantReference:M,generator:P.generator};return this.copyVariant(Q).then(function(T){if(F){var W={changeType:"setDefault",defaultVariant:M,originalDefaultVariant:this.oData[E].defaultVariant,appComponent:A,layer:K,variantManagementReference:E};var X=this.addVariantChange(E,W);T.push(X);}if(G){var Y={changeType:"setExecuteOnSelect",executeOnSelect:true,variantReference:M,appComponent:A,layer:K,variantManagementReference:E};var Z=this.addVariantChange(E,Y);T.push(Z);}N=T;return o({changes:I,vmReference:E,vReference:H,model:this}).then(y.bind(this,this.oFlexController,T,E,A));}.bind(this));}.bind(this,D,A,P),this,D).then(function(){this.oData[D].modified=false;this.checkUpdate(true);return N;}.bind(this));};v.prototype.getLocalId=function(I,A){return J.getSelector(I,A).id;};v.prototype.getVariantManagementReferenceForControl=function(z){var A=z.getId();var D=h.getAppComponentForControl(z);return(D&&D.getLocalId(A))||A;};v.prototype.switchToDefaultForVariantManagement=function(z){if(this.oData[z].currentVariant!==this.oData[z].defaultVariant){B.show(200);this.updateCurrentVariant({variantManagementReference:z,newVariantReference:this.oData[z].defaultVariant}).then(function(){B.hide();});}};v.prototype.switchToDefaultForVariant=function(z){Object.keys(this.oData).forEach(function(A){if(!z||this.oData[A].currentVariant===z){this.switchToDefaultForVariantManagement(A);}}.bind(this));};v.prototype.registerToModel=function(z){var A=this.getVariantManagementReferenceForControl(z);this._ensureStandardVariantExists(A);this.oData[A]._isEditable=z.getEditable();this.oData[A].showExecuteOnSelection=false;z.attachEvent("select",{vmReference:A,model:this},n);z.attachSave(this._handleSaveEvent,this);this.setModelPropertiesForControl(A,false,z);var D=z.getUpdateVariantInURL();this.oData[A].updateVariantInURL=D;U.registerControl({vmReference:A,updateURL:!!D,model:this});U.handleModelContextChange({model:this,vmControl:z});if(this.oData[A].initPromise){this.oData[A].initPromise.resolveFunction();delete this.oData[A].initPromise;}this.oData[A].init=true;};v.prototype.waitForVMControlInit=function(z){if(!this.oData[z]){this.oData[z]={};}else if(this.oData[z].init){return Promise.resolve();}this.oData[z].initPromise={};this.oData[z].initPromise.promise=new Promise(function(A){this.oData[z].initPromise.resolveFunction=A;}.bind(this));return this.oData[z].initPromise.promise;};v.prototype._getDirtyChangesFromVariantChanges=function(z){var A=z.map(function(D){return D.getDefinition().fileName;});return this.oChangePersistence.getDirtyChanges().filter(function(D){return i(A,D.getId())&&!D.assignedToVariant;});};v.prototype.checkDirtyStateForControlModels=function(z){z.forEach(function(A){var D=this.oData[A];var E=this.getCurrentVariantReference(A);var F=V.getControlChangesForVariant({reference:this.sFlexReference,vmReference:A,vReference:E,changeInstance:true});var G=this._getDirtyChangesFromVariantChanges(F);D.modified=G.length>0;}.bind(this));this.checkUpdate(true);};v.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(z,A){return z.concat([this.oData[A].currentVariant]);}.bind(this),[]);};v.prototype.getVariantManagementControlIds=function(){var z;return Object.keys(this.oData||{}).reduce(function(A,D){if(this.oAppComponent.byId(D)){z=this.oAppComponent.createId(D);}else{z=D;}A.push(z);return A;}.bind(this),[]);};v.prototype.destroy=function(){V.clearFakedStandardVariants(this.sFlexReference,this.oAppComponent.getId());k.prototype.destroy.apply(this);};v.prototype.getUShellService=function(z){return h.getUshellContainer()&&l[z];};return v;});
