/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseContentRenderer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper","sap/base/util/merge"],function(B,C,a,O,M,b,L,c,m){"use strict";var d=a.extend("sap.ui.integration.cards.BaseContent",{metadata:{library:"sap.ui.integration",aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{},ready:{}}},renderer:B});d.prototype.init=function(){this._oAwaitedEvents=new Set();this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new L());};d.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};d.prototype.exit=function(){this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}this._sContentBindingPath=null;};d.prototype.loadDependencies=function(o){return Promise.resolve();};d.prototype.getActions=function(){return this._oActions;};d.prototype.setActions=function(A){this._oActions=A;};d.prototype.awaitEvent=function(e){if(this._oAwaitedEvents.has(e)){return;}this._bReady=false;this._oAwaitedEvents.add(e);this.showLoadingPlaceholders();this.attachEventOnce(e,function(){this._oAwaitedEvents.delete(e);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady();}}.bind(this));};d.prototype.setConfiguration=function(o,t){this._oConfiguration=o;this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady");if(!o){return this;}this._oLoadingPlaceholder=this.getAggregation("_loadingProvider").createContentPlaceholder(o,t,this.getCardInstance());this._setDataConfiguration(o.data);return this;};d.prototype.getConfiguration=function(){return this._oConfiguration;};d.prototype.getParsedConfiguration=function(){var r=m({},this._oConfiguration),D=r.data;delete r.data;r=c.createBindingInfos(r,this.getCardInstance().getBindingNamespaces());if(D){r.data=D;}return r;};d.prototype.getStaticConfiguration=function(){return this.getConfiguration();};d.prototype._setDataConfiguration=function(D){var o=this.getCardInstance(),e;if(!D){this._sContentBindingPath=null;this.fireEvent("_dataReady");return;}this._sContentBindingPath=D.path||"/";this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(D,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(D.name){e=o.getModel(D.name);}else if(this._oDataProvider){e=new O();this.setModel(e);}if(!e){this.fireEvent("_dataReady");return;}e.attachEvent("change",function(){if(!this.isDestroyed()){this.onDataChanged();this.onDataRequestComplete();}}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){e.setData(E.getParameter("data"));});this._oDataProvider.attachError(function(E){this.handleError(E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};d.prototype.onDataRequested=function(){this.awaitEvent("_dataReady");};d.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");};d.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}};d.prototype.showLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(true);}};d.prototype.hideLoadingPlaceholders=function(){var l=this.getAggregation("_loadingProvider");if(l){l.setLoading(false);}};d.prototype.onDataChanged=function(){};d.prototype._bindAggregationToControl=function(A,o,e){var f;if(!e){return;}if(!e.path){e.path=this._sContentBindingPath;}if(!e.path){f=this.getCardInstance().getBindingContext();e.path=f&&f.getPath();}if(!e.path){return;}o.bindAggregation(A,e);this._observeAggregation(A,o);};d.prototype._observeAggregation=function(A,o){var p=this.getCardInstance().getModel("parameters"),e;if(this._mObservers[A]){return;}e=new M(function(f){var g;if(f.name!==A){return;}if(!(f.mutation==="insert"||f.mutation==="remove")){return;}g=o.getMetadata().getAggregation(A).get(o);p.setProperty("/visibleItems",g.length);});e.observe(o,{aggregations:[A]});this._mObservers[A]=e;};d.prototype.isReady=function(){return this._bReady;};d.prototype.handleError=function(l,D){this.fireEvent("_error",{logMessage:l,displayMessage:D});};d.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};d.prototype.setDataProviderFactory=function(D){this._oDataProviderFactory=D;return this;};d.prototype.setIconFormatter=function(i){this._oIconFormatter=i;return this;};d.prototype.isLoading=function(){var l=this.getAggregation("_loadingProvider"),o=this.getCardInstance();return!l.isDataProviderJson()&&(l.getLoading()||(o&&o.isLoading()));};d.prototype.attachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");a.prototype.attachEvent.apply(this,e);this.invalidate();return this;};d.prototype.detachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");a.prototype.detachEvent.apply(this,e);this.invalidate();return this;};d.prototype.onActionSubmitStart=function(f){};d.prototype.onActionSubmitEnd=function(r,e){};d.prototype.getCardInstance=function(){return C.byId(this.getCard());};d.prototype.isSkeleton=function(){var o=this.getCardInstance();return o&&o.isSkeleton();};return d;});
