/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CalendarContentRenderer","sap/ui/core/ResizeHandler","sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/CalendarAppointmentInCard","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem"],function(C,R,l,B,a,b,c,d,P,L,e,F,D,f,g,h,j,k,U,m){"use strict";var A=l.CardActionArea;var n=B.extend("sap.ui.integration.cards.CalendarContent",{renderer:C,metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{appointments:{type:"sap.f.CalendarAppointmentInCard",multiple:true,singularName:"appointment"}}}});n.prototype._createCardContent=function(){this._oCalendar=new d(this.getId()+"-navigation",{startDateChange:function(E){var i=E.getSource()._getFocusedDate().toLocalJSDate();this._handleStartDateChange(i);}.bind(this),select:function(E){var s=E.getSource().getSelectedDates()[0].getStartDate();this._setParameters(E,E.getParameter("startDate"));this._refreshVisibleAppointments(s);this.invalidate();this._handleSelect(s);}.bind(this)});this._oLegend=new P(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oCalendar.setLegend(this._oLegend);this._oContent=new F(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+_.call(this).getTimePattern("medium")});};n.prototype.init=function(){this._aVisibleAppointments=[];B.prototype.init.apply(this,arguments);this._createCardContent();};n.prototype.exit=function(){if(this._sTwoColumnsResizeListener){R.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined;}B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._bDataInitiallyLoaded){this._bDataInitiallyLoaded=null;}};n.prototype.onDataChanged=function(){var s=this._oCalendar.getSelectedDates()[0]&&this._oCalendar.getSelectedDates()[0].getStartDate();if(!s){return;}if(!this._bDataInitiallyLoaded){this._handleSelect(s);this._handleStartDateChange(s);this._bDataInitiallyLoaded=true;}this._setParameters();this._refreshVisibleAppointments(s);this.invalidate();};n.prototype.onBeforeRendering=function(){var i=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._setParameters();this._refreshVisibleAppointments(i);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};n.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=R.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()});}};n.prototype.resizeHandler=function(E){E.control.toggleStyleClass("sapMPCInCardTwoColumns",E.target.getBoundingClientRect().width>576);};n.prototype.setConfiguration=function(i){B.prototype.setConfiguration.apply(this,arguments);i=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!i){return this;}if(i.item){this._addItem(i.item);}if(i.specialDate){this._addSpecialDate(i.specialDate);}if(i.legendItem){this._addLegendItem(i.legendItem);}if(i.date){this._addDate(i.date);}if(i.maxItems){this._addMaxItems(i.maxItems);}if(i.maxLegendItems){this._addMaxLegendItems(i.maxLegendItems);}if(i.noItemsText){this._addNoItemsText(i.noItemsText);}if(i.moreItems&&i.moreItems.actions){this._oActions.attach({area:A.Content,actions:i.moreItems.actions,control:this._getMoreButton()});}return this;};n.prototype._setParameters=function(E,i){var p,s,q,r,t;if(i){p=i;}else if(this._oCalendar.getSelectedDates().length){p=this._oCalendar.getSelectedDates()[0].getStartDate();}else{p=this._oCalendar.getStartDate();}s=new Date(p.getFullYear(),p.getMonth(),p.getDate()).getTime();q=new Date(p.getFullYear(),p.getMonth(),p.getDate()+1).getTime();r=this.getAppointments();if(r){t=r.filter(function(u){var S=u.getStartDate().getTime(),v=u.getEndDate().getTime();if((S>=s&&S<q)||(v>s&&v<=q)||(S<s&&v>q)){return u;}});}else{t=[];}this._iAllItems=t.length;this._iMaxItems=this.getVisibleAppointmentsCount();this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};n.prototype._refreshVisibleAppointments=function(s){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),s);};n.prototype._calculateVisibleAppointments=function(i,s){var I=this._isAppointmentInSelectedDate(s);var t=function(p,q){var E=p.getEndDate(),N=new Date();if(s.getDate()===N.getDate()&&s.getMonth()===N.getMonth()&&s.getFullYear()===N.getFullYear()){return this._iAllItems-q<this._iVisibleItems||E.getTime()>N.getTime();}return true;};var r=i.filter(I,this).sort(this._sortByStartHourCB).filter(t,this).slice(0,this._iVisibleItems);return r;};n.prototype._sortByStartHourCB=function(i,p){return i.getStartDate().getTime()-p.getStartDate().getTime()||p.getEndDate().getTime()-i.getEndDate().getTime();};n.prototype._isAppointmentInSelectedDate=function(s){return function(i){var p=i.getStartDate().getTime(),q=i.getEndDate().getTime(),S=s.getTime(),r=U.getInstance(new Date(s.getTime())),t,u,v,E;r.setDate(r.getDate()+1);t=r.getTime();u=p<S&&q>t;v=p>=S&&p<t;E=q>S&&q<=t;return u||v||E;};};n.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};n.prototype.formatDate=function(t){var i=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!i){i=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return i;};n.prototype._addItem=function(i){var p={title:i.template.title,text:i.template.text,type:i.template.type},q;if(i.template.startDate){p.startDate=a.formattedProperty(i.template.startDate,this.formatDate);}if(i.template.endDate){p.endDate=a.formattedProperty(i.template.endDate,this.formatDate);}if(i.template.icon&&i.template.icon.src){p.icon=a.formattedProperty(i.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));}this._oAppointmentTemplate=new c(p);var r=this.getActions();r.attach({area:A.ContentItem,actions:i.template.actions,control:this,actionControl:this._oAppointmentTemplate,enabledPropertyName:"clickable",enabledPropertyValue:true,disabledPropertyValue:false});q={path:i.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,q);};n.prototype._addSpecialDate=function(s){var S=s.template,i;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new k(S);i={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,i);};n.prototype._addLegendItem=function(i){var p={text:i.template.text,type:i.template.type},q={text:i.template.text,type:i.template.type},r,s;this._oCalendarLegendItemTemplate=new m(p);r={path:i.path,template:this._oCalendarLegendItemTemplate,filters:new f({path:"category",operator:g.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,r);this._oAppointmentLegendItemTemplate=new m(q);s={path:i.path,template:this._oAppointmentLegendItemTemplate,filters:new f({path:"category",operator:g.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,s);};n.prototype._addDate=function(t){if(b.isBindingInfo(t)){if(!t){return;}var i=new k();i.bindProperty("startDate",a.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(i);}else{this._oCalendar.addSelectedDate(new k({startDate:this.formatDate(t)}));var p=this.formatDate(t);this._handleSelect(p);this._handleStartDateChange(p);this._bDataInitiallyLoaded=true;}};n.prototype._addMaxItems=function(M){if(b.isBindingInfo(M)){M&&this.bindProperty("visibleAppointmentsCount",M);}else{this.setVisibleAppointmentsCount(M);}};n.prototype._addMaxLegendItems=function(M){if(b.isBindingInfo(M)){M&&this._oLegend.bindProperty("visibleLegendItemsCount",M);}else{this._oLegend.setVisibleLegendItemsCount(M);}};n.prototype._addNoItemsText=function(N){if(b.isBindingInfo(N)){N&&this.bindProperty("noAppointmentsText",N);}else{this.setNoAppointmentsText(N);}};n.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new e({text:"More"});}return this._oMoreAppsButton;};n.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount();};n.prototype._getCurrentAppointment=function(){var p=this._getVisibleAppointments(),N=new Date(),q,s,E,i,S=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(S.getDate()===N.getDate()&&S.getMonth()===N.getMonth()&&S.getFullYear()===N.getFullYear()){for(i=p.length-1;i>=0;i--){q=p[i];s=q.getStartDate().getTime();E=q.getEndDate().getTime();if(N.getTime()>s&&N.getTime()<E){return q;}}}};n.prototype._handleStartDateChange=function(i){var p=this.getActions(),q=h.fromLocalJSDate(i),r=j._getFirstDateOfWeek(j._getFirstDateOfMonth(q)),s=new h(i.getFullYear(),i.getMonth()+1,1),t;s.setDate(s.getDate()-1);t=j._getFirstDateOfWeek(s);t.setDate(t.getDate()+6);p.fireAction(this,"MonthChange",{"firstDate":r.toLocalJSDate(),"lastDate":t.toLocalJSDate()});};n.prototype._handleSelect=function(s){var i=this.getActions();i.fireAction(this,"DateChange",{"selectedDate":s});};function _(){if(!this._oLocaleData){var s=o.call(this);var i=new sap.ui.core.Locale(s);this._oLocaleData=sap.ui.core.LocaleData.getInstance(i);}return this._oLocaleData;}function o(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}return n;});
