/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(C,f,c,i,S,_,a,d,b,F,J,M){"use strict";var e="config";var g="tags";var l={"list":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},"form":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};var P=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{metadata:{library:"sap.ui.integration",properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},_bEditorAutoDetect:false,_sCreatedBy:null,_bLayoutReady:false,constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;C.prototype.constructor.apply(this,arguments);var m=new J();this.setModel(m);if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var h=E.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(p)||!Array.isArray(h)||p.length!==h.length){this._removePropertyEditors();this._initPropertyEditors();}else if(this._sCreatedBy){this._evaluateViewRecreation(p,h);}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors();}if(this._sCreatedBy!==e){this._initPropertyEditors();}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout());}},renderer:function(r,o){r.openStart("div",o);r.openEnd();r.renderControl(o.getContent());r.close("div");}});P.prototype.init=function(){this.attachLayoutChange(function(E){var p=E.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(p));var L=E.getParameter("layout");this._initLayout(L);},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit();}.bind(this));};P.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}this._removeStylesheet(this._getLayoutPath(this.getLayout()));C.prototype.destroy.apply(this,arguments);};P.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};P.prototype._loadModule=function(s){return new Promise(function(r,R){sap.ui.require([s],r,R);});};P.prototype._loadStylesheet=function(s){this._bCssRequested=true;return S.add(s);};P.prototype._removeStylesheet=function(s){if(this._bCssRequested){S.remove(s);delete this._bCssRequested;}};P.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};P.prototype.setConfig=function(m){var p=this.getConfig();if(!Array.isArray(p)||!Array.isArray(m)||JSON.stringify(p)!==JSON.stringify(m)){var n=b(m);this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};P.prototype.setTags=function(t){var p=this.getTags();var r=t;if(typeof t==="string"){r=t.split(",").sort().join(",");}if(p!==r){this.setProperty("tags",r);this.fireTagsChange({previousTags:p,tags:r});}};P.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};P.prototype._removePropertyEditors=function(){var p=this.removeAllAssociation("propertyEditors").map(function(s){return sap.ui.getCore().byId(s);});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(p.length){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:[]});}};P.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||(!this.getBindingInfo("config")&&this.getTags()))&&this._bLayoutReady){var E=this.getEditor();var h;if(this.getConfig()){h=this.getConfig();this._sCreatedBy=e;}else{var t=this.getTags().split(",");h=E.getConfigsByTag(t);this._sCreatedBy=g;}var p=(this._getPropertyEditors()||[]).slice();this._updateViewModel(h);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:(this._getPropertyEditors()||[]).slice()});}.bind(this));}this._checkReadyState();};P.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};P.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};P.prototype.setLayout=function(L){var p=this.getLayout();if(p!==L){this.setProperty("layout",L);this.fireLayoutChange({previousLayout:p,layout:L});}};P.prototype.setLayoutConfig=function(L){var p=this.getLayoutConfig();if(!d(p,L)){this.setProperty("layoutConfig",L);this.fireLayoutConfigChange({previousLayoutConfig:p,layoutConfig:L});}};P.prototype._getLayoutConfig=function(){var L=this.getLayoutConfig();var r=this.getRenderLabels();var R;if(typeof r==="boolean"){R={renderLabels:r};}var D=l[this.getLayout()]&&l[this.getLayout()].defaultConfig||{};return Object.assign({},D,L,R);};P.prototype._getLayoutPath=function(L){return l.hasOwnProperty(L)?l[L].module:L;};P.prototype._initLayout=function(L){this.destroyContent();var p=this._getLayoutPath(L);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors();}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}var m=c(function(r,R){this._loadStylesheet(p);Promise.all([this._loadFragment(p),this._loadModule(p)]).then(r,R);}.bind(this));m.promise.then(function(r){delete this._fnCancelLayoutLoading;var o=r[0];var h=r[1];this._prepareData=h.prepareData;this._aUpdateDependencies=h.updateDependencies||[];this.setContent(o);this._bLayoutReady=true;this._initPropertyEditors();}.bind(this));this._fnCancelLayoutLoading=m.cancel;};P.prototype._evaluateViewRecreation=function(p,h){var r=this._getPropertyEditors()||[];if(p.length!==h.length||h.length!==r.length||h.some(function(o,I){return this._aUpdateDependencies.some(function(D){return p[I][D]!==o[D];});}.bind(this))){this._updateViewModel(h);}else{r.map(function(o,I){var j=h[I];o.setConfig(a(b(j),"value"));if(j.hasOwnProperty("value")){o.setValue(j.value);}});}};P.prototype._updateViewModel=function(h){var D=this._prepareData(h,this._getLayoutConfig());this._iExpectedWrapperCount=D.count;if(this._iExpectedWrapperCount>0){this._checkReadyState();}this.getModel().setData(D);};P.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};P.prototype.isReady=function(){return!!this._bIsReady;};P.prototype.hasError=function(){return this._aEditorWrappers.some(function(w){return w.hasError();});};P.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};P.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bLayoutReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};P.prototype.wrapperInit=function(E){var w=E.getSource();if(i(w,this)){return;}if(!w.getEditor()){w.setEditor(this.getEditor());}this._aEditorWrappers.push(w);this.addAssociation("propertyEditors",w);w.attachReady(function(){this._setReady(false);this._checkReadyState();}.bind(this));w.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()});}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){this._aEditorWrappers=this._aEditorWrappers.filter(function(o){return o!==m.object;});this.removeAssociation("propertyEditors",m.object);}.bind(this));}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};P.prototype._getPropertyEditors=function(){var p=(this.getAssociation("propertyEditors")||[]).map(function(I){return sap.ui.getCore().byId(I);});return p.length&&p||null;};return P;});
