/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/MultiComboBox","sap/m/MultiInput","sap/ui/core/ListItem","sap/base/util/each","sap/base/util/restricted/_debounce","sap/base/util/restricted/_isEqual","sap/base/util/ObjectPath","sap/base/util/includes","sap/base/util/merge","sap/ui/core/SeparatorItem","sap/ui/core/Core","sap/ui/model/Sorter","sap/m/Token","sap/m/Tokenizer","sap/base/util/deepClone"],function(B,I,T,M,b,L,e,_,c,O,i,m,S,C,d,f,g,h){"use strict";var D="#";var r=C.getLibraryResourceBundle("sap.ui.integration");var j=B.extend("sap.ui.integration.editor.fields.ListField",{metadata:{library:"sap.ui.integration"},renderer:B.getMetadata().getRenderer()});j.prototype.initVisualization=function(o){if(r&&r.sLocale!==C.getConfiguration().getLanguage()){r=C.getLibraryResourceBundle("sap.ui.integration");}var t=this,k;var v=o.visualization;if(!v){if(o.values){k=this.formatListItem(o.values.item);v={type:M,settings:{selectedKeys:{path:'currentSettings>value'},busy:{path:'currentSettings>_loading'},editable:o.editable,visible:o.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:k,sorter:[new d({path:'Selected',descending:false,group:true})],groupHeaderFactory:t.getGroupHeader}}};if(this.isFilterBackend()){v.settings.selectedKeys={parts:['currentSettings>value','currentSettings>suggestValue'],formatter:function(V,a){if(a){t.setSuggestValue();}return V;}};}}else{v={type:I,settings:{value:{path:'currentSettings>value',formatter:function(a){a=a||[];return a.join(",");}},change:function(E){var a=E.getSource();a.getBinding("value").setRawValue(a.getValue().split(","));},editable:o.editable,visible:o.visible,placeholder:o.placeholder}};}}else if(o.values&&this.isFilterBackend()&&v.type==="MultiInput"){k=this.formatListItem(o.values.item);var s={busy:{path:'currentSettings>_loading'},placeholder:o.placeholder,editable:o.editable,visible:o.visible,showSuggestion:true,autocomplete:false,showValueHelp:false,filterSuggests:false,width:"100%",suggestionItems:{path:"",template:k,sorter:[new d({path:'Selected',descending:false,group:true})],groupHeaderFactory:t.getGroupHeader}};if(v.settings){s=m(s,v.settings);}v={type:b,settings:s};}this._visualization=v;this.attachAfterInit(this._afterInit);};j.prototype._afterInit=function(){var o=this.getAggregation("_field");var a=this.getConfiguration();var k=this.getModel();if(a.values){this.prepareFieldsInKey(a);}if(o instanceof M){if(this.isFilterBackend()){this.onInputForMultiComboBox=_(this.onInputForMultiComboBox,500);o.oninput=this.onInputForMultiComboBox;o.attachSelectionChange(this.onSelectionChangeForFilterBackend);o.attachSelectionFinish(this.onSelectionFinishForFilterBackend);k.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);}else{o.attachSelectionChange(this.onSelectionChange);k.attachPropertyChange(this.onPropertyChange,this);}}else if(o instanceof b){this.initTokens();this.onInputForMultiInput=_(this.onInputForMultiInput,500);o.oninput=this.onInputForMultiInput;k.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);k.attachPropertyChange(this.initTokens,this);o.attachTokenChange(this.onTokenChange);}};j.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator=D;}var k=o.values.item.key;this._aFields=k.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};j.prototype.initTokens=function(){var o=this.getAggregation("_field");var a=this.getConfiguration();var t=[];if(Array.isArray(a.valueTokens)&&a.valueTokens.length>0){a.valueTokens.forEach(function(V){var k=new f(V);t.push(k);});}else if(Array.isArray(a.value)&&a.value.length>0&&Array.isArray(a.valueItems)&&a.valueItems.length>0){a.valueTokens=[];var v=a.valueItems.map(function(V){return this.getKeyFromItem(V);}.bind(this));a.value.forEach(function(V){if(i(v,V)){var s=o.getSuggestionItemByKey(V);var k=s?s.getText():V;var l={key:V,text:k};var n=new f(l);t.push(n);a.valueTokens.push(l);}});}o.setTokens(t);};j.prototype.getKeyFromItem=function(o){var s="";this._aFields.forEach(function(a){s+=o[a].toString()+this._sKeySeparator;}.bind(this));if(s.endsWith(this._sKeySeparator)){s=s.substring(0,s.length-this._sKeySeparator.length);}return s;};j.prototype.onPropertyChangeForFilterBackend=function(E){var o=this.getConfiguration();if(!o.valueItems){o.valueItems=[];}var p=o.values.data.path||"/";var v=this.getModel();var a=v.getData();if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");var R=O.get(P,a);R=this.mergeSelectedItems(o,R);O.set(P,R,a);}else{a=this.mergeSelectedItems(o,a);}v.setData(a);this.setSuggestValue();};j.prototype.onPropertyChange=function(E){var o=this.getAggregation("_field");var s=o.getSelectedItems().map(function(l){return l.getKey();});var a=this.getBindingContext("currentSettings").sPath;var k=this.getModel("currentSettings");k.setProperty(a+"/value",s);};j.prototype.mergeSelectedItems=function(o,a){if(Array.isArray(a)){var s=o.valueItems.map(function(t){return this.getKeyFromItem(t);}.bind(this));var k=a.filter(function(t){var u=this.getKeyFromItem(t);return!i(s,u);}.bind(this));var l=k.filter(function(t){return t.Selected===r.getText("EDITOR_ITEM_SELECTED");});o.valueItems=o.valueItems.concat(l);var n=k.filter(function(t){return t.Selected!==r.getText("EDITOR_ITEM_SELECTED");});a=o.valueItems.concat(n);var p=this.getAggregation("_field");if(p.isOpen&&p.isOpen()){s=o.valueItems.map(function(t){return this.getKeyFromItem(t);}.bind(this));var q=p.getSelectedKeys();if(!c(s,q)){p.setSelectedKeys(s);}}}else{a=o.valueItems;}return a;};j.prototype.setSuggestValue=function(){var o=this.getAggregation("_field");var s=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");var k=a.getProperty(s+"/suggestValue");if(k&&k!==""){o.setValue(k.replaceAll("\'\'","'"));}};j.prototype.getSuggestValue=function(){var s=this.getBindingContext("currentSettings").sPath;var o=this.getModel("currentSettings");return o.getProperty(s+"/suggestValue");};j.prototype.getGroupHeader=function(G){return new S({text:G.key});};j.prototype.onSelectionChangeForFilterBackend=function(E){var F=E.getSource().getParent();var o=F.getConfiguration();var l=E.getParameter("changedItem");var s=l.getKey();var a=E.getParameter("selected");var k=this.getModel().getData();var p=o.values.data.path||"/";var P,n;if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}P=p.split("/");n=O.get(P,k);}else{n=k;}if(n){if(!o.valueItems){o.valueItems=[];}var N=[];n.forEach(function(q){var t=h(q,500);var u=F.getKeyFromItem(t);if(u===s){if(a){t.Selected=r.getText("EDITOR_ITEM_SELECTED");o.valueItems=o.valueItems.concat([t]);}else{t.Selected=r.getText("EDITOR_ITEM_UNSELECTED");o.valueItems=o.valueItems.filter(function(v){var u=F.getKeyFromItem(v);return u!==s;});}}N.push(t);});if(P!==undefined){O.set(P,N,k);this.getModel().checkUpdate(true);}else{this.getModel().setData(N);}}};j.prototype.onTokenChange=function(E){var F=this.getParent();var o=F.getConfiguration();var s=F.getModel("currentSettings");var a=F.getBindingContext("currentSettings").sPath;var v=s.getProperty(a+"/value");var t=E.getParameter("token");if(t){var k=t.getKey();if(!o.valueTokens){o.valueTokens=[];}if(!v){v=[];}var l=E.getParameter("type");switch(l){case g.TokenChangeType.Removed:v=v.filter(function(u){return u!==k;});o.value=v;o.valueTokens=o.valueTokens.filter(function(u){return u.key!==k;});break;case g.TokenChangeType.Added:if(!i(v,k)){v=v.concat([k]);o.value=v;}var n=o.valueTokens.map(function(V){return V.key;});if(!i(n,k)){o.valueTokens=o.valueTokens.concat([{"key":k,"text":t.getText()}]);}break;case g.TokenChangeType.RemovedAll:o.value=[];o.valueItems=[];o.valueTokens=[];break;default:break;}var p=F.getModel().getData();var R;var P=o.values.data.path||"/";var q;if(P!=="/"){if(P.startsWith("/")){P=P.substring(1);}if(P.endsWith("/")){P=P.substring(0,P.length-1);}q=P.split("/");R=h(O.get(q,p),10);}else{R=h(p,10);}if(Array.isArray(R)){o.valueItems=[];R.forEach(function(u){var k=F.getKeyFromItem(u);if(i(o.value,k)){u.Selected=r.getText("EDITOR_ITEM_SELECTED");o.valueItems.push(u);}else{u.Selected=r.getText("EDITOR_ITEM_UNSELECTED");}});if(P!=="/"){O.set(q,R,p);}else{p=R;}F.getModel().setData(p);F.getModel().checkUpdate(true);}s.setProperty(a+"/value",o.value);s.setProperty(a+"/valueItems",o.valueItems);}};j.prototype.onSelectionChange=function(E){var F=E.oSource.getParent();var o=F.getConfiguration();var l=E.getParameter("changedItem");var s=l.getKey();var a=E.getParameter("selected");var k=this.getModel().getData();var p=o.values.data.path||"/";if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");var R=O.get(P,k);if(Array.isArray(R)){for(var n in R){var q=F.getKeyFromItem(R[n]);if(q===s){if(a){R[n].Selected=r.getText("EDITOR_ITEM_SELECTED");}else{R[n].Selected=r.getText("EDITOR_ITEM_UNSELECTED");}}}O.set(P,R,k);}}else if(Array.isArray(k)){for(var n in k){var q=F.getKeyFromItem(k[n]);if(q===s){if(a){k[n].Selected=r.getText("EDITOR_ITEM_SELECTED");}else{k[n].Selected=r.getText("EDITOR_ITEM_UNSELECTED");}}}}this.getModel().setData(k);this.getModel().checkUpdate(true);};j.prototype.onSelectionFinishForFilterBackend=function(E){var F=this.getParent();var o=F.getConfiguration();var s=E.getParameter("selectedItems").map(function(q){return q.getKey();});var a=this.getModel().getData();var p=o.values.data.path||"/";if(p!=="/"){if(p.startsWith("/")){p=p.substring(1);}if(p.endsWith("/")){p=p.substring(0,p.length-1);}var P=p.split("/");a=O.get(P,a);}if(a){o.valueItems=a.filter(function(q){var t=F.getKeyFromItem(q);return i(s,t);});}var k=this.getBindingContext("currentSettings").sPath;var l=this.getModel("currentSettings");l.setProperty(k+"/value",s);var n=F.getSuggestValue();if(n&&n!==""){l.setProperty(k+"/suggestValue","");}};j.prototype.onInputForMultiComboBox=function(E){var t=E.target.value;var s=this.getBindingContext("currentSettings").sPath;var o=this.getModel("currentSettings");o.setProperty(s+"/suggestValue",t.replaceAll("'","\'\'"));o.setProperty(s+"/_loading",true);E.srcControl.open();E.srcControl._getSuggestionsPopover()._sTypedInValue=t;};j.prototype.onInputForMultiInput=function(E){var o=E.srcControl;b.prototype.oninput.apply(o,arguments);var t=E.target.value;if(t===""){return;}var s=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");var k=a.getProperty(s+"/suggestValue");if(k!==t.replaceAll("'","\'\'")){a.setProperty(s+"/suggestValue",t.replaceAll("'","\'\'"));a.setProperty(s+"/_loading",true);}};return j;});
