/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/List","sap/m/CustomListItem","sap/m/VBox","sap/base/util/each","sap/base/util/restricted/_debounce","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/ui/integration/editor/EditorResourceBundles","sap/base/util/deepClone","sap/ui/model/Sorter","sap/ui/core/SeparatorItem","sap/base/util/includes","sap/ui/core/CustomData"],function(B,I,T,a,S,C,P,b,O,c,L,d,e,V,f,_,g,J,E,h,j,k,l,m){"use strict";var R=/parameters\.([^\}\}]+)/g;var s=["TODAY_ISO","NOW_ISO","LOCALE"];var n=B.extend("sap.ui.integration.editor.fields.StringField",{metadata:{library:"sap.ui.integration"},renderer:B.getMetadata().getRenderer()});n.prototype.initVisualization=function(o){var v=o.visualization;if(!v){var r=o.value?o.value.match(R):undefined;var p,q,t;if(r&&r.length>0){r=r.filter(function(i){var w=i.substring(11);return!l(s,w);});}if(r&&r.length>0){p=r.map(function(i){if(this.isOrigLangField){return"items>"+i.substring(11)+"/_language/value";}return"items>"+i.substring(11)+"/value";}.bind(this));p.unshift("currentSettings>value");q={parts:p,formatter:function(w){var A=Array.prototype.slice.call(arguments,1);for(var i=0;i<A.length;i++){if(A[i]){w=w.replaceAll("{{"+r[i]+"}}",A[i]);}}return w;}};t=function(i){var w=i.getSource().getValue();var x=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(x+"/value",w);var y=this._settingsModel.getBindings();var z=x.substring(x.lastIndexOf("/")+1);f(y,function(A,D){if(D.sPath==="/form/items/"+z+"/value"){D.checkUpdate(true);}});}.bind(this);}if(this.getMode()==="translation"){if(o.editable){v={type:I,settings:{value:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},editable:o.editable,visible:o.visible,placeholder:o.placeholder}};}else{v={type:T,settings:{text:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},visible:o.visible,wrapping:false}};}}else if(o.enum){var u=new L({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});v={type:S,settings:{selectedKey:{path:'currentSettings>value'},forceSelection:false,editable:o.editable,visible:o.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:u}}};}else if(o.values){var u=this.formatListItem(o.values.item);if(!o.values.item.key){o.values.item.key=o.values.item.text;}v={type:C,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},editable:o.editable,visible:o.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:u}}};if(this.isFilterBackend()){v.settings.selectedKey={parts:['currentSettings>value','currentSettings>suggestValue'],formatter:function(i,w){if((!i||i==="")&&w){return w.replaceAll('\'\'',"'");}else{return i;}}};}}else if(this.getMode()!=="translation"&&o.translatable){v={type:I,settings:{value:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},editable:o.editable,visible:o.visible,placeholder:o.placeholder,valueHelpIconSrc:"sap-icon://translate",showValueHelp:true,valueHelpRequest:this.openTranslationListPopup,change:function(i){var w=i.getSource();var x=w.getValue();var y=g.getConfiguration().getLanguage().replaceAll('_','-');w.getParent().setTranslationValueInTexts(y,o.manifestpath,x);}}};if(p){delete v.settings.tooltip;v.settings.value=q;v.settings.change=t;v.settings.showValueHelp=false;delete v.settings.valueHelpRequest;}}else{v={type:I,settings:{value:{path:'currentSettings>value'},tooltip:{path:'currentSettings>value'},editable:o.editable,visible:o.visible,placeholder:o.placeholder}};if(p){delete v.settings.tooltip;v.settings.value=q;v.settings.change=t;}}}this._visualization=v;this.attachAfterInit(this._afterInit);};n.prototype._afterInit=function(){var o=this.getAggregation("_field");if(o instanceof C){if(this.isFilterBackend()){this.onInput=_(this.onInput,500);o.oninput=this.onInput;o.attachSelectionChange(this.onSelectionChange);}}this._settingsModel=this.getModel("currentSettings");};n.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem")||{};var K=i.getKey();var p=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(p+"/value",K);};n.prototype.onInput=function(o){var t=o.target.value;var i=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(i+"/suggestValue",t.replaceAll("'","\'\'"));this._settingsModel.setProperty(i+"/_loading",true);this._settingsModel.setProperty(i+"/value","");var p=this._settingsModel.getBindings();var q=i.substring(i.lastIndexOf("/")+1);f(p,function(u,v){if(v.sPath==="/form/items/"+q+"/value"){v.checkUpdate(true);}});var r=o.srcControl;r.open();r.setValue(t);r.setSelection(null);};n.prototype.getOriginTranslatedValues=function(o){var i=[];var q=E.getInstance();var K;if(o._translatedDefaultPlaceholder&&o._translatedDefaultPlaceholder.startsWith("{i18n>")&&o._translatedDefaultPlaceholder.endsWith("}")){K=o._translatedDefaultPlaceholder.substring(6,o._translatedDefaultPlaceholder.length-1);}else if(o._translatedDefaultPlaceholder&&o._translatedDefaultPlaceholder.startsWith("{{")&&o._translatedDefaultPlaceholder.endsWith("}}")){K=o._translatedDefaultPlaceholder.substring(2,o._translatedDefaultPlaceholder.length-2);}for(var p in q){var r=q[p];var t="";var u="";if(K&&r){var v=r.resourceBundle&&r.resourceBundle.getText(K,[],true);if(v!==undefined){t=v;u=v;}else{t=o._translatedValue||"";u=o._translatedValue||"";}}else{t=o._translatedDefaultPlaceholder||"";u=o._translatedDefaultPlaceholder||"";}var w={"key":p,"desription":r.language,"value":t,"originValue":u,"editable":true};i.push(w);}return i;};n.prototype.getTranslationValueInTexts=function(i,K){var t="/texts/"+i;var p=this._settingsModel.getProperty(t)||{};return p[K];};n.prototype.setTranslationValueInTexts=function(i,K,v){var t="/texts";var D=this._settingsModel.getData();if(!D){return;}if(!D.hasOwnProperty("texts")){var o={};o[i]={};o[i][K]=v;this._settingsModel.setProperty(t,o);}else{t="/texts/"+i;var p;if(!D.texts.hasOwnProperty(i)){p={};}else{p=D.texts[i];}p[K]=v;this._settingsModel.setProperty(t,p);}};n.prototype.openTranslationListPopup=function(o){var t=this;var i=o.getSource();var F=i.getParent();var p=F.getConfiguration();if(!t._aOriginTranslatedValues){t._aOriginTranslatedValues=F.getOriginTranslatedValues(p);}var q=h(t._aOriginTranslatedValues,500);var r=g.getLibraryResourceBundle("sap.ui.integration");q.forEach(function(x){var y=F.getTranslationValueInTexts(x.key,p.manifestpath);if(y){x.value=y;if(!l(t._aUpdatedLanguages,x.key)){x.originValue=x.value;}}else if(p._beforeLayerChange){x.value=p._beforeLayerChange;if(!l(t._aUpdatedLanguages,x.key)){x.originValue=x.value;}}x.status=r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");if(x.key===r.sLocale.replaceAll('_','-')){x.editable=false;}});var u={"currentLanguage":{},"isUpdated":false,"translatedLanguages":[]};var M;if(q){q.forEach(function(x){if(l(t._aUpdatedLanguages,x.key)){x.value=F.getTranslationValueInTexts(x.key,p.manifestpath);x.status=r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED");}if(x.key===r.sLocale.replaceAll('_','-')){x.value=i.getValue();u.currentLanguage=x;}else{u.translatedLanguages.push(x);}});}if(!t._oTranslationPopover){var v=new d({items:{path:"languages>/translatedLanguages",template:new e({content:[new V({items:[new T({text:"{languages>desription}"}),new I({value:"{languages>value}",editable:"{languages>editable}"})]})],customData:[new m({key:"{languages>key}",value:"{languages>desription}"})]}),sorter:[new j({path:'status',descending:true,group:true})],groupHeaderFactory:t.getGroupHeader}});var w=F._previewPostion==="right"?"Right":"Left";t._oTranslationPopover=new P({placement:w,contentWidth:"300px",contentHeight:"345px",customHeader:new V({items:[new a({text:r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new a({text:r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new V({items:[new T({text:"{languages>/currentLanguage/desription}"}),new I({value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new a({text:r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:v,footer:new O({content:[new c(),new b({type:"Emphasized",text:r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var x=t._oTranslationPopover.getModel("languages").getData();var U=[];x.translatedLanguages.forEach(function(y){if(y.value!==y.originValue){F.setTranslationValueInTexts(y.key,p.manifestpath,y.value);U.push(y.key);}});if(x.currentLanguage.value!=x.currentLanguage.originValue){F.setTranslationValueInTexts(x.currentLanguage.key,p.manifestpath,x.currentLanguage.value);U.push(x.currentLanguage.key);}if(U.length>0){t._aUpdatedLanguages=U;}t._oTranslationPopover.close();}}),new b({text:r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){t._oTranslationPopover.close();}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");M=new J(u);M.attachPropertyChange(function(o){var D=M.getData();var U=r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED");var N=r.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");var x=false;D.translatedLanguages.forEach(function(y){if(y.value!==y.originValue){y.status=U;x=true;}else{y.status=N;}});D.isUpdated=x;M.setData(D);M.checkUpdate(true);});t._oTranslationPopover.setModel(M,"languages");}else{M=t._oTranslationPopover.getModel("languages");M.setData(u);M.checkUpdate(true);}t._oTranslationPopover.openBy(i._oValueHelpIcon);};n.prototype.getGroupHeader=function(G){return new k({text:G.key});};return n;});
