/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define([
	"sap/ui/base/ManagedObject",
	"sap/ui/core/Core",
	"sap/ui/core/IconPool"
], function (ManagedObject, Core, IconPool) {
	"use strict";

	/**
	 * @private
	 */
	var IconFormatter = ManagedObject.extend("sap.ui.integration.formatters.IconFormatter", {
		metadata: {
			library: "sap.ui.integration",
			properties: {
				destinations: {
					type: "object"
				}
			},
			associations : {
				/**
				 * The card.
				 */
				card: {
					type : "sap.ui.integration.widgets.Card",
					multiple: false
				}
			}
		}
	});

	/**
	 * Format relative icon sources to be relative to the provided sap.app/id.
	 *
	 * @private
	 * @param {string} sUrl The URL to format.
	 * @returns {string|Promise} The formatted URL or a Promise which resolves with the formatted url.
	 */
	IconFormatter.prototype.formatSrc = function (sUrl) {
		if (!sUrl) {
			return sUrl;
		}

		if (sUrl.startsWith("data:") || IconPool.isIconURI(sUrl)) {
			return sUrl;
		}

		if (this.getDestinations().hasDestination(sUrl)) {
			return this.getDestinations().processString(sUrl)
				.then(function (sResolvedUrl) {
					return this._format(sResolvedUrl);
				}.bind(this));
		}

		return this._format(sUrl);
	};

	IconFormatter.prototype._format = function (sUrl) {
		return this._getCardInstance().getRuntimeUrl(sUrl);
	};

	IconFormatter.prototype._getCardInstance = function () {
		return Core.byId(this.getCard());
	};

	return IconFormatter;
});
