/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/model/json/JSONModel"],function(B,i,m,J){"use strict";var r=/\{\{csrfTokens.([^\}]+)/;var T="X-CSRF-Token";var C=B.extend("sap.ui.integration.util.CsrfTokenHandler",{metadata:{library:"sap.ui.integration"},constructor:function(s){B.call(this);s=s||{};this._oHost=s.host;this._oConfiguration=s.configuration;}});C._mTokens=new Map();C.prototype.resolveToken=function(d){var c,o;d=m({},d);c=this._findCsrfPlaceholder(d);if(!c){return Promise.resolve(d);}o=this._getCsrfConfig(c.tokenName);if(this._oHost){return this._oHost.getCsrfToken(o).then(function(t){if(!t){return this._resolveTokenByUrl(d,c);}this._replaceCsrfPlaceholder(c,t);return d;}.bind(this)).catch(function(e){return Promise.reject(e);});}return this._resolveTokenByUrl(d,c);};C.prototype._resolveTokenByUrl=function(d,c){var s=c.tokenName,a=this._getCsrfConfig(s).data.request.url;if(C._mTokens.has(a)){return C._mTokens.get(a).then(function(t){this._replaceCsrfPlaceholder(c,t);return d;}.bind(this));}if(s){return this._requestToken(d,c);}return Promise.resolve(d);};C.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;};C.prototype.setHost=function(h){this._oHost=h;};C.prototype.isExpiredToken=function(j){if(!j){return false;}var x=j.getResponseHeader(T);return x&&x.toLowerCase()==="required"&&j.status===403;};C.prototype._requestToken=function(d,c){var s=c.tokenName,o=this._getCsrfConfig(s);if(!s||!o){return Promise.reject("CSRF definition is incorrect");}var p=new Promise(function(a,b){var e=this._oDataProviderFactory.create(o.data);e.getData().then(function(D){var t,M;if(o.data.path){M=new J(D);t=M.getProperty(o.data.path);M.destroy();}else{t=e.getLastJQXHR().getResponseHeader(T);}a(t);}).catch(function(){b("CSRF token cannot be resolved");});}.bind(this));this._registerToken(o,p);return p.then(function(t){this._replaceCsrfPlaceholder(c,t);return d;}.bind(this));};C.prototype.resetTokenByRequest=function(d){var c=this._findCsrfPlaceholder(d);if(!c){return;}this._deleteRegisteredToken(this._getCsrfConfig(c.tokenName));};C.prototype._getCsrfConfig=function(c){return this._oConfiguration[c];};C.prototype._replaceCsrfPlaceholder=function(c,t){var p=c.object[c.key];c.object[c.key]=p.replace("{{csrfTokens."+c.tokenName+"}}",t);};C.prototype._findCsrfPlaceholder=function(c){var v,k,t;for(k in c){v=c[k];if(typeof v==="string"){t=this._getCsrfTokenName(v);if(t){return{object:c,key:k,tokenName:t};}}if(i(v)){v=this._findCsrfPlaceholder(v);if(v){return v;}}}return null;};C.prototype._getCsrfTokenName=function(s){var M=s.match(r);if(!M){return"";}return M[1];};C.prototype._registerToken=function(c,p){C._mTokens.set(c.data.request.url,p);if(this._oHost){this._oHost.csrfTokenFetched(c,p);}};C.prototype._deleteRegisteredToken=function(c){C._mTokens.delete(c.data.request.url);if(this._oHost){this._oHost.csrfTokenExpired(c);}};return C;});
