/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/type/String','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/base/util/merge','sap/ui/base/SyncPromise'],function(S,F,P,V,a,b,c,O,C,B,d,m,e){"use strict";var f=S.extend("sap.ui.mdc.field.ConditionType",{constructor:function(i,J){S.apply(this,arguments);this.sName="Condition";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined};}});f.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._bDestroyed=true;};f.prototype.formatValue=function(i,J){if(i==undefined||i==null||this._bDestroyed){return null;}if(typeof i!=="object"||!i.operator||!i.values||!Array.isArray(i.values)){throw new F("No valid condition provided");}if(!J){J="string";}var T=o.call(this);var K=v(T);var L=this.oFormatOptions.preventGetDescription;w.call(this,i,T);switch(this.getPrimitiveType(J)){case"string":case"any":var M=n.call(this);var N=s.call(this);var Q=c.getEQOperator(N);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++;}var R=this._oCalls.last;if(!L&&M!==b.Value&&i.validated===d.Validated&&(K||(i.operator===Q.name&&!i.values[1]))){var U=this.oFormatOptions.bindingContext;var W=this.oFormatOptions.conditionModel;var X=this.oFormatOptions.conditionModelName;var Y=K?i.values[0][1]:i.values[0];return e.resolve().then(function(){return H.call(this,Y,i.inParameters,i.outParameters,U,W,X);}.bind(this)).then(function(Z){if(Z){i=m({},i);if(K){T=p.call(this);i.operator=Q.name;if(typeof Z!=="object"){Z={key:Y,description:Z};}}if(typeof Z==="object"){i=y.call(this,i,Z);}else if(i.values.length===1){i.values.push(Z);}else{i.values[1]=Z;}}return g.call(this,i,undefined,R,true,T);}.bind(this)).catch(function(Z){var $;if(!(Z instanceof F)||!E.call(this)){$=Z;}return g.call(this,i,$,R,true,T);}.bind(this)).unwrap();}return g.call(this,i,undefined,R,true,T);default:if(T&&i.values.length>=1){return T.formatValue(i.values[0],J);}throw new F("Don't know how to format Condition to "+J);}};function _(i,T){var J=n.call(this);var K=v(T);if(K&&i.values.length>1&&i.values[0][1]===i.values[1][1]){i=m({},i);i.operator="EQ";i.values.splice(1);}var L=(this.oFormatOptions.hideOperator&&i.values.length===1)||K;var M=c.getOperator(i.operator);if(!M){throw new F("No valid condition provided, Operator wrong.");}return M.format(i,T,J,L);}function g(i,J,K,L,T){if(this._oCalls.active>0){this._oCalls.active--;}if(K<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){i=this._oCalls.condition;J=this._oCalls.exception;}if(K===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=m({},i);this._oCalls.exception=J;}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined};}if(J){throw J;}var R;if(L){R=_.call(this,i,T);}else{R=h.call(this,i,T);}return R;}f.prototype.parseValue=function(i,J){if(this._bDestroyed){return null;}if(!J){J="string";}else if(J==="any"&&typeof i==="string"){J="string";}var N=this.oFormatOptions.navigateCondition;if(N){var K=this.formatValue(N,J);if(K===i){return m({},N);}}var L=n.call(this);var M=D.call(this);var T=o.call(this);var Q=q.call(this);var R=s.call(this);var U=v(T);var W;if(i===null||i===undefined||(i===""&&!M)){if(!u.call(this,T)){return null;}}x.call(this,T);switch(this.getPrimitiveType(J)){case"string":var X;var Y=false;var Z=false;if(R.length===1){X=c.getOperator(R[0]);Z=true;}else{var $=c.getMatchingOperators(R,i);if($.length===0){X=I.call(this,R,T);if(M&&!u.call(this,T)){var a1=c.getEQOperator(R);if(R.indexOf(a1.name)>=0){Y=!!X&&X.name!==a1.name;X=a1;}}Z=true;}else{var b1=$.filter(function(X){return X.valueTypes.length===0;});if(b1.length>=1){X=b1[0];}else{X=$[0];}}}if(X){if(U&&X!==c.getEQOperator(R)){throw new P("unsupported operator");}var c1;var d1=u.call(this,T);this._oCalls.active++;this._oCalls.last++;var e1=this._oCalls.last;if((!d1||U)&&X.validateInput&&M){c1=j.call(this,X,i,T,Z,Y,R,L,true);if(c1 instanceof Promise){return z.call(this,c1);}else{return c1;}}else{try{if(i===""&&d1&&Z){c1=C.createCondition(X.name,[T.parseValue(i,"string",T._aCurrentValue)],undefined,undefined,d.NotValidated);}else{c1=X.getCondition(i,T,L,Z);}}catch(f1){var g1=f1;if(g1 instanceof P&&Q){try{Q.parseValue(i,"string",Q._aCurrentValue);}catch(h1){g1=h1;}}return g.call(this,undefined,g1,e1,false,T);}}if(c1){return g.call(this,c1,undefined,e1,false,T);}}throw new P("Cannot parse value "+i);default:if(T){if(R.length===1){W=R[0];}else{W=I.call(this,R,T).name;if(R.indexOf(W)<0){W=undefined;}}if(W){return C.createCondition(W,[T.parseValue(i,J)],undefined,undefined,d.NotValidated);}}throw new P("Don't know how to parse Condition from "+J);}};function h(i,T){var J=v(T);if(i&&!J){var N=T.getMetadata().getName();var K=this.oFormatOptions.delegate;var L=this.oFormatOptions.payload;if(K&&K.getTypeUtil(L).getBaseType(N)===B.Unit&&!i.values[0][1]&&T._aCurrentValue){var U=T._aCurrentValue[1]?T._aCurrentValue[1]:null;i.values[0][1]=T._aCurrentValue[1]?T._aCurrentValue[1]:null;if(i.operator==="BT"){i.values[1][1]=U;}}}w.call(this,i,T);return i;}function j(i,J,T,U,K,L,M,N){var Q;var R;var W=true;var X=true;var Y=false;var Z;var $;var a1=this.oFormatOptions.bindingContext;var b1=this.oFormatOptions.conditionModel;var c1=this.oFormatOptions.conditionModelName;var d1;if(J===""){d1=[];Q=J;Z=J;}else{d1=i.getValues(J,M,U);Q=N?d1[0]:d1[1];R=N?d1[1]:d1[0];Y=M!==b.Value;X=M===b.Value||M===b.ValueDescription;Z=X?Q||R:R||Q;}var e1=function(i1){if(i1&&!(i1 instanceof P)&&!(i1 instanceof F)){throw i1;}if(!i1._bNotUnique){if(J===""){return null;}if(N&&d1[0]&&d1[1]){return j.call(this,i,J,T,U,K,L,M,false);}if(K){return k.call(this,T,L,J,M);}}if(E.call(this)){return l.call(this,T,L,J,M);}throw new P(i1.message);};var f1=function(j1){if(j1){var d1=[j1.key];if(i.valueTypes.length>1&&i.valueTypes[1]!==O.ValueType.Static){d1.push(j1.description);}return C.createCondition(i.name,d1,j1.inParameters,j1.outParameters,d.Validated);}else if(J===""){return null;}else{return e1.call(this,new P(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[J])));}};var g1=this._oCalls.last;var h1=function(j1,k1){var l1;var m1;try{l1=k1.call(this,j1);if(v(T)){if(l1){if(l1.operator!=="EQ"){throw new P("unsupported operator");}var n1=T._aCurrentValue&&T._aCurrentValue[0]!==undefined?T._aCurrentValue[0]:null;var o1=l1.values[0];l1.values=[[n1,o1]];}else if(J===""){l1=C.createCondition(i.name,[T.parseValue(J,"string",T._aCurrentValue)],undefined,undefined,d.NotValidated);}}}catch(i1){m1=i1;}return g.call(this,l1,m1,g1,false,T);};try{if(v(T)){$=T.parseValue(Z,"string",T._aCurrentValue);T.validateValue($);$=$[1];}else{$=T.parseValue(Z,"string");T.validateValue($);}}catch(i1){if(i1&&!(i1 instanceof P)&&!(i1 instanceof V)){throw i1;}W=false;X=false;$=undefined;}return e.resolve().then(function(){return G.call(this,Z,$,a1,X,W,Y,b1,c1);}.bind(this)).then(function(j1){return h1.call(this,j1,f1);}.bind(this)).catch(function(i1){return h1.call(this,i1,e1);}.bind(this)).unwrap();}function k(T,i,J,K){var L=I.call(this,i,T);var M;if(L&&i.indexOf(L.name)>=0){M=L.getCondition(J,T,b.Value,true);M.validated=d.NotValidated;}return M;}function l(T,i,J,K){var L;if(v(T)){L=c.getEQOperator("EQ");}else if(i.length===1){L=c.getOperator(i[0]);}else{L=c.getEQOperator(i);if(i.indexOf(L.name)<0){L=undefined;}}if(!L){throw new P("Cannot parse value "+J);}var M=L.getCondition(J,T,b.Value,true);if(M){M.validated=d.NotValidated;if(v(T)&&Array.isArray(M.values[0])){M.values[0]=M.values[0][1];}}return M;}f.prototype.validateValue=function(i){var T=o.call(this);var J=q.call(this);var K=s.call(this);var L=v(T);if(i===undefined||this._bDestroyed){return null;}else if(i===null){if(c.onlyEQ(K)){try{if(T.hasOwnProperty("_sParsedEmptyString")&&T._sParsedEmptyString!==null){T.validateValue(T._sParsedEmptyString);}else{T.validateValue(null);}}catch(M){if(M instanceof V){throw M;}else{return null;}}}return null;}if(typeof i!=="object"||!i.operator||!i.values||!Array.isArray(i.values)){throw new V(this._oResourceBundle.getText("field.VALUE_NOT_VALID"));}var N=c.getOperator(i.operator,K);if(L){N=c.getEQOperator();}if(!N){throw new V("No valid condition provided, Operator wrong.");}try{N.validate(i.values,T);}catch(Q){if(Q instanceof V&&J){N.validate(i.values,J);}throw Q;}};function n(){var i=this.oFormatOptions.display;if(!i){i=b.Value;}return i;}function o(){var T=this.oFormatOptions.valueType;if(!T){T=p.call(this);}return T;}function p(){if(!this._oDefaultType){this._oDefaultType=new a();}return this._oDefaultType;}function q(){return this.oFormatOptions.originalDateType;}function r(){return this.oFormatOptions.additionalType;}function s(){var i=this.oFormatOptions.operators;if(!i||i.length===0){i=c.getOperatorsForType(B.String);}return i;}function t(){var i=this.oFormatOptions.fieldHelpID;if(i){var J=sap.ui.getCore().byId(i);if(J&&J.isValidationSupported()){return J;}}return null;}function u(T){return T&&T.isA("sap.ui.model.CompositeType");}function v(T){if(u(T)){var i=T.getFormatOptions();var J=!i||!i.hasOwnProperty("showMeasure")||i.showMeasure;var K=!i||!i.hasOwnProperty("showNumber")||i.showNumber;if(J&&!K){return true;}}return false;}function w(i,T){if(u.call(this,T)&&i&&i.values[0]){T._aCurrentValue=i.values[0];var J=r.call(this);if(u.call(this,J)){J._aCurrentValue=i.values[0];}var K=q.call(this);if(u.call(this,K)){K._aCurrentValue=i.values[0];}}}function x(T){if(u.call(this,T)){var i=r.call(this);if(u.call(this,i)){if(!i._aCurrentValue){i._aCurrentValue=[];}T._aCurrentValue=i._aCurrentValue;}}}function y(i,R){i.values=[R.key,R.description];if(R.inParameters){i.inParameters=R.inParameters;}if(R.outParameters){i.outParameters=R.outParameters;}return i;}function z(i){if(this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(i);}return i;}function A(T){var i=T.getMetadata().getName();var J=T.getFormatOptions();var K=T.getConstraints();var L=this.oFormatOptions.delegate;var M=this.oFormatOptions.payload;var N=L?L.getTypeUtil(M).getBaseType(i,J,K):B.String;if(N===B.Unit){N=B.Numeric;}return N;}function D(){var i=t.call(this);var J=this.oFormatOptions.delegate;var K=this.oFormatOptions.payload;if(J){return J.isInputValidationEnabled(K,i);}else{return!!i;}}function E(){var i=t.call(this);var J=this.oFormatOptions.delegate;var K=this.oFormatOptions.payload;if(J){return J.isInvalidInputAllowed(K,i);}else if(i){return!i.getValidateInput();}else{return true;}}function G(i,J,K,L,M,N,Q,R){var T=t.call(this);var U=this.oFormatOptions.delegate;var W=this.oFormatOptions.payload;var X={value:i,parsedValue:J,inParameters:undefined,outParameters:undefined,bindingContext:K,checkKeyFirst:L,checkKey:M,checkDescription:N,conditionModel:Q,conditionModelName:R,exception:P};if(U){return U.getItemForValue(W,T,X);}else if(T){return T.getItemForValue(X);}}function H(K,i,J,L,M,N){var Q=t.call(this);var R=this.oFormatOptions.delegate;var T=this.oFormatOptions.payload;if(R){return R.getDescription(T,Q,K,i,J,L,M,N);}else if(Q){return Q.getTextForKey(K,i,J,L,M,N);}}function I(J,T){var K=this.oFormatOptions.defaultOperatorName;var L;if(K){L=c.getOperator(K);}else{L=c.getDefaultOperator(A.call(this,T));}if(L&&J.indexOf(L.name)<0){for(var i=0;i<J.length;i++){L=c.getOperator(J[i]);if(L.exclude||!L.hasRequiredValues()){L=undefined;}else{break;}}}return L;}return f;});
