/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/field/ConditionsType','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/enum/BaseType',"sap/ui/mdc/util/DateUtil",'sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/m/DynamicDate','sap/m/library'],function(C,F,O,a,b,B,D,S,c,P,V,d,l){"use strict";var e=C.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(o,i){S.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}});e.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);this._bDestroyed=true;};e.prototype.formatValue=function(n,I){if(n==undefined||n==null||this._bDestroyed){return null;}if(!Array.isArray(n)){throw new c("No valid conditions provided");}var M=j.call(this);var r;if(M!==1){throw new c("MaxConditions must be 1");}if(n.length===1){var o=n[0];var p=F.getOperator(o.operator);if(!o.operator||!p){throw new c("No valid condition provided, Operator wrong.");}var v=[];var s=p.name;if(!l.StandardDynamicDateRangeKeys[s]){s=p.alias||s;}for(var i=0;i<p.valueTypes.length;i++){if(l.StandardDynamicDateRangeKeys[s]&&p.valueTypes[i]===O.ValueType.Self){v.push(f.call(this,o.values[i]));}else if(p.valueTypes[i]&&p.valueTypes[i]!==O.ValueType.Static){v.push(o.values[i]);}}var q=_.call(this,p);r=q.formatValue({operator:s,values:v},I);}return r;};function _(o){if(!this._oDynamicDateType){var i={date:{source:{pattern:"timestamp"}},"int":{}};this._oDynamicDateType=new d(i);}return this._oDynamicDateType;}function f(v){var t=h.call(this);var s=t.formatValue(v,"string");var i=s.split("-");var y=parseInt(i[0]);var M=parseInt(i[1])-1;var n=parseInt(i[2]);var T=new Date(y,M,n).getTime();return T;}function g(t){var T=h.call(this);var o=new Date(t);var y=o.getFullYear();var M=o.getMonth()+1;var i=o.getDate();var s=y.toString()+"-"+((M<10)?"0":"")+M.toString()+"-"+((i<10)?"0":"")+i.toString();var v=T.parseValue(s,"string");return v;}function h(){if(!this._oInternalType){var t=k.call(this);this._oInternalType=D.createInternalType(t,"yyyy-MM-dd");}return this._oInternalType;}e.prototype.parseValue=function(v,I){if(this._bDestroyed){return null;}if(j.call(this)!==1){throw new P("Only one condition supported for parsing");}var o=m.call(this);var n=[];if(v&&v.operator){if(v.operator==="PARSEERROR"){throw new P(v.values[0]);}var s=v.operator;var p=F.getOperator(s);s=p.name;if(p){var q=_.call(this,p);var r=q.parseValue(v,I);var t=[];for(var i=0;i<p.valueTypes.length;i++){if(l.StandardDynamicDateRangeKeys[v.operator]&&p.valueTypes[i]===O.ValueType.Self){t.push(g.call(this,r.values[i]));}else if(p.valueTypes[i]&&p.valueTypes[i]!==O.ValueType.Static){t.push(r.values[i]);}}var u=a.createCondition(p.name,t,undefined,undefined,b.NotValidated);F.updateConditionValues(u);F.checkConditionsEmpty(u,o);n.push(u);}}return n;};e.prototype.validateValue=function(n){if(n===undefined||n===null||this._bDestroyed){return;}if(!Array.isArray(n)){throw new V("No valid conditions provided");}var t=k.call(this);var o=m.call(this);for(var i=0;i<n.length;i++){var p=n[i];if(typeof p!=="object"||!p.operator||!p.values||!Array.isArray(p.values)){throw new V(this._oResourceBundle.getText("field.VALUE_NOT_VALID"));}var q=F.getOperator(p.operator,o);if(!q){throw new V("No valid condition provided, Operator wrong.");}q.validate(p.values,t);}};function j(){var M=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){M=this.oFormatOptions.maxConditions;}return M;}function k(){var t=this.oFormatOptions.valueType;if(!t){throw new Error("Type missing");}return t;}function m(){var o=this.oFormatOptions.operators;if(!o||o.length===0){o=F.getOperatorsForType(B.Date);}return o;}return e;});
