/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/mdc/p13n/subcontroller/FilterController','sap/ui/core/library','sap/ui/Device','sap/ui/mdc/Control','sap/base/Log','sap/base/util/merge','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/condition/ConditionModel','sap/ui/mdc/condition/Condition','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/condition/ConditionConverter',"sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/m/library","sap/m/Button",'sap/m/MessageBox',"sap/ui/core/ShortcutHintsMixin"],function(F,c,D,C,L,m,M,a,b,d,I,e,f,P,g,l,B,h,S){"use strict";var V=c.ValueState;var j=C.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},propertyInfo:{type:"object",defaultValue:[]},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{conditions:{type:"object"}},filtersChanged:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}});var k=l.ButtonType;j.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";j.CONDITION_MODEL_NAME="$filters";var E={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2};j.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new a(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this._bPersistValues=false;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(r){this._fResolveInitialFiltersApplied=r;}.bind(this));this._bIgnoreChanges=false;this._bSearchTriggered=false;this._bIgnoreQueuing=false;};j.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._bPersistValues=false;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true);};j.prototype._isPhone=function(){return(D.system.phone)?true:false;};j.prototype._isLiveMode=function(){if(this._isPhone()){return false;}return this.getLiveMode();};j.prototype._getConditionModel=function(){return this._oConditionModel;};j.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:k.Emphasized});S.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this);}return this._btnSearch;};j.prototype.getConditionModelName=function(){return this._getConditionModelName();};j.prototype._getConditionModelName=function(){return j.CONDITION_MODEL_NAME;};j.prototype._createConditionModel=function(){this._oConditionModel=new b();this.setModel(this._oConditionModel,this._getConditionModelName());};j.prototype.applySettings=function(s,o){this._applySettings(s,o);this._initControlDelegate();};j.prototype._applySettings=function(s,o){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this);};j.prototype._initControlDelegate=function(){this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions();}}.bind(this));};j.prototype._waitForMetadata=function(){return this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};j.prototype.setIgnoreQueuing=function(v){this._bIgnoreQueuing=v;};j.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing;};j.prototype.setSuspendSelection=function(v){this.setProperty("suspendSelection",v);if(!v){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch();}this._bSearchTriggered=false;this.setIgnoreQueuing(false);}return this;};j.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,j.INNER_MODEL_NAME);return this;};j.prototype.getCurrentState=function(){var i={};var s={};if(this._bPersistValues){var n=m({},this.getFilterConditions());for(var K in n){if(this._getPropertyByName(K)){i[K]=n[K];}}s.filter=i;}var o=this.getFilterItems();var p=[];o.forEach(function(q,r){p.push({name:q.getFieldPath()});});s.items=p;return s;};j.prototype.getAssignedFilterNames=function(){var n,i=null,o=this._getConditionModel();if(o){i=[];var p=o.getConditions("$search");if(p&&p.length>0){i.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}this._getNonHiddenPropertyInfoSet().forEach(function(q){n=I.getPropertyKey(q);var p=o.getConditions(n);if(p&&p.length>0){i.push(q.label||n);}});}return i;};j.prototype._getAssignedFiltersText=function(){var t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t;};j.prototype._getAssignedFiltersExpandedText=function(){var n=0,i=0,o=this._getConditionModel();if(o){var A=o.getAllConditions();for(var s in A){var p=this._getPropertyByName(s);if(p&&!p.hiddenFilter&&(A[s].length>0)){++n;if(!(((s==="$search")&&this.getAggregation("basicSearchField"))||this._getFilterField(s))){++i;}}}}if(!n&&!i){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");}if(!i){if(n===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[n]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[n]);}if((n===1)){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[n,i]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[n,i]);};j.prototype._getAssignedFiltersCollapsedText=function(n){var A;n=n||[];if(n.length){A=Object.keys(n).map(function(i){return n[i];}).join(", ");if(n.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[n.length,A]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[n.length,A]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};j.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText();};j.prototype._reportModelChange=function(t,i){this._handleAssignedFilterNames(false,i);if(this.getLiveMode()||t){this.triggerSearch();}};j.prototype._isPersistenceSupported=function(o){return this.getEngine().isModificationSupported(this);};j.prototype._hasPropertyInfo=function(s){var p=this.getPropertyInfo();var n=p.findIndex(function(o){return o.name===s;});return(n>=0);};j.prototype._getPropertyByName=function(n){return f.getPropertyByKey(this.getPropertyInfoSet(),n);};j.prototype.getPropertyInfoSet=function(){var t,p=[];if(this._hasPropertyHelper()){return this.getPropertyHelper().getProperties();}var n=this.getPropertyInfo();if(n&&(n.length>0)){t=this.getTypeUtil();for(var i=0;i<n.length;i++){var o=n[i];if(o){var T=t.getTypeConfig(o.dataType,o.formatOptions,o.constraints);p.push({name:o.name,typeConfig:T,maxConditions:o.maxConditions,constraints:o.constraints,formatOptions:o.formatOptions,required:o.required,caseSensitive:o.caseSensitive,display:o.display});}}}return p;};j.prototype._hasPropertyHelper=function(){try{this.getPropertyHelper();return true;}catch(i){return false;}};j.prototype._createPropertyInfoChange=function(p){return{changeSpecificData:{changeType:"addPropertyInfo",content:{name:p.name,dataType:p.typeConfig.className,maxConditions:p.maxConditions,constraints:p.constraints,formatOption:p.formatOptions,required:p.required,caseSensitive:p.caseSensitive,display:p.display}},selectorElement:this};};j.prototype.createPropertyInfoChanges=function(s){var p,o,i=[];if(!this._hasPropertyInfo(s)){p=this._getPropertyByName(s);if(p){o=this._createPropertyInfoChange(p);i.push(o);}}return i;};j.prototype._addConditionChange=function(o,s){var i=this.getEngine().createChanges({control:this,key:"Filter",state:o});if(!this._aCollectedChangePromises){this._aCollectedChangePromises=[];}this._aCollectedChangePromises.push(i);};j.prototype._handleConditionModelPropertyChange=function(o){var A=function(s,i){var O={};O[s]=this._stringifyConditions(s,m([],i));this._cleanupConditions(O[s]);this._addConditionChange(O,s);}.bind(this);if(!this._bIgnoreChanges){var p=o.getParameter("path");if(p.indexOf("/conditions/")===0){var s=p.substring("/conditions/".length);if(this._bPersistValues&&this._isPersistenceSupported()){var i=o.getParameter("value");if(this._hasPropertyHelper()||this._getPropertyByName(s)){A(s,i);}else{this._retrieveMetadata().then(function(){A(s,i);});}}else{this._reportModelChange(false);}}}};j.prototype._toExternal=function(p,o){var i=m({},o);i=e.toString(i,p.typeConfig,this.getTypeUtil());this._cleanupCondition(i);this._convertInOutParameters(o,i,"inParameters",e.toString);this._convertInOutParameters(o,i,"outParameters",e.toString);return i;};j.prototype._toInternal=function(p,o){var i=m({},o);i=e.toType(i,p.typeConfig,this.getTypeUtil());this._convertInOutParameters(o,i,"inParameters",e.toType);this._convertInOutParameters(o,i,"outParameters",e.toType);return i;};j.prototype._convertInOutParameters=function(o,i,p,n){if(o[p]&&(Object.keys(o[p]).length>0)){Object.keys(o[p]).forEach(function(K){var N=K.startsWith("conditions/")?K.slice(11):K;var q=this._getPropertyByName(N);if(q){var O=d.createCondition("EQ",[o[p][K]]);var v=n(O,q.typeConfig,this.getTypeUtil());if(!i[p]){i[p]={};}if(!K.startsWith("conditions/")){delete i[p][K];K="conditions/"+N;}i[p][K]=v.values[0];}else{L.error("mdc.FilterBar._convertInOutParameters: could not find property info for "+N);}}.bind(this));}};j.prototype._cleanupCondition=function(o){if(o){if(o.hasOwnProperty("isEmpty")){delete o.isEmpty;}}};j.prototype._cleanupConditions=function(i){if(i){i.forEach(function(o){this._cleanupCondition(o);},this);}};j.prototype._stringifyCondition=function(p,o){var r=o;if(o&&o.values){if(o.values.length>0){r=this._toExternal(p,o);}else{r=m({},o);this._cleanupCondition(r);}}return r;};j.prototype._stringifyConditions=function(s,i){var p=this._getPropertyByName(s);var r=i;if(p&&i){r=[];i.forEach(function(o){r.push(this._stringifyCondition(p,o));},this);}return r;};j.prototype._handleAssignedFilterNames=function(i,n){if(this._bIsBeingDestroyed){return;}if(!i){if(this._btnAdapt){var o=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(o.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",o.length),false);}}var t=this._getAssignedFiltersText();var O={conditionsBased:(!i&&!n),filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this.fireFiltersChanged(O);};j.prototype.onReset=function(o){this._getConditionModel().oConditionModel.removeAllConditions();};j.prototype.onSearch=function(o){if(!this._bSearchPressed){this._bSearchPressed=true;this.triggerSearch().then(function(){this._bSearchPressed=false;}.bind(this),function(){this._bSearchPressed=false;}.bind(this));}};j.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve();}return this.validate();};j.prototype.validate=function(s){var i=!s;return this.initialized().then(function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise(function(r,o){this._fResolvedSearchPromise=r;this._fRejectedSearchPromise=o;}.bind(this));var n=function(){this._validate(i);this._oValidationPromise=null;};setTimeout(n.bind(this),0);}return this._oValidationPromise;}.bind(this));};j.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null;}};j.prototype._getRequiredFieldsWithoutValues=function(){var r=[];this._getRequiredPropertyNames().forEach(function(n){var i=this._getConditionModel().getConditions(n);if(!i||i.length===0){r.push(n);}}.bind(this));return r;};j.prototype._checkAsyncValidation=function(){var r=E.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){r=E.AsyncValidation;}return r;};j.prototype._checkRequiredFields=function(){var r=E.NoError;var R=this._getRequiredFieldsWithoutValues();R.forEach(function(n){var o=this._getFilterField(n);if(o){if(o.getValueState()===V.None){o.setValueState(V.Error);o.setValueStateText(this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING"));}}else{L.error("Mandatory filter field '"+n+"' not visible on FilterBarBase has no value.");}r=E.RequiredHasNoValue;}.bind(this));return r;};j.prototype._checkFieldsInErrorState=function(){var r=E.NoError;this._getNonRequiredPropertyNames().some(function(n){var o=this._getFilterField(n);if(o&&(o.getValueState()!==V.None)){r=E.FieldInErrorState;}return r!==E.NoError;}.bind(this));return r;};j.prototype._handleFilterItemSubmit=function(o){var p=o.getParameter("promise");if(p){p.then(function(){if(this._aCollectedChangePromises&&this._aCollectedChangePromises.length>0){var i=this._aCollectedChangePromises.slice();Promise.all(i).then(function(){this.triggerSearch();}.bind(this));}else{this.triggerSearch();}}.bind(this)).catch(function(i){L.error(i);});}};j.prototype._handleFilterItemChanges=function(o){if(this._bIgnoreChanges){return;}var i=o.oSource;if(i.getRequired()&&(i.getValueState()===V.Error)&&o.getParameter("valid")){i.setValueState(V.None);return;}if(!this._aFIChanges){this._aFIChanges=[];}this._aFIChanges.push({name:i.getFieldPath(),promise:o.getParameter("promise")});};j.prototype._checkFilters=function(){var r=this._checkAsyncValidation();if(r!==E.NoError){return r;}r=this._checkRequiredFields();if(r!==E.NoError){return r;}r=this._checkFieldsInErrorState();if(r!==E.NoError){return r;}return r;};j.prototype._setFocusOnFirstErroneousField=function(){var o=null;this.getFilterItems().some(function(i){if(i.getValueState()!==V.None){o=i;setTimeout(i["focus"].bind(i),0);}return o!=null;});return o;};j.prototype._handleAsyncValidation=function(i){if(this._aFIChanges&&(this._aFIChanges.length>0)){var n=this._aFIChanges.slice();this._aFIChanges=null;var o=[];n.forEach(function(N){o.push(N.promise);});Promise.all(o).then(function(p){p.forEach(function(q,r){var s=this._getFilterField(n[r].name);if(s&&s.getRequired()&&(s.getValueState()===V.Error)){s.setValueState(V.None);}},this);this._validate(i);}.bind(this),function(p){this._validate(i);}.bind(this));}};j.prototype._waitForChangeAppliance=function(i){var n=this._aCollectedChangePromises.slice();this._aCollectedChangePromises=null;Promise.all(n).then(function(o){this._validate(i);}.bind(this),function(o){this._validate(i);}.bind(this));};j.prototype._validate=function(i){var s,r;var n=function(){if(i){this.fireSearch();}}.bind(this);var o=function(){this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;}.bind(this);if(this.bIsDestroyed){o();return;}r=this._checkFilters();if(r===E.AsyncValidation){this._handleAsyncValidation(i);return;}if(this._aCollectedChangePromises&&(this._aCollectedChangePromises.length>0)){this._waitForChangeAppliance(i);return;}if(r===E.NoError){if(this._isChangeApplying()){this._oFlexPromise.then(function(){n();this._fResolvedSearchPromise();o();}.bind(this));}else{n();this._fResolvedSearchPromise();o();}}else{if(r===E.RequiredHasNoValue){s=this._oRb.getText("filterbar.REQUIRED_CONDITION_MISSING");}else{s=this._oRb.getText("filterbar.VALIDATION_ERROR");}if(this.getShowMessages()&&!this._isLiveMode()){try{h.error(s,{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":"",onClose:this._setFocusOnFirstErroneousField.bind(this)});}catch(x){L.error(x.message);}}else{L.warning("search was not triggered. "+s);}this._fRejectedSearchPromise();o();}};j.prototype.setInternalConditions=function(i){var o=this._getConditionModel();if(o){o.setConditions(i);}};j.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true);};j.prototype.hasProperty=function(n){return this._getPropertyByName(n);};j.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]);};j.prototype.initialized=function(){return this.waitForInitialization();};j.prototype._getModelConditions=function(o,i,K){var n={};if(o){var A=m({},o.getAllConditions());for(var s in A){if(A[s]&&(K||A[s].length>0)){n[s]=A[s];if(!i){this._cleanupConditions(n[s]);var p=this._stringifyConditions(s,n[s]);n[s]=p;}}}}return n;};var _=function(p){var t=p.typeConfig.typeInstance;var o=t.getConstraints();return t.getMetadata().getName()==="sap.ui.model.odata.type.String"&&o&&o.isDigitSequence&&o.maxLength?function(i){return this._toExternal(p,i,this.getTypeUtil());}.bind(this):undefined;};j.prototype._isPathKnown=function(s,x){var K,n;if(!this._getPropertyByName(s)){return false;}for(K in x["inParameters"]){n=K.startsWith("conditions/")?K.slice(11):K;if(!this._getPropertyByName(n)){return false;}}for(K in x["outParameters"]){n=K.startsWith("conditions/")?K.slice(11):K;if(!this._getPropertyByName(n)){return false;}}return true;};j.prototype._removeCondition=function(s,x,o){var p=this._getPropertyByName(s);if(p){var i=this._toInternal(p,x);if(o.indexOf(s,i,_.call(this,p))>=0){o.removeCondition(s,i);}}};j.prototype.removeCondition=function(s,x){return this.initialized().then(function(){var o=this._getConditionModel();if(o){if(!this._hasPropertyHelper()&&!this._isPathKnown(s,x)){return this._retrieveMetadata().then(function(){this._removeCondition(s,x,o);}.bind(this));}else{this._removeCondition(s,x,o);}}}.bind(this));};j.prototype._addCondition=function(s,x,o){var p=this._getPropertyByName(s);if(p){var i=this._toInternal(p,x);if(o.indexOf(s,i,_.call(this,p))<0){var n={};n[s]=[i];F.checkConditionOperatorSanity(n);var q=n[s];if(q&&q.length>0){this._cleanUpFilterFieldInErrorStateByName(s);o.addCondition(s,i);}}}};j.prototype.addCondition=function(s,x){return this.initialized().then(function(){var o=this._getConditionModel();if(o){if(!this._hasPropertyHelper()&&!this._isPathKnown(s,x)){return this._retrieveMetadata().then(function(){this._addCondition(s,x,o);}.bind(this));}else{this._addCondition(s,x,o);}}}.bind(this));};j.prototype._setXConditions=function(i,r){var s,p,n,o=this._getConditionModel();var q=null;var t=new Promise(function(v,w){q=v;});var A=function(i){for(s in i){n=i[s];p=this._getPropertyByName(s);if(p){if(n.length===0){o.removeAllConditions(s);}else{if(p.maxConditions!==-1){o.removeAllConditions(s);}n.forEach(function(v){this._addCondition(s,v,o);}.bind(this));}}}q();}.bind(this);if(r){o.removeAllConditions();}if(i){var u=true;for(s in i){n=i[s];if(!this._isPathKnown(s,n)){u=false;break;}}if(!u&&!this._hasPropertyHelper()){this._retrieveMetadata().then(function(){A(i);});}else{A(i);}}return t;};j.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false);};j.prototype._getRequiredPropertyNames=function(){var r=[];this._getNonHiddenPropertyInfoSet().forEach(function(p){if(p.required){r.push(I.getPropertyKey(p));}});return r;};j.prototype._getNonRequiredPropertyNames=function(){var n=[];this._getNonHiddenPropertyInfoSet().forEach(function(p){if(!p.required){n.push(I.getPropertyKey(p));}});return n;};j.prototype._insertFilterFieldtoContent=function(o,n){if(!this._cLayoutItem){return;}var i=this._cLayoutItem;var p=new i();p.setFilterField(o);this._oFilterBarLayout.insertFilterField(p,n);};j.prototype._filterItemInserted=function(o){if(!o.getVisible()){return;}if(o.setWidth){o.setWidth("");}this._applyFilterItemInserted(o);this._handleAssignedFilterNames(true);};j.prototype._applyFilterItemInserted=function(o){var n,p;p=this.indexOfAggregation("filterItems",o);if(this.getAggregation("basicSearchField")){p++;}n=p;var q=this.getFilterItems();for(var i=0;i<n;i++){if(!q[i].getVisible()){p--;}}this._insertFilterFieldtoContent(o,p);if(!this._oObserver.isObserved(o,{properties:["visible"]})){this._oObserver.observe(o,{properties:["visible"]});}};j.prototype._filterItemRemoved=function(o){this._applyFilterItemRemoved(o.getFieldPath());this._handleAssignedFilterNames(true);};j.prototype._applyFilterItemRemoved=function(s){this._removeFilterFieldFromContentByName(s);};j.prototype._removeFilterFieldFromContent=function(o){this._removeFilterFieldFromContentByName(o.getFieldPath());};j.prototype._removeFilterFieldFromContentByName=function(s){var o=this._getFilterItemLayoutByName(s);if(o){this._oFilterBarLayout.removeFilterField(o);o.destroy();}};j.prototype._observeChanges=function(o){if(o.type==="aggregation"){if(o.name==="filterItems"){switch(o.mutation){case"insert":o.child.attachChange(this._handleFilterItemChanges,this);o.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(o.child);break;case"remove":o.child.detachChange(this._handleFilterItemChanges,this);o.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(o.child);break;default:L.error("operation "+o.mutation+" not yet implemented");}}else if(o.name==="basicSearchField"){switch(o.mutation){case"insert":o.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(o.child,0);break;case"remove":o.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(o.child);break;default:L.error("operation "+o.mutation+" not yet implemented");}}}else if(o.type==="property"){var i;if(o.object.isA&&o.object.isA("sap.ui.mdc.FilterField")){i=o.object;if(i){if(o.current){this._filterItemInserted(i);}else{this._filterItemRemoved(i);}this._oFilterBarLayout.rerender();}}}};j.prototype._getFilterItemLayout=function(o){return this._getFilterItemLayoutByName(o.getFieldPath());};j.prototype._getFilterItemLayoutByName=function(s){var o=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(i){if(i._getFieldPath()===s){o=i;}return o!==null;});}return o;};j.prototype._getFilterField=function(n){var o=null;this.getFilterItems().some(function(i){if(i&&i.getFieldPath&&(i.getFieldPath()===n)){o=i;}return o!==null;});return o;};j.prototype._retrieveMetadata=function(){if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise;}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(r){this._fResolveMetadataApplied=r;}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){var r=function(){this._fResolveMetadataApplied();this._fResolveMetadataApplied=null;}.bind(this);if(this.bDelegateInitialized&&this.getControlDelegate().fetchProperties){this.initPropertyHelper(P).then(function(p){r();});}else{L.error("Provided delegate '"+this.getDelegate().path+"' not valid.");r();}}}.bind(this));return this._oMetadataAppliedPromise;};j.prototype.setBasicSearchField=function(o){var O=this.getAggregation("basicSearchField");if(O){this.removeAggregation("basicSearchField",O);}this.setAggregation("basicSearchField",o);if(o){if(!this._oObserver.isObserved(o,{properties:["visible"]})){this._oObserver.observe(o,{properties:["visible"]});}}return this;};j.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(p){if(!p.hiddenFilter){if(I.getPropertyKey(p)!=="$search"){v.push(p);}}return true;});return v;};j.prototype._getNonHiddenPropertyByName=function(n){var p=null;this._getNonHiddenPropertyInfoSet().some(function(o){if(I.getPropertyKey(o)===n){p=o;}return p!=null;});return p;};j.prototype._cleanUpFilterFieldInErrorStateByName=function(s){var o=null;var i=this.getFilterItems();i.some(function(n){if(n.getFieldPath()===s){o=n;}return o!=null;});if(o){this._cleanUpFilterFieldInErrorState(o);}};j.prototype._cleanUpAllFilterFieldsInErrorState=function(){var i=this.getFilterItems();i.forEach(function(o){this._cleanUpFilterFieldInErrorState(o);}.bind(this));};j.prototype._cleanUpFilterFieldInErrorState=function(o){if(o&&(o.getValueState()!==V.None)){o.setValueState(V.None);}};j.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;this._oFlexPromise=this._getWaitForChangesPromise();Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]).then(function(A){this._oFlexPromise=null;this._changesApplied();}.bind(this));};j.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this);};j.prototype._suspendBinding=function(o){if(o){var i=o.getBinding("conditions");if(i){if(!this._aBindings){this._aBindings=[];}i.suspend();this._aBindings.push(o);}}};j.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(o){if(!o.bIsDestroyed){var i=o.getBinding("conditions");if(i){i.resume();}}});this._aBindings=null;}};j.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};j.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges().then(function(){this._changesApplied();this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null;}.bind(this));};j.prototype._applyFilterConditionsChanges=function(){var s,i;s=this.getProperty("filterConditions");if(Object.keys(s).length>0){i=m({},s);return this._setXConditions(i,true);}return Promise.resolve();};j.prototype.setVariantBackreference=function(v){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",v);g.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true});}else{L.error("the association 'variant' may only be assigned once and may not change afterwards.");}};j.prototype._handleVariantSwitch=function(v){this._cleanUpAllFilterFieldsInErrorState();this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(v);this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;if(v.hasOwnProperty("createScenario")&&(v.createScenario==="saveAs")){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true;}if(!this._isChangeApplying()&&this._bInitialFiltersApplied){this._changesApplied();}};j.prototype._getExecuteOnSelectionOnVariant=function(v){var i=false,o=this._getAssignedVariantManagement();if(o){i=o.getApplyAutomaticallyOnVariant(v);}return i;};j.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false;};j.prototype._getAssignedVariantManagement=function(){var v=this.getVariantBackreference();if(v){var o=sap.ui.getCore().byId(v);if(o&&o.isA("sap.ui.fl.variants.VariantManagement")){return o;}}return null;};j.prototype._changesApplied=function(){if(!this._isChangeApplying()){this._bIgnoreChanges=false;}this._reportModelChange(this._bExecuteOnSelect,this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch);this._bExecuteOnSelect=undefined;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;};j.prototype._getView=function(){return I.getView(this);};j.prototype.getConditions=function(){var i=this._bPersistValues?this.getCurrentState().filter:this._getXConditions();if(i&&i["$search"]){delete i["$search"];}return i;};j.prototype.getSearch=function(){var s=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return s[0]?s[0].values[0]:"";};j.prototype.exit=function(){if(this._hasAssignedVariantManagement()){g.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});}if(this.bDelegateInitialized&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this);}C.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._bPersistValues=null;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aCollectedChangePromises=null;};return j;});
