/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Item","sap/ui/core/Control","sap/ui/layout/HorizontalLayout","sap/m/SearchField","sap/m/Page","sap/m/Toolbar","sap/m/ToggleButton","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/ui/events/KeyCodes","sap/m/library",'sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver'],function(F,a,D,I,b,C,H,S,P,T,c,d,R,e,K,m,M,f){"use strict";var B=m.ButtonType;var g=m.PlacementType;var h=C.extend("sap.ui.mdc.filterbar.vh.CollectiveSearchSelect",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Misc",defaultValue:null},selectedItemKey:{type:"string",group:"Misc",defaultValue:null},_currentItemText:{type:"string",group:"Misc",defaultValue:null,hidden:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},events:{select:{parameters:{key:{type:"string"}}}}},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o).class("sapUiMdcCollectiveSearchSelect").attr("title",o.oRb.getText("COL_SEARCH_TRIGGER_TT")).openEnd();r.renderControl(o.oLayout);r.close("div");}}});h.prototype.init=function(){this._oManagedObjectModel=new M(this);this.setModel(this._oManagedObjectModel,"$mdcColSearch");this._oObserver=new f(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["selectedItemKey"],aggregations:["items"]});this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.oInvisibleText=new I();this.oText=new d(this.getId()+"-text",{text:"{$mdcColSearch>/_currentItemText}"}).addStyleClass("sapUiMdcCollectiveSearchSelectClickable").addStyleClass("sapUiMdcCollectiveSearchSelectTitle");if(D.system.phone){this.oText.addStyleClass("sapUiMdcCollectiveSearchSelectTextPhoneMaxWidth");}else{this.oText.addStyleClass("sapUiMdcCollectiveSearchSelectTextMaxWidth");}this.oPopoverTrigger=new c(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:B.Transparent,tooltip:this.oRb.getText("COL_SEARCH_TRIGGER_TT")}).addAriaLabelledBy(this.oInvisibleText).addStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtn").addStyleClass("sapMTitleStyleH4");this.oLayout=new H({content:[this.oText,this.oPopoverTrigger]}).addStyleClass("sapUiMdcCollectiveSearchSelectLayout");this.oInvisibleText.toStatic();this.addDependent(this.oLayout);};h.prototype._observeChanges=function(o){if(["selectedItemKey","items"].indexOf(o.name)>=-1){this._updateCurrentItemText();}};h.prototype._updateCurrentItemText=function(){var k=this.getSelectedItemKey();var i=this._getItemByKey(k);var t=i?i.getText():k;this.oInvisibleText.setText(this.oRb.getText("COL_SEARCH_SEL_INVISIBLETXT",[t]));this.setProperty("_currentItemText",t);};h.prototype._getItemByKey=function(k){var i=null;var j=this.getItems();j.some(function(E){if(E.getKey()===k){i=E;}return(i!==null);});return i;};h.prototype.handleOpenClosePopover=function(){if(!this.bPopoverOpen){this._openList();}else if(this.oPopover&&this.oPopover.isOpen()){this.oPopover.close();}};h.prototype.getFocusDomRef=function(){if(this.oPopoverTrigger){return this.oPopoverTrigger.getFocusDomRef();}};h.prototype.onclick=function(){if(this.oPopoverTrigger&&!this.bPopoverOpen){this.oPopoverTrigger.focus();}this.handleOpenClosePopover();};h.prototype.onkeyup=function(E){if(E.which===K.F4||E.which===K.SPACE||E.altKey===true&&E.which===K.ARROW_UP||E.altKey===true&&E.which===K.ARROW_DOWN){this._openList();}};h.prototype.onAfterRendering=function(){this.oText.$().off("mouseover").on("mouseover",function(){this.oPopoverTrigger.addStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtnHover");}.bind(this));this.oText.$().off("mouseout").on("mouseout",function(){this.oPopoverTrigger.removeStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtnHover");}.bind(this));};h.prototype._createList=function(){if(this.oPopover){return;}this.oList=new e(this.getId()+"-list",{selectedKey:{path:"$mdcColSearch>/selectedItemKey"},itemPress:function(E){var s=null;if(E&&E.getParameter("item")){var i=E.getParameter("item");if(i){s=i.getKey();}}this.oPopover.close();if(this.getSelectedItemKey()!==s){this.setSelectedItemKey(s);this.fireSelect({key:s});}}.bind(this)});this.oList.bindAggregation("items",{path:"/items",model:"$mdcColSearch",template:new b({key:"{$mdcColSearch>key}",text:"{$mdcColSearch>text}"})});this.oSearchField=new S(this.getId()+"-search");this.oSearchField.attachLiveChange(function(E){var v=E.getParameter("newValue")||"";this._triggerSearch(v,this.oList);}.bind(this));this.oPage=new P(this.getId()+"-selpage",{subHeader:new T({content:[this.oSearchField]}),content:[this.oList],showNavButton:false,showHeader:false});this.oPopover=new R(this.getId()+"-popover",{title:{path:"$mdcColSearch>/title"},titleAlignment:"Auto",contentWidth:"400px",placement:g.VerticalPreferredBottom,content:[this.oPage],afterOpen:function(){this.bPopoverOpen=true;this.oPopoverTrigger.setPressed(true);}.bind(this),afterClose:function(){this.oPopoverTrigger.setPressed(false);if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oPopover.addStyleClass("sapUiMdcCollectiveSearchSelectPopover");if(this.oLayout.$().closest(".sapUiSizeCompact").length>0){this.oPopover.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oPopover);};h.prototype._openList=function(){if(this.bPopoverOpen){return;}this._createList();this.oSearchField.setValue("");this._triggerSearch("",this.oList);this.oPage.setShowSubHeader(this.oList.getItems().length>9);this.oPopover.openBy(this.oPopoverTrigger);};h.prototype._triggerSearch=function(v,l){var i=[];if(v){var o=new F({path:"text",operator:a.Contains,value1:v});i.push(o);}l.getBinding("items").filter(i);};h.prototype.exit=function(){if(this.oInvisibleText){this.oInvisibleText.destroy(true);this.oInvisibleText=undefined;}this.oRb=undefined;this.oList=undefined;this.oPage=undefined;this.oLayout=undefined;this.oText=undefined;this.oPopoverTrigger=undefined;this.oSearchField=undefined;this._oManagedObjectModel.destroy();this._oManagedObjectModel=undefined;this._oObserver.disconnect();this._oObserver=undefined;};return h;});
