/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/base/util/isEmptyObject'],function(B,c){"use strict";var L=B.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset();}});L.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this;};L.prototype.isEmpty=function(){return!(!c(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length);};L.prototype.initialize=function(s){this.reset();s.forEach(function(S){this.createSemanticObjectStructure(S);}.bind(this));};L.prototype.addContextObject=function(s,C){for(var a in C){var A=this.createAttributeStructure();this.addSemanticObjectAttribute(s,a,A);A.transformations.push({value:C[a],description:"\u2139 The attribute "+a+" with the value "+C[a]+" is initially taken from the binding context."});}};L.prototype.createSemanticObjectStructure=function(s){this._oLog.semanticObjects[s]={attributes:{},intents:[]};};L.prototype.createAttributeStructure=function(){return{transformations:[]};};L.prototype.addSemanticObjectIntent=function(s,i){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].intents.push(i);return this;};L.prototype.addSemanticObjectAttribute=function(s,a,A){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].attributes[a]=A;return this;};L.prototype.getSemanticObjectAttribute=function(s,a){return(this._oLog.semanticObjects[s]&&this._oLog.semanticObjects[s].attributes[a])?this._oLog.semanticObjects[s].attributes[a]:undefined;};L.prototype.addIntent=function(t,i){switch(t){case L.IntentType.API:this._oLog.intents.api.push(i);break;case L.IntentType.BREAKOUT:this._oLog.intents.breakout.push(i);break;default:throw"Intent type "+t+" is not supported yet.";}return this;};L.prototype.getFormattedText=function(){var g=function(v){return(typeof v==="string")?"'"+v+"'":v;};var r=function(a,A){var o={value:"\u2022\u0020"+A+" : ",description:""};a.forEach(function(b,I){o.value=o.value+(I>0?"\u0020 \u279c \u0020":"")+g(b["value"]);o.description=o.description+"\u2026 \u0020 "+b["description"]+"\n";if(b["reason"]){o.description=o.description+"\u2026 \u0020 "+b["reason"]+"\n";}});return o;};var R=function(I){var a="";I.forEach(function(o){a+="\u2022\u0020'"+o.text+"' : "+o.intent+"\n";});return a;};var s=function(e){try{var l=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){var C=window.Intl.Collator(l,{numeric:true});e.sort(function(a,b){return C.compare(a,b);});}else{e.sort(function(a,b){return a.localeCompare(b,l,{numeric:true});});}}catch(E){}};var t="";for(var S in this._oLog.semanticObjects){t=t+"\n\u2b24"+" "+S+"\n";if(c(this._oLog.semanticObjects[S].attributes)){t+="\u2026\u2026 \u0020\ud83d\udd34 No semantic attributes available for semantic object "+S+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n";}else{var d=Object.keys(this._oLog.semanticObjects[S].attributes);s(d);for(var i=0;i<d.length;i++){var A=d[i];var T=r(this._oLog.semanticObjects[S].attributes[A].transformations,A);t+=T.value+"\n";t+=T.description;}}if(this._oLog.semanticObjects[S].intents.length){t+="\nIntents returned by FLP for semantic object "+S+":\n";t+=R(this._oLog.semanticObjects[S].intents);}}if(this._oLog.intents.api.length){t+="\nIntents defined in items aggregation:\n";t+=R(this._oLog.intents.api);}if(this._oLog.intents.breakout.length){t+="\nIntents returned by modifyItemsCallback callback:\n";t+=R(this._oLog.intents.breakout);}return t;};L.prototype._getLogFormattedText=function(){return(!this.isEmpty())?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available";};L.IntentType={BREAKOUT:"Breakout",API:"Api"};return L;});
