/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/XMLComposite','sap/base/Log','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/base/ManagedObjectObserver',"sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/ui/mdc/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem"],function(X,L,J,B,M,a,E,A,P){"use strict";var b=X.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/link/Panel.designtime",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--idSectionAdditionalContent",aggregation:"items"}}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}}});b.prototype.init=function(){X.prototype.init.call(this);E.getInstance().registerAdaptation(this,{controller:{LinkItems:a}});A.call(b.prototype);E.getInstance().defaultProviderRegistry.attach(this,"Global");sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(c){this._oMetadataHelper=c;}.bind(this));var m=new J({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,showResetEnabled:false,runtimeItems:[],contentTitle:""});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapuimdclinkPanel");this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]});};b.prototype.applySettings=function(){X.prototype.applySettings.apply(this,arguments);var m=this._getInternalModel();m.setProperty("/countAdditionalContent",this.getAdditionalContent().length);};b.prototype.exit=function(c){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}if(this._oMetadataHelper){this._oMetadataHelper=null;}};b.prototype.onPressLink=function(e){if(this.getBeforeNavigationCallback()&&e.getParameter("target")!=="_blank"){var h=e.getParameter("href");e.preventDefault();this.getBeforeNavigationCallback()(e).then(function(n){if(n){this.navigate(h);}}.bind(this));}};b.prototype.navigate=function(h){if(h.indexOf("#")===0&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getServiceAsync){var t=this;if(!t.oNavigationPromise){t.oNavigationPromise=sap.ushell.Container.getServiceAsync("CrossApplicationNavigation").then(function(c){c.toExternal({target:{shellHash:h.substring(1)}});t.oNavigationPromise=undefined;});}}else{window.location.href=h;}};b.prototype.onPressLinkPersonalization=function(){sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(c){var m=this._getInternalModel();var d=c.retrieveBaseline(this);var e=d;var u=function(s){var S=s._oListControl.getItems().filter(function(i){return i.getSelected();});S=S.map(function(o){var i=s._getP13nModel().getProperty(o.getBindingContext(s.P13N_MODEL).sPath);return{id:i.name,description:i.description,href:i.href,target:i.target,text:i.text,visible:i.visible};});var f=b._showResetButtonEnabled(e,S);this._getInternalModel().setProperty("/showResetEnabled",f);};var p=this.getParent();p.setModal(true);E.getInstance().uimanager.show(this,"LinkItems").then(function(D){var r=D.getCustomHeader().getContentRight()[0];var s=D.getContent()[0];r.setModel(m,"$sapuimdclinkPanel");r.bindProperty("enabled",{path:'$sapuimdclinkPanel>/showResetEnabled'});u.call(this,s);s.attachChange(function(o){u.call(this,s);}.bind(this));D.attachAfterClose(function(){p.setModal(false);});}.bind(this));}.bind(this));};b._showResetButtonEnabled=function(m,s){var S=false;var c=b._getVisibleItems(s);var d=b._getVisibleItems(m);if(s.length!==m.length){S=true;}else if(d.length&&c.length){var e=b._allItemsIncludedInArray(d,c);var f=b._allItemsIncludedInArray(c,d);S=!e||!f;}return S;};b._allItemsIncludedInArray=function(m,c){var d=true;m.forEach(function(i){var e=b._getItemsById(i.id,c);if(e.length===0){d=false;}});return d;};b._getItemsById=function(i,m){return m.filter(function(I){return I.id===i;});};b._getItemById=function(i,c){return b._getItemsById(i,c)[0];};b._getVisibleItems=function(m){return m.filter(function(i){return i.id!==undefined&&i.visible;});};b.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel");};b.prototype._propagateDefaultIcon=function(s){if(!s){return;}var m=this._getInternalModel();m.getProperty("/runtimeItems").forEach(function(o,i){if(o.icon){return;}m.setProperty("/runtimeItems/"+i+"/icon","sap-icon://chain-link");});};function _(c){var m=this._getInternalModel();if(c.object.isA("sap.ui.mdc.link.Panel")){switch(c.name){case"additionalContent":var d=c.child?[c.child]:c.children;m.setProperty("/countAdditionalContent",d.length);break;case"items":var i=c.child?[c.child]:c.children;i.forEach(function(p){var r=m.getProperty("/runtimeItems/");switch(c.mutation){case"insert":m.setProperty("/countItemsWithIcon",p.getIcon()?m.getProperty("/countItemsWithIcon")+1:m.getProperty("/countItemsWithIcon"));m.setProperty("/countItemsWithoutIcon",p.getIcon()?m.getProperty("/countItemsWithoutIcon"):m.getProperty("/countItemsWithoutIcon")+1);r.splice(this.indexOfItem(p),0,p.getJson());m.setProperty("/runtimeItems",r);this._propagateDefaultIcon(m.getProperty("/countItemsWithIcon")>0&&m.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(p,{properties:["visible"]});break;case"remove":m.setProperty("/countItemsWithIcon",p.getIcon()?m.getProperty("/countItemsWithIcon")-1:m.getProperty("/countItemsWithIcon"));m.setProperty("/countItemsWithoutIcon",p.getIcon()?m.getProperty("/countItemsWithoutIcon"):m.getProperty("/countItemsWithoutIcon")-1);var R=r.find(function(o){return o.id===p.getId();});r.splice(r.indexOf(R),1);m.setProperty("/runtimeItems",r);this._propagateDefaultIcon(m.getProperty("/countItemsWithIcon")>0&&m.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(p);p.destroy();this.invalidate();break;default:L.error("Mutation '"+c.mutation+"' is not supported yet.");}},this);break;case"enablePersonalization":this.byId("idSectionPersonalizationButton").setVisible(c.current);break;default:L.error("The property or aggregation '"+c.name+"' has not been registered.");}}else if(c.object.isA("sap.ui.mdc.link.PanelItem")){switch(c.name){case"visible":var p=c.object;var I=this.indexOfItem(p);if(p.getVisibleChangedByUser()){m.setProperty("/runtimeItems/"+I+"/visible",p.getVisible());}else{m.setProperty("/baselineItems/"+I+"/visible",p.getVisible());m.setProperty("/runtimeItems/"+I+"/visible",p.getVisible());}break;default:L.error("The '"+c.name+"' of PanelItem is not supported yet.");}}this._updateContentTitle();}b.prototype.getContentTitle=function(){var m=this._getInternalModel();return m.getProperty("/contentTitle");};b.prototype.getCurrentState=function(){var i=[],I;this.getItems().forEach(function(o,c){I=o&&o.getId();if(o.getVisible()){i.push({name:I});}});return{items:i};};b.prototype.initPropertyHelper=function(){var c=this._oMetadataHelper.retrieveAllMetadata(this);return Promise.resolve({getProperties:function(){var i=[];c.forEach(function(I){i.push({name:I.id,getName:function(){return I.id;},getLabel:function(){return I.text;},text:I.text,href:I.href,description:I.description,target:I.target,visible:I.visible});});return i;}});};b.prototype._updateContentTitle=function(){var m=this._getInternalModel();var c=this.getAdditionalContent();var C="idSectionPersonalizationButton";if(c.length>0){C=c[0];}else{var i=this.getItems();if(i.length>0){C=i[0];}}m.setProperty("/contentTitle",C);};return b;});
