/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../ChartDelegate","../../../util/loadModules","sap/ui/core/Core","sap/m/library","sap/m/Text","sap/ui/mdc/library","sap/ui/mdc/odata/v4/ODataMetaModelUtil","sap/base/Log",'sap/ui/mdc/util/FilterUtil','sap/ui/mdc/odata/v4/util/DelegateUtil',"sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/m/VBox","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/MessageStrip"],function(V,l,C,m,T,M,O,L,F,D,c,d,S,f,g,R,h,n){"use strict";var o=Object.assign({},V);var p=m.FlexJustifyContent;var q=m.FlexAlignItems;var s=new window.WeakMap();var r;var t;var u;var v;o._getState=function(a){if(s.has(a)){return s.get(a);}L.info("Couldn't get state for "+a.getId());};o._setState=function(a,b){s.set(a,b);};o._deleteState=function(a){if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}if(this._getState(a).observer){this._getState(a).observer.disconnect();this._getState(a).observer=null;}return s.delete(a);};o._getChart=function(a){if(s.has(a)){return s.get(a).innerChart;}L.info("Couldn't get state for "+a.getId());return undefined;};o._setChart=function(a,i){if(s.has(a)){s.get(a).innerChart=i;}else{s.set(a,{innerChart:i});}};o._getInnerStructure=function(a){if(s.has(a)){return s.get(a).innerStructure;}L.info("Couldn't get state for "+a.getId());return undefined;};o._setInnerStructure=function(a,i){if(s.has(a)){s.get(a).innerStructure=i;}else{s.set(a,{innerStructure:i});}};o._getBindingInfoFromState=function(a){if(s.has(a)){return s.get(a).bindingInfo;}L.info("Couldn't get state for "+a.getId());return undefined;};o._setBindingInfoForState=function(a,b){if(s.has(a)){s.get(a).bindingInfo=b;}else{s.set(a,{bindingInfo:b});}};o._setUpChartObserver=function(a){var b=this._getState(a);if(!b.observer){b.observer=new g(function(e){if(e.type==="destroy"){this.exit(e.object);}}.bind(this));}b.observer.observe(a,{destroy:true});};o.getFilterDelegate=function(){return{addItem:function(P,a){return Promise.resolve(null);}};};o.exit=function(a){if(this._getInnerStructure(a)){this._getInnerStructure(a).destroy();}this._deleteState(a);};o.zoomIn=function(a,i){this._getChart(a).zoom({direction:"in"});};o.zoomOut=function(a,i){this._getChart(a).zoom({direction:"out"});};o.getZoomState=function(a){if(this._getChart(a)){return this._getChart(a).getZoomInfo(this);}};o.getInnerChartSelectionHandler=function(a){return{eventId:"_selectionDetails",listener:this._getChart(a)};};o.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout;}var a=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var A=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var b=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.category2];var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:a},{key:"bar",allowedLayoutOptions:a},{key:"line",allowedLayoutOptions:a},{key:"combination",allowedLayoutOptions:a},{key:"pie",allowedLayoutOptions:a},{key:"donut",allowedLayoutOptions:a},{key:"dual_column",allowedLayoutOptions:A},{key:"dual_bar",allowedLayoutOptions:A},{key:"dual_line",allowedLayoutOptions:A},{key:"stacked_bar",allowedLayoutOptions:a},{key:"scatter",allowedLayoutOptions:A},{key:"bubble",allowedLayoutOptions:e},{key:"heatmap",allowedLayoutOptions:b},{key:"bullet",allowedLayoutOptions:a},{key:"vertical_bullet",allowedLayoutOptions:a},{key:"dual_stacked_bar",allowedLayoutOptions:A},{key:"100_stacked_bar",allowedLayoutOptions:a},{key:"stacked_column",allowedLayoutOptions:a},{key:"dual_stacked_column",allowedLayoutOptions:A},{key:"100_stacked_column",allowedLayoutOptions:a},{key:"dual_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_stacked_combination",allowedLayoutOptions:A},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:A},{key:"stacked_combination",allowedLayoutOptions:a},{key:"100_dual_stacked_bar",allowedLayoutOptions:a},{key:"100_dual_stacked_column",allowedLayoutOptions:a},{key:"horizontal_stacked_combination",allowedLayoutOptions:a},{key:"waterfall",allowedLayoutOptions:b},{key:"horizontal_waterfall",allowedLayoutOptions:b}];return this._aChartTypeLayout;};o.getAdaptionUI=function(a){var b=this.getChartTypeLayoutConfig().find(function(k){return k.key===a.getChartType();});if(!b){var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.category2,M.ChartItemRoleType.series];b={key:a.getChartType(),allowedLayoutOptions:e};}var i=[{kind:"Groupable"},{kind:"Aggregatable"}];b.templateConfig=i;var A={panelConfig:b};var P=new h(A);if(a.getChartType()==="heatmap"){var j=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");P.setMessageStrip(new n({text:j.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}));}return Promise.resolve(P);};o.setLegendVisible=function(a,b){if(this._getChart(a)){this._getChart(a).setVizProperties({'legend':{'visible':b},'sizeLegend':{'visible':b}});}else{L.error("Could not set legend visibility since inner chart is not yet initialized!");}};o.getSorterForItem=function(a,b){if(a.getType()==="aggregatable"){return new S(this._getAggregatedMeasureNameForMDCItem(a),b.descending);}else if(a.getType()==="groupable"){return new S(this.getInternalChartNameFromPropertyNameAndKind(b.name,"groupable",a.getParent()),b.descending);}};o.insertItemToInnerChart=function(a,b,i){if(b.getType()==="groupable"){var I=this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a);var e=this._getChart(a).getDimensionByName(I);if(!e){this.createInnerDimension(a,b);}else{e.setLabel(b.getLabel());e.setRole(b.getRole()?b.getRole():"category");}var j=this._getChart(a).getVisibleDimensions();j.splice(i,0,I);this._getChart(a).setVisibleDimensions(j);}else if(b.getType()==="aggregatable"){this.createInnerMeasure(a,b);var k=this._getChart(a).getVisibleMeasures();k.splice(i,0,this._getAggregatedMeasureNameForMDCItem(b));this._getChart(a).setVisibleMeasures(k);}this._prepareColoringForItem(b).then(function(){this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());}.bind(this));this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};o.removeItemFromInnerChart=function(a,b){if(b.getType()==="groupable"&&this._getChart(a).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a))){var i=this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a);var N=this._getChart(a).getVisibleDimensions().filter(function(e){return e!==i;});if(this._getState(a).inResultDimensions.length>0){this._getChart(a).setInResultDimensions(this._getState(a).inResultDimensions);}this._getChart(a).setVisibleDimensions(N);}else if(b.getType()==="aggregatable"&&this._getChart(a).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(b))){var j=this._getChart(a).getVisibleMeasures().filter(function(e){return e!==this._getAggregatedMeasureNameForMDCItem(b);}.bind(this));this._getChart(a).setVisibleMeasures(j);this._getChart(a).removeMeasure(this._getChart(a).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(b)));}this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};o.addItem=function(P,a,b,e){if(a.getModel){return Promise.resolve(this._createMDCChartItem(P,a,e));}return Promise.resolve(null);};o.removeItem=function(P,a){return Promise.resolve(true);};o._createMDCChartItem=function(P,a,b){return this.fetchProperties(a).then(function(e){var i=e.find(function(j){return j.name===P;});if(!i){return null;}if(i.groupable){return new d(a.getId()+"--GroupableItem--"+i.name,{name:i.name,label:i.label,type:"groupable",role:b?b:"category"});}if(i.aggregatable){return new d(a.getId()+"--AggregatableItem--"+i.name,{name:i.name,label:i.label,type:"aggregatable",role:b?b:"axis1"});}});};o.initializeInnerChart=function(a){return new Promise(function(b,e){this._loadChart().then(function(i){var j=this._calculateInnerChartHeight(a);this._setInnerStructure(a,new f({justifyContent:"Center",alignItems:"Center",height:j,width:"100%"}));var k=new T();k.setText(a.getNoDataText());this._getInnerStructure(a).addItem(k);this._setUpChartObserver(a);b(this._getInnerStructure(a));}.bind(this));}.bind(this));};o.createInitialChartContent=function(a){};o._createContentFromItems=function(a){this.fetchProperties(a).then(function(P){var b=[];var e=[];var i=[];a.getItems().forEach(function(I,j){var k=P.find(function(x){return x.name===I.getName();});if(!k){L.error("sap.ui.mdc.Chart: Item "+I.getName()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return;}switch(I.getType()){case"groupable":e.push(this.getInternalChartNameFromPropertyNameAndKind(I.getName(),"groupable",a));this._addInnerDimension(a,I,k);break;case"aggregatable":i.push(this._getAggregatedMeasureNameForMDCItem(I));this._addInnerMeasure(a,I,k);break;default:L.error("MDC Chart Item "+I.getId()+" with label "+I.getLabel()+" has no known type. Supported typed are: \"groupable\" & \"aggregatable\"");}b.push(this._prepareColoringForItem(I));}.bind(this));this._getState(a).aColMeasures.forEach(function(k){if(this._getState(a).aInSettings.indexOf(k)==-1){var j=a.getPropertyHelper().getProperty(k);var x=j.aggregationMethod;var y=j.propertyPath;var N=this.getInternalChartNameFromPropertyNameAndKind(k,"aggregatable",a);var z={name:N,label:j.label,role:"axis1"};if(x&&y){z.analyticalInfo={propertyPath:y,"with":x};}var A=new u(z);i.push(A);this._getChart(a).addMeasure(A);}}.bind(this));Promise.all(b).then(function(){this._getChart(a).setVisibleDimensions(e);this._getChart(a).setVisibleMeasures(i);var I=a.getDelegate().inResultDimensions;if(I&&I instanceof Array&&I.length!=0){var j=[];I.forEach(function(k){j.push(this._getPropertyInfosByName(k,a).then(function(x){var N=this.getInternalChartNameFromPropertyNameAndKind(x.name,"groupable",a);var y=new t({name:N,label:x.label});this._getState(a).inResultDimensions.push(N);this._getChart(a).addDimension(y);}.bind(this)));}.bind(this));Promise.all(j).then(function(){this._getChart(a).setInResultDimensions(this._getState(a).inResultDimensions);}.bind(this));}this._updateColoring(a,e,i);this._updateSemanticalPattern(a,P);}.bind(this));}.bind(this));};o.getInnerChart=function(a){return this._getChart(a);};o._prepareColoringForItem=function(i){return this._addCriticality(i).then(function(){this._getState(i.getParent()).aInSettings.push(i.getName());if(i.getType==="aggregatable"){this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){for(var j=0;j<this._getAdditionalColoringMeasuresForItem(P);j++){if(this._getState(i.getParent()).aColMeasures.indexOf(this._getAdditionalColoringMeasuresForItem(P)[j])==-1){this._getState(i.getParent()).aColMeasures.push(this._getAdditionalColoringMeasuresForItem(P)[j]);}}}.bind(this));}}.bind(this));};o._getAdditionalColoringMeasuresForItem=function(P){var a=[];var b=P.datapoint?P.datapoint.criticality:null;if(b&&b.DynamicThresholds){a=b.DynamicThresholds.usedMeasures;}return a;};o._addCriticality=function(i){return this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){if(P.criticality||(P.datapoint&&P.datapoint.criticality)){var a=this._getState(i.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};var b={};if(i.getType()=="groupable"){var e=P.criticality?P.criticality:[];for(var k in e){b[k]={Values:e[k]};}var j=this.getInternalChartNameFromPropertyNameAndKind(i.getName(),"groupable",i.getParent());a.Criticality.DimensionValues[j]=b;}else{var e=P.datapoint&&P.datapoint.criticality?P.datapoint.criticality:[];for(var k in e){b[k]=e[k];}var x=this.getInternalChartNameFromPropertyNameAndKind(i.getName(),"aggregatable",i.getParent());a.Criticality.MeasureValues[x]=b;}var y=this._getState(i.getParent());y.oColorings=a;this._setState(i.getParent(),y);}}.bind(this));};o._updateColoring=function(a,b,e){var i=jQuery.extend(true,{},this._getState(a).oColorings),k;if(i&&i.Criticality){var A;for(k=0;k<b.length;k++){if(this._getState(a).oColorings.Criticality.DimensionValues[b[k]]){A={coloring:"Criticality",parameters:{dimension:b[k]}};delete i.Criticality.MeasureValues;break;}}if(!A){delete i.Criticality.DimensionValues;for(var j in i.Criticality.MeasureValues){if(e.indexOf(j)==-1){delete i.Criticality.MeasureValues[j];}}A={coloring:"Criticality",parameters:{measure:e}};}if(A){this._getChart(a).setColorings(i);this._getChart(a).setActiveColoring(A);}}};o._updateSemanticalPattern=function(a,P){var b=this._getChart(a).getVisibleMeasures();b.forEach(function(e){var i=this.getPropertyFromNameAndKind(e,"aggregatable",a);if(!i){return;}var j=i.datapoint;if(j){if(j.targetValue||j.foreCastValue){var A=this._getChart(a).getMeasureByName(e);A.setSemantics("actual");if(j.targetValue!=null){var k=this._getChart(a).getMeasureByName(j.targetValue);if(k){k.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+j.targetValue+" is not a valid measure");}}if(j.foreCastValue){var x=this._getChart(a).getMeasureByName(j.foreCastValue);if(x){x.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+j.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:j.targetValue,projectedValueMeasure:j.foreCastValue});}}}.bind(this));};o.getChartTypeInfo=function(a){if(!this._getChart(a)){throw'inner chart is not bound';}var b=a.getChartType(),e=C.getLibraryResourceBundle("sap.ui.mdc");var i={icon:c.mMatchingIcon[b],text:e.getText("chart.CHART_TYPE_TOOLTIP",[b])};return i;};o.getAvailableChartTypes=function(a){var b=[];if(this._getChart(a)){var A=this._getChart(a).getAvailableChartTypes().available;if(b){var e=C.getLibraryResourceBundle("sap.chart.messages");for(var i=0;i<A.length;i++){var j=A[i].chart;b.push({key:j,icon:c.mMatchingIcon[j],text:e.getText("info/"+j),selected:(j==a.getChartType())});}}}return b;};o.getDrillStackInfo=function(){};o.getDrillStack=function(a){var b=[];b=Object.assign(b,this._getChart(a).getDrillStack());b.forEach(function(e){e.dimension=e.dimension.map(function(i){var P=this.getPropertyFromNameAndKind(i,"groupable",a);if(P){return P.name;}else{L.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+i);return i;}}.bind(this));}.bind(this));return b;};o.getSortedDimensions=function(e){return new Promise(function(i,j){this.fetchProperties(e).then(function(P){var k=P.filter(function(I){return I.groupable;});if(k){k.sort(function(a,b){if(a.label&&b.label){return a.label.localeCompare(b.label);}});}i(k);});}.bind(this));};o.getDrillableItems=function(a){var b=a.getItems().filter(function(i){return i.getType()==="groupable";});return b;};o.setChartType=function(a,b){this._getChart(a).setChartType(b);};o.createInnerChartContent=function(a,b){this._setChart(a,new r({id:a.getId()+"--innerChart",chartType:"column",width:"100%",isAnalytical:true}));this._getState(a).inResultDimensions=[];if(a.getHeight()){this._getChart(a).setHeight(this._calculateInnerChartHeight(a));}R.register(a,function(){this.adjustChartHeight(a);}.bind(this));var e=this._getState(a);e.aColMeasures=[];e.aInSettings=[];this._setState(a,e);this._createContentFromItems(a);this._getChart(a).attachRenderComplete(function(){if(this._getState(a).toolbarUpdateRequested){a._updateToolbar();this._getState(a).toolbarUpdateRequested=false;}}.bind(this));this._getInnerStructure(a).removeAllItems();this._getInnerStructure(a).setJustifyContent(p.Start);this._getInnerStructure(a).setAlignItems(q.Stretch);this._getInnerStructure(a).addItem(this._getChart(a));e.dataLoadedCallback=b;this._setState(a,e);var B=this._getBindingInfo(a);this.updateBindingInfo(a,B);this.rebind(a,B);};o._calculateInnerChartHeight=function(a){var i=jQuery(a.getDomRef()).height();var b=0;var e=a.getAggregation("_toolbar");var B=0;var j=a.getAggregation("_breadcrumbs");if(e){b=jQuery(e.getDomRef()).outerHeight(true);}if(j){B=jQuery(j.getDomRef()).outerHeight(true);}var k=B+b;if(!i){return"480px";}return i-k+"px";};o.adjustChartHeight=function(a){if(a.getHeight()&&this._getChart(a)){var H=this._calculateInnerChartHeight(a);this._getInnerStructure(a).setHeight(H);this._getChart(a).setHeight(H);}};o.requestToolbarUpdate=function(a){this._getState(a).toolbarUpdateRequested=true;};o.createInnerDimension=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerDimension(a,b,e);}.bind(this));};o.createInnerMeasure=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerMeasure(a,b,e);}.bind(this));};o._addInnerDimension=function(a,b,P){var e=new t({name:this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a),role:b.getRole()?b.getRole():"category",label:b.getLabel()});if(P.textProperty){e.setTextProperty(P.textProperty);if(P.textFormatter){e.setTextFormatter(P.textFormatter);}e.setDisplayText(true);}this._getChart(a).addDimension(e);};o._addInnerMeasure=function(a,b,P){var e=P.aggregationMethod;var i=P.propertyPath;var j={name:this._getAggregatedMeasureNameForMDCItem(b),label:b.getLabel(),role:b.getRole()?b.getRole():"axis1"};if(e&&i){j.analyticalInfo={propertyPath:i,"with":e};}var k=new u(j);this._getChart(a).addMeasure(k);};o._getAggregatedMeasureNameForProperty=function(P){return P.aggregationMethod+P.name;};o.rebindChart=function(a,b){this.rebind(a,b);};o.rebind=function(a,b){if(a&&b&&this._getChart(a)){this._addBindingListener(b,"dataReceived",this._getState(a).dataLoadedCallback.bind(a));if(b.binding){b.binding.bHasAnalyticalInfo=true;}this._getChart(a).bindData(b);this._setBindingInfoForState(a,b);var e=this._getState(a);e.innerChartBound=true;}};o._getBindingInfo=function(a){if(this._getBindingInfoFromState(a)){return this._getBindingInfoFromState(a);}var b=a.getDelegate().payload;var e="/"+b.collectionName;var B={path:e};return B;};o.getInnerChartBound=function(a){var b=this._getState(a);if(!b){return false;}return b.innerChartBound?true:false;};o.updateBindingInfo=function(a,b){var e=C.byId(a.getFilter());if(e){var i=e.getConditions();if(i){if(!b){b={};}var P=e.getPropertyInfoSet?e.getPropertyInfoSet():null;var j=D.getParameterNames(e);var k=F.getFilterInfo(o.getTypeUtil(),i,P,j);if(k){b.filters=k.filters;}var x=D.getParametersInfo(e);if(x){b.path=x;}}var y=e.getSearch instanceof Function?e.getSearch():"";if(y){if(!b){b={};}if(!b.parameters){b.parameters={};}b.parameters.$search=y;}else if(b.parameters&&b.parameters.$search){delete b.parameters.$search;}}};o._getAggregatedMeasureNameForMDCItem=function(a){return this.getInternalChartNameFromPropertyNameAndKind(a.getName(),"aggregatable",a.getParent());};o.getInternalChartNameFromPropertyNameAndKind=function(N,k,a){return N;};o.getPropertyFromNameAndKind=function(N,k,a){return a.getPropertyHelper().getProperty(N);};o._getLayoutOptionsForType=function(a){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={groupable:[{key:M.ChartItemRoleType.category,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],aggregatable:[{key:M.ChartItemRoleType.axis1,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[a];};o.addInnerItem=function(P,a,b){return Promise.resolve(null);};o.insertInnerItem=function(P,a,b){};o.removeInnerItem=function(P,a,b){return Promise.resolve(true);};o.setChartTooltipVisibility=function(a,b){if(this._getChart(a)){if(b){if(!this._getState(a).vizTooltip){var e=this._getState(a);e.vizTooltip=new v();this._setState(a,e);}this._getState(a).vizTooltip.connect(this._getChart(a).getVizUid());}else if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}}else{L.error("Trying to set chart tooltip while inner chart was not yet initialized");}};o._loadChart=function(){return new Promise(function(a){var N=['sap/chart/library','sap/chart/Chart','sap/chart/data/Dimension','sap/chart/data/HierarchyDimension','sap/chart/data/TimeDimension','sap/chart/data/Measure','sap/viz/ui5/controls/VizTooltip'];function b(e,i,j,H,k,x,y){r=i;t=j;u=x;v=y;a();}sap.ui.require(N,b);});};o.initPropertyHelper=function(a){return Promise.all([this.fetchProperties(a),l("sap/ui/mdc/odata/v4/ChartPropertyHelper")]).then(function(b){return Promise.all(b.concat(this.fetchPropertyExtensions(a,b[0])));}.bind(this)).then(function(b){var P=b[0];var e=b[1][0];var E=b[2];var j=0;var k=[];for(var i=0;i<P.length;i++){k.push(Object.assign({},P[i],{extension:E[P[i].name]||{}}));if(P[i].name in E){j++;}}if(j!==Object.keys(E).length){throw new Error("At least one property extension does not point to an existing property");}return new e(k,a);});};o.fetchProperties=function(a){var b=this._getModel(a);var e;if(!b){e=new Promise(function(i){a.attachModelContextChange({resolver:i},w,this);}.bind(this)).then(function(b){return this._createPropertyInfos(a,b);}.bind(this));}else{e=this._createPropertyInfos(a,b);}return e.then(function(P){if(a.data){a.data("$mdcChartPropertyInfo",P);}return P;});};function w(e,a){var b=e.getSource();var i=this._getModel(b);if(i){b.detachModelContextChange(w);a.resolver(i);}}o._createPropertyInfos=function(a,b){var e=a.getDelegate().payload;var P=[];var E="/"+e.collectionName;var i=b.getMetaModel();return Promise.all([i.requestObject(E+"/"),i.requestObject(E+"@")]).then(function(j){var k=j[0],x=j[1];var y=x["@Org.OData.Capabilities.V1.SortRestrictions"]||{};var z=O.getSortRestrictionsInfo(y);var A=x["@Org.OData.Capabilities.V1.FilterRestrictions"];var B=O.getFilterRestrictionsInfo(A);for(var K in k){var G=k[K];if(G&&G.$kind==="Property"){if(G.$isCollection){continue;}var H=i.getObject(E+"/"+K+"@");if(!H["@Org.OData.Aggregation.V1.Aggregatable"]&&!H["@Org.OData.Aggregation.V1.Groupable"]){continue;}if(H["@Org.OData.Aggregation.V1.Aggregatable"]){P=P.concat(this._createPropertyInfosForAggregatable(K,H,B,z));}if(H["@Org.OData.Aggregation.V1.Groupable"]){P.push({name:K,propertyPath:K,label:H["@com.sap.vocabularies.Common.v1.Label"]||K,sortable:z[K]?z[K].sortable:true,filterable:B[K]?B[K].filterable:true,groupable:true,aggregatable:false,maxConditions:O.isMultiValueFilterExpression(B.propertyInfo[K])?-1:1,sortKey:K,kind:"Groupable",availableRoles:this._getLayoutOptionsForType("groupable"),role:M.ChartItemRoleType.category,criticality:null,textProperty:H["@com.sap.vocabularies.Common.v1.Text"]?H["@com.sap.vocabularies.Common.v1.Text"].$Path:null});}}}return P;}.bind(this));};o._createPropertyInfosForAggregatable=function(k,P,a,b){var e=[];if(P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"]){P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"].forEach(function(A){e.push({name:A+k,propertyPath:k,label:P["@com.sap.vocabularies.Common.v1.Label"]+" ("+A+")"||k+" ("+A+")",sortable:b[k]?b[k].sortable:true,filterable:a[k]?a[k].filterable:true,groupable:false,aggregatable:P["@Org.OData.Aggregation.V1.Aggregatable"],aggregationMethod:A,maxConditions:O.isMultiValueFilterExpression(a.propertyInfo[k])?-1:1,sortKey:P["@Org.OData.Aggregation.V1.RecommendedAggregationMethod"]+k,kind:"Aggregatable",availableRoles:this._getLayoutOptionsForType("aggregatable"),role:M.ChartItemRoleType.axis1,datapoint:null});}.bind(this));}return e;};o._getPropertyInfosByName=function(N,a){return new Promise(function(b){this.fetchProperties(a).then(function(P){var e=P.find(function(i){return i.name===N;});b(e);});}.bind(this));};o._getModel=function(a){var b=a.getDelegate().payload;return a.getModel(b.model);};o._addBindingListener=function(b,e,H){if(!b.events){b.events={};}if(!b.events[e]){b.events[e]=H;}else{var a=b.events[e];b.events[e]=function(){H.apply(this,arguments);a.apply(this,arguments);};}};return o;});
