/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/p13n/AdaptationProvider","sap/base/util/merge","sap/base/Log","sap/ui/mdc/util/PropertyHelper","sap/ui/mdc/p13n/modification/FlexModificationHandler","sap/m/MessageStrip","sap/ui/core/library","sap/ui/mdc/p13n/StateUtil","sap/ui/core/Element","sap/ui/mdc/p13n/modules/DefaultProviderRegistry","sap/ui/mdc/p13n/UIManager","sap/ui/mdc/p13n/modules/StateHandlerRegistry"],function(A,m,L,P,F,M,c,S,E,D,U,b){"use strict";var d="Engine: This class is a singleton. Please use the getInstance() method instead.";var e=c.MessageType;var _=new WeakMap();var o;var f=A.extend("sap.ui.mdc.p13n.Engine",{constructor:function(){A.call(this);if(o){throw Error(d);}this._aRegistry=[];this._aStateHandlers=[];this.defaultProviderRegistry=D.getInstance();this.uimanager=U.getInstance(this);this.stateHandlerRegistry=b.getInstance();}});f.prototype.registerAdaptation=function(C,a){if(!a.hasOwnProperty("controller")){throw new Error("Please provide atleast a configuration 'controller' containing a map of key-value pairs (key + Controller class) in order to register adaptation.");}if(this._getRegistryEntry(C)){this.deregisterAdaptation(C);}var g=Object.keys(a.controller);g.forEach(function(k){var h=a.controller[k];if(!this.getController(C,k)){if(this._aRegistry.indexOf(C.getId())<0){this._aRegistry.push(C.getId());}var i=new h(C);this.addController(i,k);}}.bind(this));};f.prototype.deregisterAdaptation=function(C){var r=this._getRegistryEntry(C);Object.keys(r.controller).forEach(function(k){var a=r.controller[k];a.destroy();delete r.controller[k];});_.delete(C);var i=this._aRegistry.indexOf(C.getId());this._aRegistry.splice(i,1);};f.prototype._setModificationHandler=function(C,a){if(!a.isA("sap.ui.mdc.p13n.modification.ModificationHandler")){throw new Error("Only sap.ui.mdc.p13n.modification.ModificationHandler derivations are allowed for modification");}var g=this._determineModification(C);g.handler=a;this._getRegistryEntry(C).modification=g;};f.prototype.createChanges=function(g){var C=g.control;var k=g.key;var n=g.state;var h=!!g.applyAbsolute;var s=!!g.suppressAppliance;if(!k||!C||!n){throw new Error("To create changes via Engine, atleast a 1)Control 2)Key and 3)State needs to be provided.");}return this.initAdaptation(C,k).then(function(){var i=this.getController(C,k);var j=i.getChangeOperations();var r=this._getRegistryEntry(C);var l=i.getCurrentState();var p=m(l instanceof Array?[]:{},l);var q={existingState:p,applyAbsolute:h,changedState:n,control:i.getAdaptationControl(),changeOperations:j,deltaAttributes:["name"],propertyInfo:r.helper.getProperties().map(function(a){return{name:a.name};})};var t=i.getDelta(q);if(!s){this._processChanges(C,t);}return t||[];}.bind(this));};f.prototype.reset=function(C,k){k=k instanceof Array?k:[k];var s=[];k.forEach(function(K){s=s.concat(this.getController(C,K).getSelectorForReset());}.bind(this));var r={selectors:s,selector:C};var a=this._determineModification(C);return a.handler.reset(r,a.payload).then(function(){this.stateHandlerRegistry.fireChange(C);return this.initAdaptation(C,k).then(function(p){k.forEach(function(K){var g=this.getController(C,K);g.update(p);}.bind(this));}.bind(this));}.bind(this));};f.prototype.waitForChanges=function(C){var a=this._determineModification(C);return a.handler.waitForChanges({element:C},a.payload);};f.prototype.isModificationSupported=function(C){var a=this._determineModification(C);return a.handler.isModificationSupported({element:C},a.payload);};f.prototype._processChanges=function(C,a){if(a instanceof Array&&a.length>0){var g=this._determineModification(C);return g.handler.processChanges(a,g.payload).then(function(a){this.stateHandlerRegistry.fireChange(f.getControlInstance(C));return a;}.bind(this));}else{return Promise.resolve([]);}};f.prototype.getRTASettingsActionHandler=function(C,p,k){var r;var a=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");if(a.length>0&&!C.isA("sap.ui.mdc.link.Panel")){return Promise.reject("Please do not use a PeristenceProvider in RTA.");}var g=this.getModificationHandler(C);var i=g.processChanges;var R=new Promise(function(h,j){r=h;});g.processChanges=function(h){r(h);return Promise.resolve(h);};this._setModificationHandler(C,g);this.uimanager.show(C,k).then(function(h){var j=h.getCustomHeader();if(j){j.getContentRight()[0].setVisible(false);}h.addStyleClass(p.styleClass);if(p.fnAfterClose instanceof Function){h.attachAfterClose(p.fnAfterClose);}});R.then(function(){g.processChanges=i;});return R;};f.prototype.enhanceXConfig=function(C,a){var g=f.getControlInstance(C);var r=this._getRegistryEntry(C);return Promise.resolve().then(function(){if(r){var h=this.getModificationHandler(C);return h.enhanceConfig(g,a).then(function(i){r.xConfig=i;});}else{throw new Error("The control instance needs to be registered to use xConfig!");}}.bind(this));};f.prototype.readXConfig=function(C,a,s){var g=f.getControlInstance(C);var h=this.getModificationHandler(C);return h.readConfig(g,a,s)||Promise.resolve({});};f.prototype.applyState=function(C,s,a){return this.retrieveState(C).then(function(g){var h=[],i=[],I={};if(C.validateState instanceof Function){I=C.validateState(S._externalizeKeys(s));}if(I.validation===e.Error){L.error(I.message);}Object.keys(s).forEach(function(j){var k=this.getController(C,j);if(!k){return;}var l=this.createChanges({control:C,key:j,state:k.sanityCheck(s[j]),suppressAppliance:true,applyAbsolute:a});h.push(l);}.bind(this));return Promise.all(h).then(function(r){r.forEach(function(j){if(j&&j.length>0){i=i.concat(j);}});return this._processChanges(C,i);}.bind(this));}.bind(this));};f.prototype.retrieveState=function(C){var v=this.checkXStateInterface(C);if(!v){throw new Error("The control needs to implement the interface IxState.");}return C.initialized().then(function(){return f.getInstance().waitForChanges(C).then(function(){var r={};f.getInstance().getRegisteredControllers(C).forEach(function(k){r[k]=f.getInstance().getController(C,k).getCurrentState();});return m({},r);});});};f.prototype.checkXStateInterface=function(C){if(!C){return false;}if(!this.isModificationSupported(C)){return false;}if(!C.isA("sap.ui.mdc.IxState")){return false;}return true;};f.prototype.initAdaptation=function(C,k,a){this.verifyController(C,k);return this._retrievePropertyHelper(C,a);};f.prototype.addController=function(C,k,p){var r=this._createRegistryEntry(C.getAdaptationControl(),p);r.controller[k]=C;};f.prototype.getController=function(C,k){var r=this._getRegistryEntry(C);if(r&&r.controller.hasOwnProperty(k)){return r.controller[k];}};f.prototype.verifyController=function(C,k){var K=k instanceof Array?k:[k];K.forEach(function(s){if(!this.getController(C,s)){var a=f.getControlInstance(C);throw new Error("No controller registered yet for "+a.getId()+" and key: "+s);}}.bind(this));};f.prototype.getUISettings=function(C,k){var K=Array.isArray(k)?k:[k];this.verifyController(C,K);var p=this._getRegistryEntry(C).helper;var u={};K.forEach(function(s){var a=this.getController(C,s);var g=a.getAdaptationUI(p);if(g instanceof Promise){u[s]={};u[s]={resetEnabled:a.getResetEnabled(),containerSettings:a.getUISettings(),adaptationUI:g};}}.bind(this));return u;};f.prototype.isRegisteredForModification=function(C){var r=this._getRegistryEntry(C);return r&&!!r.modification;};f.prototype.getRegisteredControllers=function(C){var r=this._getRegistryEntry(C);return Object.keys(r.controller);};f.prototype._getRegistryEntry=function(C){var a=f.getControlInstance(C);return _.get(a);};f.prototype.getModificationHandler=function(C){var a=this._determineModification(C);return a.handler;};f.prototype._createRegistryEntry=function(C,p){var a=f.getControlInstance(C);if(!_.has(a)){_.set(a,{modification:p&&p.modification?p.modification:null,controller:{},activeP13n:null,helper:null,xConfig:null});}return _.get(a);};f.prototype._determineModification=function(C){var r=this._getRegistryEntry(C);if(r&&r.modification){return r.modification;}var p=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");var v=f.hasForReference(C,"sap.ui.fl.variants.VariantManagement");var a=p.length?p:undefined;var h=a?a[0].getMode():"Standard";var H={Global:F,Transient:F,Standard:F,Auto:F};var g=H[h];if(!g){throw new Error("Please provide a valid ModificationHandler! - valid Modification handlers are:"+Object.keys(H));}var i={handler:g.getInstance(),payload:{hasVM:v&&v.length>0,hasPP:p&&p.length>0,mode:h}};if(r&&!r.modification){r.modification=i;}return i;};f.hasForReference=function(C,s){var a=C&&C.getId?C.getId():C;var r=E.registry.filter(function(g){if(!g.isA(s)){return false;}var h=g.getFor();for(var n=0;n<h.length;n++){if(h[n]===a||f.hasControlAncestorWithId(a,h[n])){return true;}}return false;});return r;};f.hasControlAncestorWithId=function(C,a){var g;if(C===a){return true;}g=sap.ui.getCore().byId(C);while(g){if(g.getId()===a){return true;}if(typeof g.getParent==="function"){g=g.getParent();}else{return false;}}return false;};f.getControlInstance=function(C){return typeof C=="string"?sap.ui.getCore().byId(C):C;};f.prototype.hasActiveP13n=function(C){return!!this._getRegistryEntry(C).activeP13n;};f.prototype.setActiveP13n=function(C,k){this._getRegistryEntry(C).activeP13n=k;};f.prototype.validateP13n=function(C,k,p){var a=this.getController(C,k);var g=f.getControlInstance(C);var h=this._getRegistryEntry(C).controller;var t={};Object.keys(h).forEach(function(s){t[s]=h[s].getCurrentState();});if(a.model2State instanceof Function){t[k]=a.model2State();var i=g.validateState(S._externalizeKeys(t),k);var j;if(i.validation!==e.None){j=new M({type:i.validation,text:i.message});}if(p.setMessageStrip instanceof Function){p.setMessageStrip(j);}else{L.warning("message strip could not be provided - the adaptation UI needs to implement 'setMessageStrip'");}}};f.prototype.handleP13n=function(C,k){var a=[];k.forEach(function(s){var g=this.getController(C,s);var p=this.createChanges({control:C,key:s,state:g.getP13nData(),suppressAppliance:true,applyAbsolute:true}).then(function(i){return g.getBeforeApply().then(function(h){var j=h?h.concat(i):i;return j;});});a.push(p);}.bind(this));return Promise.all(a).then(function(g){var h=[];g.forEach(function(t){h=h.concat(t);});if(h.length>0){f.getInstance()._processChanges(C,h);}});};f.prototype._retrievePropertyHelper=function(C,a){var r=this._getRegistryEntry(C);var g=f.getControlInstance(C);if(a){if(r.helper){r.helper.destroy();}r.helper=new P(a);return Promise.resolve(r.helper);}if(r.helper){return Promise.resolve(r.helper);}return g.initPropertyHelper().then(function(p){r.helper=p;return p;},function(h){throw new Error(h);});};f.getInstance=function(){if(!o){o=new f();}return o;};f.prototype._getRegistry=function(){var r={stateHandlerRegistry:this.stateHandlerRegistry,defaultProviderRegistry:this.defaultProviderRegistry,controlRegistry:{}};this._aRegistry.forEach(function(k){var C=sap.ui.getCore().byId(k);r.controlRegistry[k]=_.get(C);});return r;};f.prototype.destroy=function(){A.prototype.destroy.apply(this,arguments);o=null;this._aRegistry=null;_.delete(this);this.defaultProviderRegistry.destroy();this.defaultProviderRegistry=null;this.stateHandlerRegistry.destroy();this.stateHandlerRegistry=null;this.uimanager.destroy();this.uimanager=null;};return f;});
