/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/VBox','sap/ui/core/Control','sap/m/Column','sap/m/Text','sap/ui/model/Filter',"sap/m/Table","sap/m/OverflowToolbar","sap/m/SearchField","sap/m/ToolbarSpacer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/core/dnd/DragDropInfo"],function(V,C,a,T,F,b,O,S,c,d,e,B,D){"use strict";var f=C.extend("sap.ui.mdc.p13n.panels.BasePanel",{metadata:{library:"sap.ui.mdc",associations:{},defaultAggregation:"items",properties:{enableReorder:{type:"boolean",defaultValue:true},itemFactory:{type:"function"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},template:{type:"sap.ui.core.Control",multiple:false},messageStrip:{type:"sap.m.MessageStrip",multiple:false}},events:{change:{reason:{type:"string"},item:{type:"object"}}}},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}});f.prototype.P13N_MODEL="$p13n";f.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oListControl=this._createInnerListControl();this._oListControl.setMultiSelectMode("ClearAll");this._setInnerLayout();};f.prototype._setInnerLayout=function(){this.setAggregation("_content",new V({items:[this._oListControl]}));};f.prototype.setMessageStrip=function(s){if(!s){this.getAggregation("_content").removeItem(this._oMessageStrip);this._oMessageStrip=null;}else{if(this._oMessageStrip){this._oMessageStrip.destroy();}this._oMessageStrip=s;this.getAggregation("_content").insertItem(s,0);}return this;};f.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){this._oDragDropInfo=new D({enabled:false,sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",drop:[this._onRearrange,this]});}return this._oDragDropInfo;};f.prototype._getMoveTopButton=function(){if(!this._oMoveTopBtn){this._oMoveTopBtn=new d(this.getId()+"-moveTopBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_TOP"),icon:"sap-icon://collapse-group",press:[this._onPressButtonMoveToTop,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this.addDependent(this._oMoveTopBtn);}return this._oMoveTopBtn;};f.prototype.getItems=function(){return this._oListControl.getItems();};f.prototype._getMoveUpButton=function(){if(!this._oMoveUpButton){this._oMoveUpButton=new d(this.getId()+"-moveUpBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_UP"),icon:"sap-icon://navigation-up-arrow",press:[this._onPressButtonMoveUp,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this.addDependent(this._oMoveUpButton);}return this._oMoveUpButton;};f.prototype._getMoveDownButton=function(){if(!this._oMoveDownButton){this._oMoveDownButton=new d(this.getId()+"-moveDownpBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_DOWN"),icon:"sap-icon://navigation-down-arrow",press:[this._onPressButtonMoveDown,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this.addDependent(this._oMoveDownButton);}return this._oMoveDownButton;};f.prototype._getMoveBottomButton=function(){if(!this._oMoveBottomButton){this._oMoveBottomButton=new d(this.getId()+"-moveBottomBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_BOTTOM"),icon:"sap-icon://expand-group",press:[this._onPressButtonMoveToBottom,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this.addDependent(this._oMoveBottomButton);}return this._oMoveBottomButton;};f.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerP13nList",Object.assign(this._getListControlConfig(),{headerToolbar:new O({content:[this._getSearchField(),new c(),this._getMoveTopButton(),this._getMoveUpButton(),this._getMoveDownButton(),this._getMoveBottomButton(),this._getReorderButton()]})}));};f.prototype.setEnableReorder=function(E){var t=this.getTemplate();if(E){this._addHover(t);}else if(t&&t.aDelegates&&t.aDelegates.length>0){t.removeEventDelegate(t.aDelegates[0].oDelegate);}this._getDragDropConfig().setEnabled(E);this._setMoveButtonVisibility(E);this.setProperty("enableReorder",E);return this;};f.prototype._addHover=function(r){if(r&&r.aDelegates.length<1){r.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this)});}};f.prototype._focusHandler=function(E){if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};f.prototype._hoverHandler=function(E){if(this._oSelectedItem&&!this._oSelectedItem.bIsDestroyed){return;}if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};f.prototype._handleActivated=function(h){this._oHoveredItem=h;};f.prototype._getReorderButton=function(){if(!this.oReorderButton){this.oReorderButton=new B(this.getId()+"-showSelectedBtn",{text:{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?this.getResourceText("p13nDialog.SELECT"):this.getResourceText("p13nDialog.REORDER");}.bind(this)},press:[this._onPressToggleMode,this]});}return this.oReorderButton;};f.prototype._getListControlConfig=function(){return{mode:"MultiSelect",rememberSelections:true,itemPress:[this._onItemPressed,this],selectionChange:[this._onSelectionChange,this],sticky:["HeaderToolbar","ColumnHeaders","InfoToolbar"],dragDropConfig:this._getDragDropConfig()};};f.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new S(this.getId()+"-searchField",{liveChange:[this._onSearchFieldLiveChange,this],width:"100%",layoutData:new e({shrinkable:true,moveToOverflow:true,priority:"High",maxWidth:"16rem"})});}return this._oSearchField;};f.prototype.setTemplate=function(t){this.setAggregation("template",t);if(t){if(this.getEnableReorder()){this._addHover(t);}this._oSelectionBindingInfo=t.getBindingInfo("selected");if(this._oSelectionBindingInfo&&this._oSelectionBindingInfo.parts){this._oSelectionBindingInfo={parts:this._oSelectionBindingInfo.parts};}}this._bindListItems();return this;};f.prototype.setPanelColumns=function(v){var g;if(v instanceof Array){g=v;}else{g=[v];}this._addTableColumns(g);};f.prototype.setP13nModel=function(p){this.setModel(p,this.P13N_MODEL);this.setPanelMode(false);};f.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL);};f.prototype.getP13nState=function(){return this.getP13nModel().getProperty("/items").filter(function(o){return o[this._getPresenceAttribute()]===true;}.bind(this));};f.prototype.getResourceText=function(t,v){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundle.getText(t,v):this.oResourceBundle;};f.prototype._addTableColumns=function(g){var r=this._oListControl.removeAllColumns();r.forEach(function(R){R.destroy();});g.forEach(function(v){var o;if(typeof v=="string"){o=new a({header:new T({text:v})});}else{o=v;}this._oListControl.addColumn(o);},this);};f.prototype._getPresenceAttribute=function(){var p=this.getP13nModel().getProperty("/presenceAttribute")||"visible";return p;};f.prototype._bindListItems=function(m){var t=this.getTemplate();if(t){t.bindProperty("type",{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?"Active":"Inactive";}});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",templateShareable:false,template:this.getTemplate().clone()},m));}};f.prototype._onSelectionChange=function(E){var l=E.getParameter("listItems");var s=E.getParameter("selectAll");var g=!s&&l.length>1;l.forEach(function(t){this._selectTableItem(t,s||g);},this);if(s||g){this.fireChange({reason:s?"SelectAll":"DeselectAll",item:undefined});}if(g){this._getMoveTopButton().setEnabled(false);this._getMoveUpButton().setEnabled(false);this._getMoveDownButton().setEnabled(false);this._getMoveBottomButton().setEnabled(false);}};f.prototype._onItemPressed=function(E){var t=E.getParameter('listItem');this._oSelectedItem=t;var o=t.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this._getPresenceAttribute())){this._handleActivated(t);this._updateEnableOfMoveButtons(t,true);}};f.prototype._onSearchFieldLiveChange=function(E){this._oListControl.getBinding("items").filter(new F("label","Contains",E.getSource().getValue()));};f.prototype._onPressButtonMoveToTop=function(){this._moveSelectedItem(0);};f.prototype._onPressButtonMoveUp=function(){this._moveSelectedItem("Up");};f.prototype._onPressButtonMoveDown=function(){this._moveSelectedItem("Down");};f.prototype._onPressButtonMoveToBottom=function(){var i=this._oListControl.getItems().length-1;this._moveSelectedItem(i);};f.prototype._onPressToggleMode=function(E){this._togglePanelMode();};f.prototype.getPanelMode=function(){return this.getP13nModel()?this.getP13nModel().getProperty("/reorderMode"):false;};f.prototype.setPanelMode=function(r){return this.getP13nModel().setProperty("/reorderMode",r);};f.prototype._togglePanelMode=function(){var r=!this.getPanelMode();this.setPanelMode(r);if(r){this._updateModelItems();}this.switchListMode(r?"None":"MultiSelect");this._filterBySelected(r,this._oListControl);this._oSearchField.setVisible(!r);this._oSearchField.setValue("");this._setMoveButtonVisibility(r);this._getMoveTopButton().setEnabled(false);this._getMoveUpButton().setEnabled(false);this._getMoveDownButton().setEnabled(false);this._getMoveBottomButton().setEnabled(false);this._getDragDropConfig().setEnabled(r);};f.prototype._setMoveButtonVisibility=function(v){this._getMoveTopButton().setVisible(v);this._getMoveUpButton().setVisible(v);this._getMoveDownButton().setVisible(v);this._getMoveBottomButton().setVisible(v);};f.prototype._updateModelItems=function(){var g=this.getP13nModel().getProperty("/items");var s=[],o=[];g.forEach(function(h){if(h[this._getPresenceAttribute()]){s.push(h);}else{o.push(h);}}.bind(this));this.getP13nModel().setProperty("/items",s.concat(o));};f.prototype._filterBySelected=function(s,l){l.getBinding("items").filter(s?new F(this._getPresenceAttribute(),"EQ",true):[]);};f.prototype.switchListMode=function(m){if(this._oSelectionBindingInfo){if(m==="None"){this.getTemplate().unbindProperty("selected");}else{this.getTemplate().bindProperty("selected",this._oSelectionBindingInfo);}this._oListControl.unbindAggregation("items");}this._oListControl.setMode(m);if(this._oSelectionBindingInfo){this._bindListItems();}};f.prototype._selectTableItem=function(t,s){this._updateEnableOfMoveButtons(t,s?false:true);this._oSelectedItem=t;if(!s){var i=this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath);var p=this.getModel(this.P13N_MODEL);if(p&&i){p.setProperty(t.getBindingContext(this.P13N_MODEL).sPath+"/selected",i.visible);}this.fireChange({reason:i[this._getPresenceAttribute()]?"Add":"Remove",item:i});}};f.prototype._moveSelectedItem=function(n){var s=this._oSelectedItem;var i=this._oListControl.indexOfItem(s);if(i<0){return;}var N=(typeof n=="number")?n:i+(n=="Up"?-1:1);this._moveTableItem(s,N);};f.prototype._moveTableItem=function(i,n){var I=this._oListControl.getItems();var g=this.getP13nModel().getProperty("/items");var o=g.indexOf(i.getBindingContext(this.P13N_MODEL).getObject());n=(n<=0)?0:Math.min(n,I.length-1);var N=g.indexOf(I[n].getBindingContext(this.P13N_MODEL).getObject());if(N==o){return;}g.splice(N,0,g.splice(o,1)[0]);this.getP13nModel().setProperty("/items",g);this._oSelectedItem=this._oListControl.getItems()[n];this._updateEnableOfMoveButtons(this._oSelectedItem,true);this._handleActivated(this._oSelectedItem);this.fireChange({reason:"Move",item:this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath)});};f.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var g=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var i=this._oListControl.indexOfItem(o);var h=this._oListControl.indexOfItem(g);var A=h+(s=="Before"?0:1)+(i<h?-1:0);this._moveTableItem(o,A);};f.prototype._updateEnableOfMoveButtons=function(t,g){var i=this._oListControl.getItems().indexOf(t);var l=this._oListControl.getItems().length-1;var u=true,h=true;if(i==0){u=false;}if(i==l){h=false;}this._getMoveTopButton().setEnabled(u);this._getMoveUpButton().setEnabled(u);this._getMoveDownButton().setEnabled(h);this._getMoveBottomButton().setEnabled(h);if(g){t.focus();}};f.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oSelectionBindingInfo=null;this._oSelectedItem=null;this._oListControl=null;this._oMoveTopBtn=null;this._oMoveUpButton=null;this._oMoveDownButton=null;this._oMoveBottomButton=null;this._oSearchField=null;};return f;});
