/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text","sap/m/Column","sap/m/Table","sap/m/library","sap/m/ToolbarSpacer","sap/m/Button","sap/m/OverflowToolbar","sap/ui/model/Filter"],function(B,L,C,H,V,I,c,T,a,b,l,d,e,O,F){"use strict";var f=l.ListKeyboardMode;var g=l.FlexJustifyContent;var h=l.ListType;var i=c.IconColor;var j=B.extend("sap.ui.mdc.p13n.panels.ListView",{metadata:{library:"sap.ui.mdc",properties:{showHeader:{type:"boolean",defaultValue:false},enableCount:{type:"boolean",defaultValue:false}}},renderer:{apiVersion:2}});j.prototype.applySettings=function(){this.setTemplate(this._getListTemplate());B.prototype.applySettings.apply(this,arguments);this.addStyleClass("sapUiMDCListView");this._aInitializedFields=[];this._bShowFactory=false;this.addStyleClass("listViewHover");this.displayColumns();this.setEnableReorder(true);};j.prototype.setItemFactory=function(k){this.setProperty("itemFactory",k);this._oListControl.setGrowing(!!k);return this;};j.prototype._getListTemplate=function(){return new C({selected:"{"+this.P13N_MODEL+">visible}",type:h.Active,cells:[new V({items:[new L({wrapping:true,required:"{"+this.P13N_MODEL+">required}",tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"})]}),new H({justifyContent:g.Center,items:[new I({src:"sap-icon://circle-task-2",size:"0.5rem",color:i.Neutral,visible:{path:this.P13N_MODEL+">isFiltered",formatter:function(k){if(k){return true;}else{return false;}}}})]})]});};j.prototype.setShowHeader=function(s){if(s){var S=this.getResourceText("p13nDialog.SHOW_SELECTED");var k=this.getResourceText("p13nDialog.SHOW_ALL");this._oListControl.setHeaderToolbar(new O({content:[this._getSearchField(),new d(),new e({press:function(E){this._bShowSelected=E.getSource().getText()==S;this._filterList(this._bShowSelected,this._sSearch);E.getSource().setText(this._bShowSelected?k:S);}.bind(this),text:S})]}));}this.setProperty("showHeader",s);return this;};j.prototype._filterList=function(s,S){var o=[],k=[];if(s){k=new F(this._getPresenceAttribute(),"EQ",true);}if(S){o=new F("label","Contains",S);}this._oListControl.getBinding("items").filter(new F([].concat(k,o),true));};j.prototype._onSearchFieldLiveChange=function(E){this._sSearch=E.getSource().getValue();this._filterList(this._bShowSelected,this._sSearch);};j.prototype._handleActivated=function(o){this.removeMoveButtons();if(this._oHoveredItem&&this._oHoveredItem.getBindingContextPath()){var v=!!this.getP13nModel().getProperty(this._oHoveredItem.getBindingContextPath()).isFiltered;var k=this._oHoveredItem.getCells()[1].getItems()[0];k.setVisible(v);}var m=o.getCells()[1].getItems()[0];m.setVisible(false);this._oHoveredItem=o;this._updateEnableOfMoveButtons(o,false);this._addMoveButtons(o);};j.prototype.removeMoveButtons=function(){var m=this._getMoveButtonContainer();if(m){m.removeItem(this._getMoveTopButton());m.removeItem(this._getMoveUpButton());m.removeItem(this._getMoveDownButton());m.removeItem(this._getMoveBottomButton());}};j.prototype._getMoveButtonContainer=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.getParent()&&this._oMoveBottomButton.getParent().isA("sap.m.FlexBox")){return this._oMoveBottomButton.getParent();}};j.prototype.showFactory=function(s){this._bShowFactory=s;this.displayColumns();if(s){this.removeStyleClass("listViewHover");this._oListControl.setKeyboardMode(f.Edit);this._addFactoryControl();}else{this.addStyleClass("listViewHover");this._oListControl.setKeyboardMode(f.Navigation);this._removeFactoryControl();}};j.prototype._updateCount=function(){this.getP13nModel().setProperty("/selectedItems",this._oListControl.getSelectedContexts(true).length);};j.prototype._selectTableItem=function(t,s){B.prototype._selectTableItem.apply(this,arguments);this._updateCount();};j.prototype.setP13nModel=function(m){this.setModel(m,"$p13n");this._updateCount();this.setPanelMode(true);this._getDragDropConfig().setEnabled(this.getEnableReorder());};j.prototype._removeFactoryControl=function(){var k=this._oListControl.getItems().filter(function(o){return!o._bGroupHeader;});k.forEach(function(o){var m=o.getCells()[0];if(m.getItems().length>1){m.removeItem(m.getItems()[1]);}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields;};j.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};j.prototype.getShowFactory=function(){return this._bShowFactory;};j.prototype.displayColumns=function(){var k=[this.getResourceText("p13nDialog.LIST_VIEW_COLUMN")];if(!this._bShowFactory){k.push(new a({width:"25%",hAlign:"Center",vAlign:"Middle",header:new T({text:this.getResourceText("p13nDialog.LIST_VIEW_ACTIVE")})}));}this.setPanelColumns(k);};j.prototype.setPanelColumns=function(k){this._sText=k[0];var E=this.getEnableCount();if(E){var o=new a({header:new T({text:{parts:[{path:this.P13N_MODEL+'>/selectedItems'},{path:this.P13N_MODEL+'>/items'}],formatter:function(s,A){return this._sText+" "+this.getResourceText('p13nDialog.HEADER_COUNT',[s,A.length]);}.bind(this)}})});k[0]=o;}B.prototype.setPanelColumns.apply(this,arguments);};j.prototype._addFactoryControl=function(o){this._oListControl.getItems().forEach(function(k){var m=k.getBindingContext(this.P13N_MODEL);var n=this.getItemFactory().call(this,m);var p=k.getCells()[0];p.addItem(n);}.bind(this));this.addStyleClass("sapUiMDCAFLabelMarkingList");};j.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerListViewTable",Object.assign({growing:false,growingThreshold:25,growingScrollToLoad:true,updateStarted:function(){this.removeMoveButtons();this._removeFactoryControl();}.bind(this),updateFinished:function(){if(this.getShowFactory()){this._addFactoryControl();}}.bind(this)},this._getListControlConfig()));};j.prototype.getSelectedFields=function(){var s=[];this._loopItems(this._oListControl,function(o,k){if(o.getSelected()){s.push(k);}});return s;};j.prototype._loopItems=function(o,k){o.getItems().forEach(function(m){var p=m.getBindingContextPath();var K=this.getP13nModel().getProperty(p).name;k.call(this,m,K);}.bind(this));};j.prototype.filterWithoutDestroy=function(k){if(this._oListControl.getBinding("items")){this._oListControl.getBinding("items").filter(k,true);}};j.prototype._addMoveButtons=function(o){var t=o;if(!t){return;}var k=this.getP13nModel().getProperty(t.getBindingContextPath()).visible;if(k){t.getCells()[1].addItem(this._getMoveTopButton());t.getCells()[1].addItem(this._getMoveUpButton());t.getCells()[1].addItem(this._getMoveDownButton());t.getCells()[1].addItem(this._getMoveBottomButton());}};j.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._aInitializedFields=null;this._oHoveredItem=null;this._bShowFactory=null;this._sSearch=null;this._bShowSelected=null;};return j;});
