/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/TreeBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils',"sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(T,c,C,d,e,L,f,g){"use strict";var h=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var a in h.prototype){if(h.prototype.hasOwnProperty(a)){this[a]=h.prototype[a];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||c.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();this._bIsAdapted=true;};h.prototype.getCurrentTreeState=function(){var D=";",G;var E={};for(G in this._mTreeState.expanded){E[G]=true;}var m={};for(G in this._mTreeState.collapsed){m[G]=true;}var s={};for(G in this._mTreeState.selected){s[G]=true;}return{_getExpandedList:function(){return Object.keys(E).join(D);},_getCollapsedList:function(){return Object.keys(m).join(D);},_getSelectedList:function(){return Object.keys(s).join(D);},_isExpanded:function(G){return!!E[G];},_isCollapsed:function(G){return!!m[G];},_remove:function(G){delete E[G];delete m[G];delete s[G];}};};h.prototype.setTreeState=function(t){this._oInitialTreeState=t;};h.prototype.setAutoExpandMode=function(a){this._autoExpandMode=a;};h.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};h.prototype.getContextByIndex=function(i){if(this.isInitial()){return undefined;}var n=this.findNode(i);return n?n.context:undefined;};h.prototype.getNodeByIndex=function(i){if(this.isInitial()){return undefined;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};h.prototype.findNode=function(r){if(this.isInitial()){return undefined;}var p=typeof r;var F;var s=[];if(p==="number"){F=this._aRowIndexMap[r];if(!F){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===r){return true;}i+=1;return false;});F=s[0];}}return F;};h.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};h.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};h.prototype._createNodeState=function(p){if(!p.groupID){e(false,"To create a node state a group ID is mandatory!");return undefined;}var i;var I;if(this._oInitialTreeState){i=this._oInitialTreeState._isExpanded(p.groupID);I=this._oInitialTreeState._isCollapsed(p.groupID);this._oInitialTreeState._remove(p.groupID);}var b=p.expanded||i||false;var a=p.selected||false;var n={groupID:p.groupID,expanded:b,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:a};if(i||I){this._updateTreeState({groupID:p.groupID,fallbackNodeState:n,expanded:i,collapsed:I});}return n;};h.prototype._getNodeState=function(G){var E=this._mTreeState.expanded[G];var o=this._mTreeState.collapsed[G];var s=this._mTreeState.selected[G];var D=this._mTreeState.deselected[G];return E||o||s||D;};h.prototype._updateNodeSections=function(G,n){var N=this._getNodeState(G);if(!N){e(false,"No Node State for Group ID '"+G+"' found!");return undefined;}else if(!n){e(false,"No Section given!");return undefined;}else if(n.length<=0){e(false,"The length of the given section must be positive greater than 0.");return undefined;}else if(n.startIndex<0){e(false,"The sections start index must be greater/equal to 0.");return undefined;}N.sections=d.mergeSections(N.sections,n);return N.sections;};h.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=this._getMaxGroupSize(n);var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var o=N.sections[i];o.length=Math.max(o.length,this._iPageSize);a=d.mergeSections(a,o);}N.sections=a;}};this._map(this._oRootNode,I);};h.prototype._getMaxGroupSize=function(n){var m=0;if(n.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}return m;};h.prototype.getContexts=function(s,l,t){return this._getContextsOrNodes(false,s,l,t);};h.prototype._getContextsOrNodes=function(r,s,l,t){var m,n,a=[],N=[];if(!this.isResolved()||this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);if(this._oRootNode){N=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(N,s);for(var i=0;i<N.length;i++){n=N[i];if(!n.context){m=m||{};var p=n.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:n.positionInParent,length:1});}a.push(n.context);}if(m){var b=this;f(m,function(G,n){n.magnitude=0;n.numberOfTotals=0;b._loadChildContexts(n);});a=[];for(var j=0;j<N.length;j++){n=N[j];a.push(n.context);}}if(r){return N;}else{return a;}};h.prototype.getNodes=function(s,l,t){return this._getContextsOrNodes(true,s,l,t);};h.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};h.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}return false;});return a;};h.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};h.prototype._calculateRequestLength=function(m,s){var r;if(!m){r=s.length;}else{r=Math.max(Math.min(s.length,m-s.startIndex),0);}return r;};h.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=this._getMaxGroupSize(n);if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}N.leafCount=m;}if(this.bClientOperation){N.sections=[{startIndex:0,length:m}];}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];var r=this._calculateRequestLength(m,o);if(n.autoExpand>=0&&this._autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(o.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,o.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var b=a[j];if(!b){continue;}var k=j+o.startIndex;var l=n.children[k];var u={context:a[j],parent:n,level:n.level+1,positionInParent:k,autoExpand:Math.max(n.autoExpand-1,-1)};if(l){l.context=u.context;l.parent=u.parent;l.level=u.level;l.positionInParent=u.positionInParent;l.magnitude=0;l.numberOfTotals=0;l.autoExpand=u.autoExpand;var G;if(b){G=this._calculateGroupID(l);}l.groupID=G;}else{l=this._createNode(u);}l.nodeState=this._getNodeState(l.groupID);if(!l.nodeState){l.nodeState=this._createNodeState({groupID:l.groupID,expanded:false});}l.nodeState.parentGroupID=n.groupID;l.isLeaf=!this.nodeHasChildren(l);n.children[k]=l;if(l.isLeaf){n.numberOfLeafs+=1;}if(l.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[l.groupID]){this.setNodeSelection(l.nodeState,true);}if((l.autoExpand>0||l.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[l.groupID]&&!l.isLeaf){this._updateTreeState({groupID:l.nodeState.groupID,fallbackNodeState:l.nodeState,expanded:true});this._loadChildContexts(l);}n.magnitude+=Math.max(l.magnitude||0,0);n.numberOfLeafs+=l.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};h.prototype.isGrouped=function(){return true;};h.prototype._calculateGroupID=function(n){L.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.");};h.prototype._createNode=function(p){p=p||{};var o=p.context;var l=p.level||0;var n={context:o,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0,absoluteNodeIndex:p.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(o!==undefined){n.groupID=this._calculateGroupID(n);}return n;};h.prototype.expand=function(i,s){var n=this.findNode(i);if(!n){e(false,"No node found for index "+i);return;}this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});if(!s){this._fireChange({reason:C.Expand});}};h.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange({reason:C.Expand});};h.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};h.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);if(!N){e(false,"No node found for index "+p);return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var G=n.groupID;f(this._mTreeState.expanded,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)){t._updateTreeState({groupID:b,expanded:false});}});var D=[];f(this._mTreeState.selected,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)&&b!==G){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(b);}});if(D.length){var a={rowIndices:[]};var i=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){a.oldIndex=i;a.leadIndex=-1;}a.rowIndices.push(i);}});this._publishSelectionChanges(a);}}if(!s){this._fireChange({reason:C.Collapse});}};h.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;f(this._mTreeState.expanded,function(G,n){var N=t._getGroupIdLevel(G)-1;if(N===l){t.collapse(n,true);}});if(this.bCollapseRecursive){this.setNumberOfExpandedLevels(l);}this._fireChange({reason:C.Collapse});};h.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var o=n.children[i];this._map(o,m);}if(this._afterMapHook){this._afterMapHook(n,m);}};h.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var o=n.children[i];var b=this._match(o,r,m,M,i,n);if(b){return true;}}return this._afterMatchHook?this._afterMatchHook(n,r,m,M,p,P):false;};h.prototype.toggleIndex=function(i){var n=this.findNode(i);if(!n){e(false,"There is no node at index "+i+".");return;}if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};h.prototype._getGroupIdLevel=function(G){if(G==null){L.warning("assertion failed: no need to determine level of group ID = null");return-1;}return G.split("/").length-2;};h.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};h.prototype.setNodeSelection=function(n,i){if(!n.groupID){e(false,"NodeState must have a group ID!");return;}n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};h.prototype.isIndexSelected=function(r){var n=this.getNodeByIndex(r);return n&&n.nodeState?n.nodeState.selected:false;};h.prototype.isIndexSelectable=function(r){var n=this.getNodeByIndex(r);return this._isNodeSelectable(n);};h.prototype._isNodeSelectable=function(n){return!!n&&!n.isArtificial;};h.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n&&this._isNodeSelectable(n)){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadGroupID=n.groupID;o.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(o);}else{L.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.");}};h.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||g(this._mTreeState.selected)){return-1;}var n=-1;var a=false;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){a=true;return true;}}return false;};this._match(this._oRootNode,[],1,m);if(a){return n;}return-1;};h.prototype.getSelectedIndices=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(N);t._aRowIndexMap[N]=o;return true;}}return false;};this._match(this._oRootNode,[],n,m);return r;};h.prototype.getSelectedNodesCount=function(){var s;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var G,v,p,o;var a,V=[];if(this.filterInfo&&this.oCombinedFilter){for(var i=this.filterInfo.aFilteredContexts.length-1;i>=0;i--){a=this.filterInfo.aFilteredContexts[i];V.push(this._calculateGroupID({context:a}));}}v=0;for(G in this._mTreeState.expanded){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.expanded[G];if(!o.selectAllMode&&o.leafCount!==undefined){v+=o.leafCount;}}}for(G in this._mTreeState.selected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.selected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&!p.selectAllMode){v--;}}}for(G in this._mTreeState.deselected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.deselected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&p.selectAllMode){v++;}}}s=this._getSelectableNodesCount(this._oRootNode)-v;}else{s=Object.keys(this._mTreeState.selected).length;}return s;};h.prototype._getSelectableNodesCount=function(n){if(n){return n.magnitude;}else{return 0;}};h.prototype.getSelectedContexts=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(o.context);t._aRowIndexMap[N]=o;return true;}}return false;};this._match(this._oRootNode,[],n,m);return r;};h.prototype.setSelectionInterval=function(F,t){var i,I,m=this._clearSelection(),a={},r=[],s=this._setSelectionInterval(F,t,true);for(i=0;i<m.rowIndices.length;i++){I=m.rowIndices[i];a[I]=true;}for(i=0;i<s.rowIndices.length;i++){I=s.rowIndices[i];if(a[I]){delete a[I];}else{a[I]=true;}}for(I in a){if(a[I]){r.push(parseInt(I));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};h.prototype._setSelectionInterval=function(F,t,s){var n=Math.min(F,t);var N=Math.max(F,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var j=-1;var m=function(k){if(!k||!k.isArtificial){j++;}if(k){if(j>=n&&j<=N){if(this._isNodeSelectable(k)){if(k.nodeState.selected!==!!s){b.push(j);}if(k.groupID===this._sLeadSelectionGroupID){o=j;}this.setNodeSelection(k.nodeState,!!s);}return true;}}return false;};this._match(this._oRootNode,a,i,m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};h.prototype.addSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,true);this._publishSelectionChanges(p);};h.prototype.removeSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,false);this._publishSelectionChanges(p);};h.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(this._isNodeSelectable(N)){if(N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);p.leadGroupID=N.groupID;p.leadIndex=n;}if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};h.prototype._clearSelection=function(){var n=-1;var o=-1;var m;var a=[];if(this._oRootNode&&!this._oRootNode.nodeState.selectAllMode){m=0;for(var G in this._mTreeState.selected){if(G){m++;}}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){N.nodeState.selectAllMode=false;if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){a.push(n);}this.setNodeSelection(N.nodeState,false);if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}return false;};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:a,oldIndex:o,leadIndex:-1};};h.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};h.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};h.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};h.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive;};h.prototype.attachSelectionChanged=function(D,F,l){this.attachEvent("selectionChanged",D,F,l);return this;};h.prototype.detachSelectionChanged=function(F,l){this.detachEvent("selectionChanged",F,l);return this;};h.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};return h;},true);
