/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/util/extend","sap/ui/base/EventProvider","sap/ui/core/cache/CacheManager","sap/ui/model/odata/AnnotationParser","sap/ui/thirdparty/jquery"],function(a,e,E,C,A,q){"use strict";var O=E.extend("sap.ui.model.odata.v2.ODataAnnotations",{constructor:function(m,o){var t=this;E.apply(this,[o]);this._oMetadata=m;this._pLoaded=m.loaded();this._mCustomHeaders={};this._mAnnotations={};this._hasErrors=false;function w(r){if(!t._hasErrors){C.set(t.sCacheKey,JSON.stringify(r));}}if(!o||!o.skipMetadata){if(!o){o={};}if(!o.source){o.source=[];}else if(Array.isArray(o.source)){o.source=o.source.slice(0);}else{o.source=[o.source];}o.source.unshift({type:"xml",data:m.loaded().then(function(p){return{xml:p["metadataString"],lastModified:p["lastModified"],eTag:p["eTag"]};})});}if(o){this.sCacheKey=o.cacheKey;this.setHeaders(o.headers);if(this.sCacheKey){this._pLoaded=C.get(t.sCacheKey).then(function(s){var r;if(s){r=JSON.parse(s);}if(Array.isArray(r)){r.annotations={};r.forEach(function(b){A.restoreAnnotationsAtArrays(b.annotations);A.merge(r.annotations,b.annotations);});t._mAnnotations=r.annotations;t._fireSomeLoaded(r);t._fireLoaded(r);return r;}else{return t.addSource(o.source).then(function(r){w(r);return r;});}});}else{this._pLoaded=this.addSource(o.source);}}},metadata:{publicMethods:["getData","addSource","getHeaders","setHeaders","attachSuccess","detachSuccess","attachError","detachError","attachLoaded","detachLoaded","attachFailed","detachFailed"]}});O.prototype.getData=function(){return this._mAnnotations;};O.prototype.getAnnotationsData=function(){return this._mAnnotations;};O.prototype.getHeaders=function(){return e({},this._mCustomHeaders);};O.prototype.setHeaders=function(h){this._mCustomHeaders=e({},h);};O.prototype.loaded=function(){return this._pLoaded;};O.prototype.addSource=function(s){if(!s||Array.isArray(s)&&s.length===0){return this._oMetadata.loaded();}if(!Array.isArray(s)){s=[s];}var t=this;var m=s.map(function(v){v=(typeof v==="string")?{type:"url",data:v}:v;return t._loadSource(v).then(t._parseSourceXML).then(t._parseSource.bind(t)).catch(function(o){return o;});});return Promise.all(m).then(function(b){return b.map(function(o){try{o=t._mergeSource(o);t._fireSuccess(o);}catch(c){t._fireError(o);}return o;});}).then(function(r){r.annotations=t.getData();var b=r.filter(function(R){return R instanceof Error;});if(b.length>0){t._hasErrors=true;if(b.length!==r.length){t._fireSomeLoaded(r);t._fireFailed(r);}else{t._fireFailed(r);t._fireAllFailed(r);return Promise.reject(r);}}else{t._fireSomeLoaded(r);t._fireLoaded(r);}return r;});};O.prototype.attachSuccess=function(d,f,l){return this.attachEvent("success",d,f,l);};O.prototype.detachSuccess=function(f,l){return this.detachEvent("success",f,l);};O.prototype.attachError=function(d,f,l){return this.attachEvent("error",d,f,l);};O.prototype.detachError=function(f,l){return this.detachEvent("error",f,l);};O.prototype.attachLoaded=function(d,f,l){return this.attachEvent("loaded",d,f,l);};O.prototype.detachLoaded=function(f,l){return this.detachEvent("loaded",f,l);};O.prototype.attachFailed=function(d,f,l){return this.attachEvent("failed",d,f,l);};O.prototype.detachFailed=function(f,l){return this.detachEvent("failed",f,l);};O.prototype.attachSomeLoaded=function(d,f,l){return this.attachEvent("someLoaded",d,f,l);};O.prototype.detachSomeLoaded=function(f,l){return this.detachEvent("someLoaded",f,l);};O.prototype.attachAllFailed=function(d,f,l){return this.attachEvent("allFailed",d,f,l);};O.prototype.detachAllFailed=function(f,l){return this.detachEvent("allFailed",f,l);};O.prototype._fireSuccess=function(r){return this.fireEvent("success",{result:r},false,false);};O.prototype._fireError=function(o){return this.fireEvent("error",{result:o},false,false);};O.prototype._fireLoaded=function(r){return this.fireEvent("loaded",{result:r},false,false);};O.prototype._fireFailed=function(b){return this.fireEvent("failed",{result:b},false,false);};O.prototype._fireSomeLoaded=function(r){return this.fireEvent("someLoaded",{result:r},false,false);};O.prototype._fireAllFailed=function(b){return this.fireEvent("allFailed",{result:b},false,false);};O.prototype._loadSource=function(s){if(s.data instanceof Promise){return s.data.then(function(d){delete s.data;s.type="xml";s.xml=d.xml;s.lastModified=d.lastModified;s.eTag=d.eTag;return this._loadSource(s);}.bind(this));}else if(s.type==="xml"){if(typeof s.data==="string"){s.xml=s.data;delete s.data;}return Promise.resolve(s);}else if(s.type==="url"){return this._loadUrl(s);}else{var o=new Error("Unknown source type: \""+s.type+"\"");o.source=s;return Promise.reject(o);}};O.prototype._loadUrl=function(s){a(s.type==="url","Source type must be \"url\" in order to be loaded");return new Promise(function(r,R){var m={url:s.data,async:true,headers:this._getHeaders(),beforeSend:function(x){x.overrideMimeType("text/plain");}};var S=function(d,b,x){s.xml=x.responseText;if(x.getResponseHeader("Last-Modified")){s.lastModified=new Date(x.getResponseHeader("Last-Modified"));}if(x.getResponseHeader("eTag")){s.eTag=x.getResponseHeader("eTag");}r(s);};var f=function(x,b){var o=new Error("Could not load annotation URL: \""+s.data+"\"");o.source=s;R(o);};q.ajax(m).done(S).fail(f);}.bind(this));};O.prototype._parseSourceXML=function(s){a(typeof s.xml==="string","Source must contain XML string in order to be parsed");return new Promise(function(r,R){var x=new DOMParser().parseFromString(s.xml,'application/xml');if(x.getElementsByTagName("parsererror").length>0){var o=new Error("There were errors parsing the XML.");o.source={type:s.type,data:s.data,xml:s.xml,document:x};R(o);}else{s.document=x;r(s);}});};O.prototype._parseSource=function(s){return this._oMetadata.loaded().then(function(){s.annotations=A.parse(this._oMetadata,s.document,s.data);delete s.document;return s;}.bind(this));};O.prototype._mergeSource=function(s){a(typeof s.annotations==="object","Source must contain an annotation object to be merged");A.merge(this._mAnnotations,s.annotations);return s;};O.prototype._getHeaders=function(){return e({"sap-cancel-on-close":true},this.getHeaders(),{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()});};return O;});
