/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding","./SubmitMode","./lib/_GroupLock","./lib/_Helper","./lib/_MetadataRequestor","./lib/_Parser","./lib/_Requestor","sap/base/assert","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/core/library","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI"],function(O,a,b,c,S,_,d,e,f,g,h,L,i,j,M,B,k,l,m,U){"use strict";var r=/^\w+$/,C="sap.ui.model.odata.v4.ODataModel",E=["$count","$expand","$filter","$levels","$orderby","$search","$select"],n=/^(\$auto(\.\w+)?|\$direct|\w+)$/,o=j.MessageType,p=[undefined,o.Success,o.Information,o.Warning,o.Error],s={messageChange:true,sessionTimeout:true},q={annotationURI:true,autoExpandSelect:true,earlyRequests:true,groupId:true,groupProperties:true,httpHeaders:true,metadataUrlParams:true,odataVersion:true,operationMode:true,serviceUrl:true,sharedRequests:true,supportReferences:true,synchronizationMode:true,updateGroupId:true},t=["$apply","$count","$expand","$filter","$orderby","$search","$select"],u=/^[ -~]+$/;var v=l.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(P){var G,w,x=sap.ui.getCore().getConfiguration().getLanguageTag(),y,z,A,D,F,H=this;l.call(this);if(!P||P.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}y=P.odataVersion||"4.0";this.sODataVersion=y;if(y!=="4.0"&&y!=="2.0"){throw new Error("Unsupported value for parameter odataVersion: "+y);}for(z in P){if(!(z in q)){throw new Error("Unsupported parameter: "+z);}}A=P.serviceUrl;if(!A){throw new Error("Missing service root URL");}D=new U(A);if(D.path()[D.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(P.operationMode&&P.operationMode!==m.Server){throw new Error("Unsupported operation mode: "+P.operationMode);}this.sOperationMode=P.operationMode;F=this.buildQueryOptions(D.query(true),false,true);this.mUriParameters=F;if(sap.ui.getCore().getConfiguration().getStatistics()){F=Object.assign({"sap-statistics":true},F);}this.sServiceUrl=D.query("").toString();this.sGroupId=P.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}this.checkGroupId(P.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=P.updateGroupId||this.getGroupId();this.mGroupProperties={};for(G in P.groupProperties){H.checkGroupId(G,true);w=P.groupProperties[G];if(typeof w!=="object"||Object.keys(w).length!==1||!(w.submit in S)){throw new Error("Group '"+G+"' has invalid properties: '"+w+"'");}}this.mGroupProperties=d.clone(P.groupProperties)||{};this.mGroupProperties.$auto={submit:S.Auto};this.mGroupProperties.$direct={submit:S.Direct};if(P.autoExpandSelect!==undefined&&typeof P.autoExpandSelect!=="boolean"){throw new Error("Value for autoExpandSelect must be true or false");}this.bAutoExpandSelect=P.autoExpandSelect===true;if("sharedRequests"in P&&P.sharedRequests!==true){throw new Error("Value for sharedRequests must be true");}this.bSharedRequests=P.sharedRequests===true;this.mHeaders={"Accept-Language":x};this.mMetadataHeaders={"Accept-Language":x};this.oMetaModel=new b(e.create(this.mMetadataHeaders,y,Object.assign({},F,P.metadataUrlParams)),this.sServiceUrl+"$metadata",P.annotationURI,this,P.supportReferences);this.oInterface={fetchEntityContainer:this.oMetaModel.fetchEntityContainer.bind(this.oMetaModel),fetchMetadata:this.oMetaModel.fetchObject.bind(this.oMetaModel),fireSessionTimeout:function(){H.fireEvent("sessionTimeout");},getGroupProperty:this.getGroupProperty.bind(this),onCreateGroup:function(G){if(H.isAutoGroup(G)){H.addPrerenderingTask(H._submitBatch.bind(H,G,true));}},reportStateMessages:this.reportStateMessages.bind(this),reportTransitionMessages:this.reportTransitionMessages.bind(this)};this.oRequestor=g.create(this.sServiceUrl,this.oInterface,this.mHeaders,F,y);this.changeHttpHeaders(P.httpHeaders);if(P.earlyRequests){this.oMetaModel.fetchEntityContainer(true);this.initializeSecurityToken();}this.aAllBindings=[];this.mSupportedBindingModes={OneTime:true,OneWay:true};if(P.sharedRequests){this.sDefaultBindingMode=B.OneWay;}else{this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes.TwoWay=true;}this.aPrerenderingTasks=null;}});v.prototype._submitBatch=function(G,w){var x=this;return this.oRequestor.submitBatch(G).catch(function(y){x.reportError("$batch failed",C,y);if(!w){throw y;}});};v.prototype.addPrerenderingTask=function(P,F){var R,T,w=this;function x(y){clearTimeout(T);while(y.length){y.shift()();}if(w.aPrerenderingTasks===y){w.aPrerenderingTasks=null;}}if(!this.aPrerenderingTasks){this.aPrerenderingTasks=[];R=x.bind(null,this.aPrerenderingTasks);sap.ui.getCore().addPrerenderingTask(R);T=setTimeout(function(){T=setTimeout(R,0);},0);}if(F){this.aPrerenderingTasks.unshift(P);}else{this.aPrerenderingTasks.push(P);}};v.prototype.attachEvent=function(w,x,y,z){if(!(w in s)){throw new Error("Unsupported event '"+w+"': v4.ODataModel#attachEvent");}return l.prototype.attachEvent.apply(this,arguments);};v.prototype.attachSessionTimeout=function(F,w){return this.attachEvent("sessionTimeout",F,w);};v.prototype.bindContext=function(P,w,x){return new O(this,P,w,x);};v.prototype.bindingCreated=function(w){this.aAllBindings.push(w);};v.prototype.bindingDestroyed=function(w){var I=this.aAllBindings.indexOf(w);if(I<0){throw new Error("Unknown "+w);}this.aAllBindings.splice(I,1);};v.prototype.bindList=function(P,w,x,F,y){return new a(this,P,w,x,F,y);};v.prototype.bindProperty=function(P,w,x){return new c(this,P,w,x);};v.prototype.bindTree=function(w,x,y,z,A){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};v.prototype.buildQueryOptions=function(P,w,x){var y,T=d.clone(P)||{};function z(A,D,F){var G,H,I,V=A[D];if(!w||F.indexOf(D)<0){throw new Error("System query option "+D+" is not supported");}if((D==="$expand"||D==="$select")&&typeof V==="string"){V=f.parseSystemQueryOption(D+"="+V)[D];A[D]=V;}if(D==="$expand"){for(I in V){H=V[I];if(H===null||typeof H!=="object"){H=V[I]={};}for(G in H){z(H,G,E);}}}else if(D==="$count"){if(typeof V==="boolean"){if(!V){delete A.$count;}}else{switch(typeof V==="string"&&V.toLowerCase()){case"false":delete A.$count;break;case"true":A.$count=true;break;default:throw new Error("Invalid value for $count: "+V);}}}}if(P){for(y in P){if(y.startsWith("$$")){delete T[y];}else if(y[0]==="@"){throw new Error("Parameter "+y+" is not supported");}else if(y[0]==="$"){z(T,y,t);}else if(!x&&y.startsWith("sap-")&&!y.startsWith("sap-valid-")){throw new Error("Custom query option "+y+" is not supported");}}}return T;};v.prototype.changeHttpHeaders=function(H){var w,x,y={},z,K;this.oRequestor.checkHeaderNames(H);for(K in H){x=K.toLowerCase();z=H[K];if(y[x]){throw new Error("Duplicate header "+K);}else if(!(typeof z==="string"&&u.test(z)||z===undefined)){throw new Error("Unsupported value for header '"+K+"': "+z);}else{if(x==="x-csrf-token"){K="X-CSRF-Token";}y[x]={key:K,value:z};}}this.oRequestor.checkForOpenRequests();for(K in this.mHeaders){x=K.toLowerCase();w=y[x];if(w){delete this.mHeaders[K];delete this.mMetadataHeaders[K];if(w.value!==undefined){this.mHeaders[w.key]=w.value;this.mMetadataHeaders[w.key]=w.value;}delete y[x];}}for(K in y){w=y[K];if(w.value!==undefined){this.mHeaders[w.key]=w.value;if(K!=="x-csrf-token"){this.mMetadataHeaders[w.key]=w.value;}}}};v.prototype.checkBatchGroupId=function(G){this.checkGroupId(G);if(this.isDirectGroup(G)){throw new Error("Group ID does not use batch requests: "+G);}};v.prototype.checkGroupId=function(G,A,w){if(!A&&G===undefined||typeof G==="string"&&(A?r:n).test(G)){return;}throw new Error((w||"Invalid group ID: ")+G);};v.prototype.createBindingContext=function(P,w){var D,x,y,R,z;function A(y){var F=y.indexOf("."),G=y.indexOf("/");return F>0&&(G<0||F<G);}if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(w&&w.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}R=this.resolve(P,w);if(R===undefined){throw new Error("Cannot create binding context from relative path '"+P+"' without context");}z=R.indexOf("#");if(z>=0){D=R.slice(0,z);y=R.slice(z+1);if(y[0]==="#"){y=y.slice(1);}else if(D.length>1&&y[0]!=="@"&&A(y)){return new k(this,R);}if(y[0]==="/"){y="."+y;}x=this.oMetaModel.getMetaContext(D);return this.oMetaModel.createBindingContext(y,x);}return new k(this,R);};v.prototype.createUI5Message=function(R,w,x){var I=typeof R.target==="string",y=R.longtextUrl,T;function z(A){return A[0]==="/"?A:d.buildPath("/"+w,x,A);}if(I){w=w&&w.split("?")[0];T=[z(R.target)];if(R.additionalTargets){R.additionalTargets.forEach(function(A){T.push(z(A));});}}if(y&&w){y=d.makeAbsolute(y,this.sServiceUrl+w);}return new M({code:R.code,descriptionUrl:y||undefined,message:R.message,persistent:!I||R.transition,processor:this,target:I?T:"",technical:R.technical,technicalDetails:d.createTechnicalDetails(R),type:p[R.numericSeverity]||o.None});};v.prototype.destroy=function(){this.oMetaModel.destroy();this.oRequestor.destroy();this.mHeaders=undefined;this.mMetadataHeaders=undefined;return l.prototype.destroy.apply(this,arguments);};v.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};v.prototype.detachSessionTimeout=function(F,w){return this.detachEvent("sessionTimeout",F,w);};v.prototype.filterMatchingMessages=function(w,P){return d.hasPathPrefix(w,P)?this.mMessages[w]:[];};v.prototype.getAllBindings=function(){return this.aAllBindings.slice();};v.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};v.prototype.getDependentBindings=function(P){return this.aAllBindings.filter(function(w){var x=w.getContext();return w.isRelative()&&(x===P||x&&x.getBinding&&x.getBinding()===P);});};v.prototype.getGroupId=function(){return this.sGroupId;};v.prototype.getGroupProperty=function(G,P){switch(P){case"submit":if(G.startsWith("$auto.")){return S.Auto;}return this.mGroupProperties[G]?this.mGroupProperties[G].submit:S.API;default:throw new Error("Unsupported group property: '"+P+"'");}};v.prototype.getHttpHeaders=function(I){var H=Object.assign({},this.mHeaders);if(!I){delete H["SAP-ContextId"];}if(H["X-CSRF-Token"]===null){delete H["X-CSRF-Token"];}return H;};v.prototype.getMessages=function(w){return this.getMessagesByPath(w.getPath(),true).sort(M.compare);};v.prototype.getMetaModel=function(){return this.oMetaModel;};v.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};v.prototype.getODataVersion=function(){return this.sODataVersion;};v.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};v.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};v.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};v.prototype.getReporter=function(){var w=this;return function(x){if(!x.$reported){w.reportError(x.message,C,x);}};};v.prototype.hasPendingChanges=function(G){if(G!==undefined){this.checkBatchGroupId(G);if(this.isAutoGroup(G)&&this.oRequestor.hasPendingChanges("$parked."+G)){return true;}}return this.oRequestor.hasPendingChanges(G);};v.prototype.initializeSecurityToken=function(){this.oRequestor.refreshSecurityToken().catch(function(){});};v.prototype.isApiGroup=function(G){return this.getGroupProperty(G,"submit")===S.API;};v.prototype.isAutoGroup=function(G){return this.getGroupProperty(G,"submit")===S.Auto;};v.prototype.isDirectGroup=function(G){return this.getGroupProperty(G,"submit")===S.Direct;};v.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};v.prototype.lockGroup=function(G,w,x,y,z){return this.oRequestor.lockGroup(G,w,x,y,z);};v.prototype.refresh=function(G){if(typeof G==="boolean"){throw new Error("Unsupported parameter bForceUpdate");}this.checkGroupId(G);this.getBindings().forEach(function(w){if(w.isRoot()){w.refresh(w.isSuspended()?undefined:G);}});};v.prototype.reportError=function(w,R,x){var D;if(x.canceled==="noDebugLog"){return;}D=x.stack.includes(x.message)?x.stack:x.message+"\n"+x.stack;if(x.canceled){L.debug(w,D,R);return;}L.error(w,D,R);if(x.$reported){return;}x.$reported=true;this.reportTransitionMessages(d.extractMessages(x),x.resourcePath);};v.prototype.reportStateMessages=function(R,P,w){var D="/"+R,N=[],x=[],y=this;Object.keys(P).forEach(function(z){P[z].forEach(function(A){N.push(y.createUI5Message(A,R,z));});});(w||[""]).forEach(function(z){var A=d.buildPath(D,z);Object.keys(y.mMessages).forEach(function(F){if(F===A||F.startsWith(A+"/")||F.startsWith(A+"(")){x=x.concat(y.mMessages[F].filter(function(G){return!G.persistent;}));}});});if(N.length||x.length){this.fireMessageChange({newMessages:N,oldMessages:x});}};v.prototype.reportTransitionMessages=function(w,R){var x=this;if(w&&w.length){this.fireMessageChange({newMessages:w.map(function(y){y.transition=true;return x.createUI5Message(y,R);})});}};v.prototype.requestCanonicalPath=function(w){h(w.getModel()===this,"oEntityContext must belong to this model");return w.requestCanonicalPath();};v.prototype.requestSideEffects=function(G,A){if(!A.length){return undefined;}return i.all(this.aAllBindings.filter(function(w){return w.isRoot();}).map(function(R){return R.requestAbsoluteSideEffects(G,A);}));};v.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;this.checkBatchGroupId(G);if(this.isAutoGroup(G)){this.oRequestor.cancelChanges("$parked."+G);}this.oRequestor.cancelChanges(G);this.aAllBindings.forEach(function(w){if(G===w.getUpdateGroupId()){w.resetInvalidDataState();}});};v.prototype.resolve=function(P,w){var R;if(P&&P[0]==="/"){R=P;}else if(w){R=w.getPath();if(P){if(!R.endsWith("/")){R+="/";}R+=P;}}if(R&&R!=="/"&&R[R.length-1]==="/"&&!R.includes("#")){R=R.slice(0,R.length-1);}return R;};v.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};v.prototype.submitBatch=function(G){var w=this;this.checkBatchGroupId(G);if(this.isAutoGroup(G)){this.oRequestor.relocateAll("$parked."+G,G);}else{this.oRequestor.addChangeSet(G);}return new Promise(function(x){w.addPrerenderingTask(function(){x(w._submitBatch(G));});});};v.prototype.toString=function(){return C+": "+this.sServiceUrl;};v.prototype.withUnresolvedBindings=function(w,P){return this.aAllBindings.filter(function(x){return!x.isResolved();}).some(function(x){return x[w](P);});};return v;});
