/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/base/SyncPromise","sap/ui/model/odata/ODataUtils"],function(_,a,b,L,c,S,O){"use strict";var C="sap.ui.model.odata.v4.lib._Cache",r=/\(\$uid=[-\w]+\)$/,d=/^\$inactive\./,m="@com.sap.vocabularies.Common.v1.Messages",e=/^-?\d+$/,f=/^([^(]*)(\(.*\))$/;function g(i,p,n,D){if(n.$count!==undefined){s(i,p,n,n.$count+D);}}function h(R,p){return p===""||R===p||R.startsWith(p+"/");}function s(i,p,n,v){if(typeof v==="string"){v=parseInt(v);}a.updateExisting(i,p,n,{$count:v});}function j(R,i,q,n,G,p){this.iActiveUsages=1;this.mChangeListeners={};this.fnGetOriginalResourcePath=G;this.iInactiveSince=Infinity;this.mPatchRequests={};this.oPendingRequestsPromise=null;this.mPostRequests={};this.sReportedMessagesPath=undefined;this.oRequestor=R;this.bSentRequest=false;this.bSortExpandSelect=n;this.setResourcePath(i);this.setQueryOptions(q);this.bSharedRequest=p;}j.prototype._delete=function(G,E,p,i,D,n){var q=p.split("/"),v=q.pop(),I=e.test(v)?Number(v):undefined,P=q.join("/"),t=this;this.checkSharedRequest();this.addPendingRequest();return this.fetchValue(_.$cached,P).then(function(u){var w=j.from$skip(v,u),x=v?u[w]||u.$byPredicate[w]:u,H,K=a.getPrivateAnnotation(x,"predicate"),y=a.buildPath(P,Array.isArray(u)?K:v),T=a.getPrivateAnnotation(x,"transient");if(T===true){throw new Error("No 'delete' allowed while waiting for server response");}if(T){t.oRequestor.removePost(T,x);return undefined;}if(x["$ui5.deleting"]){throw new Error("Must not delete twice: "+E);}x["$ui5.deleting"]=true;H={"If-Match":i||x};E+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return S.all([G&&t.oRequestor.request("DELETE",E,G.getUnlockedCopy(),H,undefined,undefined,undefined,undefined,a.buildPath(t.getOriginalResourcePath(x),y)).catch(function(z){if(z.status!==404){delete x["$ui5.deleting"];throw z;}}),I===undefined&&!D&&t.requestCount(G),G&&G.unlock()]).then(function(){if(Array.isArray(u)){n(t.removeElement(u,I,K,P),u);}else{if(v){a.updateExisting(t.mChangeListeners,P,u,j.makeUpdateData([v],null));}else{x["$ui5.deleted"]=true;}n();}t.oRequestor.getModelInterface().reportStateMessages(t.sResourcePath,{},[y]);});}).finally(function(){t.removePendingRequest();});};j.prototype.addPendingRequest=function(){var R;if(!this.oPendingRequestsPromise){this.oPendingRequestsPromise=new S(function(i){R=i;});this.oPendingRequestsPromise.$count=0;this.oPendingRequestsPromise.$resolve=R;}this.oPendingRequestsPromise.$count+=1;};j.prototype.calculateKeyPredicate=function(i,t,M){var p,T=t[M];if(T&&T.$Key){p=a.getKeyPredicate(i,M,t);if(p){a.setPrivateAnnotation(i,"predicate",p);}}return p;};j.prototype.checkSharedRequest=function(){if(this.bSharedRequest){throw new Error(this+" is read-only");}};j.prototype.create=function(G,p,P,t,E,i,n){var q=this.getValue(P),u=G.getGroupId(),K=E&&E["@$ui5.keepTransientPath"],v,w=this;function x(){a.removeByPath(w.mPostRequests,P,E);q.splice(q.indexOf(E),1);q.$created-=1;if(!E["@$ui5.context.isInactive"]){w.iActiveElements-=1;g(w.mChangeListeners,P,q,-1);}delete q.$byPredicate[t];if(!P){w.adjustReadRequests(0,-1);}G.cancel();}function y(){w.addPendingRequest();a.setPrivateAnnotation(E,"transient",true);n();}function z(A,B){a.setPrivateAnnotation(E,"transient",u);a.addByPath(w.mPostRequests,P,E);return S.all([w.oRequestor.request("POST",A,B,null,v,y,x,undefined,a.buildPath(w.sResourcePath,P,t)),w.fetchTypes()]).then(function(R){var D=R[0],F,H;a.deletePrivateAnnotation(E,"postBody");a.deletePrivateAnnotation(E,"transient");E["@$ui5.context.isTransient"]=false;a.removeByPath(w.mPostRequests,P,E);w.visitResponse(D,R[1],a.getMetaPath(a.buildPath(w.sMetaPath,P)),P+t,K);F=a.getPrivateAnnotation(D,"predicate");if(F){a.setPrivateAnnotation(E,"predicate",F);if(K){F=t;}else{q.$byPredicate[F]=E;a.updateTransientPaths(w.mChangeListeners,t,F);}}H=a.getQueryOptionsForPath(w.mQueryOptions,P).$select;a.updateSelected(w.mChangeListeners,a.buildPath(P,F||t),E,D,H&&H.concat("@odata.etag"));w.removePendingRequest();return E;},function(D){if(D.canceled){throw D;}w.removePendingRequest();i(D);if(w.fetchTypes().isRejected()){throw D;}u=u.replace(d,"");u=w.oRequestor.getGroupSubmitMode(u)==="API"?u:"$parked."+u;return z(A,w.oRequestor.lockGroup(u,w,true,true));});}this.checkSharedRequest();if(!Array.isArray(q)){throw new Error("Create is only supported for collections; '"+P+"' does not reference a collection");}E=a.publicClone(E,true)||{};v=a.merge({},E);a.setPrivateAnnotation(E,"postBody",v);a.setPrivateAnnotation(E,"transientPredicate",t);E["@$ui5.context.isTransient"]=true;if(u.startsWith("$inactive.")){E["@$ui5.context.isInactive"]=true;}else{this.iActiveElements+=1;g(this.mChangeListeners,P,q,1);}q.unshift(E);q.$created+=1;q.$byPredicate=q.$byPredicate||{};q.$byPredicate[t]=E;if(!P){w.adjustReadRequests(0,1);}return p.then(function(A){A+=w.oRequestor.buildQueryString(w.sMetaPath,w.mQueryOptions,true);return z(A,G);});};j.prototype.deregisterChange=function(p,i){if(!this.bSharedRequest){a.removeByPath(this.mChangeListeners,p,i);}};j.prototype.drillDown=function(D,p,G,n){var q=S.resolve(D),E,t,u,T=false,v=this;function w(i,A){L[A?"info":"error"]("Failed to drill-down into "+p+", invalid segment: "+i,v.toString(),C);return undefined;}function x(V,i,P){var y=u.slice(0,P).join("/"),R,z;if(Array.isArray(V)){return w(i,i==="0");}return v.oRequestor.getModelInterface().fetchMetadata(v.sMetaPath+"/"+a.getMetaPath(y)).then(function(A){var B;if(!A){return w(i);}if(A.$Type==="Edm.Stream"){R=V[i+"@odata.mediaReadLink"]||V[i+"@mediaReadLink"];z=v.oRequestor.getServiceUrl();return R||a.buildPath(z+v.sResourcePath,y);}if(!T){B=V[a.getAnnotationKey(V,".Permissions",i)];if(B===0||B==="None"){return undefined;}if(!E&&!Array.isArray(D)){E=D;t=0;}return E&&v.fetchLateProperty(G,E,u.slice(0,t).join("/"),u.slice(t).join("/"),u.slice(t,P).join("/"))||w(i);}if(A.$kind==="NavigationProperty"){return null;}if(!A.$Type.startsWith("Edm.")){return{};}if("$DefaultValue"in A){return A.$Type==="Edm.String"?A.$DefaultValue:a.parseLiteral(A.$DefaultValue,A.$Type,y);}return null;});}if(!p){return q;}u=p.split("/");return u.reduce(function(P,y,i){return P.then(function(V){var I,M,z;if(y==="$count"){return Array.isArray(V)?V.$count:w(y);}if(V===undefined||V===null){return undefined;}if(typeof V!=="object"||y==="@$ui5._"||Array.isArray(V)&&(y[0]==="$"||y==="length")){return w(y);}if(a.hasPrivateAnnotation(V,"predicate")){E=V;t=i;}z=V;T=T||V["@$ui5.context.isTransient"];M=f.exec(y);if(M){if(M[1]){V=V[M[1]];}if(V){V=V.$byPredicate&&V.$byPredicate[M[2]];}}else{I=j.from$skip(y,V);if(n&&I===y&&(V[y]===undefined||V[y]===null)){V[y]={};}V=V[I];}return V===undefined&&y[0]!=="#"&&!y.includes("@")?x(z,y,i+1):V;});},q);};j.prototype.fetchLateProperty=function(G,R,i,n,M){var F,p,q,P,Q,t,u=a.getMetaPath(i),T=this.fetchTypes().getResult(),U=[n],v=this;function w(x,B){var y=a.buildPath(F,B),E=T[y],z;if(!E){E=v.fetchType(T,y).getResult();}if(B){(E.$Key||[]).forEach(function(K){if(typeof K==="object"){K=K[Object.keys(K)[0]];}U.push(a.buildPath(B,K));});U.push(B+"/@odata.etag");U.push(B+"/@$ui5._/predicate");}if(x.$expand){z=Object.keys(x.$expand)[0];w(x.$expand[z],a.buildPath(B,z));}}if(!this.mLateQueryOptions){return undefined;}F=a.buildPath(this.sMetaPath,u);Q=a.intersectQueryOptions(a.getQueryOptionsForPath(this.mLateQueryOptions,i),[n],this.oRequestor.getModelInterface().fetchMetadata,F,{});if(!Q){return undefined;}w(Q);p=a.buildPath(this.sResourcePath,i);t=p+this.oRequestor.buildQueryString(F,Q,false,true);P=this.mPropertyRequestByPath[t];if(!P){q=p+this.oRequestor.buildQueryString(F,this.mQueryOptions,true);P=this.oRequestor.request("GET",q,G.getUnlockedCopy(),undefined,undefined,undefined,undefined,F,undefined,false,Q).then(function(D){v.visitResponse(D,T,F,i);return D;});this.mPropertyRequestByPath[t]=P;}return P.then(function(D){var x=a.getPrivateAnnotation(D,"predicate");if(x&&a.getPrivateAnnotation(R,"predicate")!==x){throw new Error("GET "+t+": Key predicate changed from "+a.getPrivateAnnotation(R,"predicate")+" to "+x);}if(D["@odata.etag"]!==R["@odata.etag"]){throw new Error("GET "+t+": ETag changed");}a.updateSelected(v.mChangeListeners,i,R,D,U);return a.drillDown(R,M.split("/"));}).finally(function(){delete v.mPropertyRequestByPath[t];});};j.prototype.fetchType=function(t,M){var i=this;return this.oRequestor.fetchTypeForPath(M).then(function(T){var n,p=[];if(T){n=i.oRequestor.getModelInterface().fetchMetadata(M+"/"+m).getResult();if(n){T=Object.create(T);T[m]=n;}t[M]=T;(T.$Key||[]).forEach(function(K){if(typeof K==="object"){K=K[Object.keys(K)[0]];p.push(i.fetchType(t,M+"/"+K.slice(0,K.lastIndexOf("/"))));}});return S.all(p).then(function(){return T;});}});};j.prototype.fetchTypes=function(){var p,t,i=this;function n(B,q){if(q&&q.$expand){Object.keys(q.$expand).forEach(function(N){var M=B;N.split("/").forEach(function(u){M+="/"+u;p.push(i.fetchType(t,M));});n(M,q.$expand[N]);});}}if(!this.oTypePromise){p=[];t={};p.push(this.fetchType(t,this.sMetaPath));n(this.sMetaPath,this.mQueryOptions);this.oTypePromise=S.all(p).then(function(){return t;});}return this.oTypePromise;};j.prototype.getDownloadQueryOptions=function(q){return q;};j.prototype.getDownloadUrl=function(p,i){var q=this.mQueryOptions;if(p){q=a.getQueryOptionsForPath(q,p);q=a.merge({},i,q);}return this.oRequestor.getServiceUrl()+a.buildPath(this.sResourcePath,p)+this.oRequestor.buildQueryString(a.buildPath(this.sMetaPath,a.getMetaPath(p)),this.getDownloadQueryOptions(q));};j.prototype.getLateQueryOptions=function(){return this.mLateQueryOptions;};j.prototype.getQueryOptions=function(){return this.mQueryOptions;};j.prototype.getValue=function(i){throw new Error("Unsupported operation");};j.prototype.getOriginalResourcePath=function(E){return this.fnGetOriginalResourcePath&&this.fnGetOriginalResourcePath(E)||this.sResourcePath;};j.prototype.getResourcePath=function(){return this.sResourcePath;};j.prototype.hasChangeListeners=function(){return!c(this.mChangeListeners);};j.prototype.hasPendingChangesForPath=function(p,i,I){var t=this;return Object.keys(this.mPatchRequests).some(function(R){return h(R,p)&&!(i&&t.mPatchRequests[R].every(function(P){return P.$isKeepAlive();}));})||!I&&Object.keys(this.mPostRequests).some(function(R){return h(R,p)&&t.mPostRequests[R].some(function(E){return!E["@$ui5.context.isInactive"];});});};j.prototype.hasSentRequest=function(){return this.bSentRequest;};j.prototype.patch=function(p,D){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,p).then(function(i){a.updateExisting(t.mChangeListeners,p,i,D);return i;});};j.prototype.refreshSingle=function(G,p,i,P,K,D){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,p).then(function(E){var q=Object.assign({},a.getQueryOptionsForPath(t.mQueryOptions,p)),R;if(i!==undefined){P=a.getPrivateAnnotation(E[i],"predicate");}R=a.buildPath(t.sResourcePath,p,P);if(K&&t.mLateQueryOptions){a.aggregateExpandSelect(q,t.mLateQueryOptions);}delete q.$apply;delete q.$count;delete q.$filter;delete q.$orderby;delete q.$search;R+=t.oRequestor.buildQueryString(t.sMetaPath,q,false,t.bSortExpandSelect);t.bSentRequest=true;return S.all([t.oRequestor.request("GET",R,G,undefined,undefined,D),t.fetchTypes()]).then(function(n){var u=n[0];t.replaceElement(E,i,P,u,n[1],p);});});};j.prototype.refreshSingleWithRemove=function(G,p,i,P,K,D,n){var t=this;this.checkSharedRequest();return S.all([this.fetchValue(_.$cached,p),this.fetchTypes()]).then(function(R){var E=R[0],q,I,u={},v,w,Q=Object.assign({},a.getQueryOptionsForPath(t.mQueryOptions,p)),x,y=a.buildPath(t.sResourcePath,p),z=[],T=R[1];if(i!==undefined){q=E[i];P=a.getPrivateAnnotation(q,"predicate");}else{q=E.$byPredicate[P];}w=a.getKeyFilter(q,t.sMetaPath,T);I=(Q.$filter?"("+Q.$filter+") and ":"")+w;delete Q.$count;delete Q.$orderby;t.bSentRequest=true;if(K){if(t.mLateQueryOptions){a.aggregateExpandSelect(Q,t.mLateQueryOptions);}u=Object.assign({},Q);u.$filter=I;Q.$filter=w;delete Q.$search;x=y+t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);z.push(t.oRequestor.request("GET",x,G,undefined,undefined,D));if(i!==undefined&&(w!==I||u.$search)){delete u.$select;delete u.$expand;u.$count=true;u.$top=0;v=y+t.oRequestor.buildQueryString(t.sMetaPath,u);z.push(t.oRequestor.request("GET",v,G.getUnlockedCopy()));}}else{Q.$filter=I;x=y+t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);z.push(t.oRequestor.request("GET",x,G,undefined,undefined,D));}return S.all(z).then(function(R){var A=R[0].value,B=R[1]&&R[1]["@odata.count"]==="0";if(A.length>1){throw new Error("Unexpected server response, more than one entity returned.");}else if(A.length===0){t.removeElement(E,i,P,p);t.oRequestor.getModelInterface().reportStateMessages(t.sResourcePath,{},[p+P]);n(false);}else if(B){t.removeElement(E,i,P,p);t.replaceElement(E,undefined,P,A[0],T,p);n(true);}else{t.replaceElement(E,i,P,A[0],T,p);}});});};j.prototype.registerChange=function(p,i){if(!this.bSharedRequest){a.addByPath(this.mChangeListeners,p,i);}};j.prototype.removeElement=function(E,i,p,P){var n,t;n=E.$byPredicate[p];if(i!==undefined){i=j.getElementIndex(E,p,i);E.splice(i,1);g(this.mChangeListeners,P,E,-1);}delete E.$byPredicate[p];t=a.getPrivateAnnotation(n,"transientPredicate");if(t){E.$created-=1;if(!P){this.iActiveElements-=1;}delete E.$byPredicate[t];}else if(!P){if(i!==undefined){this.iLimit-=1;this.adjustReadRequests(i,-1);}}return i;};j.prototype.removeMessages=function(){if(this.sReportedMessagesPath){this.oRequestor.getModelInterface().reportStateMessages(this.sReportedMessagesPath,{});this.sReportedMessagesPath=undefined;}};j.prototype.removePendingRequest=function(){if(this.oPendingRequestsPromise){this.oPendingRequestsPromise.$count-=1;if(!this.oPendingRequestsPromise.$count){this.oPendingRequestsPromise.$resolve();this.oPendingRequestsPromise=null;}}};j.prototype.replaceElement=function(E,i,p,n,t,P){var q,T;if(i===undefined){E.$byPredicate[p]=n;}else{i=j.getElementIndex(E,p,i);q=E[i];E[i]=E.$byPredicate[p]=n;T=a.getPrivateAnnotation(q,"transientPredicate");if(T){n["@$ui5.context.isTransient"]=false;E.$byPredicate[T]=n;a.setPrivateAnnotation(n,"transientPredicate",T);}}this.visitResponse(n,t,a.getMetaPath(a.buildPath(this.sMetaPath,P)),P+p);};j.prototype.requestCount=function(G){var E,q,R,t=this;if(this.mQueryOptions&&this.mQueryOptions.$count){q=Object.assign({},this.mQueryOptions);delete q.$expand;delete q.$orderby;delete q.$select;E=this.getFilterExcludingCreated();if(E){q.$filter=q.$filter?"("+q.$filter+") and "+E:E;}q.$top=0;R=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,q);return this.oRequestor.request("GET",R,G.getUnlockedCopy()).catch(function(i){if(i.cause&&i.cause.status===404){return t.oRequestor.request("GET",R,G.getUnlockedCopy());}throw i;}).then(function(i){var n=parseInt(i["@odata.count"])+t.iActiveElements;s(t.mChangeListeners,"",t.aElements,n);t.iLimit=n;});}};j.prototype.resetChangesForPath=function(p){var t=this;Object.keys(this.mPatchRequests).forEach(function(R){var P,i;if(h(R,p)){P=t.mPatchRequests[R];for(i=P.length-1;i>=0;i-=1){t.oRequestor.removePatch(P[i]);}delete t.mPatchRequests[R];}});Object.keys(this.mPostRequests).forEach(function(R){var E,T,i;if(h(R,p)){E=t.mPostRequests[R];for(i=E.length-1;i>=0;i-=1){T=a.getPrivateAnnotation(E[i],"transient");if(!T.startsWith("$inactive.")){t.oRequestor.removePost(T,E[i]);}}}});};j.prototype.setActive=function(A){if(A){this.iActiveUsages+=1;this.iInactiveSince=Infinity;}else{this.iActiveUsages-=1;if(!this.iActiveUsages){this.iInactiveSince=Date.now();}this.mChangeListeners={};}};j.prototype.setLateQueryOptions=function(q){if(q){this.mLateQueryOptions={$select:q.$select,$expand:q.$expand};}else{this.mLateQueryOptions=null;}};j.prototype.setProperty=function(p,v,E){var t=this;this.checkSharedRequest();return this.fetchValue(_.$cached,E,null,null,true).then(function(i){a.updateAll(t.mChangeListeners,E,i,j.makeUpdateData(p.split("/"),v));});};j.prototype.setQueryOptions=function(q,F){this.checkSharedRequest();if(this.bSentRequest&&!F){throw new Error("Cannot set query options: Cache has already sent a request");}this.mQueryOptions=q;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,q,false,this.bSortExpandSelect);};j.prototype.setResourcePath=function(R){this.checkSharedRequest();this.sResourcePath=R;this.sMetaPath=a.getMetaPath("/"+R);this.oTypePromise=undefined;this.mLateQueryOptions=null;this.mPropertyRequestByPath={};};j.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString;};j.prototype.update=function(G,p,v,E,i,n,u,P,q,I){var t,w=p.split("/"),U,x=this;this.checkSharedRequest();try{t=this.fetchValue(_.$cached,n);}catch(y){if(!y.$cached||this.oPromise!==null){throw y;}t=this.oPromise=S.resolve({"@odata.etag":"*"});}return t.then(function(z){var F=a.buildPath(n,p),A=G.getGroupId(),B,D,H,J,T,K,M=j.makeUpdateData(w,v);function N(){a.removeByPath(x.mPatchRequests,F,D);a.updateExisting(x.mChangeListeners,n,z,j.makeUpdateData(w,B));}function Q(R,V){var W={"If-Match":z},X;function Y(){X=x.oRequestor.lockGroup(A,x,true);q();}if(P){W.Prefer="return=minimal";}D=x.oRequestor.request("PATCH",i,R,W,M,Y,N,undefined,a.buildPath(x.getOriginalResourcePath(z),n),V);D.$isKeepAlive=I;a.addByPath(x.mPatchRequests,F,D);return S.all([D,x.fetchTypes()]).then(function(Z){var $=Z[0];a.removeByPath(x.mPatchRequests,F,D);if(!P){x.visitResponse($,Z[1],a.getMetaPath(a.buildPath(x.sMetaPath,n)),n);}a.updateExisting(x.mChangeListeners,n,z,P?{"@odata.etag":$["@odata.etag"]}:$);},function(y){var Z=A;if(!E){N();throw y;}a.removeByPath(x.mPatchRequests,F,D);if(y.canceled){throw y;}E(y);switch(x.oRequestor.getGroupSubmitMode(A)){case"API":break;case"Auto":if(!x.oRequestor.hasChanges(A,z)){Z="$parked."+A;}break;default:throw y;}X.unlock();X=undefined;return Q(x.oRequestor.lockGroup(Z,x,true,true),true);}).finally(function(){if(X){X.unlock();}});}if(!z){throw new Error("Cannot update '"+p+"': '"+n+"' does not exist");}T=a.getPrivateAnnotation(z,"transient");if(T){if(T===true){throw new Error("No 'update' allowed while waiting for server response");}if(T.startsWith("$parked.")||T.startsWith("$inactive.")){J=T;T=T.slice(T.indexOf(".")+1);}if(T!==A){throw new Error("The entity will be created via group '"+T+"'. Cannot patch via group '"+A+"'");}}B=a.drillDown(z,w);H=a.getPrivateAnnotation(z,"postBody");if(H){a.updateAll({},n,H,M);if(z["@$ui5.context.isInactive"]){M["@$ui5.context.isInactive"]=false;x.iActiveElements+=1;g(x.mChangeListeners,"",x.aElements,1);}}a.updateAll(x.mChangeListeners,n,z,M);if(u){U=u.split("/");u=a.buildPath(n,u);K=x.getValue(u);if(K===undefined){L.debug("Missing value for unit of measure "+u+" when updating "+F,x.toString(),C);}else{a.merge(T?H:M,j.makeUpdateData(U,K));}}if(T){if(J){a.setPrivateAnnotation(z,"transient",T);x.oRequestor.relocate(J,H,T);}G.unlock();return Promise.resolve();}x.oRequestor.relocateAll("$parked."+A,A,z);i+=x.oRequestor.buildQueryString(x.sMetaPath,x.mQueryOptions,true);return Q(G);});};j.prototype.visitResponse=function(R,t,n,p,K,q){var u,H=false,P={},v=this.oRequestor.getServiceUrl()+this.sResourcePath,w=this;function x(M,i,B){H=true;if(M&&M.length){P[i]=M;M.forEach(function(D){if(D.longtextUrl){D.longtextUrl=a.makeAbsolute(D.longtextUrl,B);}});}}function y(B,i){return i?a.makeAbsolute(i,B):B;}function z(I,M,B,D){var E={},F,G,J,i;for(i=0;i<I.length;i+=1){G=I[i];F=B===""?q+i:i;if(G&&typeof G==="object"){A(G,M,B,D,F);J=a.getPrivateAnnotation(G,"predicate");if(!B){u.push(J||F.toString());}if(J){E[J]=G;I.$byPredicate=E;}}}}function A(i,M,I,B,D){var E,F,T=t[M],G=T&&T[m]&&T[m].$Path,J;B=y(B,i["@odata.context"]);F=w.calculateKeyPredicate(i,t,M);if(D!==undefined){I=a.buildPath(I,F||D);}else if(!K&&F){E=r.exec(I);if(E){I=I.slice(0,-E[0].length)+F;}}if(p&&!u){u=[I];}if(G){J=a.drillDown(i,G.split("/"));if(J!==undefined){x(J,I,B);}}Object.keys(i).forEach(function(N){var Q,U=M+"/"+N,V=i[N],W=a.buildPath(I,N);if(N.endsWith("@odata.mediaReadLink")||N.endsWith("@mediaReadLink")){i[N]=a.makeAbsolute(V,B);}if(N.includes("@")){return;}if(Array.isArray(V)){V.$created=0;V.$count=undefined;Q=i[N+"@odata.count"];if(Q){s({},"",V,Q);}else if(!i[N+"@odata.nextLink"]){s({},"",V,V.length);}z(V,U,W,y(B,i[N+"@odata.context"]));}else if(V&&typeof V==="object"){A(V,U,W,B);}});}if(q!==undefined){u=[];z(R.value,n||this.sMetaPath,"",y(v,R["@odata.context"]));}else if(R&&typeof R==="object"){A(R,n||this.sMetaPath,p||"",v);}if(H){this.sReportedMessagesPath=this.getOriginalResourcePath(R);this.oRequestor.getModelInterface().reportStateMessages(this.sReportedMessagesPath,P,u);}};function k(R,i,q,n,D,p){j.call(this,R,i,q,n,function(){return D;},p);this.iActiveElements=0;this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$created=0;this.aElements.$tail=undefined;this.iLimit=Infinity;this.aReadRequests=[];this.bServerDrivenPaging=false;this.oSyncPromiseAll=undefined;}k.prototype=Object.create(j.prototype);k.prototype.addKeptElement=function(E){this.aElements.$byPredicate[a.getPrivateAnnotation(E,"predicate")]=E;};k.prototype.adjustReadRequests=function(i,n){this.aReadRequests.forEach(function(R){if(R.iStart>=i){R.iStart+=n;R.iEnd+=n;}});};k.prototype.doReplaceWith=function(i,E){this.aElements[i]=E;this.addKeptElement(E);};k.prototype.fetchValue=function(G,p,i,n,q){var E,F=p.split("/")[0],t,u=this;G.unlock();if(this.aElements.$byPredicate[F]){t=S.resolve();}else if((G===_.$cached||F!=="$count")&&this.aElements[F]!==undefined){t=S.resolve(this.aElements[F]);}else{if(!this.oSyncPromiseAll){E=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=S.all(E);}t=this.oSyncPromiseAll;}return t.then(function(){u.registerChange(p,n);return u.drillDown(u.aElements,p,G,q);});};k.prototype.fill=function(p,q,E){var i,n=Math.max(this.aElements.length,1024);if(E>n){if(this.aElements.$tail&&p){throw new Error("Cannot fill from "+q+" to "+E+", $tail already in use, # of elements is "+this.aElements.length);}this.aElements.$tail=p;E=this.aElements.length;}for(i=q;i<E;i+=1){this.aElements[i]=p;}this.oSyncPromiseAll=undefined;};k.prototype.getFilterExcludingCreated=function(){var E,K,n=[],t,i;for(i=0;i<this.aElements.$created;i+=1){E=this.aElements[i];if(!E["@$ui5.context.isTransient"]){t=t||this.fetchTypes().getResult();K=a.getKeyFilter(E,this.sMetaPath,t);if(K){n.push(K);}}}return n.length?"not ("+n.join(" or ")+")":undefined;};k.prototype.getQueryString=function(){var E=this.getFilterExcludingCreated(),q=Object.assign({},this.mQueryOptions),F=q.$filter,Q=this.sQueryString;if(E){if(F){q.$filter="("+F+") and "+E;Q=this.oRequestor.buildQueryString(this.sMetaPath,q,false,this.bSortExpandSelect);}else{Q+=(Q?"&":"?")+"$filter="+a.encode(E,false);}}return Q;};k.prototype.getResourcePathWithQuery=function(i,E){var n=this.aElements.$created,q=this.getQueryString(),D=q?"&":"?",p=E-i,R=this.sResourcePath+q;if(i<n){throw new Error("Must not request created element");}i-=n;if(i>0||p<Infinity){R+=D+"$skip="+i;}if(p<Infinity){R+="&$top="+p;}return R;};k.prototype.getValue=function(p){var i=this.drillDown(this.aElements,p,_.$cached);if(i.isFulfilled()){return i.getResult();}};k.prototype.handleResponse=function(n,E,R,t){var p,q=this.aElements.$created,u,K,v=-1,w=this.aElements.$count,P,x=R.value.length,i;this.sContext=R["@odata.context"];this.visitResponse(R,t,undefined,undefined,undefined,n);for(i=0;i<x;i+=1){u=R.value[i];P=a.getPrivateAnnotation(u,"predicate");if(P){K=this.aElements.$byPredicate[P];if(K){if(u["@odata.etag"]===K["@odata.etag"]){a.updateNonExisting(K,u);u=K;}else if(this.hasPendingChangesForPath(P)){throw new Error("Modified on client and on server: "+this.sResourcePath+P);}}this.aElements.$byPredicate[P]=u;}this.aElements[n+i]=u;}p=R["@odata.count"];if(p){this.iLimit=v=parseInt(p);}if(R["@odata.nextLink"]){this.bServerDrivenPaging=true;if(E<this.aElements.length){for(i=n+x;i<E;i+=1){delete this.aElements[i];}}else{this.aElements.length=n+x;}}else if(x<E-n){if(v===-1){v=w&&w-this.iActiveElements;}v=Math.min(v!==undefined?v:Infinity,n-q+x);this.aElements.length=q+v;this.iLimit=v;if(!p&&v>0&&!this.aElements[v-1]){v=undefined;}}if(v!==-1){s(this.mChangeListeners,"",this.aElements,v!==undefined?v+this.iActiveElements:undefined);}};k.prototype.read=function(i,n,p,G,D){var E,P=this.oPendingRequestsPromise||this.aElements.$tail,t=this;if(i<0){throw new Error("Illegal index "+i+", must be >= 0");}if(n<0){throw new Error("Illegal length "+n+", must be >= 0");}if(P){return P.then(function(){return t.read(i,n,p,G,D);});}O._getReadIntervals(this.aElements,i,n,this.bServerDrivenPaging?0:p,this.aElements.$created+this.iLimit).forEach(function(I){t.requestElements(I.start,I.end,G.getUnlockedCopy(),D);D=undefined;});G.unlock();E=this.aElements.slice(i,i+n+p);if(this.aElements.$tail&&i+n>this.aElements.length){E.push(this.aElements.$tail);}return S.all(E).then(function(){var q=t.aElements.slice(i,i+n);q.$count=t.aElements.$count;return{"@odata.context":t.sContext,value:q};});};k.prototype.refreshKeptElements=function(G,i){var p=Object.keys(this.aElements.$byPredicate).sort(),t,n=this;function q(){var K,Q=a.merge({},n.mQueryOptions);if(n.mLateQueryOptions){a.aggregateExpandSelect(Q,n.mLateQueryOptions);}delete Q.$count;delete Q.$orderby;delete Q.$search;K=p.map(function(P){return a.getKeyFilter(n.aElements.$byPredicate[P],n.sMetaPath,t);});Q.$filter=K.join(" or ");if(K.length>1){Q.$top=K.length;}return n.sResourcePath+n.oRequestor.buildQueryString(n.sMetaPath,Q,false,true);}if(p.length===0){return undefined;}t=this.fetchTypes().getResult();return this.oRequestor.request("GET",q(),G).then(function(R){var u;n.visitResponse(R,t,undefined,undefined,undefined,0);u=R.value.$byPredicate||{};p.forEach(function(P){if(P in u){a.updateAll(n.mChangeListeners,P,n.aElements.$byPredicate[P],u[P]);}else{delete n.aElements.$byPredicate[P];i(P);}});});};k.prototype.requestElements=function(i,E,G,D){var p,R={iEnd:E,iStart:i},t=this;this.aReadRequests.push(R);this.bSentRequest=true;p=S.all([this.oRequestor.request("GET",this.getResourcePathWithQuery(i,E),G,undefined,undefined,D),this.fetchTypes()]).then(function(n){if(t.aElements.$tail===p){t.aElements.$tail=undefined;}t.handleResponse(R.iStart,R.iEnd,n[0],n[1]);}).catch(function(n){t.fill(undefined,R.iStart,R.iEnd);throw n;}).finally(function(){t.aReadRequests.splice(t.aReadRequests.indexOf(R),1);});this.fill(p,i,E);};k.prototype.requestSideEffects=function(G,p,N,P,q){var E,M=-1,t,Q,u={},R,v,T=this.fetchTypes().getResult(),w=this;this.checkSharedRequest();if(this.oPendingRequestsPromise){return this.oPendingRequestsPromise.then(function(){return w.requestSideEffects(G,p,N,P,q);});}Q=a.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),p,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,N,"",true);if(!Q){return S.resolve();}if(q){E=[this.aElements.$byPredicate[P[0]]];}else{P.forEach(function(i){u[i]=true;});E=this.aElements.filter(function(n,i){var x;if(!n){return false;}if(a.hasPrivateAnnotation(n,"transient")){M=i;return false;}x=a.getPrivateAnnotation(n,"predicate");if(u[x]||a.hasPrivateAnnotation(n,"transientPredicate")){M=i;delete u[x];return true;}delete w.aElements[i];delete w.aElements.$byPredicate[x];return false;});this.aElements.length=M+1;if(!E.length){return S.resolve();}Object.keys(u).forEach(function(i){E.push(w.aElements.$byPredicate[i]);});}Q.$filter=E.map(function(i){return a.getKeyFilter(i,w.sMetaPath,T);}).join(" or ");if(E.length>1){Q.$top=E.length;}a.selectKeyProperties(Q,T[this.sMetaPath]);delete Q.$count;delete Q.$orderby;delete Q.$search;t=a.extractMergeableQueryOptions(Q);R=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,Q,false,true);return this.oRequestor.request("GET",R,G,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,t,this,function(i){if(arguments.length){p=p.concat(i);}else{v=true;return p;}}).then(function(x){var y,z,i,n;function A(B){B=B.slice(z.length+1);return!p.some(function(D){return a.getRelativePath(B,D)!==undefined;});}if(v){return;}if(x.value.length!==E.length){throw new Error("Expected "+E.length+" row(s), but instead saw "+x.value.length);}w.visitResponse(x,T,undefined,"",false,NaN);for(i=0,n=x.value.length;i<n;i+=1){y=x.value[i];z=a.getPrivateAnnotation(y,"predicate");a.updateAll(w.mChangeListeners,z,w.aElements.$byPredicate[z],y,A);}});};k.prototype.reset=function(K){var B=this.aElements.$byPredicate,n=this.mChangeListeners,E,t=0,i,p=this;for(i=0;i<this.aElements.$created;i+=1){E=this.aElements[i];if(a.getPrivateAnnotation(E,"transient")){K.push(a.getPrivateAnnotation(E,"transientPredicate"));this.aElements[t]=E;t+=1;}else{this.iActiveElements-=1;}}this.mChangeListeners={};this.sContext=undefined;this.aElements.length=this.aElements.$created=t;this.aElements.$byPredicate={};this.aElements.$count=undefined;this.iLimit=Infinity;Object.keys(n).forEach(function(P){if(K.includes(P.split("/")[0])){p.mChangeListeners[P]=n[P];}});K.forEach(function(P){p.aElements.$byPredicate[P]=B[P];});};function l(R,i,q){j.call(this,R,i,q);this.oPromise=null;}l.prototype=Object.create(j.prototype);l.prototype._delete=function(){throw new Error("Unsupported");};l.prototype.create=function(){throw new Error("Unsupported");};l.prototype.fetchValue=function(G,i,D,n,p){var t=this;if(p){throw new Error("Unsupported argument: bCreateOnDemand");}if(this.oPromise){G.unlock();}else{this.bSentRequest=true;this.oPromise=S.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,G,undefined,undefined,D,undefined,this.sMetaPath));}return this.oPromise.then(function(R){t.registerChange("",n);return R&&typeof R==="object"?R.value:R;});};l.prototype.update=function(){throw new Error("Unsupported");};function o(R,i,q,n,p,G,P,M){j.call(this,R,i,q,n,G,p);this.sMetaPath=M||this.sMetaPath;this.bPost=P;this.bPosting=false;this.oPromise=null;}o.prototype=Object.create(j.prototype);o.prototype.fetchValue=function(G,p,D,i,n){var R=this.sResourcePath+this.sQueryString,t=this;if(this.oPromise){G.unlock();}else{if(this.bPost){throw new Error("Cannot fetch a value before the POST request");}this.oPromise=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D,undefined,this.sMetaPath),this.fetchTypes()]).then(function(q){t.visitResponse(q[0],q[1]);return q[0];});this.bSentRequest=true;}return this.oPromise.then(function(q){if(q&&q["$ui5.deleted"]){throw new Error("Cannot read a deleted entity");}t.registerChange(p,i);return t.drillDown(q,p,G,n);});};o.prototype.getValue=function(p){var i;if(this.oPromise&&this.oPromise.isFulfilled()){i=this.drillDown(this.oPromise.getResult(),p,_.$cached);if(i.isFulfilled()){return i.getResult();}}};o.prototype.post=function(G,D,E,i,n){var p,H=E?{"If-Match":i&&"@odata.etag"in E?"*":E}:{},q="POST",t=this;function u(v){t.bPosting=true;return S.all([t.oRequestor.request(q,t.sResourcePath+t.sQueryString,v,H,D),t.fetchTypes()]).then(function(R){t.visitResponse(R[0],R[1]);t.bPosting=false;return R[0];},function(w){t.bPosting=false;if(n&&w.strictHandlingFailed){return n(w).then(function(x){var y;if(x){delete H["Prefer"];return u(v.getUnlockedCopy());}y=Error("Action canceled due to strict handling");y.canceled=true;throw y;});}throw w;});}this.checkSharedRequest();if(!this.bPost){throw new Error("POST request not allowed");}if(this.bPosting){throw new Error("Parallel POST requests not allowed");}if(E){p=G.getGroupId();this.oRequestor.relocateAll("$parked."+p,p,E);}if(D){q=D["X-HTTP-Method"]||q;delete D["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&!Object.keys(D).length){D=undefined;}}this.bSentRequest=true;if(n){H["Prefer"]="handling=strict";}this.oPromise=u(G);return this.oPromise;};o.prototype.requestSideEffects=function(G,p,n,R){var M,q,i,t,u=this;this.checkSharedRequest();q=this.oPromise&&a.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),p,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,n);if(!q){return S.resolve();}M=a.extractMergeableQueryOptions(q);R=(R||this.sResourcePath)+this.oRequestor.buildQueryString(this.sMetaPath,q,false,true);i=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,M,this,function(v){if(arguments.length){p=p.concat(v);}else{t=true;return p;}}),this.fetchTypes(),this.fetchValue(_.$cached,"")]).then(function(v){return v;}).then(function(v){var N=v[0],w=v[2];if(t){return;}a.setPrivateAnnotation(N,"predicate",a.getPrivateAnnotation(w,"predicate"));u.visitResponse(N,v[1]);a.updateAll(u.mChangeListeners,"",w,N,function(P){return!p.some(function(x){return a.getRelativePath(P,x)!==undefined;});});});return i;};j.create=function(R,i,q,n,D,p){var t,K,P,u,v;if(p){P=i+R.buildQueryString(a.getMetaPath("/"+i),q,false,n);v=R.$mSharedCollectionCacheByPath;if(!v){v=R.$mSharedCollectionCacheByPath={};}u=v[P];if(u){u.setActive(true);}else{K=Object.keys(v);t=K.length;if(t>100){K.filter(function(w){return!v[w].iActiveUsages;}).sort(function(w,x){return v[w].iInactiveSince-v[x].iInactiveSince;}).every(function(w){delete v[w];t-=1;return t>100;});}u=v[P]=new k(R,i,q,n,D,p);}return u;}return new k(R,i,q,n,D);};j.createProperty=function(R,i,q){return new l(R,i,q);};j.createSingle=function(R,i,q,n,p,G,P,M){return new o(R,i,q,n,p,G,P,M);};j.from$skip=function(i,n){return e.test(i)?(n.$created||0)+Number(i):i;};j.getElementIndex=function(E,K,i){var n=E[i];if(!n||a.getPrivateAnnotation(n,"predicate")!==K){i=E.indexOf(E.$byPredicate[K]);}return i;};j.makeUpdateData=function(p,v){return p.reduceRight(function(V,i){var R={};R[i]=V;return R;},v);};return j;},false);
