/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Batch","./_GroupLock","./_Helper","./_V2Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/thirdparty/jquery"],function(_,a,b,c,L,S,q){"use strict";var B={Accept:"multipart/mixed"},C="sap.ui.model.odata.v4.lib._Requestor",r=/(\$\w+)=~/g,d=/^\d+$/;function g(h){var R;h=h.toLowerCase();for(R in this.headers){if(R.toLowerCase()===h){return this.headers[R];}}}function e(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.aLockedGroupLocks=[];this.oModelInterface=m;this.sQueryParams=b.buildQuery(Q);this.mRunningChangeRequests={};this.iSessionTimer=0;this.iSerialNumber=0;this.sServiceUrl=s;this.vStatistics=Q&&Q["sap-statistics"];this.processSecurityTokenHandlers();}e.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};e.prototype.mPredefinedPartHeaders={Accept:"application/json;odata.metadata=minimal;IEEE754Compatible=true"};e.prototype.mPredefinedRequestHeaders={Accept:"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};e.prototype.mReservedHeaders={accept:true,"accept-charset":true,"content-encoding":true,"content-id":true,"content-language":true,"content-length":true,"content-transfer-encoding":true,"content-type":true,"if-match":true,"if-none-match":true,isolation:true,"odata-isolation":true,"odata-maxversion":true,"odata-version":true,prefer:true,"sap-contextid":true};e.prototype.addChangeSet=function(G){var f=[],R=this.getOrCreateBatchQueue(G);f.iSerialNumber=this.getSerialNumber();R.iChangeSet+=1;R.splice(R.iChangeSet,0,f);};e.prototype.addChangeToGroup=function(o,G){var R;if(this.getGroupSubmitMode(G)==="Direct"){o.$resolve(this.request(o.method,o.url,this.lockGroup(G,this,true,true),o.headers,o.body,o.$submit,o.$cancel));}else{R=this.getOrCreateBatchQueue(G);R[R.iChangeSet].push(o);}};e.prototype.addQueryString=function(R,m,Q){var s;Q=this.convertQueryOptions(m,Q,false,true);R=R.replace(r,function(f,o){var v=Q[o];delete Q[o];return b.encodePair(o,v);});s=b.buildQuery(Q);if(!s){return R;}return R+(R.includes("?")?"&"+s.slice(1):s);};e.prototype.batchRequestSent=function(G,R,h){var p,f;if(h){if(!(G in this.mRunningChangeRequests)){this.mRunningChangeRequests[G]=[];}p=new S(function(i){f=i;});p.$resolve=f;p.$requests=R;this.mRunningChangeRequests[G].push(p);}};e.prototype.batchResponseReceived=function(G,R,h){var p;if(h){p=this.mRunningChangeRequests[G].filter(function(P){if(P.$requests===R){P.$resolve();return false;}return true;});if(p.length){this.mRunningChangeRequests[G]=p;}else{delete this.mRunningChangeRequests[G];}}};e.prototype.buildQueryString=function(m,Q,D,s){return b.buildQuery(this.convertQueryOptions(m,Q,D,s));};e.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);this.cancelGroupLocks(G);};e.prototype.cancelChangesByFilter=function(f,G){var h=false,t=this;function k(s){var l=t.mBatchQueue[s],o,m,E,i,j;for(j=l.length-1;j>=0;j-=1){if(Array.isArray(l[j])){m=l[j];for(i=m.length-1;i>=0;i-=1){o=m[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);m.splice(i,1);h=true;}}}}}if(G){if(this.mBatchQueue[G]){k(G);}}else{for(G in this.mBatchQueue){k(G);}}return h;};e.prototype.cancelGroupLocks=function(G){this.aLockedGroupLocks.forEach(function(o){if((!G||G===o.getGroupId())&&o.isModifying()&&o.isLocked()){o.cancel();}});};e.prototype.checkConflictingStrictRequest=function(R,f,h){function j(l,i){return h!==i&&l.some(k);}function k(R){return R.headers["Prefer"]==="handling=strict";}if(k(R)&&f.slice(0,f.iChangeSet+1).some(j)){throw new Error("All requests with strict handling must belong to the same change set");}};e.prototype.checkForOpenRequests=function(){var t=this;if(Object.keys(this.mRunningChangeRequests).length||Object.keys(this.mBatchQueue).some(function(G){return t.mBatchQueue[G].some(function(R){return Array.isArray(R)?R.length:true;});})||this.aLockedGroupLocks.some(function(G){return G.isLocked();})){throw new Error("Unexpected open requests");}};e.prototype.checkHeaderNames=function(h){var k;for(k in h){if(this.mReservedHeaders[k.toLowerCase()]){throw new Error("Unsupported header: "+k);}}};e.prototype.cleanUpChangeSets=function(R){var f,h=false,i;function j(o){if(!m(o)){f.push(o);}}function m(o){if(o.method!=="PATCH"){return false;}return f.some(function(k){if(k.method==="PATCH"&&k.headers["If-Match"]===o.headers["If-Match"]){b.merge(k.body,o.body);o.$resolve(k.$promise);return true;}});}for(i=R.iChangeSet;i>=0;i-=1){f=[];R[i].forEach(j);if(f.length===0){R.splice(i,1);}else if(f.length===1&&this.isChangeSetOptional()){R[i]=f[0];}else{R[i]=f;}h=h||f.length>0;}return h;};e.prototype.clearSessionContext=function(t){if(t){this.oModelInterface.fireSessionTimeout();}delete this.mHeaders["SAP-ContextId"];if(this.iSessionTimer){clearInterval(this.iSessionTimer);this.iSessionTimer=0;}};e.prototype.convertExpand=function(E,s){var k,R=[],t=this;if(!E||typeof E!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(E);if(s){k=k.sort();}k.forEach(function(f){var v=E[f];if(v&&typeof v==="object"){R.push(t.convertExpandOptions(f,v,s));}else{R.push(f);}});return R.join(",");};e.prototype.convertExpandOptions=function(E,v,s){var f=[];this.doConvertSystemQueryOptions(undefined,v,function(o,O){f.push(o+"="+O);},undefined,s);return f.length?E+"("+f.join(";")+")":E;};e.prototype.convertQueryOptions=function(m,Q,D,s){var f={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){f[k]=v;},D,s);return f;};e.prototype.convertResourcePath=function(R){return R;};e.prototype.destroy=function(){this.clearSessionContext();};e.prototype.doCheckVersionHeader=function(G,R,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+R);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+R);};e.prototype.doConvertResponse=function(R,f){return R;};e.prototype.doConvertSystemQueryOptions=function(f,Q,R,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==="$"){return;}switch(k){case"$expand":if(v!=="~"){v=t.convertExpand(v,s);}break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}R(k,v);});};e.prototype.fetchTypeForPath=function(m,A){return this.oModelInterface.fetchMetadata(m+(A?"/$Type":"/"));};e.prototype.formatPropertyAsLiteral=function(v,p){return b.formatLiteral(v,p.$Type);};e.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.getGroupProperty(G,"submit");};e.prototype.getModelInterface=function(){return this.oModelInterface;};e.prototype.getOrCreateBatchQueue=function(G){var f,R=this.mBatchQueue[G];if(!R){f=[];f.iSerialNumber=0;R=this.mBatchQueue[G]=[f];R.iChangeSet=0;if(this.oModelInterface.onCreateGroup){this.oModelInterface.onCreateGroup(G);}}return R;};e.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},f,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(f){N[f.$Name]=f;});}if(o.$kind==="Function"){for(n in P){f=N[n];if(f){if(f.$isCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],f)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};e.prototype.getSerialNumber=function(){this.iSerialNumber+=1;return this.iSerialNumber;};e.prototype.getServiceUrl=function(){return this.sServiceUrl;};e.prototype.hasChanges=function(G,E){var R=this.mBatchQueue[G];if(R){return R.some(function(v){return Array.isArray(v)&&v.some(function(o){return o.headers["If-Match"]===E;});});}return false;};e.prototype.hasPendingChanges=function(G){var t=this;function f(m){if(!G){return Object.keys(m);}return G in m?[G]:[];}return f(this.mRunningChangeRequests).length>0||this.aLockedGroupLocks.some(function(o){var s=o.getGroupId();return(G===undefined||s===G)&&o.isModifying()&&o.isLocked()&&!s.startsWith("$inactive.");})||f(this.mBatchQueue).some(function(s){return!s.startsWith("$inactive.")&&t.mBatchQueue[s].some(function(R){return Array.isArray(R)&&R.some(function(o){return o.$cancel;});});});};e.prototype.isActionBodyOptional=function(){return false;};e.prototype.isChangeSetOptional=function(){return true;};e.prototype.mergeGetRequests=function(R){var f=[],t=this;function m(o){return o.$queryOptions&&f.some(function(h){if(h.$queryOptions&&o.url===h.url&&o.$owner===h.$owner){b.aggregateExpandSelect(h.$queryOptions,o.$queryOptions);o.$resolve(h.$promise);if(h.$mergeRequests&&o.$mergeRequests){h.$mergeRequests(o.$mergeRequests());}return true;}return false;});}R.forEach(function(o){if(!m(o)){f.push(o);}});f.forEach(function(o){if(o.$queryOptions){o.url=t.addQueryString(o.url,o.$metaPath,o.$queryOptions);}});f.iChangeSet=R.iChangeSet;return f;};e.prototype.processBatch=function(G){var h,R=this.mBatchQueue[G]||[],t=this;function o(i){if(Array.isArray(i)){i.forEach(o);}else if(i.$submit){i.$submit();}}function f(E,i){if(Array.isArray(i)){i.forEach(f.bind(null,E));}else{i.$reject(E);}}function v(R,j){var k;R.forEach(function(l,m){var E,s,n,p=j[m];if(Array.isArray(p)){v(l,p);}else if(!p){E=new Error("HTTP request was not processed because the previous request failed");E.cause=k;E.$reported=true;l.$reject(E);}else if(p.status>=400){p.getResponseHeader=g;k=b.createError(p,"Communication error",l.url?t.sServiceUrl+l.url:undefined,l.$resourcePath);if(Array.isArray(l)){b.decomposeError(k,l,t.sServiceUrl).forEach(function(E,i){l[i].$reject(E);});}else{l.$reject(k);}}else{if(p.responseText){try{t.doCheckVersionHeader(g.bind(p),l.url,true);n=t.doConvertResponse(JSON.parse(p.responseText),l.$metaPath);}catch(u){l.$reject(u);return;}}else{n=l.method==="GET"?null:{};}t.reportHeaderMessages(l.url,g.call(p,"sap-messages"));s=g.call(p,"ETag");if(s){n["@odata.etag"]=s;}l.$resolve(n);}});}delete this.mBatchQueue[G];o(R);h=this.cleanUpChangeSets(R);if(R.length===0){return Promise.resolve();}R=this.mergeGetRequests(R);this.batchRequestSent(G,R,h);return this.sendBatch(R,G).then(function(i){v(R,i);}).catch(function(E){var i=new Error("HTTP request was not processed because $batch failed");i.cause=E;f(i,R);throw E;}).finally(function(){t.batchResponseReceived(G,R,h);});};e.prototype.ready=function(){return S.resolve();};e.prototype.lockGroup=function(G,o,l,m,f){var h;h=new a(G,o,l,m,this.getSerialNumber(),f);if(l){this.aLockedGroupLocks.push(h);}return h;};e.prototype.processSecurityTokenHandlers=function(){var t=this;this.oSecurityTokenPromise=null;sap.ui.getCore().getConfiguration().getSecurityTokenHandlers().some(function(h){var s=h(t.sServiceUrl);if(s!==undefined){t.oSecurityTokenPromise=s.then(function(H){t.checkHeaderNames(H);Object.assign(t.mHeaders,{"X-CSRF-Token":undefined},H);t.oSecurityTokenPromise=null;}).catch(function(E){L.error("An error occurred within security token handler: "+h,E,C);throw E;});return true;}});};e.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(R,f){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:Object.assign({},t.mHeaders,{"X-CSRF-Token":"Fetch"})}).then(function(h,i,j){var s=j.getResponseHeader("X-CSRF-Token");if(s){t.mHeaders["X-CSRF-Token"]=s;}else{delete t.mHeaders["X-CSRF-Token"];}t.oSecurityTokenPromise=null;R();},function(j){t.oSecurityTokenPromise=null;f(b.createError(j,"Could not refresh security token"));});});}return this.oSecurityTokenPromise;};e.prototype.relocate=function(s,o,n){var R=this.mBatchQueue[s],t=this,f=R&&R[0].some(function(h,i){if(h.body===o){t.addChangeToGroup(h,n);R[0].splice(i,1);return true;}});if(!f){throw new Error("Request not found in group '"+s+"'");}};e.prototype.relocateAll=function(s,n,E){var j=0,R=this.mBatchQueue[s],t=this;if(R){R[0].slice().forEach(function(o){if(!E||o.headers["If-Match"]===E){t.addChangeToGroup(o,n);R[0].splice(j,1);}else{j+=1;}});}};e.prototype.removePatch=function(p){var f=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!f){throw new Error("Cannot reset the changes, the batch request is running");}};e.prototype.removePost=function(G,E){var o=b.getPrivateAnnotation(E,"postBody"),f=this.cancelChangesByFilter(function(h){return h.body===o;},G);if(!f){throw new Error("Cannot reset the changes, the batch request is running");}};e.prototype.reportHeaderMessages=function(R,m){if(m){this.oModelInterface.reportTransitionMessages(JSON.parse(m),R);}};e.prototype.request=function(m,R,G,h,p,s,f,M,o,A,Q,O,i){var j,E,k=G&&G.getGroupId()||"$direct",P,l=Infinity,n,t=this;if(k==="$cached"){E=new Error("Unexpected request: "+m+" "+R);E.$cached=true;throw E;}if(G&&G.isCanceled()){if(f){f();}E=new Error("Request already canceled");E.canceled=true;return Promise.reject(E);}if(G){G.unlock();l=G.getSerialNumber();}R=this.convertResourcePath(R);o=o||R;if(this.getGroupSubmitMode(k)!=="Direct"){P=new Promise(function(u,v){var w=t.getOrCreateBatchQueue(k);n={method:m,url:R,headers:Object.assign({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:f,$mergeRequests:i,$metaPath:M,$owner:O,$queryOptions:Q,$reject:v,$resolve:u,$resourcePath:o,$submit:s};if(m==="GET"){w.push(n);}else if(A){w[0].unshift(n);}else{j=w.iChangeSet;while(w[j].iSerialNumber>l){j-=1;}t.checkConflictingStrictRequest(n,w,j);w[j].push(n);}});n.$promise=P;return P;}if(this.vStatistics!==undefined){Q=Object.assign({"sap-statistics":this.vStatistics},Q);}if(Q){R=t.addQueryString(R,M,Q);}if(s){s();}return this.sendRequest(m,R,Object.assign({},h,this.mFinalHeaders),JSON.stringify(p),o).then(function(u){t.reportHeaderMessages(u.resourcePath,u.messages);return t.doConvertResponse(u.body,M);});};e.prototype.sendBatch=function(R,G){var o=_.serializeBatchRequest(R,this.getGroupSubmitMode(G)==="Auto"?"Group ID: "+G:"Group ID (API): "+G);return this.sendRequest("POST","$batch"+this.sQueryParams,Object.assign(o.headers,B),o.body).then(function(f){if(f.messages!==null){throw new Error("Unexpected 'sap-messages' response header for batch request");}return _.deserializeBatchResponse(f.contentType,f.body);});};e.prototype.sendRequest=function(m,R,h,p,o){var s=this.sServiceUrl+R,t=this;return new Promise(function(f,i){function j(I){var O=t.mHeaders["X-CSRF-Token"];return q.ajax(s,{contentType:h&&h["Content-Type"],data:p,headers:Object.assign({},t.mPredefinedRequestHeaders,t.mHeaders,b.resolveIfMatchHeader(h)),method:m}).then(function(v,k,l){var E=l.getResponseHeader("ETag"),n=l.getResponseHeader("X-CSRF-Token");try{t.doCheckVersionHeader(l.getResponseHeader,R,!v);}catch(u){i(u);return;}if(n){t.mHeaders["X-CSRF-Token"]=n;}t.setSessionContext(l.getResponseHeader("SAP-ContextId"),l.getResponseHeader("SAP-Http-Session-Timeout"));if(!v){v=m==="GET"?null:{};}if(E&&typeof v==="object"){v["@odata.etag"]=E;}f({body:v,contentType:l.getResponseHeader("Content-Type"),messages:l.getResponseHeader("sap-messages"),resourcePath:R});},function(k){var l=k.getResponseHeader("SAP-ContextId"),n=k.getResponseHeader("X-CSRF-Token"),M;if(!I&&k.status===403&&n&&n.toLowerCase()==="required"){t.refreshSecurityToken(O).then(function(){j(true);},i);}else{M="Communication error";if(l){t.setSessionContext(l,k.getResponseHeader("SAP-Http-Session-Timeout"));}else if(t.mHeaders["SAP-ContextId"]){M="Session not found on server";L.error(M,undefined,C);t.clearSessionContext(true);}i(b.createError(k,M,s,o));}});}if(t.oSecurityTokenPromise&&m!=="GET"){t.oSecurityTokenPromise.then(j);}else{j();}});};e.prototype.setSessionContext=function(s,f){var t=d.test(f)?parseInt(f):0,i=Date.now()+30*60*1000,h=this;this.clearSessionContext();if(s){h.mHeaders["SAP-ContextId"]=s;if(t>=60){this.iSessionTimer=setInterval(function(){if(Date.now()>=i){h.clearSessionContext(true);}else{q.ajax(h.sServiceUrl+h.sQueryParams,{method:"HEAD",headers:{"SAP-ContextId":h.mHeaders["SAP-ContextId"]}}).fail(function(j){if(j.getResponseHeader("SAP-Err-Id")==="ICMENOSESSION"){L.error("Session not found on server",undefined,C);h.clearSessionContext(true);}});}},(t-5)*1000);}else if(f!==null){L.warning("Unsupported SAP-Http-Session-Timeout header",f,C);}}};e.prototype.submitBatch=function(G){var f,p,t=this;p=S.all(this.aLockedGroupLocks.map(function(o){return o.waitFor(G);}));f=p.isPending();if(f){L.info("submitBatch('"+G+"') is waiting for locks",null,C);}return p.then(function(){if(f){L.info("submitBatch('"+G+"') continues",null,C);}t.aLockedGroupLocks=t.aLockedGroupLocks.filter(function(o){return o.isLocked();});return t.processBatch(G);});};e.prototype.waitForRunningChangeRequests=function(G){var p=this.mRunningChangeRequests[G];if(p){return p.length>1?S.all(p):p[0];}return S.resolve();};e.create=function(s,m,h,Q,o){var R=new e(s,h,Q,m);if(o==="2.0"){c(R);}return R;};return e;},false);
