/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/core/Control","sap/m/Text","sap/ui/core/format/DateFormat","sap/ui/events/KeyCodes","sap/ui/rta/util/changeVisualization/categories/getVisualizationCategory","sap/ui/fl/Utils","sap/ui/fl/util/resolveBinding"],function(F,J,C,T,D,K,g,a,r){"use strict";var b=C.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}}}},renderer:{apiVersion:2,render:function(R,c){R.openStart("div",c);R.class("sapUiRtaChangeIndicator");R.class("sapUiRtaChangeIndicatorChange");R.style("width",c._getSize()+"px");R.style("height",c._getSize()+"px");R.openEnd();R.openStart("div");R.openEnd();R.renderControl(c.getAggregation("_text"));R.close("div");R.close("div");}},constructor:function(){this._oDetailModel=new J();this._oDetailModel.setDefaultBindingMode("OneWay");C.prototype.constructor.apply(this,arguments);}});b.prototype.init=function(){this._iOldTabIndex=0;this.setAggregation("_text",new T({text:"{= (${changes} || []).length}",visible:"{= (${changes} || []).length > 1}"}).addStyleClass("sapUiRtaChangeIndicatorText"));this.attachBrowserEvent("click",this._onSelect,this);this.attachBrowserEvent("tap",this._onSelect,this);this.attachBrowserEvent("keydown",this._onKeyDown,this);this.attachBrowserEvent("mouseleave",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("focusout",function(){this._toggleHoverStyleClasses(false);},this);this.attachBrowserEvent("mouseover",function(){this._toggleHoverStyleClasses(true);},this);this.attachBrowserEvent("focusin",function(){this._toggleHoverStyleClasses(true);},this);};b.prototype.focus=function(){if(this.getDomRef()){C.prototype.focus.apply(this,arguments);this._bScheduledForFocus=false;}this._bScheduledForFocus=true;};b.prototype._getSize=function(){var o=document.getElementById(this.getOverlayId());var s=o.offsetHeight;return(s>50?50:s)-2;};b.prototype.onAfterRendering=function(){var o=document.getElementById(this.getOverlayId());o.appendChild(this.getDomRef());this.getDomRef().tabIndex=this._iOldTabIndex;if(this._bScheduledForFocus){this.focus();this._toggleHoverStyleClasses(true);}};b.prototype.exit=function(){var d=this.getDomRef();if(d){d.parentNode.removeChild(d);}this.detachBrowserEvent("click",this._onSelect,this);this.detachBrowserEvent("keydown",this._onKeyDown,this);};b.prototype.setChanges=function(c){this.setProperty("changes",c);this._oDetailModel.setData((c||[]).map(this._formatChangesModelItem.bind(this)));};b.prototype._onSelect=function(e){this.focus();e.stopPropagation();this._openDetailPopover();};b.prototype._onKeyDown=function(e){if(e.keyCode===K.ENTER){this._onSelect(e);}this.fireKeyPress({originalEvent:e});};b.prototype._toggleHoverStyleClasses=function(A){var o=sap.ui.getCore().byId(this.getOverlayId());if(o.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return;}var f=A?"addStyleClass":"removeStyleClass";o[f]("sapUiRtaOverlayHover");o[f]("sapUiRtaChangeIndicatorHovered");};b.prototype._formatChangesModelItem=function(c){var A=sap.ui.getCore().byId(c.affectedElementId);var p=Object.keys(c.payload||{}).reduce(function(p,q){var O=c.payload[q];var I=a.isBinding(O);var V=I?r(O,A):O;p[q]=V;return p;},{});var o=sap.ui.getCore().byId(this.getOverlayId());var e=o.getDesignTimeMetadata().getLabel(A);var v=g(c.commandName);var d=v&&v.getDescription(p,e);var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s=c.commandName.charAt(0).toUpperCase()+c.commandName.slice(1);e=e&&"'"+e+"'";var f=("TXT_CHANGEVISUALIZATION_CHANGE_"+c.commandName.toUpperCase());var h=d?d.descriptionText:R.getText(f,e);var i=c.change.getCreation();var j=new Date(i);var k=R.getText("TXT_CHANGEVISUALIZATION_CREATED_IN_SESSION_DATE");var l=i?D.getDateTimeInstance().format(j):k;var m=i?D.getDateTimeInstance({relative:"true"}).format(j):k;var n=d&&d.buttonText;return{id:c.id,change:c,changeTitle:s,description:h,fullDate:l,relativeDate:m,detailButtonText:n};};b.prototype._openDetailPopover=function(){if(!this.getAggregation("_popover")){this._iOldTabIndex=this.getDomRef().getAttribute("tabindex");F.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",controller:this}).then(function(p){p._bOpenedByChangeIndicator=true;this.setAggregation("_popover",p);p.setModel(this._oDetailModel,"details");p.openBy(this);}.bind(this));}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close();}this.getAggregation("_popover").openBy(this);}};b.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();var c=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:c});};return b;});
