/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry"],function(d,a,L,J,C,O,E,K,b,c,P,e,F,R,f,g,h){"use strict";var V={add:["createContainer","addDelegateProperty","reveal","addIFrame"],move:["move"],rename:["rename"],combinesplit:["combine","split"],remove:["remove"]};var i="all";var j={all:"sap-icon://show",add:"sap-icon://add",move:"sap-icon://move",rename:"sap-icon://edit",combinesplit:"sap-icon://combine",remove:"sap-icon://less"};function _(){if(this.oMenuButton){this.oMenuButton.getMenu().close();}}var k=C.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}}},constructor:function(){C.prototype.constructor.apply(this,arguments);this._oChangeIndicatorRegistry=new h({commandCategories:V});this._oTextBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.setModel(new R({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new f({active:this.getIsActive()});this._oChangeVisualizationModel.setDefaultBindingMode("OneWay");this._sSelectedCommandCategory="all";this._bSetModeChanged=false;this._fnOnClickHandler=_.bind(this);}});k.prototype.setRootControlId=function(r){if(this.getRootControlId()&&this.getRootControlId()!==r){this._reset();}this.setProperty("rootControlId",r);};k.prototype._getComponent=function(){return F.getAppComponentForControl(E.getElementInstance(this.getRootControlId()));};k.prototype.setIsActive=function(A){if(A===this.getIsActive()){return;}this.setProperty("isActive",A);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:A});}};k.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();if(this.oRootOverlay){this.oRootOverlay.getDomRef().removeEventListener("click",this._fnOnClickHandler,{capture:true});}};k.prototype._reset=function(){this._oChangeIndicatorRegistry.reset();};k.prototype._updateVisualizationModelMenuData=function(){var l=Object.keys(V).map(function(s){var t=this._getCommandCategoryLabel(s,this._getChangesForCommandCategory(s).length);return{key:s,count:this._getChangesForCommandCategory(s).length,title:t,icon:j[s]};}.bind(this));l.unshift({key:i,count:this._getChangesForCommandCategory(i).length,title:this._getCommandCategoryLabel(i,this._getChangesForCommandCategory(i).length),icon:j[i]});this._updateVisualizationModel({commandCategories:l});};k.prototype._getChangesForCommandCategory=function(s){var r=this._oChangeIndicatorRegistry.getChanges();return r.filter(function(o){return s===i?o.commandCategory!==undefined:s===o.commandCategory;});};k.prototype._getCommandCategoryLabel=function(s,l){var m="TXT_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(m,[l]);};k.prototype._getCommandCategoryButton=function(s){var B="BTN_CHANGEVISUALIZATION_OVERVIEW_"+s.toUpperCase();return this._oTextBundle.getText(B);};k.prototype.onCommandCategorySelection=function(o){var s=o.getParameter("item").getKey();return this._selectCommandCategory(s);};k.prototype._selectCommandCategory=function(s){this._sSelectedCommandCategory=s;var r=this._getChangesForCommandCategory(s);var l=this._getCommandCategoryButton(s);this._updateVisualizationModel({commandCategory:s,commandCategoryText:l});return Promise.all(r.map(function(o){return this._getVisualizationInfo(o).then(function(v){this._oChangeIndicatorRegistry.addVisualizationInfo(o.change.getId(),v);}.bind(this));}.bind(this))).then(function(){this._updateChangeIndicators();this._setFocusedIndicator();}.bind(this));};k.prototype._getVisualizationInfo=function(m){var o=this._getComponent();function l(s){if(!s){return undefined;}return s.map(function(S){var n=typeof S.getId==="function"?S:J.bySelector(S,o);return n&&n.getId();}).filter(Boolean);}return this._getInfoFromChangeHandler(o,m.change).then(function(I){var v=I||{};var A=(l(v.affectedControls||[m.change.getSelector()]));return{affectedElementIds:A,dependentElementIds:l(v.dependentControls)||[],displayElementIds:l(v.displayControls)||A,payload:v.payload};});};k.prototype._getCommandForChange=function(o){var s=o.getDefinition().support.command;if(s){return s;}var l=this._getComponent();var S=J.bySelector(o.getSelector(),l);var m=o.getDependentSelectorList().slice(-1)[0];var n=J.bySelector(m,l);function p(q,A){var r=q.getElement();var s=q.getDesignTimeMetadata().getCommandName(o.getChangeType(),r,A);if(s){return s;}var t=q.getParentElementOverlay();var u=q.getParentAggregationOverlay();if(q.getElement().getId()===S.getId()||!t){return undefined;}return p(t,u&&u.getAggregationName());}return S&&n&&p(O.getOverlay(n));};k.prototype._getInfoFromChangeHandler=function(A,o){var l=J.bySelector(o.getSelector(),A);if(l){var p={modifier:J,appComponent:A,view:F.getViewForControl(l)};var m=b.getControlIfTemplateAffected(o,l,p);return c.getChangeHandler({changeType:o.getChangeType(),element:m.control,modifier:J,layer:o.getLayer()}).then(function(n){if(n&&typeof n.getChangeVisualizationInfo==="function"){return n.getChangeVisualizationInfo(o,A);}return undefined;}).catch(function(v){L.error(v);return undefined;});}return Promise.resolve();};k.prototype._collectChanges=function(){var o=this._getComponent();var p={oComponent:o,selector:o,invalidateCache:false,includeVariants:true,currentLayer:e.CUSTOMER};return P._getUIChanges(p);};k.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(l){var r=this._oChangeIndicatorRegistry.getChangeIds();var o=l.reduce(function(n,p){n[p.getId()]=p;return n;},{});var m=Object.keys(o);d(r,m).forEach(function(s){this._oChangeIndicatorRegistry.removeChange(s);}.bind(this));d(m,r).forEach(function(s){var n=o[s];var p=this._getCommandForChange(n);this._oChangeIndicatorRegistry.registerChange(n,p);}.bind(this));}.bind(this));};k.prototype.selectChange=function(o){var s=o.getParameter("changeId");this._selectChange(s);};k.prototype._selectChange=function(s){var D=this._oChangeIndicatorRegistry.getChange(s).visualizationInfo.dependentElementIds;D.forEach(function(l){var o=O.getOverlay(l).getDomRef();o.scrollIntoViewIfNeeded();o.classList.add("sapUiRtaChangeIndicatorDependent");o.addEventListener("animationend",function(){o.classList.remove("sapUiRtaChangeIndicatorDependent");},{once:true});});};k.prototype._updateVisualizationModel=function(D){this._oChangeVisualizationModel.setData(Object.assign({},this._oChangeVisualizationModel.getData(),D));};k.prototype._updateChangeIndicators=function(){var s=this._oChangeIndicatorRegistry.getChangeIndicatorData();var I={};Object.keys(s).forEach(function(S){var l=s[S];var o=O.getOverlay(S);if(!o||!o.getDomRef()){return undefined;}var m=o.getDomRef().getClientRects()[0]||{left:0,top:0};I[S]={posX:parseInt(m.left),posY:parseInt(m.top),changes:this._filterRelevantChanges(l)};if(!this._oChangeIndicatorRegistry.hasChangeIndicator(S)){this._createChangeIndicator(o,S);}return undefined;}.bind(this));if(!a(I,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:I});}};k.prototype._filterRelevantChanges=function(l){if(!Array.isArray(l)){return l;}var r=this._oChangeVisualizationModel.getData();return l.filter(function(o){return(!o.dependent&&(r.commandCategory==='all'||r.commandCategory===o.commandCategory));});};k.prototype._createChangeIndicator=function(o,s){var l=new g({changes:"{changes}",posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:o.getId(),selectorId:s,selectChange:this.selectChange.bind(this)});l.setModel(this._oChangeVisualizationModel);l.bindElement("/content/"+s);l.setModel(this.getModel("i18n"),"i18n");l.placeAt(sap.ui.getCore().getStaticAreaRef());this._oChangeIndicatorRegistry.registerChangeIndicator(s,l);};k.prototype._setFocusedIndicator=function(){sap.ui.getCore().applyChanges();var v=this._oChangeIndicatorRegistry.getChangeIndicators().filter(function(I){return I.getVisible();}).sort(function(I,o){var D=I.getPosY()-o.getPosY();var l=I.getPosX()-o.getPosX();return D||l;});if(v.length===0){return;}v.forEach(function(I,l){I.getDomRef().tabIndex=l+2;});v[0].focus();};k.prototype.triggerModeChange=function(r,t){this.oMenuButton=t.getControl("toggleChangeVisualizationMenuButton");this.oRootOverlay=O.getOverlay(r);if(this.getIsActive()){this.setIsActive(false);if(this.oRootOverlay){this.oRootOverlay.getDomRef().removeEventListener("click",this._fnOnClickHandler,{capture:true});}return;}if(this.oRootOverlay){this.oRootOverlay.getDomRef().addEventListener("click",this._fnOnClickHandler,{capture:true});}if(!this.getRootControlId()){this.setRootControlId(r);}this.setIsActive(true);this._updateChangeRegistry().then(this._selectCommandCategory.bind(this,this._sSelectedCommandCategory)).then(function(){this._updateVisualizationModelMenuData();t.setModel(this._oChangeVisualizationModel,"visualizationModel");}.bind(this));};return k;});
