/*!
* OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Component","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/library"],function(L,M,E,C,A,a,b,H,c,I,d,D,f,g,R,h,l){"use strict";var j=null;var m=null;var o=new H(g.HIGHLIGHTER_ID);var k=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){c.publish(f.ON_PROGRESS_UPDATE,{currentProgress:i});};M.apply(this,arguments);var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{L.warning("Only one support tool allowed");return m;}}});k.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};k.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(e){t._supportModeConfig=s=s||e.getConfiguration().getSupportMode();c.bSilentMode=s.indexOf("silent")>-1;t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=e;t._oDataCollector=new D(e);t._oCoreFacade=a(e);t._oExecutionScope=null;t._createElementSpies();e.attachLibraryChanged(R._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(i){j=i;j.injectFrame(s);c.allowFrame(j.getCommunicationInfo());});}else{R.updateRuleSets(function(){t.fireEvent("ready");});}},stopPlugin:function(){j._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};k.prototype._createElementSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var e=E.prototype[N];E.prototype[N]=function(){e.apply(this,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){c.publish(f.ON_CORE_STATE_CHANGE);},n);};};s("register");s("deregister");};k.prototype._setCommunicationSubscriptions=function(){c.subscribe(f.VERIFY_CREATE_RULE,function(t){var T=h.deserialize(t),e=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset,r=e.addRule(T);c.publish(f.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:h.serialize(T)});},this);c.subscribe(f.VERIFY_UPDATE_RULE,function(e){var t=h.deserialize(e.updateObj),T=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset,r=T.updateRule(e.oldId,t);c.publish(f.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:h.serialize(t)});},this);c.subscribe(f.DELETE_RULE,function(e){var t=h.deserialize(e),T=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset;T.removeRule(t);},this);c.subscribe(f.OPEN_URL,function(u){var w=window.open(u,"_blank");w.opener=null;w.focus();},this);c.subscribe(f.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);c.subscribe(f.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);c.subscribe(f.TREE_ELEMENT_MOUSE_ENTER,function(e){o.highlight(e);},this);c.subscribe(f.TREE_ELEMENT_MOUSE_OUT,function(){o.hideHighLighter();},this);c.subscribe(f.TOGGLE_FRAME_HIDDEN,function(e){j.toggleHide(e);},this);c.subscribe(f.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);c.subscribe(f.GET_AVAILABLE_COMPONENTS,function(){c.publish(f.POST_AVAILABLE_COMPONENTS,Object.keys(C.registry.all()));},this);c.subscribe(f.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.rulePreset);},this);c.subscribe(f.ON_INIT_ANALYSIS_CTRL,function(){R.updateRuleSets(function(){c.publish(f.POST_APPLICATION_INFORMATION,{versionInfo:sap.ui.getVersionInfo()});this.fireEvent("ready");}.bind(this));},this);c.subscribe(f.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);c.subscribe(f.LOAD_RULESETS,function(e){R.loadAdditionalRuleSets(e.aLibNames);},this);c.subscribe(f.REQUEST_RULES_MODEL,function(e){if(e){c.publish(f.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);c.subscribe(f.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),n=I.getIssuesViewModel(e);c.publish(f.GET_ISSUES,{groupedIssues:e,issuesModel:n});}},this);c.subscribe(f.GET_NON_LOADED_RULE_SETS,function(e){R.fetchNonLoadedRuleSets(e.loadedRulesets);},this);};k.prototype.analyze=function(e,p,i){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}if(typeof p==="string"){p=l.SystemPresets[p];if(!p){L.error("System preset ID is not valid");return;}}e=e||{type:"global"};if(i){this._oAnalysisMetadata=JSON.parse(JSON.stringify(i));}else{this._oAnalysisMetadata=null;}var r;if(p&&p.selections){this._oSelectedRulePreset=p;r=p.selections;if(!p.id||!p.title){L.error("The preset must have an ID and a title");return;}}else{this._oSelectedRulePreset=null;r=p;}r=r||R.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){c.publish(f.POST_MESSAGE,{message:"Set a valid element ID."});return;}c.publish(f.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};k.prototype._isExecutionScopeValid=function(e){var n=sap.ui.getCore(),s=[],p=false,i;if(b.possibleScopes.indexOf(e.type)===-1){L.error("Invalid execution scope type. Type must be one of the following: "+b.possibleScopes.join(", "));return false;}if(e.type==="subtree"){if(e.parentId){s.push(e.parentId);}else if(Array.isArray(e.selectors)){s=s.concat(e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(n.byId(s[i])){p=true;break;}}if(!p){return false;}}return true;};k.prototype.setExecutionScope=function(s){this._oExecutionScope=b(this._oCore,s);};k.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(e){var i,n;if(!e.libName||!e.ruleId){L.error("["+g.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}i=R.getRuleSet(e.libName);if(!i||!i.ruleset){L.error("["+g.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+e.libName);return;}n=i.ruleset.getRules();if(!n||!n[e.ruleId]){L.error("["+g.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+e.ruleId+" for library "+e.libName);return;}this._aSelectedRules.push(n[e.ruleId]);this._oSelectedRulesIds[e.ruleId]=true;},this);};k.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};k.prototype._done=function(){c.publish(f.ON_ANALYZE_FINISH,{issues:I.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});d.saveAnalysis(this);};k.prototype._createElementTree=function(){var e=this._copyElementsStructure(),n=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}n.push(e[i]);}return[{content:n,id:"WEBPAGE",name:"WEBPAGE"}];};k.prototype._setContextElementReferences=function(e){var i=E.registry.all();for(var n in e){var p=e[n],q=i[n]==undefined?undefined:i[n].getParent();if(i[n]instanceof sap.ui.core.ComponentContainer){var r=i[n],s=r.getComponent();if(s){p.content.push(e[s]);e[s].skip=true;}}if(q){var t=q.getId();if(!e[t]){continue;}e[t].content.push(e[n]);e[n].skip=true;}}};k.prototype._copyElementsStructure=function(){var e={};var n=function(r,s){for(var i in r){if(Object.prototype.hasOwnProperty.call(r,i)){var t=r[i];var u={content:[],id:t.getId(),name:(s==undefined)?t.getMetadata().getName():s};e[t.getId()]=u;}}};n(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var r=i.getComponent(),s=C.registry.get(r);if(s){n([s],"sap-ui-component");}}});switch(this._oExecutionScope.getType()){case"global":n(this._oCoreFacade.getUIAreas(),"sap-ui-area");n(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;n([E.registry.get(p)]);break;case"components":var q=this._oExecutionScope._getContext().components;q.forEach(function(i){n([C.registry.get(i)],"sap-ui-component");});break;}return e;};k.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=R.getRuleSets(),s=this._oSelectedRulesIds,S=this._oSelectedRulePreset||null;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),rulePreset:S,scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,abap:d.getFormattedHistory(l.HistoryFormats.Abap),name:g.SUPPORT_ASSISTANT_NAME};};k.prototype.getAnalysisHistory=function(){if(this._oAnalyzer.running()){return null;}return d.getHistory();};k.prototype.getFormattedAnalysisHistory=function(F){if(this._oAnalyzer.running()){return"";}return d.getFormattedHistory(F);};k.prototype.getLastAnalysisHistory=function(){var e=this.getAnalysisHistory();if(Array.isArray(e)&&e.length>0){return e[e.length-1];}else{return null;}};k.prototype.addRule=function(r){if(!r){return"No rule provided.";}r.selected=r.selected!==undefined?r.selected:true;r.async=r.async||false;var s=R.getRuleSet(g.TEMP_RULESETS_NAME).ruleset.addRule(r);c.publish(f.VERIFY_RULE_CREATE_RESULT,{result:s,newRule:h.serialize(r)});return s;};var m=new k();return m;},true);
