/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/Version","sap/ui/support/library","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants"],function(L,V,l,s,c){"use strict";var r={};var R=function(S){S=S||{};if(!S.name){L.error("Please provide a name for the RuleSet.");}if(r[S.name]){return r[S.name];}this._oSettings=S;this._mRules={};r[S.name]=this;};R.clearAllRuleSets=function(){r={};};R.prototype.getRules=function(){return this._mRules;};R.prototype.updateRule=function(a,O){var b=this._verifySettingsObject(O,true);if(b==="success"){delete this._mRules[a];this._mRules[O.id]=O;}return b;};R.prototype._verifySettingsObject=function(S,u){if(!S.id){L.error("Support rule needs an id.");return"Support rule needs an unique id.";}if(!u&&this._mRules[S.id]){L.error("Support rule with the id "+S.id+" already exists.");return"Support rule with the id "+S.id+" already exists.";}if(!S.check){L.error("Support rule with the id "+S.id+" needs a check function.");return"Support rule with the id "+S.id+" needs a check function.";}if(!S.title){L.error("Support rule with the id "+S.id+" needs a title.");return"Support rule with the id "+S.id+" needs a title.";}if(!S.description){L.error("Support rule with the id "+S.id+" needs a description.");return"Support rule with the id "+S.id+" needs a description.";}if(!S.resolution&&(!S.resolutionurls||S.resolutionurls.length===0)){L.error("Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function");return"Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function";}if(!S.audiences||S.audiences.length===0){L.error("Support rule with the id "+S.id+" should have an audience. Applying audience ['Control']");S.audiences=[l.Audiences.Control];}if(S.audiences&&S.audiences.forEach){var i=false,a="";S.audiences.forEach(function(b){if(!l.Audiences[b]){i=true;a=b;}});if(i){L.error("Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences");return"Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences";}}if(!S.categories||S.categories.length===0){L.error("Support rule with the id "+S.id+" should have a category. Applying category ['Performance']");S.categories=["Performance"];}if(S.categories&&S.categories.forEach){var I=false,C="";S.categories.forEach(function(b){if(!l.Categories[b]){I=true;C=b;}});if(I){L.error("Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories");return"Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories";}}return"success";};R.prototype.addRule=function(S,v){var C=R.versionInfo?R.versionInfo.version:v.version;var a=S.minversion?S.minversion:'';if(a==='-'){a='';}if(a&&V(C).compareTo(a)<0){return"Rule "+S.id+" should be used with a version >= "+S.minversion;}var b=this._verifySettingsObject(S);if(b==="success"){this._mRules[S.id]=S;S.libName=this._oSettings.name;}return b;};R.prototype.removeRule=function(o){if(this._mRules[o.id]){delete this._mRules[o.id];}};R.storeSelectionOfRules=function(a){var b=R._extractRulesSettingsToSave(a);s.setSelectedRules(b);};R.loadSelectionOfRules=function(a){var b=s.getSelectedRules();if(!b){return;}for(var i=0;i<a.length;i+=1){var d=a[i].rules;var e=a[i].title;for(var f=0;f<d.length;f+=1){if(b[e]&&b[e].hasOwnProperty(d[f].id)){d[f].selected=b[e][d[f].id].selected;}}}};R._extractRulesSettingsToSave=function(a){var o={};var b;var d=a.length;var e;var f;var g;for(var h=0;h<d;h+=1){f=a[h].title;o[f]={};b=a[h].rules;e=b.length;for(var i=0;i<e;i+=1){g={};g.id=b[i].id;g.selected=b[i].selected;o[f][g.id]=g;}}return o;};return R;},true);
