/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils"],function(E,T){"use strict";var a={onAfterRendering:function(){this.attachScrollbar();}};var S=E.extend("sap.ui.table.extensions.ScrollingIOS",{_init:function(t){T.addDelegate(t,a,this);this.attachScrollbar();return"ScrollIOSExtension";},destroy:function(){var t=this.getTable();T.removeDelegate(t,a);clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);E.prototype.destroy.apply(this,arguments);},_attachEvents:function(){var t=this.getTable();T.Hook.register(t,T.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);T.Hook.register(t,T.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this);},_detachEvents:function(){var t=this.getTable();var v=t._getScrollExtension().getVerticalScrollbar();if(v){v.removeEventListener("scroll",this._onVerticalScrollEventHandler);}delete this._onVerticalScrollEventHandler;var V=this.getVerticalScrollbar();if(V){V.removeEventListener("pointerdown",this._onPointerDownEventHandler);}delete this._onPointerDownEventHandler;var o=this.getVerticalScrollbarThumb();if(o){o.removeEventListener("touchmove",this._onTouchMoveEventHandler);}delete this._onTouchMoveEventHandler;T.Hook.deregister(t,T.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);T.Hook.deregister(t,T.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this);}});S.prototype.onUpdateTableSizes=function(){this.updateVerticalScrollbarThumbHeight();this.updateVerticalScrollbarThumbPosition();};S.prototype.onTotalRowCountChanged=function(){this.updateVerticalScrollbarThumbHeight();};S.prototype.attachScrollbar=function(){var t=this.getTable();var v=t._getScrollExtension().getVerticalScrollbar();var V=this.getVerticalScrollbar();var o=this.getVerticalScrollbarThumb();if(!v){return;}if(!V){V=document.createElement("div");V.setAttribute("id",t.getId()+"-vsb-ios");V.classList.add("sapUiTableVSbIOS");o=document.createElement("div");o.classList.add("sapUiTableVSbIOSThumb");V.append(o);v.after(V);}if(!this._onPointerDownEventHandler){this._onPointerDownEventHandler=this.onPointerDown.bind(this);V.addEventListener("pointerdown",this._onPointerDownEventHandler);this._onTouchMoveEventHandler=this.onTouchMove.bind(this);o.addEventListener("touchmove",this._onTouchMoveEventHandler);this._onVerticalScrollEventHandler=this.updateVerticalScrollbarThumbPosition.bind(this);v.addEventListener("scroll",this._onVerticalScrollEventHandler);}this.updateVerticalScrollbar();};S.prototype.getVerticalScrollbar=function(){var t=this.getTable();return t?t.getDomRef("vsb-ios"):null;};S.prototype.getVerticalScrollbarThumb=function(){var v=this.getVerticalScrollbar();return v?v.firstElementChild:null;};S.prototype.updateVerticalScrollbar=function(){var t=this.getTable();var v=this.getVerticalScrollbar();v.style.height=t._getScrollExtension().getVerticalScrollbarHeight()+"px";v.style.top=Math.max(0,t._getRowCounts().fixedTop*t._getBaseRowHeight()-1)+"px";this.updateVerticalScrollbarThumbPosition();this.updateVerticalScrollbarThumbHeight();};S.prototype.updateVerticalScrollbarThumbPosition=function(){var v=this.getVerticalScrollbarThumb();if(v){v.style.top=this.getCalculateThumbOffset()+"px";}};S.prototype.updateVerticalScrollbarThumbHeight=function(){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();if(v){if(s.isVerticalScrollbarRequired()){v.style.height=this.getCalculateThumbHeight()+"px";}else{v.style.height="0";}}};S.prototype.getCalculateThumbHeight=function(){var t=this.getTable();var s=t._getScrollExtension();var v=s.getVerticalScrollbarHeight();var V=s.getVerticalScrollHeight();return Math.round(Math.pow(v,2)/V);};S.prototype.getCalculateThumbOffset=function(){var t=this.getTable();var s=t._getScrollExtension();var v=s.getVerticalScrollbarHeight();var V=s.getVerticalScrollHeight();var o=s.getVerticalScrollbar();var i=o?s.getVerticalScrollbar().scrollTop:0;return Math.round(i*v/V);};S.prototype.onTouchMove=function(e){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();var i=v.getBoundingClientRect().y;var b=this.getCalculateThumbHeight();var c=v.offsetTop+e.touches[0].pageY-i-b/2;var o=Math.min(s.getVerticalScrollbarHeight()-b,Math.max(0,c));e.preventDefault();e.stopPropagation();v.style.top=o+"px";clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);this._iUpdateDefaultScrollbarPositionTimeoutId=setTimeout(function(){this.updateDefaultScrollbarPosition(o,b);delete this._iUpdateDefaultScrollbarPositionTimeoutId;}.bind(this),30);};S.prototype.onPointerDown=function(e){var t=this.getTable();var s=t._getScrollExtension();var v=this.getVerticalScrollbarThumb();var i=v.getBoundingClientRect().y;var b=this.getCalculateThumbHeight();var c=v.offsetTop+e.clientY-i-b/2;var o=Math.min(s.getVerticalScrollbarHeight()-b,Math.max(0,c));e.preventDefault();e.stopPropagation();v.style.top=o+"px";this.updateDefaultScrollbarPosition(o,b);};S.prototype.updateDefaultScrollbarPosition=function(o,t){var b=this.getTable();if(!b){return;}var s=b._getScrollExtension();var i=s.getVerticalScrollbarHeight();if(o+t>=i){s.scrollVerticallyMax(true);}else{var c=o*s.getVerticalScrollHeight()/i;var v=s.getVerticalScrollbar();v.scrollTop=c;}};return S;});
