/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject',"sap/ui/test/_OpaLogger",'sap/ui/thirdparty/jquery',"sap/ui/test/selectors/_ControlSelectorValidator",'sap/ui/test/selectors/_selectors'],function(M,_,$,a,s){"use strict";var b=M.extend("sap.ui.test.selectors._ControlSelectorGenerator");var c=_.getLogger("sap.ui.test.selectors._ControlSelectorGenerator");b._generate=function(o){var p=b._getOrderedGenerators(o.settings);var P=o.includeAll?b._executeAllPlainGenerators(p,o):b._executeTopPlainGenerator(p,o);return P.catch(function(e){if(o.shallow){return Promise.reject(e);}else{return b._generateHierarchicalUp(o).catch(function(){return b._generateHierarchicalDown(o);}).catch(function(){return b._generateWithSibling(o);}).then(function(S){return S;});}});};var D=20;var d=10;b.setParams=function(p){if(p.maxDepth&&Number.isInteger(p.maxDepth)&&p.maxDepth>0){b._maxDepth=p.maxDepth;}if(p.maxWidth&&Number.isInteger(p.maxWidth)&&p.maxWidth>0){b._maxWidth=p.maxWidth;}};b.resetParams=function(i){b._maxDepth=D;b._maxWidth=d;};b.resetParams();b._executeAllPlainGenerators=function(g,o){return Promise.all(g.map(function(G){return b._executeGenerator(G,o);})).then(function(S){S=S.filter(function(v){return v&&!$.isEmptyObject(v)&&(!Array.isArray(v)||v.length);});if(S.length){c.debug("The matching "+(o.multiple?"non-unique":"unique")+" selectors are: "+JSON.stringify(S));return S;}else{return Promise.reject(new Error("Could not generate a selector for control "+o.control));}});};b._executeTopPlainGenerator=function(g,o,i){i=i||0;if(i===g.length){return Promise.reject(new Error("Could not generate a selector for control "+o.control));}return b._executeGenerator(g[i],o).then(function(S){if(S.length){c.debug("The top priority "+(o.multiple?"non-unique":"unique")+" selector is: "+JSON.stringify(S[0]));return S[0];}else{return b._executeTopPlainGenerator(g,o,i+1);}});};b._executeGenerator=function(g,o){var S={};return b._getValidationRootSelector(g,o).then(function(r){S.relative=r;return b._getAncestorSelector(g,o);}).then(function(A){S.ancestor=A;var v=g.generate(o.control,S);return b._filterUnique(v,o);});};b._getValidationRootSelector=function(g,o){o=o||{};return new Promise(function(r,e){if(o.shallow||!g._isValidationRootRequired()){r(null);}else{var v=g._getValidationRoot(o.control);if(v){b._generateUniqueSelectorInSubtree(o.control,v).then(function(S){r(S);}).catch(function(E){e(E);});}else{r(null);}}});};b._getAncestorSelector=function(g,o){o=o||{};return new Promise(function(r,e){if(o.shallow||!g._isAncestorRequired()){r(null);}else{var A=g._getAncestor(o.control);if(A){b._generate({control:A}).then(function(S){r(S);}).catch(function(E){c.debug("Could not generate selector for ancestor "+A+". Error: "+E);r(null);});}else{r(null);}}});};b._generateHierarchicalUp=function(o){return b._generateUniqueAncestorSelector(o.control).then(function(u){return b._generateUniqueSelectorInSubtree(o.control,u.ancestor).then(function(r){return $.extend({},r,{ancestor:u.selector});}).then(b._filterUniqueHierarchical(o));});};b._generateHierarchicalDown=function(o){return b._generate({control:o.control,shallow:true,multiple:true}).then(function(m){return b._generateUniqueDescendantSelector(o.control).then(function(u){return $.extend({},m,{descendant:u});}).then(b._filterUniqueHierarchical(o));});};b._generateWithSibling=function(o){return b._generate({control:o.control,shallow:true,multiple:true}).then(function(t){return b._generateSelectorWithUniqueSibling(o,t);});};b._generateUniqueDescendantSelector=function(C,i){return new Promise(function(r,e){i=i||0;if(i>=b._maxDepth){e(new Error("Could not generate selector for descendant of "+C+". Exceeded limit of "+b._maxDepth+" levels"));}else{var f=b._getAggregatedControls(C.mAggregations);b._generateUniqueSelectorForChild(f).then(function(S){r(S);}).catch(function(){return b._callGenerateUniqueDescendant(f,i+1).then(function(S){r(S);}).catch(function(E){e(E);});});}});};b._callGenerateUniqueDescendant=function(C,i,I){I=I||0;if(I>=C.length){return Promise.reject(new Error("Could not generate unique selector for descendant at level "+i));}return b._generateUniqueDescendantSelector(C[I],i).catch(function(){return b._callGenerateUniqueDescendant(C,i,I+1);});};b._generateUniqueSelectorForChild=function(C,i){i=i||0;if(i>=C.length){return Promise.reject();}return b._generate({control:C[i],shallow:true}).then(function(S){return S;}).catch(function(e){return b._generateUniqueSelectorForChild(C,i+1);});};b._generateUniqueAncestorSelector=function(C,u,i){u=u||C.getParent();i=i||0;var e=i>=b._maxDepth;if(!u||e){return Promise.reject(new Error("Could not generate unique selector for ancestor of "+C+(e?". Exceeded limit of "+b._maxDepth+" levels":"")));}return b._generate({control:u,shallow:true}).then(function(A){return{ancestor:u,selector:A};}).catch(function(E){c.debug("Could not generate selector for ancestor "+u+". Error: "+E);return b._generateUniqueAncestorSelector(C,u.getParent(),i+1);});};b._generateUniqueSelectorInSubtree=function(C,v){return b._generate({control:C,validationRoot:v,shallow:true});};b._generateSelectorWithUniqueSibling=function(o,t){return new Promise(function(r,e){var A;var l=-1;var g=function(){A=A&&A.getParent()||o.control.getParent();l+=1;if(A&&l<b._maxDepth){var S=[];var f=b._getAggregatedControls(A.mAggregations);f.forEach(function(h){if(h!==o.control){S.push(h);S=S.concat(b._getAggregatedControls(h.mAggregations));}});c.debug("Found "+S.length+" siblings at level "+l+" with ancestor "+A);return b._generateSelectorWithUniqueSiblingAtLevel({options:o,targetMultiSelector:t,level:{siblings:S,number:l,width:b._maxWidth}}).then(function(m){r(m);}).catch(function(){return g();});}else{e(new Error("Could not generate unique sibling selector at level "+l));}};g();});};b._generateSelectorWithUniqueSiblingAtLevel=function(o){o.index=o.index||0;if(o.index>=o.level.width||o.index>=o.level.siblings.length){return Promise.reject(new Error("Could not generate unique selector for the first "+o.index+" siblings"));}return b._generate({control:o.level.siblings[o.index],shallow:true}).then(function(u){var S=$.extend({},o.targetMultiSelector,{sibling:[u,{level:o.level.number}]});return b._filterUniqueHierarchical(o.options)(S);}).catch(function(){return b._generateSelectorWithUniqueSiblingAtLevel($.extend(o,{index:o.index+1}));});};b._getAggregatedControls=function(A){var r=[];for(var e in A){var v=A[e];if(Array.isArray(v)){r=r.concat(v.slice(0,b._maxWidth));}else if(v){r.push(v);}}r=r.filter(function(C){return C.getMetadata&&C.getMetadata().getName()&&C.$().length;});return r;};b._filterUnique=function(S,o){o=o||{};var e=[];var f=new a(o.validationRoot,o.multiple);if(Array.isArray(S)){S.forEach(function(v){if(Array.isArray(v)){v.forEach(function(m){if(f._validate(m)){e.push(m);}});}else if(f._validate(v)){e.push(v);}});}else if(f._validate(S)){e.push(S);}return e;};b._filterUniqueHierarchical=function(o){return function(S){c.debug("Found hierarchical selector '"+JSON.stringify(S)+"'. Checking for uniqueness");var e=b._filterUnique(S,o);if(e.length){c.debug("The matching unique selectors are: "+JSON.stringify(e));return Promise.resolve(e[0]);}else{return Promise.reject(new Error("Could not generate a selector for control "+o.control));}};};b._getOrderedGenerators=function(S){var o=["globalID","viewID","labelFor","bindingPath","properties","dropdownItem","tableRowItem","controlType"];if(S&&S.preferViewId){var e=o[0];o[0]=o[1];o[1]=e;}return o.map(function(n){return s[n];});};return b;});
