/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/Popover','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Core','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/CustomYearPicker','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./CalendarMonthIntervalRenderer',"sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(P,D,C,a,L,b,R,c,d,e,H,M,Y,f,g,h,i,j,q,k){"use strict";var l=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"monthsRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});var m={MONTHS_ROW:"monthsRow",YEAR_PICKER:"yearPicker"};l.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=c.getDateInstance({format:"y"});this._oMinDate=d._minDate();this._oMaxDate=d._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};l.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}if(this._oCustomYearPicker){this._oCustomYearPicker.removeDelegate(this._oFocusCYPDelegate);this._oCustomYearPicker.destroy();this._oCustomYearPicker=null;}};l.prototype.onBeforeRendering=function(){var O=this.getAggregation("monthsRow");var Q=this._getFocusedDate();t.call(this);O.displayDate(Q.toLocalJSDate());};l.prototype._setAriaRole=function(O){var Q=this.getAggregation("monthsRow");Q._setAriaRole(O);Q.invalidate();return this;};l.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",z,this);this.setAggregation("header",O);};l.prototype._initializeMonthsRow=function(){var O=new M(this.getId()+"--MonthsRow");O.attachEvent("focus",E,this);O.attachEvent("select",B,this);O._bNoThemeChange=true;this.setAggregation("monthsRow",O);};l.prototype._initilizeYearPicker=function(){var O=this._createYearPicker();this.setAggregation("yearPicker",O);O._setSelectedDatesControlOrigin(this);};l.prototype._createYearPicker=function(){var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",G,this);O.attachEvent("pageChange",N,this);O._oMinDate.setYear(this._oMinDate.getYear());O._oMaxDate.setYear(this._oMaxDate.getYear());return O;};l.prototype._getCalendarPicker=function(){var O;if(!this._oCustomYearPicker){O=new e(this.getId()+"--Cal");O.setPopupMode(true);O.attachEvent("select",F,this);O.attachEvent("cancel",function(Q){this._oPopup.close();var S=this.getAggregation("header").getDomRef("B2");if(S){S.focus();}},this);this._oFocusCYPDelegate={onAfterRendering:function(){this.focus();}};O.addDelegate(this._oFocusCYPDelegate,O);this._oCustomYearPicker=O;}return this._oCustomYearPicker;};l.prototype.setStartDate=function(S){d._checkJSDateObject(S);if(i(this.getStartDate(),S)){return this;}var O=S.getFullYear();d._checkYearInValidRange(O);this.setProperty("startDate",S,true);this._oStartDate=f.fromLocalJSDate(S);this._oStartDate.setDate(1);var Q=this.getAggregation("monthsRow");Q.setStartDate(S);t.call(this);var T=this._getFocusedDate().toLocalJSDate();if(!Q.checkDateFocusable(T)){this._setFocusedDate(this._oStartDate);Q.displayDate(S);}return this;};l.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof k))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(I.bind(this),0);}};l.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("selectedDates");return O;};l.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("selectedDates");return O;};l.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("specialDates");return O;};l.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("specialDates");return O;};l.prototype.setLocale=function(O){if(this._sLocale!=O){this._sLocale=O;this._oLocaleData=undefined;this.invalidate();}return this;};l.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};l.prototype._getFocusedDate=function(){if(!this._oFocusedDate){p.call(this);}return this._oFocusedDate;};l.prototype._setFocusedDate=function(O){d._checkCalendarDate(O);this._oFocusedDate=new f(O);};l.prototype.focusDate=function(O){var Q=false;var S=this.getAggregation("monthsRow");if(O&&!S.checkDateFocusable(O)){J.call(this,f.fromLocalJSDate(O));Q=true;}y.call(this,O,false);if(Q){this.fireStartDateChange();}return this;};l.prototype.displayDate=function(O){y.call(this,O,true);return this;};l.prototype.setMonths=function(O){this.setProperty("months",O,true);O=this._getMonths();var Q=this.getAggregation("monthsRow");Q.setMonths(O);if(!Q.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=n.call(this);this._setFocusedDate(this._oStartDate);Q.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var T=this.getAggregation("yearPicker");var U=Math.floor(O/2);if(U>20){U=20;}T.setYears(U);}t.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};l.prototype._getMonths=function(){var O=this.getMonths();if(D.system.phone&&O>6){return 6;}else{return O;}};l.prototype._getLocaleData=function(){if(!this._oLocaleData){var O=this.getLocale();var Q=new L(O);this._oLocaleData=b.getInstance(Q);}return this._oLocaleData;};l.prototype.setPickerPopup=function(O){var Q;this.setProperty("pickerPopup",O,true);if(O){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}Q=this.getAggregation("yearPicker");Q.setColumns(0);Q.setYears(6);}return this;};l.prototype.setMinDate=function(O){if(i(O,this.getMinDate())){return this;}if(!O){this._oMinDate=d._minDate();}else{d._checkJSDateObject(O);this._oMinDate=f.fromLocalJSDate(O);this._oMinDate.setDate(1);var Q=this._oMinDate.getYear();d._checkYearInValidRange(Q);if(this._oMaxDate.isBefore(this._oMinDate)){j.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=f.fromLocalJSDate(O);this._oMaxDate.setDate(d._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){j.warning("focused date < minDate -> minDate focused",this);this.focusDate(O);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){j.warning("start date < minDate -> minDate set as start date",this);_.call(this,new f(this._oMinDate),true,true);}}this.setProperty("minDate",O,false);if(this.getPickerPopup()){var S=this._getCalendarPicker();S.setMinDate(O);}else{var T=this.getAggregation("yearPicker");T._oMinDate.setYear(this._oMinDate.getYear());}return this;};l.prototype.setMaxDate=function(O){if(i(O,this.getMaxDate())){return this;}if(!O){this._oMaxDate=d._maxDate();}else{d._checkJSDateObject(O);this._oMaxDate=f.fromLocalJSDate(O);this._oMaxDate.setDate(d._daysInMonth(this._oMaxDate));var Q=this._oMaxDate.getYear();d._checkYearInValidRange(Q);if(this._oMinDate.isAfter(this._oMaxDate)){j.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=f.fromLocalJSDate(O);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){j.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(O);}}if(this._oStartDate){var S=new f(this._oStartDate);S.setDate(1);S.setMonth(S.getMonth()+this._getMonths());S.setDate(0);if(S.isAfter(this._oMaxDate)){var T=new f(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isSameOrAfter(this._oMinDate)){j.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,T,true,true);}}}}this.setProperty("maxDate",O,false);if(this.getPickerPopup()){var U=this._getCalendarPicker();U.setMaxDate(O);}else{var V=this.getAggregation("yearPicker");V._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};l.prototype.onclick=function(O){if(O.isMarked("delayedMouseEvent")){return;}if(O.target.id==this.getId()+"-cancel"){this.onsapescape(O);}};l.prototype.onmousedown=function(O){O.preventDefault();O.setMark("cancelAutoClose");};l.prototype.onsapescape=function(O){if(this.getPickerPopup()){A.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:s.call(this);break;}}};l.prototype.onsaptabnext=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){T=this.getAggregation("monthsRow");q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}O.preventDefault();}};l.prototype.onsaptabprevious=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(this._bPoupupMode){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}O.preventDefault();}}else if(O.target.id==Q.getId()+"-B2"){switch(this._iMode){case 0:S=this.getAggregation("monthsRow");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T._oItemNavigation.focusItem(T._oItemNavigation.getFocusedIndex());}break;}O.preventDefault();}};l.prototype.onfocusin=function(O){if(O.target.id==this.getId()+"-end"){var Q=this.getAggregation("header"),S,T;if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");if(T.getDomRef()){q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};l.prototype.onsapfocusleave=function(O){var Q,S;if(!O.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(O.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};l.prototype._handlePrevious=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new f(n.call(this));T.setMonth(T.getMonth()-S);Q.setMonth(Q.getMonth()-S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.previousPage();v.call(this);}break;}};l.prototype._handleNext=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new f(n.call(this));T.setMonth(T.getMonth()+S);Q.setMonth(Q.getMonth()+S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.nextPage();v.call(this);}break;}};l.prototype._showOverlay=function(){this.$("contentOver").css("display","");};l.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};l.prototype._getShowItemHeader=function(){var O=this.getMonths();if(O>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,O,Q){var T=new f(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isBefore(this._oMinDate)){T=new f(this._oMinDate);T.setMonth(T.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new f(this._oMinDate);}else if(S.isAfter(T)){S=T;}S.setDate(1);var U=S.toLocalJSDate();this.setProperty("startDate",U,true);this._oStartDate=S;var V=this.getAggregation("monthsRow");V.setStartDate(U);t.call(this);if(O){var W=this._getFocusedDate().toLocalJSDate();if(!V.checkDateFocusable(W)){this._setFocusedDate(S);V.setDate(U);}else{V.setDate(W);}}if(!Q){this.fireStartDateChange();}}function n(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function o(O){var Q=this._getFocusedDate();var S=this.getAggregation("monthsRow");if(!O){S.setDate(Q.toLocalJSDate());}else{S.displayDate(Q.toLocalJSDate());}t.call(this);}function p(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=f.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new f();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new f(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new f(this._oMaxDate);}}function r(){var O=this._getFocusedDate();var Q=this.getAggregation("yearPicker");this.setProperty("_currentPicker",m.YEAR_PICKER);this._showOverlay();Q.setDate(O.toLocalJSDate());if(this._iMode==0){var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}v.call(this);this._iMode=1;}function s(O){this._iMode=0;this.setProperty("_currentPicker",m.MONTHS_ROW);this._hideOverlay();if(!O){o.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function t(){w.call(this);u.call(this);}function u(){var O=new f(n.call(this));var Q=this._getMonths();var S=O.getYear();var T=this._oMaxDate.getYear();var U=this._oMinDate.getYear();var V=O.getMonth();var W=this._oMaxDate.getMonth();var X=this._oMinDate.getMonth();var Z=this.getAggregation("header");if(S<U||(S==U&&V<=X)){Z.setEnabledPrevious(false);}else{Z.setEnabledPrevious(true);}O.setMonth(O.getMonth()+Q-1);S=O.getYear();V=O.getMonth();if(S>T||(S==T&&V>=W)){Z.setEnabledNext(false);}else{Z.setEnabledNext(true);}}function v(){var O=this.getAggregation("yearPicker");var Q=O.getYears();var S=new f(O.getProperty("_middleDate"));S.setYear(S.getYear()+Math.floor(Q/2));var T=this.getAggregation("header");var U=new f(this._oMaxDate);U.setYear(U.getYear()-Math.ceil(Q/2));U.setMonth(11,31);var V=new f(this._oMinDate);V.setYear(V.getYear()+Math.floor(Q/2)+1);V.setMonth(0,1);T.setEnabledNext(!S.isAfter(U));T.setEnabledPrevious(!S.isBefore(V));}function w(){var T;var S=n.call(this);var O=this._oYearFormat.format(S.toUTCJSDate(),true);var Q=new f(S);Q.setMonth(Q.getMonth()+this._getMonths()-1);var U=this._oYearFormat.format(Q.toUTCJSDate(),true);if(O!=U){var V=this._getLocaleData();var W=V.getIntervalPattern();T=W.replace(/\{0\}/,O).replace(/\{1\}/,U);}else{T=O;}var X=this.getAggregation("header");X.setTextButton2(T);}function x(O,Q){var S;var T=false;if(O.isBefore(this._oMinDate)){S=this._oMinDate;T=true;}else if(O.isAfter(this._oMaxDate)){S=this._oMaxDate;T=true;}else{S=O;}this._setFocusedDate(S);if(T||Q){J.call(this,S);o.call(this,false);this.fireStartDateChange();}}function y(O,S){if(!O){return;}var Q=f.fromLocalJSDate(O);if(this._oFocusedDate&&this._oFocusedDate.isSame(Q)){return;}var T=Q.getYear();d._checkYearInValidRange(T);if(d._isOutside(Q,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(Q);if(this.getDomRef()&&this._iMode==0){o.call(this,S);}}function z(O){var Q;if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){Q=function(){var S=this.getAggregation("yearPicker");S.focus();S.removeDelegate(Q);};r.call(this);this.getAggregation("yearPicker").addDelegate({onAfterRendering:Q},this);}else{s.call(this);}}}l.prototype._showCalendarPicker=function(){var O=this._getFocusedDate(true).toLocalJSDate();var Q=this._getCalendarPicker();var S=new k({startDate:O});var T=f.fromLocalJSDate(O);Q.displayDate(O,false);T.setMonth(0,1);Q._getYearPicker().setProperty("_middleDate",T);Q.removeAllSelectedDates();Q.addSelectedDate(S);Q.setMinDate(this.getMinDate());Q.setMaxDate(this.getMaxDate());K.call(this,Q);this._showOverlay();};function A(O){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!O){o.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function B(O){this.fireSelect();}function E(O){var Q=f.fromLocalJSDate(O.getParameter("date"));var S=O.getParameter("notVisible");x.call(this,Q,S);}function F(O){var Q=new f(this._getFocusedDate());var S=this._getCalendarPicker();var T=S.getSelectedDates()[0].getStartDate();var U=f.fromLocalJSDate(T);U.setMonth(Q.getMonth());U.setDate(Q.getDate());x.call(this,U,true);A.call(this);}function G(O){var Q=new f(this._getFocusedDate());var S=this.getAggregation("yearPicker");var T=f.fromLocalJSDate(S.getDate());var U={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(U);}};var V=this.getAggregation("monthsRow");T.setMonth(Q.getMonth());T.setDate(Q.getDate());Q=T;x.call(this,Q,true);s.call(this);V.addDelegate(U,V);}function I(){this._sInvalidateContent=undefined;var O=this.getAggregation("monthsRow");if(O){O._bDateRangeChanged=true;O._bInvalidateSync=true;O.invalidate();O._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}function J(O){var Q=this.getAggregation("monthsRow");var S=n.call(this);var T=Q._oItemNavigation.getFocusedIndex();S=new f(O);S.setMonth(S.getMonth()-T);_.call(this,S,false,true);}function K(O){if(!this._oPopup){var Q=new P({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});Q.oPopup.setDurations(0,0);Q.addEventDelegate({onsapescape:function(T){this._oCustomYearPicker.onsapescape(T);this._hideOverlay();}},this);this._oPopup=Q;}this._oPopup.addContent(O);this._oPopup.attachAfterClose(function(){this._hideOverlay();},this);this._oPopup.attachAfterOpen(function(){var $=S.$("B2");var T=this._oPopup.$();var U=Math.floor((T.width()-$.width())/2);this._oPopup.setOffsetX(a.getConfiguration().getRTL()?U:-U);var V=$.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?V:-V);},this);var S=this.getAggregation("header");this._oPopup.openBy(S.getDomRef("B2"));}function N(O){v.call(this);}return l;});
