/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/ValueStateSupport','./MenuItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/base/Log','sap/ui/events/PseudoEvents','sap/ui/core/InvisibleText','sap/ui/core/Core','sap/ui/dom/jquery/cursorPos'],function(V,M,l,I,c,D,L,P,a,C){"use strict";var b=c.ValueState;var d=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:b.None}}}});(function(){d.prototype.render=function(r,i,m,o){var e=r,f=m.checkEnabled(i),g=i.getId();e.openStart("li",i);e.class("sapUiMnuItm").class("sapUiMnuTfItm");if(o.iItemNo==1){e.class("sapUiMnuItmFirst");}else if(o.iItemNo==o.iTotalItems){e.class("sapUiMnuItmLast");}if(!m.checkEnabled(i)){e.class("sapUiMnuItmDsbl");}if(i.getStartsSection()){e.class("sapUiMnuItmSepBefore");}if(!f){e.attr("disabled","disabled");}if(o.bAccessible){e.attr("role","menuitem");e.attr("aria-posinset",o.iItemNo);e.attr("aria-setsize",o.iTotalItems);}e.openEnd();e.openStart("div").class("sapUiMnuItmL").openEnd().close("div");e.openStart("div").class("sapUiMnuItmIco").openEnd();if(i.getIcon()){e.icon(i.getIcon(),null,{title:null});}e.close("div");e.openStart("div",g+"-txt").class("sapUiMnuItmTxt").openEnd();e.openStart("label",g+"-lbl").class("sapUiMnuTfItemLbl").openEnd();e.text(i.getLabel());e.close("label");e.openStart("div",g+"-str").class("sapUiMnuTfItmStretch").openEnd().close("div");e.openStart("div").class("sapUiMnuTfItemWrppr").openEnd();e.voidStart("input",g+"-tf").attr("tabindex","-1");if(i.getValue()){e.attr("value",i.getValue());}e.class("sapUiMnuTfItemTf").class(f?"sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTfDsbl");if(!f){e.attr("disabled","disabled");}if(o.bAccessible){e.accessibilityState(i,{role:"textbox",disabled:null,multiline:false,autocomplete:"none",describedby:g+"-lbl "+i._fnInvisibleCountInformationFactory(o).getId()});}e.voidEnd().close("div").close("div");e.openStart("div").class("sapUiMnuItmR").openEnd().close("div");e.close("li");};d.prototype.exit=function(){if(this._invisibleCountInformation){this._fnInvisibleCountInformationFactory().destroy();this._invisibleCountInformation=null;}};d.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);}};d.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$("tf").get(0).focus();}else{m.focus();}};d.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};d.prototype.onsapup=function(e){this.getParent().onsapprevious(e);};d.prototype.onsapdown=function(e){this.getParent().onsapnext(e);};d.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().onsaphome(e);}};d.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().onsapend(e);}};d.prototype.onsappageup=function(e){this.getParent().onsappageup(e);};d.prototype.onsappagedown=function(e){this.getParent().onsappagedown(e);};d.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};d.prototype.onkeydown=function(e){e.stopPropagation();};d.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!D.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};d.prototype.onkeyup=function(e){if(!P.events.sapenter.fnCheck(e)&&e.key!=="Enter"){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};d.prototype.setSubmenu=function(m){L.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};d.prototype.setLabel=function(s){this.setProperty("label",s,true);this.$("lbl").text(s);this._adaptSizes();return this;};d.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};d.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==b.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==b.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());if(t){this.$().attr("title",t);}return this;};d.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};d.prototype._adaptSizes=function(){var $=this.$("tf");var e=this.$("lbl");var o=e.length?e.get(0).offsetLeft:0;if(C.getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(e.outerWidth(true)-e.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+e.outerWidth(true))+"px"});}};d.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var B=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var i=$.val().length;if(r){p=i-p;}if((!B&&p!=i)||(B&&p!=0)){return false;}return true;};d.prototype._fnInvisibleCountInformationFactory=function(i){if(!this._invisibleCountInformation){this._invisibleCountInformation=new a({text:C.getLibraryResourceBundle("sap.ui.unified").getText("UNIFIED_MENU_ITEM_COUNT_TEXT",[i.iItemNo,i.iTotalItems])}).toStatic();}return this._invisibleCountInformation;};}());return d;});
