/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,L,I,a,b,c,d,l,e,f,g,M,h,K,q){"use strict";var j=f.CalendarType;var k=l.CalendarDayType;var m=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},_focusedDate:{type:"object",group:"Data",visibility:"hidden",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});m.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=e.getInstance({pattern:"yyyyMMdd",calendarType:j.Gregorian});this._oFormatLong=e.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=this._handleMouseMove.bind(this);this._iColumns=7;this._aVisibleDays=[];this._bAlwaysShowSpecialDates=false;};m.prototype._getAriaRole=function(){return"gridcell";};m.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}this._aVisibleDays=null;this._bAlwaysShowSpecialDates=null;};m.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()];};m.prototype.onAfterRendering=function(){this.bSpaceButtonPressed=false;_.call(this);s.call(this);};m.prototype.onmouseover=function(E){var t=q(E.target),S=this.getSelectedDates()[0],i,u;if(!this._isMarkingUnfinishedRangeAllowed()){return;}if(!t.hasClass('sapUiCalItemText')&&!t.hasClass('sapUiCalItem')){return;}if(t.hasClass('sapUiCalItemText')){t=t.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()));u=t.data("sapDay");if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:u});}else{this._markDatesBetweenStartAndHoveredDate(i,u);}};m.prototype._markDatesBetweenStartAndHoveredDate=function(t,u){var v,$,w,i;v=this.$().find(".sapUiCalItem");if(t>u){t=t+u;u=t-u;t=t-u;}for(i=0;i<v.length;i++){$=q(v[i]);w=$.data('sapDay');if(w>t&&w<u){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');if(w!=t&&w!=u){$.removeClass('sapUiCalItemSel');}}}};m.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=this._selectDay(this._getDate());if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;r.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}}};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};m.prototype.setDate=function(i){if(i){var t=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.call(this,t);}return this.setProperty("date",i);};m.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};m.prototype.displayDate=function(i){var t=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.call(this,t);return this;};m.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=e.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};m.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this._oFormatSecondaryLong=e.getInstance({style:"long",calendarType:i});return this;};m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S===P){S=undefined;}}return S;};m.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};m.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var t=new g(i);this._oLocaleData=L.getInstance(t);}return this._oLocaleData;};m.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!==i){var t=new g(i);this._oFormatLong=e.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},t);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=e.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},t);}}return this._oFormatLong;};m.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};m.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};m.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};m.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};m.prototype.getPrimaryCalendarType=function(){var P=this.getParent();if(P&&P.getPrimaryCalendarType){return P.getPrimaryCalendarType();}return this.getProperty("primaryCalendarType");};m.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};m.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};m.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};m.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};m.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!Array.isArray(N)){N=[];}return N;};m.prototype._isSpecialDateMarkerEnabled=function(i){var t;if(this.getStartDate){t=this.getStartDate();}else if(this.getDate()){t=this.getDate();}else{t=new Date();}return this._bAlwaysShowSpecialDates||a._isSameMonthAndYear(i,b.fromLocalJSDate(t));};m.prototype._checkDateSelected=function(t){a._checkCalendarDate(t);var S=0,u=this.getSelectedDates(),v=this.getPrimaryCalendarType(),i=0,F=this.getProperty("_focusedDate"),w=false,A;for(i=0;i<u.length;i++){var R=u[i],x=R.getStartDate()?b.fromLocalJSDate(R.getStartDate(),v):undefined,E=R.getEndDate()?b.fromLocalJSDate(R.getEndDate(),v):undefined;if(x&&E){A=this._arrangeStartAndEndDates(x,E);x=A.startDate;E=A.endDate;}w=this._isMarkingUnfinishedRangeAllowed()&&F&&(a._isBetween(t,x,F,true)||a._isBetween(t,F,x,true));if(x&&!E&&t.isSame(x)){S=1;break;}else if(E&&t.isSame(x)){S=2;if(t.isSame(E)){S=5;}break;}else if(E&&t.isSame(E)){S=3;break;}else if((E&&t.isAfter(x)&&t.isBefore(E))||w){S=4;break;}if(this.getSingleSelection()){break;}}return S;};m.prototype._getDateTypes=function(t){a._checkCalendarDate(t);var T,u,N,v=[];var S=this._getSpecialDates();var w=t.toUTCJSDate().getTime();var U=new Date(Date.UTC(0,0,1));for(var i=0;i<S.length;i++){var R=S[i];var x=R.getStartDate();var y=a.MAX_MILLISECONDS;if(x){U.setUTCFullYear(x.getFullYear(),x.getMonth(),x.getDate());y=U.getTime();}var E=R.getEndDate();var z=-a.MAX_MILLISECONDS;if(E){U.setUTCFullYear(E.getFullYear(),E.getMonth(),E.getDate());z=U.getTime();}N=R.getType()===k.NonWorking;if((w===y&&!E)||(w>=y&&w<=z)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString(),color:R.getColor()};v.push(T);}else if(N&&!u){u={type:R.getType(),tooltip:R.getTooltip_AsString()};v.push(u);}if(T&&u){break;}}}return v;};m.prototype._checkDateEnabled=function(t){a._checkCalendarDate(t);var E=true;var u=this.getDisabledDates();var T=t.toUTCJSDate().getTime();var v=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<u.length;i++){var R=u[i];var S=R.getStartDate();var w=0;if(S){S=b.fromLocalJSDate(S,v);w=S.toUTCJSDate().getTime();}var x=R.getEndDate();var y=0;if(x){x=b.fromLocalJSDate(x,v);y=x.toUTCJSDate().getTime();}if(x){if(T>w&&T<y){E=false;break;}}else if(T===w){E=false;break;}}return E;};m.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalItemText")){t=t.parent();}if(this._sLastTargetId&&this._sLastTargetId===t.attr("id")){return;}this._sLastTargetId=t.attr("id");if(t.hasClass("sapUiCalItem")){var O=this._getDate();if(h(this.getDomRef(),E.target)){var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(t.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._oDate=F;var S=this._selectDay(F,true);if(S){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};m.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};if(E.button||D.support.touch||!this._isWeekSelectionAllowed()||!E.target.classList.contains("sapUiCalWeekNum")){return;}var $=q(E.target),i=$.siblings().eq(0).attr("data-sap-day"),P=this._oFormatYyyymmdd.parse(i),F=b.fromLocalJSDate(P,this.getPrimaryCalendarType());this._handleWeekSelection(F,true);};m.prototype.onmouseup=function(E){var N=E.button!==2;if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var t=this._oItemNavigation.getItemDomRefs();for(var i=0;i<t.length;i++){var $=q(t[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")===this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.trigger("focus");break;}}}if(this._bMoveChange){var S=this._selectDay(F);if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;r.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}else if(D.support.touch&&N&&this._areMouseEventCoordinatesInThreshold(E.clientX,E.clientY,10)){var u=E.target.classList,v=(u.contains("sapUiCalItemText")||u.contains("sapUiCalDayName")),w=u.contains("sapUiCalWeekNum"),x=this._getSelectedDateFromEvent(E);if(w&&this._isWeekSelectionAllowed()){this._handleWeekSelection(x,true);}else if(v&&E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(x);}else if(v){this._selectDay(x,false,false);r.call(this);}}};m.prototype.onsapselect=function(E){if(this.bSpaceButtonPressed){return;}var S=this._selectDay(this._getSelectedDateFromEvent(E));if(S){r.call(this);}E.stopPropagation();E.preventDefault();};m.prototype.onkeydown=function(E){if(E.which===K.SPACE){this.bSpaceButtonPressed=true;}};m.prototype.onkeyup=function(E){if(E.which===K.SPACE){this.bSpaceButtonPressed=false;}};m.prototype.onsapselectmodifiers=function(E){var S=this._getSelectedDateFromEvent(E),F;if(this._isWeekSelectionAllowed()&&E.shiftKey&&E.keyCode===K.SPACE){F=a._getFirstDateOfWeek(S);this._handleWeekSelection(F,false);}else if(this._isConsecutiveDaysSelectionAllowed()&&E.shiftKey&&E.keyCode===K.ENTER){this._handleConsecutiveDaysSelection(S);}E.preventDefault();};m.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};m.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};m.prototype._isValueInThreshold=function(R,v,t){var i=R-t,u=R+t;return v>=i&&v<=u;};m.prototype._areMouseEventCoordinatesInThreshold=function(i,t,T){return this._oMousedownPosition&&this._isValueInThreshold(this._oMousedownPosition.clientX,i,T)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t,T)?true:false;};m.prototype._bindMousemove=function(F){q(window.document).on('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};m.prototype._unbindMousemove=function(F){q(window.document).off('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};m.prototype.onThemeChanged=function(){if(this._bNoThemeChange||!this.getDomRef()){return;}var w=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._getLocaleData(),S=this._getFirstWeekDay(),u=t.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType()),W,i;this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;for(i=0;i<w.length;i++){W=w[i];W.textContent=u[(i+S)%7];}s.call(this);};m.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var t=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode===K.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode===K.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":t=F.getMonth()+1;F.setMonth(t);if(t%12!==F.getMonth()){while(t!==F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":t=F.getMonth()-1;F.setMonth(t);if(t<0){t=11;}if(t!==F.getMonth()){while(t!==F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};m.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var t=this._getDate();var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(u,t);};m.prototype.applyFocusInfo=function(i){return this;};m.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};m.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};m.prototype._getVisibleDays=function(S,i){var N,t,u,v,F,w,y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];w=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);v=F.getDay()-w;if(v<0){v=7+v;}if(v>0){F.setDate(1-v);}t=new b(F);N=(S.getMonth()+1)%12;do{y=t.getYear();u=new b(t,this.getPrimaryCalendarType());if(i&&y<1){u._bBeforeFirstYear=true;this._aVisibleDays.push(u);}else if(y>0&&y<10000){this._aVisibleDays.push(u);}t.setDate(t.getDate()+1);}while(t.getMonth()!==N||t.getDay()!==w);return this._aVisibleDays;};m.prototype._handleMousedown=function(E,F){var w=E.target.classList.contains("sapUiCalWeekNum"),i=!E.button,S=this._getSelectedDateFromEvent(E);if(!i||D.support.touch){return this;}if(w){this._isWeekSelectionAllowed()&&this._handleWeekSelection(S,true);return this;}else if(E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(S);return this;}var t=this._selectDay(F);if(t){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(t&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");};m.prototype._getSelectedDateFromEvent=function(E){var t=E.target,i,P;if(t.classList.contains("sapUiCalWeekNum")){i=t.nextSibling.getAttribute("data-sap-day");}else{i=t.getAttribute("data-sap-day")||t.parentNode.getAttribute("data-sap-day");}P=this._oFormatYyyymmdd.parse(i);return P?b.fromLocalJSDate(P,this.getPrimaryCalendarType()):null;};m.prototype._handleWeekSelection=function(S,F){var i=this._calculateWeekNumber(S),E=this._getLastWeekDate(S),t=this.getSingleSelection(),u=this.getIntervalSelection();if(!t&&!u){this._handleWeekSelectionByMultipleDays(i,S,E);}else if(t&&u){this._handleWeekSelectionBySingleInterval(i,S,E);}F&&this._focusDate(S);return this;};m.prototype._handleConsecutiveDaysSelection=function(E){var S=this.getSelectedDates(),i=S.length&&S[S.length-1].getStartDate(),t=i?b.fromLocalJSDate(i):E,u;u=this._areAllDaysBetweenSelected(t,E);this._toggleDaysBetween(t,E,!u);return this;};m.prototype._calculateWeekNumber=function(i){var E=this._getLastWeekDate(i);var t=new g(this._getLocale());var u=this._getLocaleData();var v=e.getInstance({pattern:"w",calendarType:this.getPrimaryCalendarType()},t);var w;var x=u.firstDayStartsFirstWeek();if(i.getMonth()===11&&E.getMonth()===0&&x){w=1;}else{w=v.format(i.toLocalJSDate());}return w;};m.prototype._isWeekSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection(),t=this.getPrimaryCalendarType(),u=this.getFirstDayOfWeek()!==-1,v=!S&&!i,w=S&&i,A=w||v;return t===j.Gregorian&&!u&&A;};m.prototype._isConsecutiveDaysSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection();return!S&&!i;};m.prototype._isMarkingUnfinishedRangeAllowed=function(){var S=this.getSelectedDates()[0],v=!!(S&&S.getStartDate()&&!S.getEndDate());return(this.getIntervalSelection()&&v);};m.prototype._handleWeekSelectionByMultipleDays=function(w,S,E){var i,t,u;i=this._areAllDaysBetweenSelected(S,E)?new c({startDate:S.toLocalJSDate()}):new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()});t=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});u=i.getEndDate()?true:false;if(t){this._toggleDaysBetween(S,E,u);}return this;};m.prototype._handleWeekSelectionBySingleInterval=function(w,S,E){var i=new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()}),t=this.getParent(),A=this,u;if(t&&t.getSelectedDates){A=t;}if(this._isIntervalSelected(i)){i=null;}u=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});if(u){A.removeAllSelectedDates();A.addSelectedDate(i);}return this;};m.prototype._isIntervalSelected=function(i){var S=this.getSelectedDates(),t=S.length&&S[0],u=t&&t.getEndDate();return t&&t.getStartDate()&&t.getStartDate().getTime()===i.getStartDate().getTime()&&u&&t.getEndDate()&&t.getEndDate().getTime()===i.getEndDate().getTime();};m.prototype._getLastWeekDate=function(w){return new b(w).setDate(w.getDate()+6);};m.prototype._toggleDaysBetween=function(S,E,i){var A=this._arrangeStartAndEndDates(S,E),t=new b(A.startDate),u;do{u=this._checkDateSelected(t);if((!u&&i)||(u&&!i)){this._selectDay(t);r.call(this);}t.setDate(t.getDate()+1);}while(t.isSameOrBefore(A.endDate));return this;};m.prototype._areAllDaysBetweenSelected=function(S,E){var A=this._arrangeStartAndEndDates(S,E),i=new b(A.startDate),t=true;do{if(!this._checkDateSelected(i)){t=false;break;}i.setDate(i.getDate()+1);}while(i.isSameOrBefore(A.endDate));return t;};m.prototype._arrangeStartAndEndDates=function(S,E){var A=S.isSameOrBefore(E);return{startDate:A?S:E,endDate:A?E:S};};m.prototype._selectDay=function(t,u){if(!this._checkDateEnabled(t)){return false;}var S=this.getSelectedDates();var v;var w=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var x;var z=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){v=S[0];x=v.getStartDate();if(x){x=b.fromLocalJSDate(x,z);}}else{v=new c();A.addAggregation("selectedDates",v,true);}if(this.getIntervalSelection()&&(!v.getEndDate()||u)&&x){var E;if(t.isBefore(x)){E=x;x=t;if(!u){v.setProperty("startDate",x.toLocalJSDate());v.setProperty("endDate",E.toLocalJSDate());}}else if(t.isSameOrAfter(x)){E=t;if(!u){v.setProperty("endDate",E.toLocalJSDate());}}}else{v.setProperty("startDate",t.toLocalJSDate());v.setProperty("endDate",undefined);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var B=this._checkDateSelected(t);if(B>0){for(i=0;i<S.length;i++){x=S[i].getStartDate();if(x&&t.isSame(b.fromLocalJSDate(x,z))){A.removeAggregation("selectedDates",i,true);break;}}}else{v=new c({startDate:t.toLocalJSDate()});A.addAggregation("selectedDates",v,true);}y=this._oFormatYyyymmdd.format(t.toUTCJSDate(),true);for(i=0;i<w.length;i++){$=q(w[i]);if($.attr("data-sap-day")===y){if(B>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;};m.prototype._getSpecialDates=function(){var P=this.getParent();if(P&&P._getSpecialDates){return P._getSpecialDates();}else{var t=this.getSpecialDates();for(var i=0;i<t.length;i++){var N=t[i].getSecondaryType()===l.CalendarDayType.NonWorking&&t[i].getType()!==l.CalendarDayType.NonWorking;if(N){var u=new d();u.setType(l.CalendarDayType.NonWorking);u.setStartDate(t[i].getStartDate());if(t[i].getEndDate()){u.setEndDate(t[i].getEndDate());}t.push(u);}}return t;}};function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true),t=0,R=this.getDomRef(),u=R.querySelectorAll(".sapUiCalItem");for(var i=0;i<u.length;i++){if(u[i].getAttribute("data-sap-day")===y){t=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,n,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,o,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(u);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(u.length);}function n(t){var u=t.getParameter("index"),E=t.getParameter("event"),O=this._getDate(),F=new b(O,this.getPrimaryCalendarType()),v=false,w=true,x=this._oItemNavigation.getItemDomRefs(),y=x[u],z=y.getAttribute("data-sap-day"),A;if(!E){return;}if(y.classList.contains("sapUiCalItemOtherMonth")||y.classList.contains("sapUiCalItemDsbl")){if(E.type==="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){for(var i=0;i<x.length;++i){A=x[i];if(!(A.classList.contains("sapUiCalItemOtherMonth")||A.classList.contains("sapUiCalItemDsbl"))){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.getAttribute("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else if(E.type==="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(var i=x.length-1;i>0;--i){A=x[i];if(!(A.classList.contains("sapUiCalItemOtherMonth")||A.classList.contains("sapUiCalItemDsbl"))){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.getAttribute("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{v=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type==="mousedown"||(this._sTouchstartYyyyMMdd&&E.type==="focusin"&&this._sTouchstartYyyyMMdd===z)||y.classList.contains("sapUiCalItemDsbl")){w=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}this._sTouchstartYyyyMMdd=E.originalEvent&&(E.originalEvent.type==="touchstart")?z:undefined;}}else{if(E.target.classList.contains("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z),this.getPrimaryCalendarType());this._oDate=F;}this._sTouchstartYyyyMMdd=undefined;}if(E.type==="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=y.id;}if(w){this.fireFocus({date:F.toLocalJSDate(),otherMonth:v});}if(E.type==="mousedown"){this._handleMousedown(E,F,u);}}function o(i){var t=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type==="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var u=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=u[t].id;}this._handleMousedown(E,F,t);}}function p(i){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var t=new b(i);this.setProperty("date",i.toLocalJSDate());this._oDate=t;}else{this.invalidate();}}m.prototype._focusDate=function(t,S,u){if(!S){this.setDate(t.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(t.toUTCJSDate(),true),v=this._oItemNavigation.getItemDomRefs(),w;for(var i=0;i<v.length;i++){w=v[i];if(w.getAttribute("data-sap-day")===y){if(document.activeElement!==v[i]){if(u||D.system.phone){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};function r(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}function s(){if(!this._bNamesLengthChecked){var w,W=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._isMonthNameLong(W),u,S,v,i;if(t){this._bLongWeekDays=false;u=this._getLocaleData();S=this._getFirstWeekDay();v=u.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];w.textContent=v[(i+S)%7];}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}return m;});
