/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log",'sap/ui/core/InvisibleText',"sap/ui/core/format/DateFormat","sap/ui/core/Locale"],function(C,a,b,c,d,l,L,I,D,e){"use strict";var f=l.CalendarDayType;var g=d.CalendarType;var M={apiVersion:2};M.render=function(r,m){var o=this.getStartDate(m),t=m.getTooltip_AsString(),h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),i=m.getId(),A={value:"",append:true},s="",w=m.getWidth();r.openStart("div",m);this.getClass(r,m).forEach(function(j){r.class(j);});if(m._getSecondaryCalendarType()){r.class("sapUiCalMonthSecType");}this.addWrapperAdditionalStyles(r,m);if(t){r.attr("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(m._bCalendar){s+=" "+I.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+I.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT");}if(w){r.style("width",w);}r.accessibilityState(m,{role:"grid",roledescription:h.getText("CALENDAR_DIALOG"),multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A,describedby:s});r.openEnd();if(m.getIntervalSelection()){r.openStart("span",i+"-Start");r.style("display","none");r.openEnd();r.text(h.getText("CALENDAR_START_DATE"));r.close("span");r.openStart("span",i+"-End");r.style("display","none");r.openEnd();r.text(h.getText("CALENDAR_END_DATE"));r.close("span");}this.renderMonth(r,m,o);r.close("div");};M.addWrapperAdditionalStyles=function(){};M.getStartDate=function(m){return m._getDate();};M.getClass=function(r,m){var h=["sapUiCalMonthView"],s=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(s===g.Islamic||!S){h.push("sapUiCalNoWeekNum");}return h;};M.renderMonth=function(r,m,o){this.renderHeader(r,m,o);this.renderDays(r,m,o);};M.renderHeader=function(r,m,o){var h=m._getLocaleData();var F=m._getFirstDayOfWeek();this.renderHeaderLine(r,m,h,o);r.openStart("div");r.accessibilityState(null,{role:"row"});r.style("overflow","hidden");r.openEnd();this.renderDayNames(r,m,h,F,7,true,undefined);r.close("div");};M.renderHeaderLine=function(r,m,o,h){C._checkCalendarDate(h);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var j=o.getMonthsStandAlone("wide",s);r.openStart("div",i+"-Head");r.class("sapUiCalHeadText");r.openEnd();r.text(j[h.getMonth()]);r.close("div");}};M.renderDayNames=function(r,m,o,s,h,j,w){var F=m._getFirstDayOfWeek();var k=m.getId();var n="";var p=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",p);}else{W=o.getDaysStandAlone("narrow",p);}var q=o.getDaysStandAlone("wide",p);if(m.getShowWeekNumbers()&&p!==g.Islamic){this.renderDummyCell(r,"sapUiCalWH",true,"columnheader");}for(var i=0;i<h;i++){if(j){n=k+"-WH"+((i+F)%7);}else{n=k+"-WH"+i;}r.openStart("div",n);r.class("sapUiCalWH");if(i===0){r.class("sapUiCalFirstWDay");}if(w){r.style("width",w);}r.accessibilityState(null,{role:"columnheader",label:q[(i+s)%7]});r.openEnd();r.text(W[(i+s)%7]);r.close("div");}};M.renderDays=function(r,m,o){var w,h,j,H,i,t,s;C._checkCalendarDate(o);if(!o){o=m._getFocusedDate();}t=o.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,o);h=m._getVisibleDays(o,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==g.Islamic&&s;j=h.length;for(i=0;i<j;i++){if(i%7===0){r.openStart("div");r.attr("role","row");r.openEnd();if(w){this._renderWeekNumber(r,h[i],H,m);}}this.renderDay(r,m,h[i],H,true,w,-1);if(i%7===6||i===j-1){r.close("div");}}if(j===28){this.renderDummyCell(r,"sapUiCalItem",false,"");}};M.renderDummyCell=function(r,s,v,R){r.openStart("div");r.class(s);r.class("sapUiCalDummy");r.style("visibility",v?"visible":"hidden");r.attr("role",R);r.attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_WEEK"));r.openEnd();r.close('div');};M.getDayHelper=function(m,o){var h,s,i=m._getLocaleData(),H={sLocale:m._getLocale(),oLocaleData:i,iMonth:o.getMonth(),iYear:o.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:i.getWeekendStart(),iWeekendEnd:i.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:i.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sPrimaryCalendarType:m.getPrimaryCalendarType(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){h=sap.ui.getCore().byId(s);if(h){if(!(h instanceof b)){throw new Error(h+" is not an sap.ui.unified.CalendarLegend. "+m);}H.oLegend=h;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return H;};M.renderDay=function(r,m,o,h,O,w,n,W,j){C._checkCalendarDate(o);var s=new a(o,h.sSecondaryCalendarType),A={role:m._getAriaRole(),selected:false,label:"",describedby:""},B=o._bBeforeFirstYear,k="",p=h.oLegend,N;var y=m._oFormatYyyymmdd.format(o.toUTCJSDate(),true);var q=o.getDay();var S=m._checkDateSelected(o);var t=m._getDateTypes(o);var E=m._checkDateEnabled(o);var i=0;var u=m._isSpecialDateMarkerEnabled(o);if(B){E=false;}r.openStart("div",h.sId+"-"+y);r.class("sapUiCalItem");r.class("sapUiCalWDay"+q);if(W){r.style("width",W);}if(q===h.iFirstDayOfWeek){r.class("sapUiCalFirstWDay");}if(O&&h.iMonth!==o.getMonth()){r.class("sapUiCalItemOtherMonth");A["disabled"]=true;}if(o.isSame(h.oToday)){r.class("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.class("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S===2){r.class("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S===3){r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S===4){r.class("sapUiCalItemSelBetween");}else if(S===5){r.class("sapUiCalItemSelStart");r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(u){t.forEach(function(v){if(v.type!==f.None){if(v.type===f.NonWorking){r.class("sapUiCalItemWeekEnd");N=this._addNonWorkingDayText(A);return;}r.class("sapUiCalItem"+v.type);k=v.type;if(v.tooltip){r.attr('title',v.tooltip);}}}.bind(this));}if(!N){if(h.aNonWorkingDays){h.aNonWorkingDays.forEach(function(v){if(o.getDay()===v){this._addNonWorkingDayText(A);}}.bind(this));}else if(o.getDay()===h.iWeekendStart||o.getDay()===h.iWeekendEnd){this._addNonWorkingDayText(A);}}if(((m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval")||(m.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow"))&&m.getStartDate()&&o.getMonth()!==m.getStartDate().getMonth()){r.class("sapUiCalItemOtherMonth");}if(!E){r.class("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(q===h.aNonWorkingDays[i]){r.class("sapUiCalItemWeekEnd");break;}}}else if((q>=h.iWeekendStart&&q<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(q>=h.iWeekendStart||q<=h.iWeekendEnd))){r.class("sapUiCalItemWeekEnd");}r.attr("tabindex","-1");r.attr("data-sap-day",y);if(j){A["label"]=A["label"]+h.aWeekDaysWide[q]+" ";}A["label"]=A["label"]+h.oFormatLong.format(o.toUTCJSDate(),true);if(k!==""){c.addCalendarTypeAccInfo(A,k,p);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.accessibilityState(null,A);r.openEnd();if(t[0]&&u){r.openStart("div");r.class("sapUiCalSpecialDate");if(t[0].color){r.style("background-color",t[0].color);}r.openEnd();r.close("div");}r.openStart("span");r.class("sapUiCalItemText");if(t[0]&&t[0].color){r.class("sapUiCalItemTextCustomColor");}r.openEnd();if(!B){r.text(o.getDate());}r.close("span");if(j){r.openStart("span");r.class("sapUiCalDayName");r.openEnd();r.text(h.aWeekDays[q]);r.close("span");}if(h.sSecondaryCalendarType){r.openStart("span");r.class("sapUiCalItemSecText");r.openEnd();r.text(s.getDate());r.close("span");}r.close("div");};M._addNonWorkingDayText=function(A){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("LEGEND_NON_WORKING_DAY")+" ";A["label"]+=t;return t;};M._renderWeekNumber=function(r,o,h,m){var w=m._calculateWeekNumber(o);var i=h.sId+"-WNum-"+w;r.openStart("div",i);r.class("sapUiCalWeekNum");r.accessibilityState(null,{role:"rowheader",labelledby:I.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+i});r.openEnd();r.text(w);r.close("div");};return M;},true);
