sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/types/AnimationMode","sap/ui/webc/common/thirdparty/base/config/AnimationMode","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/main/thirdparty/Button","sap/ui/webc/common/thirdparty/icons/slim-arrow-left","sap/ui/webc/common/thirdparty/icons/slim-arrow-right","./types/FCLLayout","./fcl-utils/FCLLayout","./generated/i18n/i18n-defaults","./generated/templates/FlexibleColumnLayoutTemplate.lit","./generated/themes/FlexibleColumnLayout.css"],function(t,e,i,r,n,o,s,a,u,l,c,d,h,m,y,f,g){"use strict";function L(t){return t&&typeof t==="object"&&"default"in t?t["default"]:t}var w=L(t);var p=L(e);var C=L(i);var T=L(r);var b=L(n);var A=L(s);var _=L(l);const O={tag:"ui5-flexible-column-layout",properties:{layout:{type:h,defaultValue:h.OneColumn},hideArrows:{type:Boolean},accessibilityTexts:{type:Object},_width:{type:T,defaultValue:0},_columnLayout:{type:Object,defaultValue:undefined},_visibleColumns:{type:b,defaultValue:0},_layoutsConfiguration:{type:Object,defaultValue:undefined}},slots:{startColumn:{type:HTMLElement},midColumn:{type:HTMLElement},endColumn:{type:HTMLElement}},events:{"layout-change":{detail:{layout:{type:h},columnLayout:{type:Array},startColumnVisible:{type:Boolean},midColumnVisible:{type:Boolean},endColumnVisible:{type:Boolean},arrowsUsed:{type:Boolean},resize:{type:Boolean}}}}};class E extends w{constructor(){super();this._prevLayout=null;this.initialRendering=true;this._handleResize=this.handleResize.bind(this)}static get metadata(){return O}static get render(){return p}static get styles(){return g}static get template(){return f}static get dependencies(){return[_]}static async onDefine(){E.i18nBundle=await o.getI18nBundle("@ui5/webcomponents-fiori")}static get BREAKPOINTS(){return{PHONE:599,TABLET:1023}}static get MEDIA(){return{PHONE:"phone",TABLET:"tablet",DESKTOP:"desktop"}}static get ANIMATION_DURATION(){return a.getAnimationMode()!==A.None?560:0}onEnterDOM(){C.register(this,this._handleResize)}onExitDOM(){C.deregister(this,this._handleResize);["start","mid","end"].forEach(t=>{this[`${t}ColumnDOM`].removeEventListener("transitionend",this.columnResizeHandler)})}onAfterRendering(){if(this.initialRendering){this.handleInitialRendering();return}this.syncLayout()}handleInitialRendering(){this._prevLayout=this.layout;this.updateLayout();this.initialRendering=false}handleResize(){if(this.initialRendering){return}const t=this.columnLayout.join();this.updateLayout();if(t!==this.columnLayout.join()){this.fireLayoutChange(false,true)}}startArrowClick(){this.arrowClick({start:true,end:false})}endArrowClick(){this.arrowClick({start:false,end:true})}arrowClick({start:t,end:e}){this.layout=this.nextLayout(this.layout,{start:t,end:e});this.updateLayout();this.fireLayoutChange(true,false)}updateLayout(){this._width=this.widthDOM;this._columnLayout=this.nextColumnLayout(this.layout);this._visibleColumns=this.calcVisibleColumns(this._columnLayout);this.toggleColumns()}syncLayout(){if(this._prevLayout!==this.layout){this.updateLayout();this._prevLayout=this.layout}}toggleColumns(){this.toggleColumn("start");this.toggleColumn("mid");this.toggleColumn("end")}toggleColumn(t){const e=this[`${t}ColumnWidth`];const i=this[`${t}ColumnDOM`];const r=e===0;const n=i.style.width==="0px";if(r&&n){return}if(!r&&!n){i.style.width=e;return}if(r){i.style.width=e;i.addEventListener("transitionend",this.columnResizeHandler);return}if(n){i.removeEventListener("transitionend",this.columnResizeHandler);i.classList.remove("ui5-fcl-column--hidden");i.style.width=e}}columnResizeHandler(t){t.target.classList.add("ui5-fcl-column--hidden")}nextLayout(t,e={}){if(e.start){return m.getNextLayoutByStartArrow()[t]}if(e.end){return m.getNextLayoutByEndArrow()[t]}}nextColumnLayout(t){return this._effectiveLayoutsByMedia[this.media][t].layout}calcVisibleColumns(t){return t.filter(t=>t!==0).length}fireLayoutChange(t,e){this.fireEvent("layout-change",{layout:this.layout,columnLayout:this._columnLayout,startColumnVisible:this.startColumnVisible,midColumnVisible:this.midColumnVisible,endColumnVisible:this.endColumnVisible,arrowUsed:t,resize:e})}get columnLayout(){return this._columnLayout}get startColumnVisible(){if(this._columnLayout){return this._columnLayout[0]!==0}return false}get midColumnVisible(){if(this._columnLayout){return this._columnLayout[1]!==0}return false}get endColumnVisible(){if(this._columnLayout){return this._columnLayout[2]!==0}return false}get visibleColumns(){return this._visibleColumns}get classes(){const t=a.getAnimationMode()!==A.None;return{root:{"ui5-fcl-root":true,"ui5-fcl--ie":u.isIE()},columns:{start:{"ui5-fcl-column":true,"ui5-fcl-column-animation":t,"ui5-fcl-column--start":true},middle:{"ui5-fcl-column":true,"ui5-fcl-column-animation":t,"ui5-fcl-column--middle":true},end:{"ui5-fcl-column":true,"ui5-fcl-column-animation":t,"ui5-fcl-column--end":true}}}}get styles(){return{arrowsContainer:{start:{display:this.showStartSeparator?"flex":"none"},end:{display:this.showEndSeparator?"flex":"none"}},arrows:{start:{display:this.showStartArrow?"inline-block":"none",transform:this.startArrowDirection==="mirror"?"rotate(180deg)":""},end:{display:this.showEndArrow?"inline-block":"none",transform:this.endArrowDirection==="mirror"?"rotate(180deg)":""}}}}get startColumnWidth(){return this._columnLayout?this._columnLayout[0]:"100%"}get midColumnWidth(){return this._columnLayout?this._columnLayout[1]:0}get endColumnWidth(){return this._columnLayout?this._columnLayout[2]:0}get showStartSeparator(){return this.effectiveArrowsInfo[0].separator||this.startArrowVisibility}get showEndSeparator(){return this.effectiveArrowsInfo[1].separator||this.endArrowVisibility}get showStartArrow(){return this.hideArrows?false:this.startArrowVisibility}get showEndArrow(){return this.hideArrows?false:this.endArrowVisibility}get startArrowVisibility(){return this.effectiveArrowsInfo[0].visible}get endArrowVisibility(){return this.effectiveArrowsInfo[1].visible}get startArrowDirection(){return this.effectiveArrowsInfo[0].dir}get endArrowDirection(){return this.effectiveArrowsInfo[1].dir}get effectiveArrowsInfo(){return this._effectiveLayoutsByMedia[this.media][this.layout].arrows}get media(){if(this._width<=E.BREAKPOINTS.PHONE){return E.MEDIA.PHONE}if(this._width<=E.BREAKPOINTS.TABLET){return E.MEDIA.TABLET}return E.MEDIA.DESKTOP}get widthDOM(){return this.getBoundingClientRect().width}get startColumnDOM(){return this.shadowRoot.querySelector(".ui5-fcl-column--start")}get midColumnDOM(){return this.shadowRoot.querySelector(".ui5-fcl-column--middle")}get endColumnDOM(){return this.shadowRoot.querySelector(".ui5-fcl-column--end")}get accStartColumnText(){return this.accessibilityTexts.startColumnAccessibleName||E.i18nBundle.getText(y.FCL_START_COLUMN_TXT)}get accMiddleColumnText(){return this.accessibilityTexts.midColumnAccessibleName||E.i18nBundle.getText(y.FCL_MIDDLE_COLUMN_TXT)}get accEndColumnText(){return this.accessibilityTexts.endColumnAccessibleName||E.i18nBundle.getText(y.FCL_END_COLUMN_TXT)}get _effectiveLayoutsByMedia(){return this._layoutsConfiguration||m.getLayoutsByMedia()}get accStartArrowText(){const t=this.accessibilityTexts;if(this.startArrowDirection==="mirror"){return t.startArrowLeftText||E.i18nBundle.getText(y.FCL_START_COLUMN_COLLAPSE_BUTTON_TOOLTIP)}return t.startArrowRightText||E.i18nBundle.getText(y.FCL_START_COLUMN_EXPAND_BUTTON_TOOLTIP)}get accEndArrowText(){const t=this.accessibilityTexts;if(this.endArrowDirection==="mirror"){return t.endArrowRightText||E.i18nBundle.getText(y.FCL_END_COLUMN_COLLAPSE_BUTTON_TOOLTIP)}return t.endArrowLeftText||E.i18nBundle.getText(y.FCL_END_COLUMN_EXPAND_BUTTON_TOOLTIP)}}E.define();return E});