sap.ui.define(['sap/ui/webc/common/thirdparty/base/renderer/LitRenderer'], function (litRender) { 'use strict';

	const block0 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-dialog", tags, suffix)} aria-label="${litRender.ifDefined(context._dialogTitle)}" @ui5-after-open=${litRender.ifDefined(context._focusRecentlyUsedControl)} @ui5-before-close=${litRender.ifDefined(context._restoreConfirmedOnEscape)} ?stretch=${context._isPhone}><div slot="header" class="ui5-vsd-header"><${litRender.scopeTag("ui5-bar", tags, suffix)}><div slot="startContent" class="ui5-vsd-start">${ context.showBackButton ? block1(context, tags, suffix) : block2(context, tags, suffix) }</div><${litRender.scopeTag("ui5-button", tags, suffix)} slot="endContent" design="Transparent" @click="${context._resetSettings}" ?disabled=${context._disableResetButton} reset-button>${litRender.ifDefined(context._resetButtonLabel)}</${litRender.scopeTag("ui5-button", tags, suffix)}></${litRender.scopeTag("ui5-bar", tags, suffix)}></div><div class="ui5-vsd-content">${ context.isModeSort ? block3(context, tags, suffix) : undefined }${ context.isModeFilter ? block6(context, tags, suffix) : undefined }</div><div slot="footer" class="ui5-vsd-footer"><${litRender.scopeTag("ui5-button", tags, suffix)} design="Emphasized" @click="${context._confirmSettings}">${litRender.ifDefined(context._okButtonLabel)}</${litRender.scopeTag("ui5-button", tags, suffix)}><${litRender.scopeTag("ui5-button", tags, suffix)} design="Transparent" @click="${context._cancelSettings}">${litRender.ifDefined(context._cancelButtonLabel)}</${litRender.scopeTag("ui5-button", tags, suffix)}></div></${litRender.scopeTag("ui5-dialog", tags, suffix)}>`;
	const block1 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} design="Transparent" icon="nav-back" class="ui5-vsd-back-button" @click="${context._navigateToFilters}"></${litRender.scopeTag("ui5-button", tags, suffix)}><${litRender.scopeTag("ui5-label", tags, suffix)}>${litRender.ifDefined(context._filterByTitle)}</${litRender.scopeTag("ui5-label", tags, suffix)}>`;
	const block2 = (context, tags, suffix) => litRender.html`<div class="ui5-vsd-bar-title"><${litRender.scopeTag("ui5-label", tags, suffix)} class="ui5-vsd-title">${litRender.ifDefined(context._dialogTitle)}</${litRender.scopeTag("ui5-label", tags, suffix)}><${litRender.scopeTag("ui5-segmented-button", tags, suffix)} @ui5-selection-change="${litRender.ifDefined(context._handleModeChange)}"><${litRender.scopeTag("ui5-segmented-button-item", tags, suffix)} ?pressed="${context.isModeSort}" ?focused="${context.isModeSort}" icon="sort" mode="Sort"></${litRender.scopeTag("ui5-segmented-button-item", tags, suffix)}><${litRender.scopeTag("ui5-segmented-button-item", tags, suffix)} ?pressed="${context.isModeFilter}" ?focused="${context.isModeFilter}" icon="filter" mode="Filter"></${litRender.scopeTag("ui5-segmented-button-item", tags, suffix)}></${litRender.scopeTag("ui5-segmented-button", tags, suffix)}></div>`;
	const block3 = (context, tags, suffix) => litRender.html`<div class="ui5-vsd-sort"><${litRender.scopeTag("ui5-list", tags, suffix)} mode="SingleSelectBegin" @ui5-item-click="${litRender.ifDefined(context._onSortOrderChange)}" sort-order><${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}>${litRender.ifDefined(context._sortOrderLabel)}</${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}>${ litRender.repeat(context._currentSettings.sortOrder, (item, index) => item._id || index, (item, index) => block4(item, index, context, tags, suffix)) }</${litRender.scopeTag("ui5-list", tags, suffix)}><${litRender.scopeTag("ui5-list", tags, suffix)} mode="SingleSelectBegin" @ui5-item-click=${litRender.ifDefined(context._onSortByChange)} sort-by><${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}>${litRender.ifDefined(context._sortByLabel)}</${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}>${ litRender.repeat(context._currentSettings.sortBy, (item, index) => item._id || index, (item, index) => block5(item, index, context, tags, suffix)) }</${litRender.scopeTag("ui5-list", tags, suffix)}></div>`;
	const block4 = (item, index, context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-li", tags, suffix)} ?selected="${item.selected}">${litRender.ifDefined(item.text)}</${litRender.scopeTag("ui5-li", tags, suffix)}>`;
	const block5 = (item, index, context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-li", tags, suffix)} ?selected="${item.selected}">${litRender.ifDefined(item.text)}</${litRender.scopeTag("ui5-li", tags, suffix)}>`;
	const block6 = (context, tags, suffix) => litRender.html`${ context._filterStepTwo ? block7(context, tags, suffix) : block11(context, tags, suffix) }`;
	const block7 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-list", tags, suffix)} mode="MultiSelect" @ui5-item-click="${litRender.ifDefined(context._handleFilterValueItemClick)}">${ litRender.repeat(context._currentSettings.filters, (item, index) => item._id || index, (item, index) => block8(item, index, context, tags, suffix)) }</${litRender.scopeTag("ui5-list", tags, suffix)}>`;
	const block8 = (item, index, context, tags, suffix) => litRender.html`${ item.selected ? block9(item, index, context, tags, suffix) : undefined }`;
	const block9 = (item, index, context, tags, suffix) => litRender.html`${ litRender.repeat(item.filterOptions, (item, index) => item._id || index, (item, index) => block10(item, index, context, tags, suffix)) }`;
	const block10 = (item, index, context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-li", tags, suffix)} ?selected=${item.selected}>${litRender.ifDefined(item.text)}</${litRender.scopeTag("ui5-li", tags, suffix)}>`;
	const block11 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-list", tags, suffix)} @ui5-item-click="${litRender.ifDefined(context._changeCurrentFilter)}"><${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}>${litRender.ifDefined(context._filterByLabel)}</${litRender.scopeTag("ui5-li-groupheader", tags, suffix)}><slot name="filterItems"></slot></${litRender.scopeTag("ui5-list", tags, suffix)}>`;

	return block0;

});
