sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/types/ValueState","sap/ui/webc/common/thirdparty/base/FeaturesRegistry","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/Keys","./generated/i18n/i18n-defaults","./Input","./Popover","./generated/templates/FileUploaderTemplate.lit","./generated/templates/FileUploaderPopoverTemplate.lit","./generated/themes/FileUploader.css","./generated/themes/ResponsivePopoverCommon.css","./generated/themes/ValueStateMessage.css"],function(e,t,a,s,i,r,n,o,u,l,p,c,h,g){"use strict";function d(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var m=d(e);var f=d(t);var S=d(s);const v={tag:"ui5-file-uploader",languageAware:true,properties:{accept:{type:String},hideInput:{type:Boolean},disabled:{type:Boolean},multiple:{type:Boolean},name:{type:String},placeholder:{type:String},value:{type:String},valueState:{type:f,defaultValue:f.None},focused:{type:Boolean}},managedSlots:true,slots:{default:{propertyName:"content",type:HTMLElement},valueStateMessage:{type:HTMLElement},formSupport:{type:HTMLElement}},events:{change:{detail:{files:{type:FileList}}}}};class y extends m{static get formAssociated(){return true}static get metadata(){return v}static get render(){return S}static get styles(){return c}static get template(){return l}static get staticAreaTemplate(){return p}static get staticAreaStyles(){return[h,g]}constructor(){super();this._internals=this.attachInternals&&this.attachInternals()}_onmouseover(){this.content.forEach(e=>{e.classList.add("ui5_hovered")})}_onmouseout(){this.content.forEach(e=>{e.classList.remove("ui5_hovered")})}_onclick(e){if(e.isMarked==="button"){this._input.click(e)}}_onkeydown(e){if(r.isEnter(e)){this._input.click(e);e.preventDefault()}}_onkeyup(e){if(r.isSpace(e)){this._input.click(e);e.preventDefault()}}_onfocusin(){this.focused=true}_onfocusout(){this.focused=false}get files(){if(this._input){return this._input.files}return y._emptyFilesList}onBeforeRendering(){this._enableFormSupport()}onAfterRendering(){if(!this.value){this._input.value=""}this.toggleValueStatePopover(this.shouldOpenValueStateMessagePopover)}_enableFormSupport(){const e=a.getFeature("FormSupport");if(e){if(this._canUseNativeFormSupport){this._setFormValue()}else{e.syncNativeFileInput(this,(e,t)=>{t.disabled=e.disabled},this._onChange.bind(this))}}else if(this.name){console.warn(`In order for the "name" property to have effect, you should also: import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";`)}}_onChange(e){this._updateValue(e.target.files);this.fireEvent("change",{files:e.target.files})}_updateValue(e){this.value=Array.from(e).reduce((e,t)=>`${e}"${t.name}" `,"")}_setFormValue(){const e=new FormData;for(let t=0;t<this.files.length;t++){e.append(this.name,this.files[t])}this._internals.setFormValue(e)}toggleValueStatePopover(e){if(e){this.openValueStatePopover()}else{this.closeValueStatePopover()}}async openValueStatePopover(){const e=await this._getPopover();if(e){e.showAt(this)}}async closeValueStatePopover(){const e=await this._getPopover();if(e){e.close()}}async _getPopover(){const e=await this.getStaticAreaItemDomRef();return e.querySelector(".ui5-valuestatemessage-popover")}static get _emptyFilesList(){if(!this.emptyInput){this.emptyInput=document.createElement("input");this.emptyInput.type="file"}return this.emptyInput.files}get browseText(){return y.i18nBundle.getText(n.FILEUPLOAD_BROWSE)}get titleText(){return y.i18nBundle.getText(n.FILEUPLOADER_TITLE)}get _canUseNativeFormSupport(){return this._internals&&this._internals.setFormValue}get _keepInputInShadowDOM(){return this._canUseNativeFormSupport||!this.name}get _input(){return this.shadowRoot.querySelector("input[type=file]")||this.querySelector("input[type=file][data-ui5-form-support]")}get _type(){return"file"}get valueStateTextMappings(){return{Success:y.i18nBundle.getText(n.VALUE_STATE_SUCCESS),Information:y.i18nBundle.getText(n.VALUE_STATE_INFORMATION),Error:y.i18nBundle.getText(n.VALUE_STATE_ERROR),Warning:y.i18nBundle.getText(n.VALUE_STATE_WARNING)}}get valueStateText(){return this.valueStateTextMappings[this.valueState]}get hasValueState(){return this.valueState!==f.None}get hasValueStateText(){return this.hasValueState&&this.valueState!==f.Success}get valueStateMessageText(){return this.getSlottedNodes("valueStateMessage").map(e=>e.cloneNode(true))}get shouldDisplayDefaultValueStateMessage(){return!this.valueStateMessage.length&&this.hasValueStateText}get shouldOpenValueStateMessagePopover(){return this.focused&&this.hasValueStateText&&!this.hideInput}get _valueStateMessageInputIcon(){const e={Error:"error",Warning:"alert",Success:"sys-enter-2",Information:"information"};return this.valueState!==f.None?e[this.valueState]:""}get classes(){return{popoverValueState:{"ui5-valuestatemessage-root":true,"ui5-valuestatemessage--success":this.valueState===f.Success,"ui5-valuestatemessage--error":this.valueState===f.Error,"ui5-valuestatemessage--warning":this.valueState===f.Warning,"ui5-valuestatemessage--information":this.valueState===f.Information}}}get styles(){return{popoverHeader:{width:`${this.ui5Input?this.ui5Input.offsetWidth:0}px`}}}get ui5Input(){return this.shadowRoot.querySelector(".ui5-file-uploader-input")}static get dependencies(){return[o,u]}static async onDefine(){y.i18nBundle=await i.getI18nBundle("@ui5/webcomponents")}}y.define();return y});